# Generated by ariadne-codegen
# Source: tools/graphql_codegen/artifacts/

from __future__ import annotations

from typing import Any, List, Literal, Optional

from pydantic import Field

from wandb._pydantic import GQLBase, GQLId, Typename

from .enums import ArtifactState


class ArtifactCollectionsFragment(GQLBase):
    page_info: ArtifactCollectionsFragmentPageInfo = Field(alias="pageInfo")
    total_count: int = Field(alias="totalCount")
    edges: List[ArtifactCollectionsFragmentEdges]


class ArtifactCollectionsFragmentEdges(GQLBase):
    node: Optional[ArtifactCollectionsFragmentEdgesNode]
    cursor: str


class ArtifactCollectionsFragmentEdgesNode(GQLBase):
    typename__: Typename[
        Literal["ArtifactCollection", "ArtifactPortfolio", "ArtifactSequence"]
    ]
    id: GQLId
    name: str
    description: Optional[str]
    created_at: str = Field(alias="createdAt")


class ArtifactCollectionsFragmentPageInfo(GQLBase):
    end_cursor: Optional[str] = Field(alias="endCursor")
    has_next_page: bool = Field(alias="hasNextPage")


class ArtifactFragment(GQLBase):
    id: GQLId
    artifact_sequence: ArtifactFragmentArtifactSequence = Field(
        alias="artifactSequence"
    )
    version_index: Optional[int] = Field(alias="versionIndex")
    artifact_type: ArtifactFragmentArtifactType = Field(alias="artifactType")
    description: Optional[str]
    metadata: Optional[Any]
    ttl_duration_seconds: Optional[Any] = Field(
        alias="ttlDurationSeconds", default=None
    )
    ttl_is_inherited: Optional[bool] = Field(alias="ttlIsInherited", default=None)
    aliases: Optional[List[ArtifactFragmentAliases]] = None
    tags: Optional[List[ArtifactFragmentTags]] = None
    history_step: Optional[Any] = Field(alias="historyStep", default=None)
    state: ArtifactState
    current_manifest: Optional[ArtifactFragmentCurrentManifest] = Field(
        alias="currentManifest"
    )
    commit_hash: Optional[str] = Field(alias="commitHash")
    file_count: Any = Field(alias="fileCount")
    created_at: str = Field(alias="createdAt")
    updated_at: Optional[str] = Field(alias="updatedAt")


class ArtifactFragmentAliases(GQLBase):
    artifact_collection: Optional[ArtifactFragmentAliasesArtifactCollection] = Field(
        alias="artifactCollection"
    )
    alias: str


class ArtifactFragmentAliasesArtifactCollection(GQLBase):
    typename__: Typename[
        Literal["ArtifactCollection", "ArtifactPortfolio", "ArtifactSequence"]
    ]
    project: Optional[ArtifactFragmentAliasesArtifactCollectionProject]
    name: str


class ArtifactFragmentAliasesArtifactCollectionProject(GQLBase):
    entity_name: str = Field(alias="entityName")
    name: str


class ArtifactFragmentArtifactSequence(GQLBase):
    project: Optional[ArtifactFragmentArtifactSequenceProject]
    name: str


class ArtifactFragmentArtifactSequenceProject(GQLBase):
    entity_name: str = Field(alias="entityName")
    name: str


class ArtifactFragmentArtifactType(GQLBase):
    name: str


class ArtifactFragmentCurrentManifest(GQLBase):
    file: ArtifactFragmentCurrentManifestFile


class ArtifactFragmentCurrentManifestFile(GQLBase):
    direct_url: str = Field(alias="directUrl")


class ArtifactFragmentTags(GQLBase):
    name: str


class ArtifactPortfolioTypeFields(GQLBase):
    typename__: Typename[Literal["ArtifactPortfolio"]] = "ArtifactPortfolio"
    id: GQLId
    name: str


class ArtifactSequenceTypeFields(GQLBase):
    typename__: Typename[Literal["ArtifactSequence"]] = "ArtifactSequence"
    id: GQLId
    name: str


class ArtifactTypeFragment(GQLBase):
    typename__: Typename[Literal["ArtifactType"]] = "ArtifactType"
    id: GQLId
    name: str
    description: Optional[str]
    created_at: str = Field(alias="createdAt")


class ArtifactTypesFragment(GQLBase):
    edges: List[ArtifactTypesFragmentEdges]
    page_info: ArtifactTypesFragmentPageInfo = Field(alias="pageInfo")


class ArtifactTypesFragmentEdges(GQLBase):
    node: Optional[ArtifactTypeFragment]
    cursor: str


class ArtifactTypesFragmentPageInfo(GQLBase):
    end_cursor: Optional[str] = Field(alias="endCursor")
    has_next_page: bool = Field(alias="hasNextPage")


class ArtifactsFragment(GQLBase):
    total_count: int = Field(alias="totalCount")
    edges: List[ArtifactsFragmentEdges]
    page_info: ArtifactsFragmentPageInfo = Field(alias="pageInfo")


class ArtifactsFragmentEdges(GQLBase):
    node: ArtifactFragment
    version: str
    cursor: str


class ArtifactsFragmentPageInfo(GQLBase):
    end_cursor: Optional[str] = Field(alias="endCursor")
    has_next_page: bool = Field(alias="hasNextPage")


class FilesFragment(GQLBase):
    edges: List[FilesFragmentEdges]
    page_info: FilesFragmentPageInfo = Field(alias="pageInfo")


class FilesFragmentEdges(GQLBase):
    node: Optional[FilesFragmentEdgesNode]
    cursor: str


class FilesFragmentEdgesNode(GQLBase):
    id: GQLId
    name: str
    url: Optional[str]
    size_bytes: Any = Field(alias="sizeBytes")
    storage_path: Optional[str] = Field(alias="storagePath", default=None)
    mimetype: Optional[str]
    updated_at: Optional[str] = Field(alias="updatedAt")
    digest: Optional[str]
    md_5: Optional[str] = Field(alias="md5")
    direct_url: str = Field(alias="directUrl")


class FilesFragmentPageInfo(GQLBase):
    end_cursor: Optional[str] = Field(alias="endCursor")
    has_next_page: bool = Field(alias="hasNextPage")


ArtifactCollectionsFragment.model_rebuild()
ArtifactCollectionsFragmentEdges.model_rebuild()
ArtifactCollectionsFragmentEdgesNode.model_rebuild()
ArtifactCollectionsFragmentPageInfo.model_rebuild()
ArtifactFragment.model_rebuild()
ArtifactFragmentAliases.model_rebuild()
ArtifactFragmentAliasesArtifactCollection.model_rebuild()
ArtifactFragmentAliasesArtifactCollectionProject.model_rebuild()
ArtifactFragmentArtifactSequence.model_rebuild()
ArtifactFragmentArtifactSequenceProject.model_rebuild()
ArtifactFragmentArtifactType.model_rebuild()
ArtifactFragmentCurrentManifest.model_rebuild()
ArtifactFragmentCurrentManifestFile.model_rebuild()
ArtifactFragmentTags.model_rebuild()
ArtifactPortfolioTypeFields.model_rebuild()
ArtifactSequenceTypeFields.model_rebuild()
ArtifactTypeFragment.model_rebuild()
ArtifactTypesFragment.model_rebuild()
ArtifactTypesFragmentEdges.model_rebuild()
ArtifactTypesFragmentPageInfo.model_rebuild()
ArtifactsFragment.model_rebuild()
ArtifactsFragmentEdges.model_rebuild()
ArtifactsFragmentPageInfo.model_rebuild()
FilesFragment.model_rebuild()
FilesFragmentEdges.model_rebuild()
FilesFragmentEdgesNode.model_rebuild()
FilesFragmentPageInfo.model_rebuild()
ArtifactFragment.model_rebuild()
ArtifactTypeFragment.model_rebuild()
