Var bolCustomCreatedLegacy

!macro CustomCodePreInstall
	${If} ${FileExists} "$INSTDIR\Data\settings\gtkrc"
	${AndIfNot} ${FileExists} "$INSTDIR\Data\settings\gtk2\*.*"
		CreateDirectory "$INSTDIR\Data\settings\gtk2"
		CreateDirectory "$INSTDIR\Data\settings\gtk3"
		Rename "$INSTDIR\Data\settings\gtkrc" "$INSTDIR\Data\settings\gtk2\gtkrc"
	${EndIf}
	
	${If} ${FileExists} "$INSTDIR\Data\settings\geany.conf"
	${AndIfNot} ${FileExists} "$INSTDIR\Data\Projects\*.*"
		CreateDirectory "$INSTDIR\Data\Projects"
	${EndIf}
	
	System::Call kernel32::GetCurrentProcess()i.s
	System::Call kernel32::IsWow64Process(is,*i.r0)
	ReadRegStr $1 HKLM "Software\Microsoft\Windows NT\CurrentVersion" "CurrentBuild"
	
	${If} $1 < 10000 ;Windows 7/8
	${OrIf} $0 == 0 ;or 32-bit 10
		${If} ${FileExists} "$INSTDIR\Data\settings\config\*.*"
			${VersionCompare} $0 "2.0.0.0" $R0
			${If} $R0 = 2
				${GetParent} $INSTDIR $1
				${IfNot} ${FileExists} "$1\GeanyPortableLegacyx86\*.*"
					${GetParent} $INSTDIR $1
					CreateDirectory "$1\GeanyPortableLegacyx86"
					CreateDirectory "$1\GeanyPortableLegacyx86\App"
					CreateDirectory "$1\GeanyPortableLegacyx86\App\AppInfo"
					CreateDirectory "$1\GeanyPortableLegacyx86\App\DefaultData"
					CreateDirectory "$1\GeanyPortableLegacyx86\Data"
					CreateDirectory "$1\GeanyPortableLegacyx86\Other"
					CopyFiles /SILENT /FILESONLY "$INSTDIR\*.*" "$1\GeanyPortableLegacyx86"
					CopyFiles /SILENT "$INSTDIR\App\AppInfo\*.*" "$1\GeanyPortableLegacyx86\App\AppInfo"
					CopyFiles /SILENT "$INSTDIR\App\DefaultData\*.*" "$1\GeanyPortableLegacyx86\App\DefaultData"
					Rename "$INSTDIR\App\Geany" "$1\GeanyPortableLegacyx86\App\Geany"
					CopyFiles /SILENT "$INSTDIR\Data\*.*" "$1\GeanyPortableLegacyx86\Data"
					CopyFiles /SILENT "$INSTDIR\Other\*.*" "$1\GeanyPortableLegacyx86\Other"
					WriteINIStr "$1\GeanyPortableLegacyx86\App\AppInfo\AppInfo.ini" "Details" "AppID" "GeanyPortableLegacyx86"
					WriteINIStr "$1\GeanyPortableLegacyx86\App\AppInfo\AppInfo.ini" "Details" "Name" "Geany Portable (Legacy 32-bit)"
					WriteINIStr "$1\GeanyPortableLegacyx86\App\AppInfo\AppInfo.ini" "Version" "PackageVersion" "1.37.1.0"
					WriteINIStr "$1\GeanyPortableLegacyx86\App\AppInfo\AppInfo.ini" "Version" "DisplayVersion" "1.37.1"
					StrCpy $bolCustomCreatedLegacy true
					WriteINIStr "$1\GeanyPortableLegacyx86\App\AppInfo\AppInfo.ini" "Control" "Start" "GeanyPortableLegacyx86.exe"
					DeleteINIStr "$1\GeanyPortableLegacyx86\App\AppInfo\AppInfo.ini" "Control" "BaseAppID64"
				${EndIf}	
			${EndIf}
		${EndIf}
	${EndIf}
!macroend

!macro CustomCodePostInstall
	${If} $bolCustomCreatedLegacy == true
		${GetParent} $INSTDIR $1
		Delete "$1\GeanyPortableLegacyx86\GeanyPortable.exe"
		Delete "$1\GeanyPortableLegacyx86\App\AppInfo\Launcher\custom.nsh"
		Delete "$1\GeanyPortableLegacyx86\App\AppInfo\Launcher\GeanyPortable.ini"
		CopyFiles /SILENT "$INSTDIR\Other\Source\Legacy\GeanyPortableLegacyx86.exe" "$1\GeanyPortableLegacyx86"
		CopyFiles /SILENT "$INSTDIR\Other\Source\Legacy\custom.nsh" "$1\GeanyPortableLegacyx86\App\AppInfo\Launcher"
		CopyFiles /SILENT "$INSTDIR\Other\Source\Legacy\GeanyPortableLegacyx86.ini" "$1\GeanyPortableLegacyx86\App\AppInfo\Launcher"
	${EndIf}
!macroend
