/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.StringUtils;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.expertsystem.ApplicationStage;
import com.nvidia.viper.expertsystem.BoundsStage;
import com.nvidia.viper.expertsystem.ComputeStage;
import com.nvidia.viper.expertsystem.ExpertSystemStageKind;
import com.nvidia.viper.expertsystem.IExpertSystemStage;
import com.nvidia.viper.expertsystem.IntroductionStage;
import com.nvidia.viper.expertsystem.KernelsStage;
import com.nvidia.viper.expertsystem.LatencyStage;
import com.nvidia.viper.expertsystem.MemoryStage;
import com.nvidia.viper.expertsystem.TipsStage;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.ISessionSerializable;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.model.Session;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.Disposable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExpertSystem
extends ModelWithProperties
implements IModel,
ISessionSerializable,
ISessionPropertyChangeListener,
Disposable {
    public static final String PROPERTY_CURRENT = "expertsystem:current";
    public static final String PROPERTY_VISITED = "expertsystem:visited";
    public static final String PROPERTY_RESULTS = "expertsystem:results";
    public static final String PROPERTY_STAGE = "expertsystem:stage";
    private Session session;
    private Map<ExpertSystemStageKind, IExpertSystemStage> stageMap;
    private ExpertSystemStageKind currentStageKind;
    private Set<ExpertSystemStageKind> visitedStageKinds;
    private List<AnalysisResult> activeResults;

    public ExpertSystem(Session session) {
        this.session = session;
        this.stageMap = new HashMap<ExpertSystemStageKind, IExpertSystemStage>();
        this.visitedStageKinds = new HashSet<ExpertSystemStageKind>();
        this.activeResults = new LinkedList<AnalysisResult>();
        this.setCurrentStageKind(ExpertSystemStageKind.INTRO);
        session.addPropertyChangeListener(this);
    }

    public ExpertSystem(Session session, Element el) throws ViperException {
        this(session);
        this.read(el);
    }

    public void dispose() {
        this.session.removePropertyChangeListener(this);
        for (IExpertSystemStage stage : this.stageMap.values()) {
            if (!(stage instanceof Disposable)) continue;
            ((Disposable)stage).dispose();
        }
        this.stageMap.clear();
        this.visitedStageKinds.clear();
        this.activeResults.clear();
        this.stageMap = null;
        this.visitedStageKinds = null;
        this.currentStageKind = null;
        this.activeResults = null;
    }

    public Session getSession() {
        return this.session;
    }

    public Set<ExpertSystemStageKind> getVisitedStageKinds() {
        return this.visitedStageKinds;
    }

    public IExpertSystemStage[] getVisitedStages() {
        IExpertSystemStage[] stages = new IExpertSystemStage[this.visitedStageKinds.size()];
        int cnt = 0;
        for (ExpertSystemStageKind kind : this.visitedStageKinds) {
            stages[cnt++] = this.getStageForKind(kind);
        }
        Arrays.sort(stages, new ExpertSystemStageComparator());
        return stages;
    }

    public void setVisitedStage(ExpertSystemStageKind kind, boolean visited) {
        if (visited && !this.visitedStageKinds.contains((Object)kind) || !visited && this.visitedStageKinds.contains((Object)kind)) {
            if (visited) {
                this.visitedStageKinds.add(kind);
            } else {
                this.visitedStageKinds.remove((Object)kind);
            }
            this.firePropertyChange(PROPERTY_VISITED);
        }
    }

    public ExpertSystemStageKind getCurrentStageKind() {
        return this.currentStageKind;
    }

    public void setCurrentStageKind(ExpertSystemStageKind kind) {
        if (this.currentStageKind == null || !this.currentStageKind.equals((Object)kind)) {
            switch (kind) {
                case INTRO: {
                    this.visitedStageKinds.clear();
                    break;
                }
                case APPLICATION: 
                case KERNELS: 
                case TIPS: {
                    this.visitedStageKinds.clear();
                    this.visitedStageKinds.add(ExpertSystemStageKind.INTRO);
                    break;
                }
                case BOUNDS: {
                    this.visitedStageKinds.clear();
                    this.visitedStageKinds.add(ExpertSystemStageKind.INTRO);
                    this.visitedStageKinds.add(ExpertSystemStageKind.KERNELS);
                    break;
                }
            }
            this.currentStageKind = kind;
            this.setVisitedStage(kind, true);
            this.firePropertyChange(PROPERTY_CURRENT);
        }
    }

    public IExpertSystemStage getCurrentStage() {
        return this.getStageForKind(this.currentStageKind);
    }

    public List<AnalysisResult> getAnalysisResults() {
        return Collections.unmodifiableList(this.activeResults);
    }

    public void setAnalysisResults(List<AnalysisResult> results) {
        if (!this.activeResults.equals(results)) {
            this.activeResults.clear();
            this.activeResults.addAll(results);
            this.firePropertyChange(PROPERTY_RESULTS);
        }
    }

    public void resetForNewTimeline() {
        this.activeResults.clear();
    }

    @Override
    public void propertyChange(IModel model, String propertyName) {
        IExpertSystemStage current = this.getCurrentStage();
        if (current != null && current.propertyChange(propertyName)) {
            this.firePropertyChange(PROPERTY_STAGE);
        }
    }

    public IExpertSystemStage getStageForKind(ExpertSystemStageKind kind) {
        IExpertSystemStage stage = this.stageMap.get((Object)kind);
        if (stage == null) {
            switch (kind) {
                case INTRO: {
                    stage = new IntroductionStage(this);
                    break;
                }
                case APPLICATION: {
                    stage = new ApplicationStage(this);
                    break;
                }
                case KERNELS: {
                    stage = new KernelsStage(this);
                    break;
                }
                case BOUNDS: {
                    stage = new BoundsStage(this);
                    break;
                }
                case LATENCY: {
                    stage = new LatencyStage(this);
                    break;
                }
                case COMPUTE: {
                    stage = new ComputeStage(this);
                    break;
                }
                case MEMORY: {
                    stage = new MemoryStage(this);
                    break;
                }
                case TIPS: {
                    stage = new TipsStage(this);
                    break;
                }
                default: {
                    ViperExceptionHandler.logError("unknown stage kind " + (Object)((Object)kind));
                }
            }
            if (stage != null) {
                this.stageMap.put(kind, stage);
            }
        }
        return stage;
    }

    protected void read(Element el) throws ViperException {
        if (!"expertsystem".equals(el.getTagName())) {
            throw new ViperException("expected \"expertsystem\" tag, got " + el.getTagName());
        }
        String currentStr = StringUtils.emptyToNull(el.getAttribute("current"));
        if (currentStr != null) {
            try {
                ExpertSystemStageKind kind = ExpertSystemStageKind.valueOf(currentStr);
                this.setCurrentStageKind(kind);
            }
            catch (IllegalArgumentException e) {
                this.setCurrentStageKind(ExpertSystemStageKind.INTRO);
                ViperExceptionHandler.logError("unknown current expert system stage", e);
            }
        }
        this.visitedStageKinds.clear();
        this.visitedStageKinds.add(this.currentStageKind);
        NodeList stageList = el.getElementsByTagName("stage");
        int d = 0;
        while (d < stageList.getLength()) {
            Element stageElement = (Element)stageList.item(d);
            if (!"stage".equals(stageElement.getTagName())) {
                throw new ViperException("expected \"stage\" tag, got " + stageElement.getTagName());
            }
            String stageStr = StringUtils.emptyToNull(stageElement.getAttribute("name"));
            if (stageStr != null) {
                try {
                    ExpertSystemStageKind kind = ExpertSystemStageKind.valueOf(stageStr);
                    this.visitedStageKinds.add(kind);
                }
                catch (IllegalArgumentException e) {
                    this.setCurrentStageKind(ExpertSystemStageKind.INTRO);
                    ViperExceptionHandler.logError("unknown current expert system stage", e);
                }
            }
            ++d;
        }
    }

    @Override
    public void write(Writer w) throws ViperException {
        try {
            w.write("<expertsystem");
            if (this.currentStageKind != null) {
                w.write(" current=\"" + this.currentStageKind.name() + "\"");
            }
            w.write(">");
            w.write("<visited>");
            for (ExpertSystemStageKind kind : this.visitedStageKinds) {
                w.write("<stage name=\"" + kind.name() + "\"/>");
            }
            w.write("</visited>");
            w.write("</expertsystem>\n");
        }
        catch (Exception e) {
            throw new ViperException(e);
        }
    }

    private class ExpertSystemStageComparator
    implements Comparator<IExpertSystemStage> {
        private ExpertSystemStageComparator() {
        }

        @Override
        public int compare(IExpertSystemStage o1, IExpertSystemStage o2) {
            int priority1 = this.getStagePriority(o1);
            int priority2 = this.getStagePriority(o2);
            return priority1 - priority2;
        }

        private int getStagePriority(IExpertSystemStage stage) {
            switch (stage.getStageKind()) {
                case INTRO: {
                    return 0;
                }
                case APPLICATION: {
                    return 1;
                }
                case KERNELS: {
                    return 2;
                }
                case BOUNDS: {
                    return 3;
                }
                case LATENCY: {
                    return 4;
                }
                case COMPUTE: {
                    return 5;
                }
                case MEMORY: {
                    return 6;
                }
                case TIPS: {
                    return 7;
                }
            }
            ViperExceptionHandler.logError("unknown expert system stage kind " + (Object)((Object)stage.getStageKind()));
            return 0;
        }
    }
}

