/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.RAStreamBufferMgr;

public class RAFolderOutputStream
extends RAOutputStream {
    private Collection<RAFolderOutputStream> manager;
    private RandomAccessFile randomFile;
    private String name;
    private RAStreamBufferMgr bufferMgr;

    public RAFolderOutputStream(Collection<RAFolderOutputStream> manager, File file) throws FileNotFoundException, IOException {
        this(manager, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAFolderOutputStream(Collection<RAFolderOutputStream> manager, File file, boolean append) throws FileNotFoundException, IOException {
        block7: {
            this.manager = manager;
            this.name = file.getCanonicalPath();
            this.randomFile = new RandomAccessFile(file, "rw");
            try {
                if (!append) {
                    this.randomFile.setLength(0L);
                }
                this.bufferMgr = new RAStreamBufferMgr(this.randomFile);
                if (manager == null) break block7;
                Collection<RAFolderOutputStream> collection = manager;
                synchronized (collection) {
                    manager.add(this);
                }
            }
            catch (IOException ex) {
                if (this.randomFile != null) {
                    this.randomFile.close();
                }
                throw ex;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    private void flushBuffer() throws IOException {
        this.bufferMgr.flushBuffer();
    }

    @Override
    public void write(int b) throws IOException {
        byte[] writeBuffer = new byte[]{(byte)b};
        this.bufferMgr.write(writeBuffer, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.bufferMgr.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.bufferMgr.write(b, off, len);
    }

    @Override
    public void writeInt(int v) throws IOException {
        byte[] writeBuffer = new byte[]{(byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        this.bufferMgr.write(writeBuffer, 0, 4);
    }

    @Override
    public void writeLong(long v) throws IOException {
        byte[] writeBuffer = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        this.bufferMgr.write(writeBuffer, 0, 8);
    }

    @Override
    public long getOffset() throws IOException {
        return this.bufferMgr.getFilePointer();
    }

    @Override
    public void seek(long localPos) throws IOException {
        this.bufferMgr.seek(localPos);
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        super.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.flushBuffer();
        this.randomFile.close();
        super.close();
        if (this.manager != null) {
            Collection<RAFolderOutputStream> collection = this.manager;
            synchronized (collection) {
                this.manager.remove(this);
            }
        }
    }

    @Override
    public long length() throws IOException {
        return this.bufferMgr.length();
    }
}

