/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeEditor;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

@Deprecated
public class TableTreeViewer
extends AbstractTreeViewer {
    private TableTreeEditorImpl tableEditorImpl;
    private TableTree tableTree;
    private TableTreeEditor tableTreeEditor;

    @Deprecated
    public TableTreeViewer(TableTree tree) {
        this.tableTree = tree;
        this.hookControl((Control)tree);
        this.tableTreeEditor = new TableTreeEditor(this.tableTree);
        this.tableEditorImpl = new TableTreeEditorImpl(this);
    }

    @Deprecated
    public TableTreeViewer(Composite parent) {
        this(parent, 2818);
    }

    @Deprecated
    public TableTreeViewer(Composite parent, int style) {
        this(new TableTree(parent, style));
    }

    @Override
    protected void addTreeListener(Control c, TreeListener listener) {
        ((TableTree)c).addTreeListener(listener);
    }

    @Override
    @Deprecated
    public void cancelEditing() {
        this.tableEditorImpl.cancelEditing();
    }

    @Override
    protected void doUpdateItem(Item item, Object element) {
        IBaseLabelProvider prov = this.getLabelProvider();
        ITableLabelProvider tprov = null;
        if (prov instanceof ITableLabelProvider) {
            tprov = (ITableLabelProvider)prov;
        }
        int columnCount = this.tableTree.getTable().getColumnCount();
        TableTreeItem ti = (TableTreeItem)item;
        int column = 0;
        while (column < columnCount || column == 0) {
            String text = "";
            Image image = null;
            if (tprov != null) {
                text = tprov.getColumnText(element, column);
                image = tprov.getColumnImage(element, column);
            } else if (column == 0) {
                ViewerLabel updateLabel = new ViewerLabel(item.getText(), item.getImage());
                this.buildLabel(updateLabel, element);
                if (item.isDisposed()) {
                    this.unmapElement(element, (Widget)item);
                    return;
                }
                text = updateLabel.getText();
                image = updateLabel.getImage();
            }
            if (text == null) {
                text = "";
            }
            ti.setText(column, text);
            if (ti.getImage(column) != image) {
                ti.setImage(column, image);
            }
            this.getColorAndFontCollector().setFontsAndColors(element);
            this.getColorAndFontCollector().applyFontsAndColors(ti);
            ++column;
        }
    }

    @Override
    @Deprecated
    public void editElement(Object element, int column) {
        this.tableEditorImpl.editElement(element, column);
    }

    @Override
    @Deprecated
    public CellEditor[] getCellEditors() {
        return this.tableEditorImpl.getCellEditors();
    }

    @Override
    @Deprecated
    public ICellModifier getCellModifier() {
        return this.tableEditorImpl.getCellModifier();
    }

    @Override
    protected Item[] getChildren(Widget o) {
        if (o instanceof TableTreeItem) {
            return ((TableTreeItem)o).getItems();
        }
        if (o instanceof TableTree) {
            return ((TableTree)o).getItems();
        }
        return null;
    }

    @Override
    protected Item getChild(Widget widget, int index) {
        if (widget instanceof TableTreeItem) {
            return ((TableTreeItem)widget).getItem(index);
        }
        if (widget instanceof TableTree) {
            return ((TableTree)widget).getItem(index);
        }
        return null;
    }

    @Override
    @Deprecated
    public Object[] getColumnProperties() {
        return this.tableEditorImpl.getColumnProperties();
    }

    @Override
    @Deprecated
    public Control getControl() {
        return this.tableTree;
    }

    @Deprecated
    public Object getElementAt(int index) {
        TableTreeItem i = this.tableTree.getItems()[index];
        if (i != null) {
            return i.getData();
        }
        return null;
    }

    @Override
    protected boolean getExpanded(Item item) {
        return ((TableTreeItem)item).getExpanded();
    }

    @Override
    protected Item getItemAt(Point p) {
        return this.getTableTree().getTable().getItem(p);
    }

    @Override
    protected int getItemCount(Control widget) {
        return ((TableTree)widget).getItemCount();
    }

    @Override
    protected int getItemCount(Item item) {
        return ((TableTreeItem)item).getItemCount();
    }

    @Override
    protected Item[] getItems(Item item) {
        return ((TableTreeItem)item).getItems();
    }

    @Override
    @Deprecated
    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    @Override
    protected Item getParentItem(Item item) {
        return ((TableTreeItem)item).getParentItem();
    }

    @Override
    protected Item[] getSelection(Control widget) {
        return ((TableTree)widget).getSelection();
    }

    @Deprecated
    public TableTree getTableTree() {
        return this.tableTree;
    }

    @Override
    protected void hookControl(Control control) {
        super.hookControl(control);
        this.tableTree.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = TableTreeViewer.this.tableTree.getTable().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    Rectangle rect = item.getImageBounds(0);
                    if (rect.contains(e.x, e.y)) {
                        return;
                    }
                    ++n2;
                }
                TableTreeViewer.this.tableEditorImpl.handleMouseDown(e);
            }
        });
    }

    @Override
    @Deprecated
    public boolean isCellEditorActive() {
        return this.tableEditorImpl.isCellEditorActive();
    }

    @Override
    protected Item newItem(Widget parent, int flags, int ix) {
        TableTreeItem item = ix >= 0 ? (parent instanceof TableTreeItem ? new TableTreeItem((TableTreeItem)parent, flags, ix) : new TableTreeItem((TableTree)parent, flags, ix)) : (parent instanceof TableTreeItem ? new TableTreeItem((TableTreeItem)parent, flags) : new TableTreeItem((TableTree)parent, flags));
        return item;
    }

    @Override
    protected void removeAll(Control widget) {
        ((TableTree)widget).removeAll();
    }

    @Override
    @Deprecated
    public void setCellEditors(CellEditor[] editors) {
        this.tableEditorImpl.setCellEditors(editors);
    }

    @Override
    @Deprecated
    public void setCellModifier(ICellModifier modifier) {
        this.tableEditorImpl.setCellModifier(modifier);
    }

    @Override
    @Deprecated
    public void setColumnProperties(String[] columnProperties) {
        this.tableEditorImpl.setColumnProperties(columnProperties);
    }

    @Override
    @Deprecated
    protected void setExpanded(Item node, boolean expand) {
        ((TableTreeItem)node).setExpanded(expand);
    }

    @Override
    @Deprecated
    protected void setSelection(List items) {
        TableTreeItem[] newItems = new TableTreeItem[items.size()];
        items.toArray(newItems);
        this.getTableTree().setSelection(newItems);
    }

    @Override
    @Deprecated
    protected void showItem(Item item) {
        this.getTableTree().showItem((TableTreeItem)item);
    }

    class TableTreeEditorImpl {
        private CellEditor cellEditor;
        private CellEditor[] cellEditors;
        private ICellModifier cellModifier;
        private String[] columnProperties;
        private Item tableItem;
        private int columnNumber;
        private ICellEditorListener cellEditorListener;
        private FocusListener focusListener;
        private MouseListener mouseListener;
        private int doubleClickExpirationTime;
        private ColumnViewer viewer;

        private TableTreeEditorImpl(ColumnViewer viewer) {
            this.viewer = viewer;
            this.initCellEditorListener();
        }

        public ColumnViewer getViewer() {
            return this.viewer;
        }

        private void activateCellEditor() {
            String property;
            Object element;
            if (this.cellEditors != null && this.cellEditors[this.columnNumber] != null && this.cellModifier != null && this.cellModifier.canModify(element = this.tableItem.getData(), property = this.columnProperties[this.columnNumber])) {
                this.cellEditor = this.cellEditors[this.columnNumber];
                this.cellEditor.addListener(this.cellEditorListener);
                Object value = this.cellModifier.getValue(element, property);
                this.cellEditor.setValue(value);
                final Control control = this.cellEditor.getControl();
                this.cellEditor.activate();
                if (control == null) {
                    return;
                }
                this.setLayoutData(this.cellEditor.getLayoutData());
                this.setEditor(control, this.tableItem, this.columnNumber);
                this.cellEditor.setFocus();
                if (this.focusListener == null) {
                    this.focusListener = new FocusAdapter(){

                        public void focusLost(FocusEvent e) {
                            TableTreeEditorImpl.this.applyEditorValue();
                        }
                    };
                }
                control.addFocusListener(this.focusListener);
                this.mouseListener = new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        if (e.time <= TableTreeEditorImpl.this.doubleClickExpirationTime) {
                            control.removeMouseListener(TableTreeEditorImpl.this.mouseListener);
                            TableTreeEditorImpl.this.cancelEditing();
                            TableTreeEditorImpl.this.handleDoubleClickEvent();
                        } else if (TableTreeEditorImpl.this.mouseListener != null) {
                            control.removeMouseListener(TableTreeEditorImpl.this.mouseListener);
                        }
                    }
                };
                control.addMouseListener(this.mouseListener);
            }
        }

        private void activateCellEditor(MouseEvent event) {
            int columnToEdit;
            if (this.tableItem == null || this.tableItem.isDisposed()) {
                return;
            }
            int columns = this.getColumnCount();
            if (columns == 0) {
                columnToEdit = 0;
            } else {
                columnToEdit = -1;
                int i = 0;
                while (i < columns) {
                    Rectangle bounds = this.getBounds(this.tableItem, i);
                    if (bounds.contains(event.x, event.y)) {
                        columnToEdit = i;
                        break;
                    }
                    ++i;
                }
                if (columnToEdit == -1) {
                    return;
                }
            }
            this.columnNumber = columnToEdit;
            this.activateCellEditor();
        }

        public void applyEditorValue() {
            CellEditor c = this.cellEditor;
            if (c != null) {
                this.cellEditor = null;
                Item t = this.tableItem;
                if (t != null && !t.isDisposed()) {
                    this.saveEditorValue(c, t);
                }
                this.setEditor(null, null, 0);
                c.removeListener(this.cellEditorListener);
                Control control = c.getControl();
                if (control != null) {
                    if (this.mouseListener != null) {
                        control.removeMouseListener(this.mouseListener);
                    }
                    if (this.focusListener != null) {
                        control.removeFocusListener(this.focusListener);
                    }
                }
                c.deactivate();
            }
        }

        public void cancelEditing() {
            if (this.cellEditor != null) {
                this.setEditor(null, null, 0);
                this.cellEditor.removeListener(this.cellEditorListener);
                CellEditor oldEditor = this.cellEditor;
                this.cellEditor = null;
                oldEditor.deactivate();
            }
        }

        public void editElement(Object element, int column) {
            if (this.cellEditor != null) {
                this.applyEditorValue();
            }
            this.setSelection(new StructuredSelection(element), true);
            Item[] selection = this.getSelection();
            if (selection.length != 1) {
                return;
            }
            this.tableItem = selection[0];
            this.showSelection();
            this.columnNumber = column;
            this.activateCellEditor();
        }

        public CellEditor[] getCellEditors() {
            return this.cellEditors;
        }

        public ICellModifier getCellModifier() {
            return this.cellModifier;
        }

        public Object[] getColumnProperties() {
            return this.columnProperties;
        }

        public void handleMouseDown(MouseEvent event) {
            if (event.button != 1) {
                return;
            }
            if (this.cellEditor != null) {
                this.applyEditorValue();
            }
            this.doubleClickExpirationTime = event.time + Display.getCurrent().getDoubleClickTime();
            Item[] items = this.getSelection();
            if (items.length != 1) {
                this.tableItem = null;
                return;
            }
            this.tableItem = items[0];
            this.activateCellEditor(event);
        }

        private void initCellEditorListener() {
            this.cellEditorListener = new ICellEditorListener(){

                @Override
                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                }

                @Override
                public void cancelEditor() {
                    TableTreeEditorImpl.this.cancelEditing();
                }

                @Override
                public void applyEditorValue() {
                    TableTreeEditorImpl.this.applyEditorValue();
                }
            };
        }

        public boolean isCellEditorActive() {
            return this.cellEditor != null;
        }

        private void saveEditorValue(CellEditor cellEditor, Item tableItem) {
            if (this.cellModifier != null) {
                cellEditor.isValueValid();
            }
            String property = null;
            if (this.columnProperties != null && this.columnNumber < this.columnProperties.length) {
                property = this.columnProperties[this.columnNumber];
            }
            this.cellModifier.modify(tableItem, property, cellEditor.getValue());
        }

        public void setCellEditors(CellEditor[] editors) {
            this.cellEditors = editors;
        }

        public void setCellModifier(ICellModifier modifier) {
            this.cellModifier = modifier;
        }

        public void setColumnProperties(String[] columnProperties) {
            this.columnProperties = columnProperties;
        }

        Rectangle getBounds(Item item, int columnNumber) {
            return ((TableTreeItem)item).getBounds(columnNumber);
        }

        int getColumnCount() {
            return TableTreeViewer.this.getTableTree().getTable().getColumnCount();
        }

        Item[] getSelection() {
            return TableTreeViewer.this.getTableTree().getSelection();
        }

        void setEditor(Control w, Item item, int columnNumber) {
            TableTreeViewer.this.tableTreeEditor.setEditor(w, (TableTreeItem)item, columnNumber);
        }

        void setSelection(StructuredSelection selection, boolean b) {
            TableTreeViewer.this.setSelection(selection, b);
        }

        void showSelection() {
            TableTreeViewer.this.getTableTree().showSelection();
        }

        void setLayoutData(CellEditor.LayoutData layoutData) {
            ((TableTreeViewer)TableTreeViewer.this).tableTreeEditor.horizontalAlignment = layoutData.horizontalAlignment;
            ((TableTreeViewer)TableTreeViewer.this).tableTreeEditor.grabHorizontal = layoutData.grabHorizontal;
            ((TableTreeViewer)TableTreeViewer.this).tableTreeEditor.minimumWidth = layoutData.minimumWidth;
        }

        void handleDoubleClickEvent() {
            ColumnViewer viewer = this.getViewer();
            TableTreeViewer.this.fireDoubleClick(new DoubleClickEvent(viewer, ((Viewer)viewer).getSelection()));
            TableTreeViewer.this.fireOpen(new OpenEvent(viewer, ((Viewer)viewer).getSelection()));
        }
    }
}

