/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.extension.oda;

import java.util.List;
import org.eclipse.birt.report.model.api.filterExtension.IODAFilterExprProvider;
import org.eclipse.birt.report.model.api.filterExtension.interfaces.IFilterExprDefinition;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.extension.oda.IODAProviderFactory;
import org.eclipse.birt.report.model.extension.oda.ODAProvider;

public class ODAProviderFactory
implements IODAProviderFactory,
IODAFilterExprProvider {
    private static volatile IODAProviderFactory baseFactory = null;
    private static volatile ODAProviderFactory instance = null;
    private static volatile IODAFilterExprProvider filterProvider = null;

    public static ODAProviderFactory getInstance() {
        if (instance == null) {
            instance = new ODAProviderFactory();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IODAProviderFactory getODAProvider() {
        if (baseFactory != null) {
            return baseFactory;
        }
        Class<ODAProviderFactory> clazz = ODAProviderFactory.class;
        synchronized (ODAProviderFactory.class) {
            if (baseFactory == null) {
                try {
                    Class<?> clazz2 = Class.forName("org.eclipse.birt.report.model.plugin.ODABaseProviderFactory");
                    baseFactory = (IODAProviderFactory)clazz2.newInstance();
                }
                catch (Exception exception) {}
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return baseFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IODAFilterExprProvider getFilterProvider() {
        if (filterProvider != null) {
            return filterProvider;
        }
        Class<ODAProviderFactory> clazz = ODAProviderFactory.class;
        synchronized (ODAProviderFactory.class) {
            if (filterProvider == null) {
                try {
                    Class<?> clazz2 = Class.forName("org.eclipse.birt.report.model.api.filterExtension.ODAFilterExprProvider");
                    filterProvider = (IODAFilterExprProvider)clazz2.newInstance();
                }
                catch (Exception exception) {}
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return filterProvider;
        }
    }

    @Override
    public ODAProvider createODAProvider(DesignElement element, String extensionID) {
        IODAProviderFactory provider = ODAProviderFactory.getODAProvider();
        if (provider != null) {
            return provider.createODAProvider(element, extensionID);
        }
        return null;
    }

    @Override
    public IFilterExprDefinition createFilterExprDefinition() {
        IODAProviderFactory provider = ODAProviderFactory.getODAProvider();
        if (provider != null) {
            return provider.createFilterExprDefinition();
        }
        return null;
    }

    @Override
    public IFilterExprDefinition createFilterExprDefinition(String birtFilterExpr) {
        IODAProviderFactory provider = ODAProviderFactory.getODAProvider();
        if (provider != null) {
            return provider.createFilterExprDefinition(birtFilterExpr);
        }
        return null;
    }

    public static synchronized void initeTheFactory(IODAProviderFactory base) {
        if (baseFactory != null) {
            return;
        }
        baseFactory = base;
    }

    public static synchronized void initFilterExprFactory(IODAFilterExprProvider provider) {
        if (filterProvider != null) {
            return;
        }
        filterProvider = provider;
    }

    public static void releaseInstance() {
        baseFactory = null;
        instance = null;
    }

    @Override
    public List<IFilterExprDefinition> getMappedFilterExprDefinitions(String odaDatasetExtensionId, String odaDataSourceExtensionId) {
        IODAFilterExprProvider provider = ODAProviderFactory.getFilterProvider();
        if (provider != null) {
            return provider.getMappedFilterExprDefinitions(odaDatasetExtensionId, odaDataSourceExtensionId);
        }
        return null;
    }

    @Override
    public boolean supportOdaExtensionFilters() {
        IODAFilterExprProvider provider = ODAProviderFactory.getFilterProvider();
        if (provider != null) {
            return provider.supportOdaExtensionFilters();
        }
        return false;
    }

    @Override
    public boolean supportODAFilterPushDown(String dataSourceExtId, String dataSetExtId) {
        IODAFilterExprProvider provider = ODAProviderFactory.getFilterProvider();
        if (provider != null) {
            return provider.supportODAFilterPushDown(dataSourceExtId, dataSetExtId);
        }
        return false;
    }
}

