/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.analysis.AnalysisBase;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultKernelPriority;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KernelPriorityAnalysis
extends AnalysisBase {
    private static final int MAX_PRIORITY_SCALE = 8;
    private static final double OK_OCCUPANCY = 0.5;
    private static final double PRIORITY_GROUP_SLOP = 0.15;

    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = true;
        if (session.getTimelines().isEmpty()) {
            results.add(new AnalysisResult(AnalysisDescriptor.KERNELS_NO_TIMELINE));
            ret = false;
        } else {
            List<Timeline> deviceTimelines = session.getTimelines(TimelineKind.DEVICE);
            if (deviceTimelines.isEmpty()) {
                results.add(new AnalysisResult(AnalysisDescriptor.KERNELS_NO_DEVICE));
            } else {
                if (generateAllResults) {
                    results.add(new AnalysisResult(AnalysisDescriptor.KERNELS_NO_TIMELINE));
                    results.add(new AnalysisResult(AnalysisDescriptor.KERNELS_NO_DEVICE));
                }
                this.runAnalysis(session, results, deviceTimelines, generateAllResults);
            }
        }
        return ret;
    }

    private void runAnalysis(Session session, List<AnalysisResult> results, List<Timeline> deviceTimelines, boolean generateAllResults) {
        AnalysisResultKernelPriority priorityResult = new AnalysisResultKernelPriority(AnalysisDescriptor.KERNELS_PRIORITY);
        for (Timeline deviceTimeline : deviceTimelines) {
            if (((TimelineDevice)deviceTimeline).getComputeCapabilityMajor() <= 1) continue;
            Metric occupancyMetric = null;
            for (Timeline timeline : deviceTimeline.getDescendants(TimelineKind.KERNEL)) {
                TimelineKernel kernelTimeline = (TimelineKernel)timeline;
                PriorityGroups groups = new PriorityGroups(kernelTimeline);
                long[] lArray = kernelTimeline.getIntervalIds();
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TimelineIntervalKernel kernel;
                    long intervalId = lArray[n2];
                    ITimelineInterval interal = session.loadInterval(intervalId, true);
                    if (interal instanceof TimelineIntervalKernel && (kernel = (TimelineIntervalKernel)interal) != null) {
                        if (occupancyMetric == null) {
                            occupancyMetric = KernelPriorityAnalysis.getMetric(kernel, "achieved_occupancy");
                        }
                        Number occupancy = null;
                        if (occupancyMetric != null && (occupancy = kernel.getAggregateMetricValue(occupancyMetric)) == null) {
                            occupancy = this.deriveAggregateMetricValue(kernel, occupancyMetric, true);
                        }
                        long priority = this.getPriority(kernel.getEnd() - kernel.getStart(), occupancy);
                        groups.add(kernel.getID(), priority);
                    }
                    ++n2;
                }
                groups.createRecords(priorityResult);
            }
        }
        priorityResult.normalizePriorities();
        results.add(priorityResult);
    }

    private long getPriority(long duration, Number occupancy) {
        long priority = duration / 16L;
        if (occupancy != null && occupancy.doubleValue() < 0.5) {
            priority = (long)((double)priority * Math.min(8.0, 0.5 / occupancy.doubleValue()));
        }
        return priority;
    }

    private static class PriorityGroups {
        private TimelineKernel timeline;
        private List<Priority> priorities;
        private long maxPriority;

        public PriorityGroups(TimelineKernel timeline) {
            this.timeline = timeline;
            this.priorities = new ArrayList<Priority>();
            this.maxPriority = 0L;
        }

        public void add(long id, long priority) {
            this.priorities.add(new Priority(id, priority));
            this.maxPriority = Math.max(priority, this.maxPriority);
        }

        public void createRecords(AnalysisResultKernelPriority priorityResult) {
            Object[] pList = this.priorities.toArray(new Priority[0]);
            Arrays.sort(pList);
            AnalysisResultKernelPriority.PriorityRecord group = null;
            long groupPriority = 0L;
            int groupSize = 0;
            Object[] objectArray = pList;
            int n = pList.length;
            int n2 = 0;
            while (n2 < n) {
                Object p = objectArray[n2];
                if (group == null || (double)Math.abs(groupPriority - ((Priority)p).priority) / (double)groupPriority > 0.15) {
                    if (group != null) {
                        priorityResult.addResult(group);
                    }
                    group = new AnalysisResultKernelPriority.PriorityRecord(this.timeline);
                    group.addInterval(((Priority)p).interval, ((Priority)p).priority);
                    groupPriority = ((Priority)p).priority;
                    groupSize = 1;
                } else {
                    group.addInterval(((Priority)p).interval, ((Priority)p).priority);
                    groupPriority = (long)(((double)groupPriority * (double)groupSize + (double)((Priority)p).priority) / (double)(groupSize + 1));
                    ++groupSize;
                }
                ++n2;
            }
            if (group != null) {
                priorityResult.addResult(group);
            }
        }

        private static class Priority
        implements Comparable<Priority> {
            private long interval;
            private long priority;

            private Priority(long interval, long priority) {
                this.interval = interval;
                this.priority = priority;
            }

            @Override
            public int compareTo(Priority o) {
                long d = this.priority - o.priority;
                return d == 0L ? 0 : (d < 0L ? 1 : -1);
            }
        }
    }
}

