ストーリー
--------
高橋市警では警察官の人手不足解消のために、自動運転の無人パトカーによる自動パトロールが実施されることになった。
無人パトカーには屋根の上に高性能な全方位カメラが取り付けられており、現在位置からの直線上にある道路全体を一度に見渡すことが出来、画像処理技術を用いて異変がないかを自動検出する。
市民の安全で安心な暮らしを守るため、市内の隅から隅まで少なくとも一度は見渡すことが出来るような巡回ルートを設定したい。
そのような巡回ルートの中で出来るだけ短いものを求めてほしい。

問題文
--------
$N\times N$ マスの地図が与えられる。
一番左上のマスを $(0,0)$ とし、そこから下方向に $i$ 回、右方向に $j$ 回移動した先のマスを $(i, j)$ とする。
各マスは障害物(`#`)もしくは道路であり、道路マス上を上下左右に移動することが出来る。
各道路マスは`5`-`9`の数字で表され、隣接マスからそのマスへの移動にかかる時間を表している。
位置 $(i, j)$ の道路マス上に居る時、以下の条件を満たす道路マス $(i',j')$ を「視界に入る」と定義する。

- $i=i'$ であり、全ての $\min(j,j')\leq j''\leq\max(j,j')$ に対して $(i,j'')$ が道路マス、もしくは
- $j=j'$ であり、全ての $\min(i,i')\leq i''\leq\max(i,i')$ に対して $(i'',j)$ が道路マス。

例えば下図では灰色のマスが障害物を、白色と薄黄色のマスが道路を表しており、緑丸の地点に居るときに視界に入る道路マスが薄黄色で塗られている。


![](./images/1bc7c896310a65486d0ce3aa275f41b7.png "視界の例")

指定された道路マス $(si,sj)$ からスタートして、道路マス上を上下左右に移動することを繰り返して $(si,sj)$ に戻ってくるような巡回ルートのうちで、全ての道路マスが少なくとも一回は視界に入るようなもののうち、出来るだけ総移動時間の短いものを求めよ。
同じマス上を何度も移動してよく、Uターンすることも可能である。

得点
--------
道路マスの総数を $r$、少なくとも一回は視界に入った道路マスの総数を $v$、巡回ルートの総移動時間を $t$ とすると、以下の得点が得られる。

- $v<r$ の場合、$\mathrm{round}(10^4\times \frac{v}{r})$
- $v=r$ の場合、$\mathrm{round}(10^4+10^7\times \frac{N}{t})$

不正なルート($N\times N$ の外に出る、障害物マス上に移動する、$(si,sj)$ に戻ってこない)が出力された場合、`WA`と判定される。
テストケースは全部で100個あり、各テストケースの得点の合計が提出の得点となる。
1つ以上のテストケースで`AC`以外の判定がされた場合、提出の得点は0点となる。
コンテスト時間中に得た最高得点で最終順位が決定され、コンテスト終了後のシステムテストは行われない。
同じ得点を複数の参加者が得た場合、その得点を獲得した提出の早い方が上位となる。

入力
--------
入力は以下の形式で標準入力から与えられる。

~~~
$N$ $si$ $sj$
$c_0$
$\vdots$
$c_{N-1}$
~~~

- $N$ は $49$ 以上 $69$ 以下の奇数。
- $si, sj$ は $0\leq si\leq N-1$、$0\leq sj\leq N-1$ を満たす整数値。
- 各 $c_i$ は`5`, `6`, `7`, `8`, `9`, `#` からなる長さ $N$ の文字列であり、$j$ ($0\leq j\leq N-1$) 文字目の文字は位置 $(i, j)$ のマスの情報を以下のように示している。
	- `#` はそのマスに障害物があることを表す。$(si, sj)$ のマスには障害物が無いことが保証されている。
	- `5`から`9`はそのマスが道路であることを示しており、その数字はそのマスへの移動にかかる時間を表している。

出力
--------
$(i, j)$ から $(i-1,j)$, $(i+1,j)$, $(i,j-1)$, $(i,j+1)$ への移動をそれぞれ `U`, `D`, `L`, `R` として巡回ルートを文字列で表し、標準出力に一行で出力せよ。


入力生成方法
--------
$L$ 以上 $U$ 以下の整数値を一様ランダムに生成する関数を $\mathrm{rand}(L,U)$ で表す。
まずはじめに、地図の大きさを表す奇数 $N=\mathrm{rand}(25, 35)\times 2 - 1$ と、道路の本数を表すパラメータ $K=\mathrm{rand}(2 N, 4 N)$ を生成する。
全てのマスが障害物の状態からスタートし、以下の操作を $K$ 回繰り返す。

1. 道路の向きを表す整数 $d=\mathrm{rand}(0, 1)$ を生成する。
1. 道路の中心を表す整数 $i=\mathrm{rand}(0, (N-1)/2)\times 2$ と、$j=\mathrm{rand}(0, N-1)$ を生成する。
1. 道路の長さを表す整数 $h=\mathrm{rand}(3, 10)$ を生成する。
1. 移動時間を表す整数 $w=\mathrm{rand}(5, 9)$ を生成する。
1. 各 $\max(j-h,0)\leq k\leq \min(j+h,N-1)$ に対して、$d=0$の場合はマス $(i,k)$ を、$d=1$ の場合はマス $(k,i)$ を移動コスト $w$ の道路マスで上書きする。

最後に、道路マスの最大連結成分のみを残して残りを障害物に置き換え、道路マスの中から一様ランダムに1マス選んで $(si,sj)$ とする。


ツール
--------
- <a href="https://img.atcoder.jp/ahc005/c746dac8cc11fd18c68063546997666e.zip">入力データ</a>: サンプル入力(seed 0)を含む、ローカルテスト用の100個の入力データ(seed 0-99)です。これらの入力は実際のテストケースとは異なります。
- <a href="https://img.atcoder.jp/ahc005/dc9ed10f037e2dd4b48ca255dbd470d9.html">Web版ビジュアライザ</a>
- <a href="https://img.atcoder.jp/ahc005/dc9ed10f037e2dd4b48ca255dbd470d9.zip">入力ジェネレータ・ビジュアライザ</a>: より多くの入力を生成するための入力ジェネレータとローカル実行用のビジュアライザです。使用するには、<a href="https://www.rust-lang.org/ja">Rust言語</a>のコンパイル環境をご用意下さい。

{sample example}
