Problem Statement
--------
In a two-dimensional grid, let $(0, 0)$ be the coordinates of the top-left square, and $(i, j)$ be the coordinates of the square located $i$ squares down and $j$ squares to the right from there.

There is an $N \times N$ square board.
Initially, each square $(i, j)$ on the board is assigned an integer $a_{i, j}$.

There are $M$ stamps, each with $3 \times 3$ squares. On stamp $m$ $(0 \leq m \leq M - 1)$, an integer $s_{m,i,j}$ is written in each square $(i, j)$.

You can perform the following operation at most $K$ times.

- Select a stamp $m$ and a square $(p, q)$ $(0 \leq p, q \leq N - 3)$ on the board. Press the stamp in such a way that its coordinates $(0, 0)$ align with the square $(p, q)$ on the board.
This operation increases the value of the square $(p + i, q + j)$ on the board by $s_{m,i,j}$ for each square $(i, j)$ $(0 \leq i, j \leq 2)$ on the stamp.
You cannot press a stamp beyond the bounds of the board, nor can you rotate stamps.

You can use the same stamp multiple times or have stamps that are not used at all. It is also acceptable to press stamps multiple times on the same square.

Please maximize the sum of the remainders obtained by dividing the values of each square on the final board by $998244353$.

Scoring
--------
After performing all the operations, let $b_{i, j}$ be the integer assigned to the square $(i, j)$ on the board.
Then, you will obtain the following score.

\\[
\sum_{i = 0}^{N - 1}{\sum_{j = 0}^{N - 1}{(b_{i, j} \bmod 998244353)}}
\\]

Here, $b_{i, j} \bmod 998244353$ represents the remainder obtained by dividing $b_{i, j}$ by $998244353$.

If the number of operations exceeds $K$ or if you output an illegal operation, the submission will be judged as <span class='label label-warning' data-toggle='tooltip' data-placement='top' title="Wrong Answer">WA</span>.

There are $150$ test cases, and the score of a submission is the total score for each test case.
If your submission produces an illegal output or exceeds the time limit for some test cases, the submission itself will be judged as <span class='label label-warning' data-toggle='tooltip' data-placement='top' title="Wrong Answer">WA</span> or <span class='label label-warning' data-toggle='tooltip' data-placement='top' title="Time Limit Exceeded">TLE</span>.
The highest score obtained during the contest will determine the final ranking, and there will be no system test after the contest.
If more than one participant gets the same score, they will be ranked in the same place regardless of the submission time.



Input
--------
Input is given from Standard Input in the following format:
~~~
$N$ $M$ $K$
$a_{0, 0}$ $\cdots$ $a_{0, N - 1}$
$\vdots$
$a_{N - 1, 0}$ $\cdots$ $a_{N - 1, N - 1}$
$s_{0, 0, 0}$ $s_{0, 0, 1}$ $s_{0, 0, 2}$
$s_{0, 1, 0}$ $s_{0, 1, 1}$ $s_{0, 1, 2}$
$s_{0, 2, 0}$ $s_{0, 2, 1}$ $s_{0, 2, 2}$
$\vdots$
$s_{M - 1, 0, 0}$ $s_{M - 1, 0, 1}$ $s_{M - 1, 0, 2}$
$s_{M - 1, 1, 0}$ $s_{M - 1, 1, 1}$ $s_{M - 1, 1, 2}$
$s_{M - 1, 2, 0}$ $s_{M - 1, 2, 1}$ $s_{M - 1, 2, 2}$
~~~

Each value satisfies the following constraints.

- $N = 9$
- $M = 20$
- $K = 81$
- $0 \leq a_{i, j} \leq 998244352$
- $0 \leq s_{m, i, j} \leq 998244352$

Output
--------
Let $L$ $(0 \leq L \leq K)$ be the number of operations, and $m_l$ $(0 \leq m_l \leq M - 1)$ and $(p_l, q_l)$ $(0 \leq p_l, q_l \leq N - 3)$ be the stamp and board square selected in the $l$-th operation, respectively. Then, output to Standard Output in the following format:

~~~
$L$
$m_0$ $p_0$ $q_0$
$m_1$ $p_1$ $q_1$
$\vdots$
$m_{L - 1}$ $p_{L - 1}$ $q_{L - 1}$
~~~

<a href="https://img.atcoder.jp/ahc032/e2weanqa.html?lang=en&seed=0&output=sample">Show example</a>


Input Generation
--------
Let $\mathrm{rand}(L,U)$ be a function that generates a uniform random integer between $L$ and $U$, inclusive.

Each $a_{i, j}$ and $s_{m, i, j}$ are all independently generated by $a_{i, j} = \mathrm{rand}(0, 998244352)$ and $s_{m, i, j} = \mathrm{rand}(0, 998244352)$.


Tools (Input generator and visualizer)
--------
- <a href="https://img.atcoder.jp/ahc032/e2weanqa.html?lang=en">Web version</a>: This is more powerful than the local version providing animations.
- <a href="https://img.atcoder.jp/ahc032/e2weanqa.zip">Local version</a>: You need a compilation environment of <a href="https://www.rust-lang.org/">Rust language</a>.
	- <a href="https://img.atcoder.jp/ahc032/e2weanqa_windows.zip">Pre-compiled binary for Windows</a>: If you are not familiar with the Rust language environment, please use this instead.

Please be aware that sharing visualization results or discussing solutions/ideas during the contest is prohibited.

{sample example}
