import{s as En,n as Hn,o as Yn}from"../chunks/scheduler.182ea377.js";import{S as Fn,i as Qn,g as r,s as a,r as d,A as Ln,h as s,f as n,c as i,j as nn,u as o,x as c,k as Nn,y,a as l,v as p,d as g,t as m,w as h}from"../chunks/index.abf12888.js";import{C as J}from"../chunks/CodeBlock.57fe6e13.js";import{H as M}from"../chunks/Heading.16916d63.js";function xn(ln){let f,zt,Ct,kt,T,Nt,w,an='🤗 Diffusers supports the latest optimizations from <a href="https://pytorch.org/get-started/pytorch-2.0/" rel="nofollow">PyTorch 2.0</a> which include:',Et,j,rn='<li>A memory-efficient attention implementation, scaled dot product attention, without requiring any extra dependencies such as xFormers.</li> <li><a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow"><code>torch.compile</code></a>, a just-in-time (JIT) compiler to provide an extra performance boost when individual models are compiled.</li>',Ht,U,sn="Both of these optimizations require PyTorch 2.0 or later and 🤗 Diffusers > 0.13.0.",Yt,Z,Ft,B,Qt,G,cn='<a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention" rel="nofollow"><code>torch.nn.functional.scaled_dot_product_attention</code></a> (SDPA) is an optimized and memory-efficient attention (similar to xFormers) that automatically enables several other optimizations depending on the model inputs and GPU type. SDPA is enabled by default if you’re using PyTorch 2.0 and the latest version of 🤗 Diffusers, so you don’t need to add anything to your code.',Lt,I,dn='However, if you want to explicitly enable it, you can set a <a href="/docs/diffusers/v0.23.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to use <a href="/docs/diffusers/v0.23.0/en/api/attnprocessor#diffusers.models.attention_processor.AttnProcessor2_0">AttnProcessor2_0</a>:',xt,W,Dt,X,on='SDPA should be as fast and memory efficient as <code>xFormers</code>; check the <a href="#benchmark">benchmark</a> for more details.',qt,S,pn='In some cases - such as making the pipeline more deterministic or converting it to other formats - it may be helpful to use the vanilla attention processor, <a href="/docs/diffusers/v0.23.0/en/api/attnprocessor#diffusers.models.attention_processor.AttnProcessor">AttnProcessor</a>. To revert to <a href="/docs/diffusers/v0.23.0/en/api/attnprocessor#diffusers.models.attention_processor.AttnProcessor">AttnProcessor</a>, call the <a href="/docs/diffusers/v0.23.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel.set_default_attn_processor">set_default_attn_processor()</a> function on the pipeline:',At,$,Pt,v,Kt,R,gn="The <code>torch.compile</code> function can often provide an additional speed-up to your PyTorch code. In 🤗 Diffusers, it is usually best to wrap the UNet with <code>torch.compile</code> because it does most of the heavy lifting in the pipeline.",Ot,_,te,C,mn="Depending on GPU type, <code>torch.compile</code> can provide an <em>additional speed-up</em> of <strong>5-300x</strong> on top of SDPA! If you’re using more recent GPU architectures such as Ampere (A100, 3090), Ada (4090), and Hopper (H100), <code>torch.compile</code> is able to squeeze even more performance out of these GPUs.",ee,V,hn="Compilation requires some time to complete, so it is best suited for situations where you prepare your pipeline once and then perform the same type of inference operations multiple times. For example, calling the compiled pipeline on a different image size triggers compilation again which can be expensive.",ne,z,Mn='For more information and different options about <code>torch.compile</code>, refer to the <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow"><code>torch_compile</code></a> tutorial.',le,k,ae,N,bn='We conducted a comprehensive benchmark with PyTorch 2.0’s efficient attention implementation and <code>torch.compile</code> across different GPUs and batch sizes for five of our most used pipelines. The code is benchmarked on 🤗 Diffusers v0.17.0.dev0 to optimize <code>torch.compile</code> usage (see <a href="https://github.com/huggingface/diffusers/pull/3313" rel="nofollow">here</a> for more details).',ie,E,un="Expand the dropdown below to find the code used to benchmark each pipeline:",re,b,H,xe,Y,De,F,qe,Q,Ae,L,Pe,x,Ke,D,Oe,q,tn,A,en,P,se,K,yn='The graph below highlights the relative speed-ups for the <a href="/docs/diffusers/v0.23.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> across five GPU families with PyTorch 2.0 and <code>torch.compile</code> enabled. The benchmarks for the following graphs are measured in <em>number of iterations/second</em>.',ce,O,fn='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/pt2_benchmarks/t2i_speedup.png" alt="t2i_speedup"/>',de,tt,Jn=`To give you an even better idea of how this speed-up holds for the other pipelines, consider the following
graph for an A100 with PyTorch 2.0 and <code>torch.compile</code>:`,oe,et,Tn='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/pt2_benchmarks/a100_numbers.png" alt="a100_numbers"/>',pe,nt,wn="In the following tables, we report our findings in terms of the <em>number of iterations/second</em>.",ge,lt,me,at,jn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">21.66</td> <td align="center">23.13</td> <td align="center">44.03</td> <td align="center">49.74</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">21.81</td> <td align="center">22.40</td> <td align="center">43.92</td> <td align="center">46.32</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">22.24</td> <td align="center">23.23</td> <td align="center">43.76</td> <td align="center">49.25</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">15.02</td> <td align="center">15.82</td> <td align="center">32.13</td> <td align="center">36.08</td></tr> <tr><td align="center">IF</td> <td align="center">20.21 / <br/>13.84 / <br/>24.00</td> <td align="center">20.12 / <br/>13.70 / <br/>24.03</td> <td align="center">❌</td> <td align="center">97.34 / <br/>27.23 / <br/>111.66</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">8.64</td> <td align="center">9.9</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',he,it,Me,rt,Un='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">11.6</td> <td align="center">13.12</td> <td align="center">14.62</td> <td align="center">17.27</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">11.47</td> <td align="center">13.06</td> <td align="center">14.66</td> <td align="center">17.25</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">11.67</td> <td align="center">13.31</td> <td align="center">14.88</td> <td align="center">17.48</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">8.28</td> <td align="center">9.38</td> <td align="center">10.51</td> <td align="center">12.41</td></tr> <tr><td align="center">IF</td> <td align="center">25.02</td> <td align="center">18.04</td> <td align="center">❌</td> <td align="center">48.47</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">2.44</td> <td align="center">2.74</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',be,st,ue,ct,Zn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">3.04</td> <td align="center">3.6</td> <td align="center">3.83</td> <td align="center">4.68</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">2.98</td> <td align="center">3.58</td> <td align="center">3.83</td> <td align="center">4.67</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">3.04</td> <td align="center">3.66</td> <td align="center">3.9</td> <td align="center">4.76</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">2.15</td> <td align="center">2.58</td> <td align="center">2.74</td> <td align="center">3.35</td></tr> <tr><td align="center">IF</td> <td align="center">8.78</td> <td align="center">9.82</td> <td align="center">❌</td> <td align="center">16.77</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">0.64</td> <td align="center">0.72</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',ye,dt,fe,ot,Bn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">18.99</td> <td align="center">19.14</td> <td align="center">20.95</td> <td align="center">22.17</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">18.56</td> <td align="center">19.18</td> <td align="center">20.95</td> <td align="center">22.11</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">19.14</td> <td align="center">19.06</td> <td align="center">21.08</td> <td align="center">22.20</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">13.48</td> <td align="center">13.93</td> <td align="center">15.18</td> <td align="center">15.88</td></tr> <tr><td align="center">IF</td> <td align="center">20.01 / <br/>9.08 / <br/>23.34</td> <td align="center">19.79 / <br/>8.98 / <br/>24.10</td> <td align="center">❌</td> <td align="center">55.75 / <br/>11.57 / <br/>57.67</td></tr></tbody>',Je,pt,Te,gt,Gn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">5.96</td> <td align="center">5.89</td> <td align="center">6.83</td> <td align="center">6.86</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">5.90</td> <td align="center">5.91</td> <td align="center">6.81</td> <td align="center">6.82</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">5.99</td> <td align="center">6.03</td> <td align="center">6.93</td> <td align="center">6.95</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">4.26</td> <td align="center">4.29</td> <td align="center">4.92</td> <td align="center">4.93</td></tr> <tr><td align="center">IF</td> <td align="center">15.41</td> <td align="center">14.76</td> <td align="center">❌</td> <td align="center">22.95</td></tr></tbody>',we,mt,je,ht,In='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">1.66</td> <td align="center">1.66</td> <td align="center">1.92</td> <td align="center">1.90</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">1.65</td> <td align="center">1.65</td> <td align="center">1.91</td> <td align="center">1.89</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">1.69</td> <td align="center">1.69</td> <td align="center">1.95</td> <td align="center">1.93</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">1.19</td> <td align="center">1.19</td> <td align="center">OOM after warmup</td> <td align="center">1.36</td></tr> <tr><td align="center">IF</td> <td align="center">5.43</td> <td align="center">5.29</td> <td align="center">❌</td> <td align="center">7.06</td></tr></tbody>',Ue,Mt,Ze,bt,Wn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">6.9</td> <td align="center">6.95</td> <td align="center">7.3</td> <td align="center">7.56</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">6.84</td> <td align="center">6.99</td> <td align="center">7.04</td> <td align="center">7.55</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">6.91</td> <td align="center">6.7</td> <td align="center">7.01</td> <td align="center">7.37</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">4.89</td> <td align="center">4.86</td> <td align="center">5.35</td> <td align="center">5.48</td></tr> <tr><td align="center">IF</td> <td align="center">17.42 / <br/>2.47 / <br/>18.52</td> <td align="center">16.96 / <br/>2.45 / <br/>18.69</td> <td align="center">❌</td> <td align="center">24.63 / <br/>2.47 / <br/>23.39</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">1.15</td> <td align="center">1.16</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',Be,ut,Ge,yt,Xn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">1.79</td> <td align="center">1.79</td> <td align="center">2.03</td> <td align="center">1.99</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">1.77</td> <td align="center">1.77</td> <td align="center">2.05</td> <td align="center">2.04</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">1.81</td> <td align="center">1.82</td> <td align="center">2.09</td> <td align="center">2.09</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">1.34</td> <td align="center">1.27</td> <td align="center">1.47</td> <td align="center">1.46</td></tr> <tr><td align="center">IF</td> <td align="center">5.79</td> <td align="center">5.61</td> <td align="center">❌</td> <td align="center">7.39</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">0.288</td> <td align="center">0.289</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',Ie,ft,We,Jt,Sn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">2.34s</td> <td align="center">2.30s</td> <td align="center">OOM after 2nd iteration</td> <td align="center">1.99s</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">2.35s</td> <td align="center">2.31s</td> <td align="center">OOM after warmup</td> <td align="center">2.00s</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">2.30s</td> <td align="center">2.26s</td> <td align="center">OOM after 2nd iteration</td> <td align="center">1.95s</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">OOM after 2nd iteration</td> <td align="center">OOM after 2nd iteration</td> <td align="center">OOM after warmup</td> <td align="center">OOM after warmup</td></tr> <tr><td align="center">IF *</td> <td align="center">1.44</td> <td align="center">1.44</td> <td align="center">❌</td> <td align="center">1.94</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">OOM</td> <td align="center">OOM</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',Xe,Tt,Se,wt,$n='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">22.56</td> <td align="center">22.84</td> <td align="center">23.84</td> <td align="center">25.69</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">22.25</td> <td align="center">22.61</td> <td align="center">24.1</td> <td align="center">25.83</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">22.22</td> <td align="center">22.54</td> <td align="center">24.26</td> <td align="center">26.02</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">16.03</td> <td align="center">16.33</td> <td align="center">17.38</td> <td align="center">18.56</td></tr> <tr><td align="center">IF</td> <td align="center">27.08 / <br/>9.07 / <br/>31.23</td> <td align="center">26.75 / <br/>8.92 / <br/>31.47</td> <td align="center">❌</td> <td align="center">68.08 / <br/>11.16 / <br/>65.29</td></tr></tbody>',$e,jt,ve,Ut,vn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">6.46</td> <td align="center">6.35</td> <td align="center">7.29</td> <td align="center">7.3</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">6.33</td> <td align="center">6.27</td> <td align="center">7.31</td> <td align="center">7.26</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">6.47</td> <td align="center">6.4</td> <td align="center">7.44</td> <td align="center">7.39</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">4.59</td> <td align="center">4.54</td> <td align="center">5.27</td> <td align="center">5.26</td></tr> <tr><td align="center">IF</td> <td align="center">16.81</td> <td align="center">16.62</td> <td align="center">❌</td> <td align="center">21.57</td></tr></tbody>',Re,Zt,_e,Bt,Rn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">1.7</td> <td align="center">1.69</td> <td align="center">1.93</td> <td align="center">1.91</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">1.68</td> <td align="center">1.67</td> <td align="center">1.93</td> <td align="center">1.9</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">1.72</td> <td align="center">1.71</td> <td align="center">1.97</td> <td align="center">1.94</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">1.23</td> <td align="center">1.22</td> <td align="center">1.4</td> <td align="center">1.38</td></tr> <tr><td align="center">IF</td> <td align="center">5.01</td> <td align="center">5.00</td> <td align="center">❌</td> <td align="center">6.33</td></tr></tbody>',Ce,Gt,Ve,It,_n='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">40.5</td> <td align="center">41.89</td> <td align="center">44.65</td> <td align="center">49.81</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">40.39</td> <td align="center">41.95</td> <td align="center">44.46</td> <td align="center">49.8</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">40.51</td> <td align="center">41.88</td> <td align="center">44.58</td> <td align="center">49.72</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">29.27</td> <td align="center">30.29</td> <td align="center">32.26</td> <td align="center">36.03</td></tr> <tr><td align="center">IF</td> <td align="center">69.71 / <br/>18.78 / <br/>85.49</td> <td align="center">69.13 / <br/>18.80 / <br/>85.56</td> <td align="center">❌</td> <td align="center">124.60 / <br/>26.37 / <br/>138.79</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">6.8</td> <td align="center">8.18</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',ze,Wt,ke,Xt,Cn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">12.62</td> <td align="center">12.84</td> <td align="center">15.32</td> <td align="center">15.59</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">12.61</td> <td align="center">12,.79</td> <td align="center">15.35</td> <td align="center">15.66</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">12.65</td> <td align="center">12.81</td> <td align="center">15.3</td> <td align="center">15.58</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">9.1</td> <td align="center">9.25</td> <td align="center">11.03</td> <td align="center">11.22</td></tr> <tr><td align="center">IF</td> <td align="center">31.88</td> <td align="center">31.14</td> <td align="center">❌</td> <td align="center">43.92</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">2.19</td> <td align="center">2.35</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',Ne,St,Ee,$t,Vn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">3.17</td> <td align="center">3.2</td> <td align="center">3.84</td> <td align="center">3.85</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">3.16</td> <td align="center">3.2</td> <td align="center">3.84</td> <td align="center">3.85</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">3.17</td> <td align="center">3.2</td> <td align="center">3.85</td> <td align="center">3.85</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">2.23</td> <td align="center">2.3</td> <td align="center">2.7</td> <td align="center">2.75</td></tr> <tr><td align="center">IF</td> <td align="center">9.26</td> <td align="center">9.2</td> <td align="center">❌</td> <td align="center">13.31</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">0.52</td> <td align="center">0.53</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',He,vt,Ye,Rt,zn='<li>Follow this <a href="https://github.com/huggingface/diffusers/pull/3313" rel="nofollow">PR</a> for more details on the environment used for conducting the benchmarks.</li> <li>For the DeepFloyd IF pipeline where batch sizes &gt; 1, we only used a batch size of &gt; 1 in the first IF pipeline for text-to-image generation and NOT for upscaling. That means the two upscaling pipelines received a batch size of 1.</li>',Fe,_t,kn='<em>Thanks to <a href="https://github.com/Chillee" rel="nofollow">Horace He</a> from the PyTorch team for their support in improving our support of <code>torch.compile()</code> in Diffusers.</em>',Qe,Vt,Le;return T=new M({props:{title:"Torch 2.0",local:"torch-20",headingTag:"h1"}}),Z=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHRvcmNoJTIwZGlmZnVzZXJz",highlighted:"pip install --upgrade torch diffusers",wrap:!1}}),B=new M({props:{title:"Scaled dot product attention",local:"scaled-dot-product-attention",headingTag:"h2"}}),W=new J({props:{code:"JTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMjAlMjBmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMkIlMjBmcm9tJTIwZGlmZnVzZXJzLm1vZGVscy5hdHRlbnRpb25fcHJvY2Vzc29yJTIwaW1wb3J0JTIwQXR0blByb2Nlc3NvcjJfMCUwQSUwQSUyMCUyMHBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKSUwQSUyQiUyMHBpcGUudW5ldC5zZXRfYXR0bl9wcm9jZXNzb3IoQXR0blByb2Nlc3NvcjJfMCgpKSUwQSUwQSUyMCUyMHByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEElMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`  import torch
  from diffusers import DiffusionPipeline
<span class="hljs-addition">+ from diffusers.models.attention_processor import AttnProcessor2_0</span>

  pipe = DiffusionPipeline.from_pretrained(&quot;runwayml/stable-diffusion-v1-5&quot;, torch_dtype=torch.float16, use_safetensors=True).to(&quot;cuda&quot;)
<span class="hljs-addition">+ pipe.unet.set_attn_processor(AttnProcessor2_0())</span>

  prompt = &quot;a photo of an astronaut riding a horse on mars&quot;
  image = pipe(prompt).images[0]`,wrap:!1}}),$=new J({props:{code:"JTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMjAlMjBmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMjAlMjBmcm9tJTIwZGlmZnVzZXJzLm1vZGVscy5hdHRlbnRpb25fcHJvY2Vzc29yJTIwaW1wb3J0JTIwQXR0blByb2Nlc3NvciUwQSUwQSUyMCUyMHBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKSUwQSUyQiUyMHBpcGUudW5ldC5zZXRfZGVmYXVsdF9hdHRuX3Byb2Nlc3NvcigpJTBBJTBBJTIwJTIwcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQSUyMCUyMGltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`  import torch
  from diffusers import DiffusionPipeline
  from diffusers.models.attention_processor import AttnProcessor

  pipe = DiffusionPipeline.from_pretrained(&quot;runwayml/stable-diffusion-v1-5&quot;, torch_dtype=torch.float16, use_safetensors=True).to(&quot;cuda&quot;)
<span class="hljs-addition">+ pipe.unet.set_default_attn_processor()</span>

  prompt = &quot;a photo of an astronaut riding a horse on mars&quot;
  image = pipe(prompt).images[0]`,wrap:!1}}),v=new M({props:{title:"torch.compile",local:"torchcompile",headingTag:"h2"}}),_=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSkudG8oJTIyY3VkYSUyMiklMEFwaXBlLnVuZXQlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGUudW5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKSUwQWltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRHN0ZXBzJTJDJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEYmF0Y2hfc2l6ZSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
images = pipe(prompt, num_inference_steps=steps, num_images_per_prompt=batch_size).images[<span class="hljs-number">0</span>]`,wrap:!1}}),k=new M({props:{title:"Benchmark",local:"benchmark",headingTag:"h2"}}),H=new M({props:{title:"Stable Diffusion text-to-image",local:"stable-diffusion-text-to-image",headingTag:"h3"}}),Y=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwYXRoJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEElMEFydW5fY29tcGlsZSUyMCUzRCUyMFRydWUlMjAlMjAlMjMlMjBTZXQlMjBUcnVlJTIwJTJGJTIwRmFsc2UlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHBhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQSUwQWlmJTIwcnVuX2NvbXBpbGUlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJSdW4lMjB0b3JjaCUyMGNvbXBpbGUlMjIpJTBBJTIwJTIwJTIwJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJnaGlibGklMjBzdHlsZSUyQyUyMGElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTIwd2l0aCUyMGNhc3RsZXMlMjIlMEElMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0KS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>

pipe = DiffusionPipeline.from_pretrained(path, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Run torch compile&quot;</span>)
    pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with castles&quot;</span>

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    images = pipe(prompt=prompt).images`,wrap:!1}}),F=new M({props:{title:"Stable Diffusion image-to-image",local:"stable-diffusion-image-to-image",headingTag:"h3"}}),Q=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhyZXNwb25zZS5jb250ZW50KSkuY29udmVydCglMjJSR0IlMjIpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGluaXRfaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXBhdGglMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQSUwQXJ1bl9jb21waWxlJTIwJTNEJTIwVHJ1ZSUyMCUyMCUyMyUyMFNldCUyMFRydWUlMjAlMkYlMjBGYWxzZSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHBhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQSUwQWlmJTIwcnVuX2NvbXBpbGUlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJSdW4lMjB0b3JjaCUyMGNvbXBpbGUlMjIpJTBBJTIwJTIwJTIwJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJnaGlibGklMjBzdHlsZSUyQyUyMGElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTIwd2l0aCUyMGNhc3RsZXMlMjIlMEElMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>

pipe = StableDiffusionImg2ImgPipeline.from_pretrained(path, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Run torch compile&quot;</span>)
    pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with castles&quot;</span>

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),L=new M({props:{title:"Stable Diffusion inpainting",local:"stable-diffusion-inpainting",headingTag:"h3"}}),x=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInpaintPipeline
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

path = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>

pipe = StableDiffusionInpaintPipeline.from_pretrained(path, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Run torch compile&quot;</span>)
    pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with castles&quot;</span>

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    image = pipe(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),D=new M({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),q=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQWltcG9ydCUyMHJlcXVlc3RzJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhyZXNwb25zZS5jb250ZW50KSkuY29udmVydCglMjJSR0IlMjIpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGluaXRfaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXBhdGglMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQSUwQXJ1bl9jb21waWxlJTIwJTNEJTIwVHJ1ZSUyMCUyMCUyMyUyMFNldCUyMFRydWUlMjAlMkYlMjBGYWxzZSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmxsbHlhc3ZpZWwlMkZzZC1jb250cm9sbmV0LWNhbm55JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBwYXRoJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQXBpcGUuY29udHJvbG5ldC50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEElMEFpZiUyMHJ1bl9jb21waWxlJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyUnVuJTIwdG9yY2glMjBjb21waWxlJTIyKSUwQSUyMCUyMCUyMCUyMHBpcGUudW5ldCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZS51bmV0JTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBJTIwJTIwJTIwJTIwcGlwZS5jb250cm9sbmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLmNvbnRyb2xuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJnaGlibGklMjBzdHlsZSUyQyUyMGElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTIwd2l0aCUyMGNhc3RsZXMlMjIlMEElMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    path, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.to(memory_format=torch.channels_last)
pipe.controlnet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Run torch compile&quot;</span>)
    pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    pipe.controlnet = torch.<span class="hljs-built_in">compile</span>(pipe.controlnet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with castles&quot;</span>

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),A=new M({props:{title:"DeepFloyd IF text-to-image + upscaling",local:"deepfloyd-if-text-to-image--upscaling",headingTag:"h3"}}),P=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;DeepFloyd/IF-I-M-v1.0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, text_encoder=<span class="hljs-literal">None</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe_2 = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;DeepFloyd/IF-II-M-v1.0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, text_encoder=<span class="hljs-literal">None</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe_2.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe_3 = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-x4-upscaler&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe_3.to(<span class="hljs-string">&quot;cuda&quot;</span>)


pipe.unet.to(memory_format=torch.channels_last)
pipe_2.unet.to(memory_format=torch.channels_last)
pipe_3.unet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    pipe_2.unet = torch.<span class="hljs-built_in">compile</span>(pipe_2.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    pipe_3.unet = torch.<span class="hljs-built_in">compile</span>(pipe_3.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;the blue hulk&quot;</span>

prompt_embeds = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">4096</span>), dtype=torch.float16)
neg_prompt_embeds = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">4096</span>), dtype=torch.float16)

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    image = pipe(prompt_embeds=prompt_embeds, negative_prompt_embeds=neg_prompt_embeds, output_type=<span class="hljs-string">&quot;pt&quot;</span>).images
    image_2 = pipe_2(image=image, prompt_embeds=prompt_embeds, negative_prompt_embeds=neg_prompt_embeds, output_type=<span class="hljs-string">&quot;pt&quot;</span>).images
    image_3 = pipe_3(prompt=prompt, image=image, noise_level=<span class="hljs-number">100</span>).images`,wrap:!1}}),lt=new M({props:{title:"A100 (batch size: 1)",local:"a100-batch-size-1",headingTag:"h3"}}),it=new M({props:{title:"A100 (batch size: 4)",local:"a100-batch-size-4",headingTag:"h3"}}),st=new M({props:{title:"A100 (batch size: 16)",local:"a100-batch-size-16",headingTag:"h3"}}),dt=new M({props:{title:"V100 (batch size: 1)",local:"v100-batch-size-1",headingTag:"h3"}}),pt=new M({props:{title:"V100 (batch size: 4)",local:"v100-batch-size-4",headingTag:"h3"}}),mt=new M({props:{title:"V100 (batch size: 16)",local:"v100-batch-size-16",headingTag:"h3"}}),Mt=new M({props:{title:"T4 (batch size: 1)",local:"t4-batch-size-1",headingTag:"h3"}}),ut=new M({props:{title:"T4 (batch size: 4)",local:"t4-batch-size-4",headingTag:"h3"}}),ft=new M({props:{title:"T4 (batch size: 16)",local:"t4-batch-size-16",headingTag:"h3"}}),Tt=new M({props:{title:"RTX 3090 (batch size: 1)",local:"rtx-3090-batch-size-1",headingTag:"h3"}}),jt=new M({props:{title:"RTX 3090 (batch size: 4)",local:"rtx-3090-batch-size-4",headingTag:"h3"}}),Zt=new M({props:{title:"RTX 3090 (batch size: 16)",local:"rtx-3090-batch-size-16",headingTag:"h3"}}),Gt=new M({props:{title:"RTX 4090 (batch size: 1)",local:"rtx-4090-batch-size-1",headingTag:"h3"}}),Wt=new M({props:{title:"RTX 4090 (batch size: 4)",local:"rtx-4090-batch-size-4",headingTag:"h3"}}),St=new M({props:{title:"RTX 4090 (batch size: 16)",local:"rtx-4090-batch-size-16",headingTag:"h3"}}),vt=new M({props:{title:"Notes",local:"notes",headingTag:"h2"}}),{c(){f=r("meta"),zt=a(),Ct=r("p"),kt=a(),d(T.$$.fragment),Nt=a(),w=r("p"),w.innerHTML=an,Et=a(),j=r("ol"),j.innerHTML=rn,Ht=a(),U=r("p"),U.textContent=sn,Yt=a(),d(Z.$$.fragment),Ft=a(),d(B.$$.fragment),Qt=a(),G=r("p"),G.innerHTML=cn,Lt=a(),I=r("p"),I.innerHTML=dn,xt=a(),d(W.$$.fragment),Dt=a(),X=r("p"),X.innerHTML=on,qt=a(),S=r("p"),S.innerHTML=pn,At=a(),d($.$$.fragment),Pt=a(),d(v.$$.fragment),Kt=a(),R=r("p"),R.innerHTML=gn,Ot=a(),d(_.$$.fragment),te=a(),C=r("p"),C.innerHTML=mn,ee=a(),V=r("p"),V.textContent=hn,ne=a(),z=r("p"),z.innerHTML=Mn,le=a(),d(k.$$.fragment),ae=a(),N=r("p"),N.innerHTML=bn,ie=a(),E=r("p"),E.textContent=un,re=a(),b=r("details"),d(H.$$.fragment),xe=a(),d(Y.$$.fragment),De=a(),d(F.$$.fragment),qe=a(),d(Q.$$.fragment),Ae=a(),d(L.$$.fragment),Pe=a(),d(x.$$.fragment),Ke=a(),d(D.$$.fragment),Oe=a(),d(q.$$.fragment),tn=a(),d(A.$$.fragment),en=a(),d(P.$$.fragment),se=a(),K=r("p"),K.innerHTML=yn,ce=a(),O=r("p"),O.innerHTML=fn,de=a(),tt=r("p"),tt.innerHTML=Jn,oe=a(),et=r("p"),et.innerHTML=Tn,pe=a(),nt=r("p"),nt.innerHTML=wn,ge=a(),d(lt.$$.fragment),me=a(),at=r("table"),at.innerHTML=jn,he=a(),d(it.$$.fragment),Me=a(),rt=r("table"),rt.innerHTML=Un,be=a(),d(st.$$.fragment),ue=a(),ct=r("table"),ct.innerHTML=Zn,ye=a(),d(dt.$$.fragment),fe=a(),ot=r("table"),ot.innerHTML=Bn,Je=a(),d(pt.$$.fragment),Te=a(),gt=r("table"),gt.innerHTML=Gn,we=a(),d(mt.$$.fragment),je=a(),ht=r("table"),ht.innerHTML=In,Ue=a(),d(Mt.$$.fragment),Ze=a(),bt=r("table"),bt.innerHTML=Wn,Be=a(),d(ut.$$.fragment),Ge=a(),yt=r("table"),yt.innerHTML=Xn,Ie=a(),d(ft.$$.fragment),We=a(),Jt=r("table"),Jt.innerHTML=Sn,Xe=a(),d(Tt.$$.fragment),Se=a(),wt=r("table"),wt.innerHTML=$n,$e=a(),d(jt.$$.fragment),ve=a(),Ut=r("table"),Ut.innerHTML=vn,Re=a(),d(Zt.$$.fragment),_e=a(),Bt=r("table"),Bt.innerHTML=Rn,Ce=a(),d(Gt.$$.fragment),Ve=a(),It=r("table"),It.innerHTML=_n,ze=a(),d(Wt.$$.fragment),ke=a(),Xt=r("table"),Xt.innerHTML=Cn,Ne=a(),d(St.$$.fragment),Ee=a(),$t=r("table"),$t.innerHTML=Vn,He=a(),d(vt.$$.fragment),Ye=a(),Rt=r("ul"),Rt.innerHTML=zn,Fe=a(),_t=r("p"),_t.innerHTML=kn,Qe=a(),Vt=r("p"),this.h()},l(t){const e=Ln("svelte-u9bgzb",document.head);f=s(e,"META",{name:!0,content:!0}),e.forEach(n),zt=i(t),Ct=s(t,"P",{}),nn(Ct).forEach(n),kt=i(t),o(T.$$.fragment,t),Nt=i(t),w=s(t,"P",{"data-svelte-h":!0}),c(w)!=="svelte-15wmwhw"&&(w.innerHTML=an),Et=i(t),j=s(t,"OL",{"data-svelte-h":!0}),c(j)!=="svelte-19p82dc"&&(j.innerHTML=rn),Ht=i(t),U=s(t,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1u908i1"&&(U.textContent=sn),Yt=i(t),o(Z.$$.fragment,t),Ft=i(t),o(B.$$.fragment,t),Qt=i(t),G=s(t,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1bb69gh"&&(G.innerHTML=cn),Lt=i(t),I=s(t,"P",{"data-svelte-h":!0}),c(I)!=="svelte-dj2603"&&(I.innerHTML=dn),xt=i(t),o(W.$$.fragment,t),Dt=i(t),X=s(t,"P",{"data-svelte-h":!0}),c(X)!=="svelte-psbnvm"&&(X.innerHTML=on),qt=i(t),S=s(t,"P",{"data-svelte-h":!0}),c(S)!=="svelte-15xcloi"&&(S.innerHTML=pn),At=i(t),o($.$$.fragment,t),Pt=i(t),o(v.$$.fragment,t),Kt=i(t),R=s(t,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1vjh5md"&&(R.innerHTML=gn),Ot=i(t),o(_.$$.fragment,t),te=i(t),C=s(t,"P",{"data-svelte-h":!0}),c(C)!=="svelte-mm2mnz"&&(C.innerHTML=mn),ee=i(t),V=s(t,"P",{"data-svelte-h":!0}),c(V)!=="svelte-19iy5vt"&&(V.textContent=hn),ne=i(t),z=s(t,"P",{"data-svelte-h":!0}),c(z)!=="svelte-yz7oqo"&&(z.innerHTML=Mn),le=i(t),o(k.$$.fragment,t),ae=i(t),N=s(t,"P",{"data-svelte-h":!0}),c(N)!=="svelte-km3nc0"&&(N.innerHTML=bn),ie=i(t),E=s(t,"P",{"data-svelte-h":!0}),c(E)!=="svelte-pe5bn7"&&(E.textContent=un),re=i(t),b=s(t,"DETAILS",{});var u=nn(b);o(H.$$.fragment,u),xe=i(u),o(Y.$$.fragment,u),De=i(u),o(F.$$.fragment,u),qe=i(u),o(Q.$$.fragment,u),Ae=i(u),o(L.$$.fragment,u),Pe=i(u),o(x.$$.fragment,u),Ke=i(u),o(D.$$.fragment,u),Oe=i(u),o(q.$$.fragment,u),tn=i(u),o(A.$$.fragment,u),en=i(u),o(P.$$.fragment,u),u.forEach(n),se=i(t),K=s(t,"P",{"data-svelte-h":!0}),c(K)!=="svelte-1cr83s7"&&(K.innerHTML=yn),ce=i(t),O=s(t,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1sjwyaz"&&(O.innerHTML=fn),de=i(t),tt=s(t,"P",{"data-svelte-h":!0}),c(tt)!=="svelte-1zzsz7"&&(tt.innerHTML=Jn),oe=i(t),et=s(t,"P",{"data-svelte-h":!0}),c(et)!=="svelte-19p9vzv"&&(et.innerHTML=Tn),pe=i(t),nt=s(t,"P",{"data-svelte-h":!0}),c(nt)!=="svelte-18iwyus"&&(nt.innerHTML=wn),ge=i(t),o(lt.$$.fragment,t),me=i(t),at=s(t,"TABLE",{"data-svelte-h":!0}),c(at)!=="svelte-14f48w"&&(at.innerHTML=jn),he=i(t),o(it.$$.fragment,t),Me=i(t),rt=s(t,"TABLE",{"data-svelte-h":!0}),c(rt)!=="svelte-19bbd89"&&(rt.innerHTML=Un),be=i(t),o(st.$$.fragment,t),ue=i(t),ct=s(t,"TABLE",{"data-svelte-h":!0}),c(ct)!=="svelte-cd9a2o"&&(ct.innerHTML=Zn),ye=i(t),o(dt.$$.fragment,t),fe=i(t),ot=s(t,"TABLE",{"data-svelte-h":!0}),c(ot)!=="svelte-9j8rj7"&&(ot.innerHTML=Bn),Je=i(t),o(pt.$$.fragment,t),Te=i(t),gt=s(t,"TABLE",{"data-svelte-h":!0}),c(gt)!=="svelte-1xs3uwi"&&(gt.innerHTML=Gn),we=i(t),o(mt.$$.fragment,t),je=i(t),ht=s(t,"TABLE",{"data-svelte-h":!0}),c(ht)!=="svelte-1elkjwp"&&(ht.innerHTML=In),Ue=i(t),o(Mt.$$.fragment,t),Ze=i(t),bt=s(t,"TABLE",{"data-svelte-h":!0}),c(bt)!=="svelte-sqqgka"&&(bt.innerHTML=Wn),Be=i(t),o(ut.$$.fragment,t),Ge=i(t),yt=s(t,"TABLE",{"data-svelte-h":!0}),c(yt)!=="svelte-15f755w"&&(yt.innerHTML=Xn),Ie=i(t),o(ft.$$.fragment,t),We=i(t),Jt=s(t,"TABLE",{"data-svelte-h":!0}),c(Jt)!=="svelte-uuno4d"&&(Jt.innerHTML=Sn),Xe=i(t),o(Tt.$$.fragment,t),Se=i(t),wt=s(t,"TABLE",{"data-svelte-h":!0}),c(wt)!=="svelte-1hbo08l"&&(wt.innerHTML=$n),$e=i(t),o(jt.$$.fragment,t),ve=i(t),Ut=s(t,"TABLE",{"data-svelte-h":!0}),c(Ut)!=="svelte-abi9u4"&&(Ut.innerHTML=vn),Re=i(t),o(Zt.$$.fragment,t),_e=i(t),Bt=s(t,"TABLE",{"data-svelte-h":!0}),c(Bt)!=="svelte-11m8i0f"&&(Bt.innerHTML=Rn),Ce=i(t),o(Gt.$$.fragment,t),Ve=i(t),It=s(t,"TABLE",{"data-svelte-h":!0}),c(It)!=="svelte-1i4s3fg"&&(It.innerHTML=_n),ze=i(t),o(Wt.$$.fragment,t),ke=i(t),Xt=s(t,"TABLE",{"data-svelte-h":!0}),c(Xt)!=="svelte-13cqeai"&&(Xt.innerHTML=Cn),Ne=i(t),o(St.$$.fragment,t),Ee=i(t),$t=s(t,"TABLE",{"data-svelte-h":!0}),c($t)!=="svelte-16al08t"&&($t.innerHTML=Vn),He=i(t),o(vt.$$.fragment,t),Ye=i(t),Rt=s(t,"UL",{"data-svelte-h":!0}),c(Rt)!=="svelte-1bizas7"&&(Rt.innerHTML=zn),Fe=i(t),_t=s(t,"P",{"data-svelte-h":!0}),c(_t)!=="svelte-7zliwv"&&(_t.innerHTML=kn),Qe=i(t),Vt=s(t,"P",{}),nn(Vt).forEach(n),this.h()},h(){Nn(f,"name","hf:doc:metadata"),Nn(f,"content",Dn)},m(t,e){y(document.head,f),l(t,zt,e),l(t,Ct,e),l(t,kt,e),p(T,t,e),l(t,Nt,e),l(t,w,e),l(t,Et,e),l(t,j,e),l(t,Ht,e),l(t,U,e),l(t,Yt,e),p(Z,t,e),l(t,Ft,e),p(B,t,e),l(t,Qt,e),l(t,G,e),l(t,Lt,e),l(t,I,e),l(t,xt,e),p(W,t,e),l(t,Dt,e),l(t,X,e),l(t,qt,e),l(t,S,e),l(t,At,e),p($,t,e),l(t,Pt,e),p(v,t,e),l(t,Kt,e),l(t,R,e),l(t,Ot,e),p(_,t,e),l(t,te,e),l(t,C,e),l(t,ee,e),l(t,V,e),l(t,ne,e),l(t,z,e),l(t,le,e),p(k,t,e),l(t,ae,e),l(t,N,e),l(t,ie,e),l(t,E,e),l(t,re,e),l(t,b,e),p(H,b,null),y(b,xe),p(Y,b,null),y(b,De),p(F,b,null),y(b,qe),p(Q,b,null),y(b,Ae),p(L,b,null),y(b,Pe),p(x,b,null),y(b,Ke),p(D,b,null),y(b,Oe),p(q,b,null),y(b,tn),p(A,b,null),y(b,en),p(P,b,null),l(t,se,e),l(t,K,e),l(t,ce,e),l(t,O,e),l(t,de,e),l(t,tt,e),l(t,oe,e),l(t,et,e),l(t,pe,e),l(t,nt,e),l(t,ge,e),p(lt,t,e),l(t,me,e),l(t,at,e),l(t,he,e),p(it,t,e),l(t,Me,e),l(t,rt,e),l(t,be,e),p(st,t,e),l(t,ue,e),l(t,ct,e),l(t,ye,e),p(dt,t,e),l(t,fe,e),l(t,ot,e),l(t,Je,e),p(pt,t,e),l(t,Te,e),l(t,gt,e),l(t,we,e),p(mt,t,e),l(t,je,e),l(t,ht,e),l(t,Ue,e),p(Mt,t,e),l(t,Ze,e),l(t,bt,e),l(t,Be,e),p(ut,t,e),l(t,Ge,e),l(t,yt,e),l(t,Ie,e),p(ft,t,e),l(t,We,e),l(t,Jt,e),l(t,Xe,e),p(Tt,t,e),l(t,Se,e),l(t,wt,e),l(t,$e,e),p(jt,t,e),l(t,ve,e),l(t,Ut,e),l(t,Re,e),p(Zt,t,e),l(t,_e,e),l(t,Bt,e),l(t,Ce,e),p(Gt,t,e),l(t,Ve,e),l(t,It,e),l(t,ze,e),p(Wt,t,e),l(t,ke,e),l(t,Xt,e),l(t,Ne,e),p(St,t,e),l(t,Ee,e),l(t,$t,e),l(t,He,e),p(vt,t,e),l(t,Ye,e),l(t,Rt,e),l(t,Fe,e),l(t,_t,e),l(t,Qe,e),l(t,Vt,e),Le=!0},p:Hn,i(t){Le||(g(T.$$.fragment,t),g(Z.$$.fragment,t),g(B.$$.fragment,t),g(W.$$.fragment,t),g($.$$.fragment,t),g(v.$$.fragment,t),g(_.$$.fragment,t),g(k.$$.fragment,t),g(H.$$.fragment,t),g(Y.$$.fragment,t),g(F.$$.fragment,t),g(Q.$$.fragment,t),g(L.$$.fragment,t),g(x.$$.fragment,t),g(D.$$.fragment,t),g(q.$$.fragment,t),g(A.$$.fragment,t),g(P.$$.fragment,t),g(lt.$$.fragment,t),g(it.$$.fragment,t),g(st.$$.fragment,t),g(dt.$$.fragment,t),g(pt.$$.fragment,t),g(mt.$$.fragment,t),g(Mt.$$.fragment,t),g(ut.$$.fragment,t),g(ft.$$.fragment,t),g(Tt.$$.fragment,t),g(jt.$$.fragment,t),g(Zt.$$.fragment,t),g(Gt.$$.fragment,t),g(Wt.$$.fragment,t),g(St.$$.fragment,t),g(vt.$$.fragment,t),Le=!0)},o(t){m(T.$$.fragment,t),m(Z.$$.fragment,t),m(B.$$.fragment,t),m(W.$$.fragment,t),m($.$$.fragment,t),m(v.$$.fragment,t),m(_.$$.fragment,t),m(k.$$.fragment,t),m(H.$$.fragment,t),m(Y.$$.fragment,t),m(F.$$.fragment,t),m(Q.$$.fragment,t),m(L.$$.fragment,t),m(x.$$.fragment,t),m(D.$$.fragment,t),m(q.$$.fragment,t),m(A.$$.fragment,t),m(P.$$.fragment,t),m(lt.$$.fragment,t),m(it.$$.fragment,t),m(st.$$.fragment,t),m(dt.$$.fragment,t),m(pt.$$.fragment,t),m(mt.$$.fragment,t),m(Mt.$$.fragment,t),m(ut.$$.fragment,t),m(ft.$$.fragment,t),m(Tt.$$.fragment,t),m(jt.$$.fragment,t),m(Zt.$$.fragment,t),m(Gt.$$.fragment,t),m(Wt.$$.fragment,t),m(St.$$.fragment,t),m(vt.$$.fragment,t),Le=!1},d(t){t&&(n(zt),n(Ct),n(kt),n(Nt),n(w),n(Et),n(j),n(Ht),n(U),n(Yt),n(Ft),n(Qt),n(G),n(Lt),n(I),n(xt),n(Dt),n(X),n(qt),n(S),n(At),n(Pt),n(Kt),n(R),n(Ot),n(te),n(C),n(ee),n(V),n(ne),n(z),n(le),n(ae),n(N),n(ie),n(E),n(re),n(b),n(se),n(K),n(ce),n(O),n(de),n(tt),n(oe),n(et),n(pe),n(nt),n(ge),n(me),n(at),n(he),n(Me),n(rt),n(be),n(ue),n(ct),n(ye),n(fe),n(ot),n(Je),n(Te),n(gt),n(we),n(je),n(ht),n(Ue),n(Ze),n(bt),n(Be),n(Ge),n(yt),n(Ie),n(We),n(Jt),n(Xe),n(Se),n(wt),n($e),n(ve),n(Ut),n(Re),n(_e),n(Bt),n(Ce),n(Ve),n(It),n(ze),n(ke),n(Xt),n(Ne),n(Ee),n($t),n(He),n(Ye),n(Rt),n(Fe),n(_t),n(Qe),n(Vt)),n(f),h(T,t),h(Z,t),h(B,t),h(W,t),h($,t),h(v,t),h(_,t),h(k,t),h(H),h(Y),h(F),h(Q),h(L),h(x),h(D),h(q),h(A),h(P),h(lt,t),h(it,t),h(st,t),h(dt,t),h(pt,t),h(mt,t),h(Mt,t),h(ut,t),h(ft,t),h(Tt,t),h(jt,t),h(Zt,t),h(Gt,t),h(Wt,t),h(St,t),h(vt,t)}}}const Dn='{"title":"Torch 2.0","local":"torch-20","sections":[{"title":"Scaled dot product attention","local":"scaled-dot-product-attention","sections":[],"depth":2},{"title":"torch.compile","local":"torchcompile","sections":[],"depth":2},{"title":"Benchmark","local":"benchmark","sections":[{"title":"Stable Diffusion text-to-image","local":"stable-diffusion-text-to-image","sections":[],"depth":3},{"title":"Stable Diffusion image-to-image","local":"stable-diffusion-image-to-image","sections":[],"depth":3},{"title":"Stable Diffusion inpainting","local":"stable-diffusion-inpainting","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3},{"title":"DeepFloyd IF text-to-image + upscaling","local":"deepfloyd-if-text-to-image--upscaling","sections":[],"depth":3},{"title":"A100 (batch size: 1)","local":"a100-batch-size-1","sections":[],"depth":3},{"title":"A100 (batch size: 4)","local":"a100-batch-size-4","sections":[],"depth":3},{"title":"A100 (batch size: 16)","local":"a100-batch-size-16","sections":[],"depth":3},{"title":"V100 (batch size: 1)","local":"v100-batch-size-1","sections":[],"depth":3},{"title":"V100 (batch size: 4)","local":"v100-batch-size-4","sections":[],"depth":3},{"title":"V100 (batch size: 16)","local":"v100-batch-size-16","sections":[],"depth":3},{"title":"T4 (batch size: 1)","local":"t4-batch-size-1","sections":[],"depth":3},{"title":"T4 (batch size: 4)","local":"t4-batch-size-4","sections":[],"depth":3},{"title":"T4 (batch size: 16)","local":"t4-batch-size-16","sections":[],"depth":3},{"title":"RTX 3090 (batch size: 1)","local":"rtx-3090-batch-size-1","sections":[],"depth":3},{"title":"RTX 3090 (batch size: 4)","local":"rtx-3090-batch-size-4","sections":[],"depth":3},{"title":"RTX 3090 (batch size: 16)","local":"rtx-3090-batch-size-16","sections":[],"depth":3},{"title":"RTX 4090 (batch size: 1)","local":"rtx-4090-batch-size-1","sections":[],"depth":3},{"title":"RTX 4090 (batch size: 4)","local":"rtx-4090-batch-size-4","sections":[],"depth":3},{"title":"RTX 4090 (batch size: 16)","local":"rtx-4090-batch-size-16","sections":[],"depth":3}],"depth":2},{"title":"Notes","local":"notes","sections":[],"depth":2}],"depth":1}';function qn(ln){return Yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tl extends Fn{constructor(f){super(),Qn(this,f,qn,xn,En,{})}}export{tl as component};
