import{S as E2,i as j2,s as C2,e as t,k as l,w as _,t as a,M as F2,c as s,d as r,m as d,a as n,x as P,h as i,b as c,N as I2,G as e,g as h,y as b,q as w,o as y,B as $,v as M2,L as ko}from"../../chunks/vendor-hf-doc-builder.js";import{T as Or}from"../../chunks/Tip-hf-doc-builder.js";import{D as x}from"../../chunks/Docstring-hf-doc-builder.js";import{C as To}from"../../chunks/CodeBlock-hf-doc-builder.js";import{I as j}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{E as $o}from"../../chunks/ExampleCodeBlock-hf-doc-builder.js";function q2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import PerceiverModel, PerceiverConfig

# Initializing a Perceiver deepmind/language-perceiver style configuration
configuration = PerceiverConfig()

# Initializing a model from the deepmind/language-perceiver style configuration
model = PerceiverModel(configuration)

# Accessing the model configuration
configuration = model.config`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverModel, PerceiverConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Perceiver deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PerceiverConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){u=t("p"),T=a("Example:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Example:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function z2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function A2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import PerceiverConfig, PerceiverTokenizer, PerceiverImageProcessor, PerceiverModel
from transformers.models.perceiver.modeling_perceiver import (
    PerceiverTextPreprocessor,
    PerceiverImagePreprocessor,
    PerceiverClassificationDecoder,
)
import torch
import requests
from PIL import Image

# EXAMPLE 1: using the Perceiver to classify texts
# - we define a TextPreprocessor, which can be used to embed tokens
# - we define a ClassificationDecoder, which can be used to decode the
# final hidden states of the latents to classification logits
# using trainable position embeddings
config = PerceiverConfig()
preprocessor = PerceiverTextPreprocessor(config)
decoder = PerceiverClassificationDecoder(
    config,
    num_channels=config.d_latents,
    trainable_position_encoding_kwargs=dict(num_channels=config.d_latents, index_dims=1),
    use_query_residual=True,
)
model = PerceiverModel(config, input_preprocessor=preprocessor, decoder=decoder)

# you can then do a forward pass as follows:
tokenizer = PerceiverTokenizer()
text = "hello world"
inputs = tokenizer(text, return_tensors="pt").input_ids

with torch.no_grad():
    outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# to train, one can train the model using standard cross-entropy:
criterion = torch.nn.CrossEntropyLoss()

labels = torch.tensor([1])
loss = criterion(logits, labels)

# EXAMPLE 2: using the Perceiver to classify images
# - we define an ImagePreprocessor, which can be used to embed images
config = PerceiverConfig(image_size=224)
preprocessor = PerceiverImagePreprocessor(
    config,
    prep_type="conv1x1",
    spatial_downsample=1,
    out_channels=256,
    position_encoding_type="trainable",
    concat_or_add_pos="concat",
    project_pos_dim=256,
    trainable_position_encoding_kwargs=dict(
        num_channels=256,
        index_dims=config.image_size**2,
    ),
)

model = PerceiverModel(
    config,
    input_preprocessor=preprocessor,
    decoder=PerceiverClassificationDecoder(
        config,
        num_channels=config.d_latents,
        trainable_position_encoding_kwargs=dict(num_channels=config.d_latents, index_dims=1),
        use_query_residual=True,
    ),
)

# you can then do a forward pass as follows:
image_processor = PerceiverImageProcessor()
url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)
inputs = image_processor(image, return_tensors="pt").pixel_values

with torch.no_grad():
    outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# to train, one can train the model using standard cross-entropy:
criterion = torch.nn.CrossEntropyLoss()

labels = torch.tensor([1])
loss = criterion(logits, labels)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverConfig, PerceiverTokenizer, PerceiverImageProcessor, PerceiverModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.models.perceiver.modeling_perceiver <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    PerceiverTextPreprocessor,
<span class="hljs-meta">... </span>    PerceiverImagePreprocessor,
<span class="hljs-meta">... </span>    PerceiverClassificationDecoder,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 1: using the Perceiver to classify texts</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a TextPreprocessor, which can be used to embed tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a ClassificationDecoder, which can be used to decode the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># final hidden states of the latents to classification logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># using trainable position embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PerceiverConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverTextPreprocessor(config)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    num_channels=config.d_latents,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(config, input_preprocessor=preprocessor, decoder=decoder)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = PerceiverTokenizer()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 2: using the Perceiver to classify images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define an ImagePreprocessor, which can be used to embed images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PerceiverConfig(image_size=<span class="hljs-number">224</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverImagePreprocessor(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    prep_type=<span class="hljs-string">&quot;conv1x1&quot;</span>,
<span class="hljs-meta">... </span>    spatial_downsample=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    position_encoding_type=<span class="hljs-string">&quot;trainable&quot;</span>,
<span class="hljs-meta">... </span>    concat_or_add_pos=<span class="hljs-string">&quot;concat&quot;</span>,
<span class="hljs-meta">... </span>    project_pos_dim=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(
<span class="hljs-meta">... </span>        num_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>        index_dims=config.image_size**<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    input_preprocessor=preprocessor,
<span class="hljs-meta">... </span>    decoder=PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>        config,
<span class="hljs-meta">... </span>        num_channels=config.d_latents,
<span class="hljs-meta">... </span>        trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>        use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = PerceiverImageProcessor()
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function D2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function O2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import AutoTokenizer, PerceiverForMaskedLM
import torch

tokenizer = AutoTokenizer.from_pretrained("deepmind/language-perceiver")
model = PerceiverForMaskedLM.from_pretrained("deepmind/language-perceiver")

# training
text = "This is an incomplete sentence where some words are missing."
inputs = tokenizer(text, padding="max_length", return_tensors="pt")
# mask " missing."
inputs["input_ids"][0, 52:61] = tokenizer.mask_token_id
labels = tokenizer(text, padding="max_length", return_tensors="pt").input_ids

outputs = model(**inputs, labels=labels)
loss = outputs.loss
round(loss.item(), 2)

logits = outputs.logits
list(logits.shape)

# inference
text = "This is an incomplete sentence where some words are missing."
encoding = tokenizer(text, padding="max_length", return_tensors="pt")

# mask bytes corresponding to " missing.". Note that the model performs much better if the masked span starts with a space.
encoding["input_ids"][0, 52:61] = tokenizer.mask_token_id

# forward pass
with torch.no_grad():
    outputs = model(**encoding)
logits = outputs.logits
list(logits.shape)

masked_tokens_predictions = logits[0, 52:61].argmax(dim=-1).tolist()
tokenizer.decode(masked_tokens_predictions)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PerceiverForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMaskedLM.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask &quot; missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">19.87</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">262</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask bytes corresponding to &quot; missing.&quot;. Note that the model performs much better if the masked span starts with a space.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">262</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>masked_tokens_predictions = logits[<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>].argmax(dim=-<span class="hljs-number">1</span>).tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(masked_tokens_predictions)
<span class="hljs-string">&#x27; missing.&#x27;</span>`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function N2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function L2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import AutoTokenizer, PerceiverForSequenceClassification

tokenizer = AutoTokenizer.from_pretrained("deepmind/language-perceiver")
model = PerceiverForSequenceClassification.from_pretrained("deepmind/language-perceiver")

text = "hello world"
inputs = tokenizer(text, return_tensors="pt").input_ids
outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PerceiverForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function S2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function B2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import AutoImageProcessor, PerceiverForImageClassificationLearned
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

image_processor = AutoImageProcessor.from_pretrained("deepmind/vision-perceiver-learned")
model = PerceiverForImageClassificationLearned.from_pretrained("deepmind/vision-perceiver-learned")

inputs = image_processor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationLearned
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationLearned.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function W2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function H2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import AutoImageProcessor, PerceiverForImageClassificationFourier
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

image_processor = AutoImageProcessor.from_pretrained("deepmind/vision-perceiver-fourier")
model = PerceiverForImageClassificationFourier.from_pretrained("deepmind/vision-perceiver-fourier")

inputs = image_processor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationFourier
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationFourier.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function V2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function R2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import AutoImageProcessor, PerceiverForImageClassificationConvProcessing
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

image_processor = AutoImageProcessor.from_pretrained("deepmind/vision-perceiver-conv")
model = PerceiverForImageClassificationConvProcessing.from_pretrained("deepmind/vision-perceiver-conv")

inputs = image_processor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationConvProcessing
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationConvProcessing.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function U2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function K2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import PerceiverForOpticalFlow
import torch

model = PerceiverForOpticalFlow.from_pretrained("deepmind/optical-flow-perceiver")

# in the Perceiver IO paper, the authors extract a 3 x 3 patch around each pixel,
# leading to 3 x 3 x 3 = 27 values for each pixel (as each pixel also has 3 color channels)
# patches have shape (batch_size, num_frames, num_channels, height, width)
# the authors train on resolutions of 368 x 496
patches = torch.randn(1, 2, 27, 368, 496)
outputs = model(inputs=patches)
logits = outputs.logits
list(logits.shape)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForOpticalFlow
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForOpticalFlow.from_pretrained(<span class="hljs-string">&quot;deepmind/optical-flow-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, the authors extract a 3 x 3 patch around each pixel,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># leading to 3 x 3 x 3 = 27 values for each pixel (as each pixel also has 3 color channels)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># patches have shape (batch_size, num_frames, num_channels, height, width)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the authors train on resolutions of 368 x 496</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>patches = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">27</span>, <span class="hljs-number">368</span>, <span class="hljs-number">496</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=patches)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">368</span>, <span class="hljs-number">496</span>, <span class="hljs-number">2</span>]`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function G2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var C=n(v);g=i(C,"Module"),C.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function J2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import PerceiverForMultimodalAutoencoding
import torch
import numpy as np

# create multimodal inputs
images = torch.randn((1, 16, 3, 224, 224))
audio = torch.randn((1, 30720, 1))
inputs = dict(image=images, audio=audio, label=torch.zeros((images.shape[0], 700)))

model = PerceiverForMultimodalAutoencoding.from_pretrained("deepmind/multimodal-perceiver")

# in the Perceiver IO paper, videos are auto-encoded in chunks
# each chunk subsamples different index dimensions of the image and audio modality decoder queries
nchunks = 128
image_chunk_size = np.prod((16, 224, 224)) // nchunks
audio_chunk_size = audio.shape[1] // model.config.samples_per_patch // nchunks
# process the first chunk
chunk_idx = 0
subsampling = {
    "image": torch.arange(image_chunk_size * chunk_idx, image_chunk_size * (chunk_idx + 1)),
    "audio": torch.arange(audio_chunk_size * chunk_idx, audio_chunk_size * (chunk_idx + 1)),
    "label": None,
}

outputs = model(inputs=inputs, subsampled_output_points=subsampling)
logits = outputs.logits
list(logits["audio"].shape)

list(logits["image"].shape)

list(logits["label"].shape)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForMultimodalAutoencoding
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create multimodal inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">16</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">30720</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(image=images, audio=audio, label=torch.zeros((images.shape[<span class="hljs-number">0</span>], <span class="hljs-number">700</span>)))

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMultimodalAutoencoding.from_pretrained(<span class="hljs-string">&quot;deepmind/multimodal-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, videos are auto-encoded in chunks</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># each chunk subsamples different index dimensions of the image and audio modality decoder queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>nchunks = <span class="hljs-number">128</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_chunk_size = np.prod((<span class="hljs-number">16</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>)) // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_chunk_size = audio.shape[<span class="hljs-number">1</span>] // model.config.samples_per_patch // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># process the first chunk</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chunk_idx = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>subsampling = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;image&quot;</span>: torch.arange(image_chunk_size * chunk_idx, image_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;audio&quot;</span>: torch.arange(audio_chunk_size * chunk_idx, audio_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs, subsampled_output_points=subsampling)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;audio&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">240</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;image&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">6272</span>, <span class="hljs-number">3</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;label&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">700</span>]`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function X2(E){let u,T,v,g,k,p,f,C,pp,Mc,ye,xo,Qn,Nr,mp,ea,hp,qc,Eo,up,Lr,fp,gp,zc,jo,vp,Sr,_p,Pp,Ac,Ws,bp,Dc,Hs,oa,wp,Oc,Vs,yp,Nc,Rs,$p,Lc,D,kp,Us,Tp,xp,ra,Ep,jp,ta,Cp,Fp,sa,Ip,Mp,na,qp,zp,Sc,Ks,Ap,Bc,I,Dp,aa,Op,Np,ia,Lp,Sp,ca,Bp,Wp,la,Hp,Vp,da,Rp,Up,pa,Kp,Gp,Wc,Co,O_,Hc,Br,Jp,Gs,Xp,Vc,ve,Zp,Wr,Yp,Qp,Hr,em,om,Rc,Js,rm,Uc,Fo,Vr,tm,Rr,sm,nm,am,Ur,im,Kr,cm,lm,Kc,Gr,ma,dm,pm,Gc,Xs,_e,mm,ha,hm,um,ua,fm,gm,Jr,vm,Jc,$e,Io,fa,Xr,_m,ga,Pm,Xc,ke,Zr,bm,va,wm,Zc,Te,Yr,ym,_a,$m,Yc,xe,Qr,km,Pa,Tm,Qc,Ee,et,xm,ba,Em,el,je,Mo,wa,ot,jm,ya,Cm,ol,H,rt,Fm,Ce,Im,Zs,Mm,qm,tt,zm,Am,Dm,Fe,Om,Ys,Nm,Lm,Qs,Sm,Bm,Wm,qo,rl,Ie,zo,$a,st,Hm,ka,Vm,tl,V,nt,Rm,Ta,Um,Km,at,Gm,en,Jm,Xm,Zm,Ao,it,Ym,xa,Qm,sl,Me,Do,Ea,ct,eh,ja,oh,nl,qe,lt,rh,Oo,dt,th,Ca,sh,al,ze,No,Fa,pt,nh,Ia,ah,il,ne,mt,ih,Ma,ch,lh,Lo,ht,dh,qa,ph,cl,Ae,So,za,ut,mh,Aa,hh,ll,ae,ft,uh,gt,fh,Da,gh,vh,_h,vt,Ph,Oa,bh,wh,dl,De,Bo,Na,_t,yh,La,$h,pl,ie,Pt,kh,Sa,Th,xh,R,Eh,Ba,jh,Ch,Wa,Fh,Ih,Ha,Mh,qh,Va,zh,Ah,ml,Oe,Wo,Ra,bt,Dh,Ua,Oh,hl,Ne,wt,Nh,Ka,Lh,ul,Le,Ho,Ga,yt,Sh,Ja,Bh,fl,Se,$t,Wh,Xa,Hh,gl,Be,Vo,Za,kt,Vh,Ya,Rh,vl,ce,Tt,Uh,Qa,Kh,Gh,ei,Jh,_l,We,Ro,oi,xt,Xh,ri,Zh,Pl,He,Et,Yh,ti,Qh,bl,Ve,Uo,si,jt,eu,ni,ou,wl,le,Ct,ru,ai,tu,su,ii,nu,yl,Re,Ko,ci,Ft,au,li,iu,$l,Ue,It,cu,Mt,lu,di,du,pu,kl,Ke,Go,pi,qt,mu,mi,hu,Tl,Ge,zt,uu,hi,fu,xl,Je,Jo,ui,At,gu,fi,vu,El,Xe,Dt,_u,Ot,Pu,gi,bu,wu,jl,Ze,Xo,vi,Nt,yu,_i,$u,Cl,de,Lt,ku,St,Tu,Pi,xu,Eu,ju,bi,Cu,Fl,Ye,Zo,wi,Bt,Fu,yi,Iu,Il,Qe,Wt,Mu,$i,qu,Ml,eo,Yo,ki,Ht,zu,Ti,Au,ql,oo,Vt,Du,xi,Ou,zl,ro,Qo,Ei,Rt,Nu,ji,Lu,Al,to,Ut,Su,Ci,Bu,Dl,so,er,Fi,Kt,Wu,Ii,Hu,Ol,no,Gt,Vu,Mi,Ru,Nl,ao,or,qi,Jt,Uu,zi,Ku,Ll,pe,Xt,Gu,Zt,Ju,Yt,Xu,Zu,Yu,U,Qt,Qu,io,ef,on,of,rf,Ai,tf,sf,nf,rr,af,tr,Sl,co,sr,Di,es,cf,Oi,lf,Bl,me,os,df,rs,pf,ts,mf,hf,uf,K,ss,ff,lo,gf,rn,vf,_f,Ni,Pf,bf,wf,nr,yf,ar,Wl,po,ir,Li,ns,$f,Si,kf,Hl,he,as,Tf,is,xf,cs,Ef,jf,Cf,G,ls,Ff,mo,If,tn,Mf,qf,Bi,zf,Af,Df,cr,Of,lr,Vl,ho,dr,Wi,ds,Nf,Hi,Lf,Rl,q,ps,Sf,Vi,Bf,Wf,Ri,Hf,Vf,L,sn,Rf,Uf,nn,Kf,Gf,Ui,Jf,Xf,an,Zf,Yf,cn,Qf,eg,og,ms,rg,hs,tg,sg,ng,J,us,ag,uo,ig,ln,cg,lg,Ki,dg,pg,mg,pr,hg,mr,Ul,fo,hr,Gi,fs,ug,Ji,fg,Kl,z,gs,gg,Xi,vg,_g,Zi,Pg,bg,S,dn,wg,yg,pn,$g,kg,Yi,Tg,xg,mn,Eg,jg,hn,Cg,Fg,Ig,vs,Mg,_s,qg,zg,Ag,X,Ps,Dg,go,Og,un,Ng,Lg,Qi,Sg,Bg,Wg,ur,Hg,fr,Gl,vo,gr,ec,bs,Vg,oc,Rg,Jl,A,ws,Ug,rc,Kg,Gg,tc,Jg,Xg,B,fn,Zg,Yg,gn,Qg,ev,sc,ov,rv,vn,tv,sv,_n,nv,av,iv,ys,cv,$s,lv,dv,pv,Z,ks,mv,_o,hv,Pn,uv,fv,nc,gv,vv,_v,vr,Pv,_r,Xl,Po,Pr,ac,Ts,bv,ic,wv,Zl,O,xs,yv,N,$v,bn,kv,Tv,wn,xv,Ev,cc,jv,Cv,yn,Fv,Iv,$n,Mv,qv,zv,lc,Av,Dv,Es,Ov,js,Nv,Lv,Sv,Y,Cs,Bv,bo,Wv,kn,Hv,Vv,dc,Rv,Uv,Kv,br,Gv,wr,Yl,wo,yr,pc,Fs,Jv,mc,Xv,Ql,F,Is,Zv,hc,Yv,Qv,$r,Tn,e_,o_,xn,r_,t_,s_,Pe,En,n_,a_,jn,i_,c_,Cn,l_,d_,p_,kr,Fn,m_,h_,In,u_,f_,g_,Ms,v_,uc,__,P_,b_,fc,w_,y_,qs,$_,zs,k_,T_,x_,Q,As,E_,yo,j_,Mn,C_,F_,gc,I_,M_,q_,Tr,z_,xr,ed;return p=new j({}),Nr=new j({}),Xr=new j({}),Zr=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",parameters:[{name:"logits",val:": FloatTensor = None"},{name:"last_hidden_state",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L61"}}),Yr=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",parameters:[{name:"logits",val:": FloatTensor = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Output of the basic decoder.`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L92"}}),Qr=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Masked language modeling (MLM) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L110"}}),et=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L141"}}),ot=new j({}),rt=new x({props:{name:"class transformers.PerceiverConfig",anchor:"transformers.PerceiverConfig",parameters:[{name:"num_latents",val:" = 256"},{name:"d_latents",val:" = 1280"},{name:"d_model",val:" = 768"},{name:"num_blocks",val:" = 1"},{name:"num_self_attends_per_block",val:" = 26"},{name:"num_self_attention_heads",val:" = 8"},{name:"num_cross_attention_heads",val:" = 8"},{name:"qk_channels",val:" = None"},{name:"v_channels",val:" = None"},{name:"cross_attention_shape_for_attention",val:" = 'kv'"},{name:"self_attention_widening_factor",val:" = 1"},{name:"cross_attention_widening_factor",val:" = 1"},{name:"hidden_act",val:" = 'gelu'"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"position_embedding_init_scale",val:" = 0.02"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"use_query_residual",val:" = True"},{name:"vocab_size",val:" = 262"},{name:"max_position_embeddings",val:" = 2048"},{name:"image_size",val:" = 56"},{name:"train_size",val:" = [368, 496]"},{name:"num_frames",val:" = 16"},{name:"audio_samples_per_frame",val:" = 1920"},{name:"samples_per_patch",val:" = 16"},{name:"output_shape",val:" = [1, 16, 224, 224]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverConfig.num_latents",description:`<strong>num_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of latents.`,name:"num_latents"},{anchor:"transformers.PerceiverConfig.d_latents",description:`<strong>d_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
Dimension of the latent embeddings.`,name:"d_latents"},{anchor:"transformers.PerceiverConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the inputs. Should only be provided in case [<em>PerceiverTextPreprocessor</em>] is used or no
preprocessor is provided.`,name:"d_model"},{anchor:"transformers.PerceiverConfig.num_blocks",description:`<strong>num_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of blocks in the Transformer encoder.`,name:"num_blocks"},{anchor:"transformers.PerceiverConfig.num_self_attends_per_block",description:`<strong>num_self_attends_per_block</strong> (<code>int</code>, <em>optional</em>, defaults to 26) &#x2014;
The number of self-attention layers per block.`,name:"num_self_attends_per_block"},{anchor:"transformers.PerceiverConfig.num_self_attention_heads",description:`<strong>num_self_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each self-attention layer in the Transformer encoder.`,name:"num_self_attention_heads"},{anchor:"transformers.PerceiverConfig.num_cross_attention_heads",description:`<strong>num_cross_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each cross-attention layer in the Transformer encoder.`,name:"num_cross_attention_heads"},{anchor:"transformers.PerceiverConfig.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the queries + keys before applying attention in the cross-attention and self-attention
layers of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"qk_channels"},{anchor:"transformers.PerceiverConfig.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the values before applying attention in the cross-attention and self-attention layers
of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"v_channels"},{anchor:"transformers.PerceiverConfig.cross_attention_shape_for_attention",description:`<strong>cross_attention_shape_for_attention</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&apos;kv&apos;</code>) &#x2014;
Dimension to use when downsampling the queries and keys in the cross-attention layer of the encoder.`,name:"cross_attention_shape_for_attention"},{anchor:"transformers.PerceiverConfig.self_attention_widening_factor",description:`<strong>self_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the cross-attention layer of the Transformer encoder.`,name:"self_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.cross_attention_widening_factor",description:`<strong>cross_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the self-attention layers of the Transformer encoder.`,name:"cross_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.PerceiverConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.PerceiverConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.PerceiverConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.PerceiverConfig.use_query_residual",description:`<strong>use_query_residual</strong> (<code>float</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a query residual in the cross-attention layer of the encoder.`,name:"use_query_residual"},{anchor:"transformers.PerceiverConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 262) &#x2014;
Vocabulary size for the masked language modeling model.`,name:"vocab_size"},{anchor:"transformers.PerceiverConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that the masked language modeling model might ever be used with. Typically set
this to something large just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.PerceiverConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 56) &#x2014;
Size of the images after preprocessing, for <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a>.`,name:"image_size"},{anchor:"transformers.PerceiverConfig.train_size",description:`<strong>train_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to [368, 496]) &#x2014;
Training size of the images for the optical flow model.`,name:"train_size"},{anchor:"transformers.PerceiverConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of video frames used for the multimodal autoencoding model.`,name:"num_frames"},{anchor:"transformers.PerceiverConfig.audio_samples_per_frame",description:`<strong>audio_samples_per_frame</strong> (<code>int</code>, <em>optional</em>, defaults to 1920) &#x2014;
Number of audio samples per frame for the multimodal autoencoding model.`,name:"audio_samples_per_frame"},{anchor:"transformers.PerceiverConfig.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of audio samples per patch when preprocessing the audio for the multimodal autoencoding model.`,name:"samples_per_patch"},{anchor:"transformers.PerceiverConfig.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 16, 224, 224]</code>) &#x2014;
Shape of the output (batch_size, num_frames, height, width) for the video decoder queries of the multimodal
autoencoding model. This excludes the channel dimension.`,name:"output_shape"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/configuration_perceiver.py#L36"}}),qo=new $o({props:{anchor:"transformers.PerceiverConfig.example",$$slots:{default:[q2]},$$scope:{ctx:E}}}),st=new j({}),nt=new x({props:{name:"class transformers.PerceiverTokenizer",anchor:"transformers.PerceiverTokenizer",parameters:[{name:"pad_token",val:" = '[PAD]'"},{name:"bos_token",val:" = '[BOS]'"},{name:"eos_token",val:" = '[EOS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"model_max_length",val:" = 2048"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.PerceiverTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[BOS]&quot;</code>) &#x2014;
The BOS token (reserved in the vocab, but not actually used).`,name:"bos_token"},{anchor:"transformers.PerceiverTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[EOS]&quot;</code>) &#x2014;
The end of sequence token (reserved in the vocab, but not actually used).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.PerceiverTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The MASK token, useful for masked language modeling.`,name:"mask_token"},{anchor:"transformers.PerceiverTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The CLS token (reserved in the vocab, but not actually used).`,name:"cls_token"},{anchor:"transformers.PerceiverTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from two sequences.`,name:"sep_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/tokenization_perceiver.py#L27"}}),it=new x({props:{name:"__call__",anchor:"transformers.PerceiverTokenizer.__call__",parameters:[{name:"text",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]]] = None"},{name:"text_pair",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"text_target",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]]] = None"},{name:"text_pair_target",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": typing.Union[bool, str, transformers.utils.generic.PaddingStrategy] = False"},{name:"truncation",val:": typing.Union[bool, str, transformers.tokenization_utils_base.TruncationStrategy] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"stride",val:": int = 0"},{name:"is_split_into_words",val:": bool = False"},{name:"pad_to_multiple_of",val:": typing.Optional[int] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"return_token_type_ids",val:": typing.Optional[bool] = None"},{name:"return_attention_mask",val:": typing.Optional[bool] = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair",description:`<strong>text_pair</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair"},{anchor:"transformers.PerceiverTokenizer.__call__.text_target",description:`<strong>text_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_target"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair_target",description:`<strong>text_pair_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair_target"},{anchor:"transformers.PerceiverTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to encode the sequences with the special tokens relative to their model.`,name:"add_special_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.PerceiverTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.PerceiverTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.PerceiverTokenizer.__call__.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.PerceiverTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.PerceiverTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. This is especially useful to enable
the use of Tensor Cores on NVIDIA hardware with compute capability <code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.PerceiverTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PerceiverTokenizer.__call__.return_token_type_ids",description:`<strong>return_token_type_ids</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return token type IDs. If left to the default, will return the token type IDs according to
the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"return_token_type_ids"},{anchor:"transformers.PerceiverTokenizer.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"return_attention_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_overflowing_tokens",description:`<strong>return_overflowing_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return overflowing token sequences. If a pair of sequences of input ids (or a batch
of pairs) is provided with <code>truncation_strategy = longest_first</code> or <code>True</code>, an error is raised instead
of returning overflowing tokens.`,name:"return_overflowing_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.return_special_tokens_mask",description:`<strong>return_special_tokens_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return special tokens mask information.`,name:"return_special_tokens_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_offsets_mapping",description:`<strong>return_offsets_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return <code>(char_start, char_end)</code> for each token.</p>
<p>This is only available on fast tokenizers inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a>, if using
Python&#x2019;s tokenizer, this method will raise <code>NotImplementedError</code>.`,name:"return_offsets_mapping"},{anchor:"transformers.PerceiverTokenizer.__call__.return_length",description:`<strong>return_length</strong>  (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the lengths of the encoded inputs.`,name:"return_length"},{anchor:"transformers.PerceiverTokenizer.__call__.verbose",description:`<strong>verbose</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to print more information and warnings.
**kwargs &#x2014; passed to the <code>self.tokenize()</code> method`,name:"verbose"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L2453",returnDescription:`
<p>A <a
  href="/docs/transformers/main/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a> with the following fields:</p>
<ul>
<li>
<p><strong>input_ids</strong> \u2014 List of token ids to be fed to a model.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
</li>
<li>
<p><strong>token_type_ids</strong> \u2014 List of token type ids to be fed to a model (when <code>return_token_type_ids=True</code> or
if <em>\u201Ctoken_type_ids\u201D</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a></p>
</li>
<li>
<p><strong>attention_mask</strong> \u2014 List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>\u201Cattention_mask\u201D</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
</li>
<li>
<p><strong>overflowing_tokens</strong> \u2014 List of overflowing tokens sequences (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>num_truncated_tokens</strong> \u2014 Number of tokens truncated (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>special_tokens_mask</strong> \u2014 List of 0s and 1s, with 1 specifying added special tokens and 0 specifying
regular sequence tokens (when <code>add_special_tokens=True</code> and <code>return_special_tokens_mask=True</code>).</p>
</li>
<li>
<p><strong>length</strong> \u2014 The length of the inputs (when <code>return_length=True</code>)</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/main/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),ct=new j({}),lt=new x({props:{name:"class transformers.PerceiverFeatureExtractor",anchor:"transformers.PerceiverFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/feature_extraction_perceiver.py#L26"}}),dt=new x({props:{name:"__call__",anchor:"transformers.PerceiverFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils.py#L448"}}),pt=new j({}),mt=new x({props:{name:"class transformers.PerceiverImageProcessor",anchor:"transformers.PerceiverImageProcessor",parameters:[{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>True</code>) &#x2014;
Whether or not to center crop the image. If the input size if smaller than <code>crop_size</code> along any edge, the
image will be padded with zeros and then center cropped. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Desired output size when applying center-cropping. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image to <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>. Can be overridden by the <code>do_resize</code>
parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.PerceiverImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Defines the resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter
in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.
do_normalize &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/image_processing_perceiver.py#L47"}}),ht=new x({props:{name:"preprocess",anchor:"transformers.PerceiverImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[transformers.utils.generic.TensorType, str, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess.`,name:"images"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to <code>crop_size</code>.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Desired output size after applying the center crop.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.PerceiverImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.PerceiverImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.PerceiverImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PerceiverImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/image_processing_perceiver.py#L223"}}),ut=new j({}),ft=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2831"}}),_t=new j({}),Pt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:" = 'conv'"},{name:"spatial_downsample",val:": int = 4"},{name:"temporal_downsample",val:": int = 1"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 64"},{name:"conv_after_patching",val:": bool = False"},{name:"conv_after_patching_in_channels",val:": int = 54"},{name:"conv2d_use_batchnorm",val:": bool = True"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"project_pos_dim",val:": int = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;conv&quot;</code>) &#x2014;
Preprocessing type. Can be &#x201C;conv1x1&#x201D;, &#x201C;conv&#x201D;, &#x201C;patches&#x201D;, &#x201C;pixels&#x201D;.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.spatial_downsample",description:`<strong>spatial_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Spatial downsampling factor.`,name:"spatial_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.temporal_downsample",description:`<strong>temporal_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Temporal downsampling factor (only relevant in case a time dimension is present).`,name:"temporal_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Position encoding type. Can be &#x201C;fourier&#x201D; or &#x201C;trainable&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching",description:`<strong>conv_after_patching</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply a convolutional layer after patching.`,name:"conv_after_patching"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching_in_channels",description:`<strong>conv_after_patching_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 54) &#x2014;
Number of channels in the input of the convolutional layer after patching.`,name:"conv_after_patching_in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv2d_use_batchnorm",description:`<strong>conv2d_use_batchnorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use batch normalization in the convolutional layer.`,name:"conv2d_use_batchnorm"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2988"}}),bt=new j({}),wt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L3217"}}),yt=new j({}),$t=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:": str = 'patches'"},{name:"samples_per_patch",val:": int = 96"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"out_channels",val:" = 64"},{name:"project_pos_dim",val:" = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Preprocessor type to use. Only &#x201C;patches&#x201D; is supported.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
Number of samples per patch.`,name:"samples_per_patch"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Type of position encoding to use. Can be &#x201C;trainable&#x201D; or &#x201C;fourier&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L3243"}}),kt=new j({}),Tt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",parameters:[{name:"modalities",val:": typing.Mapping[str, typing.Callable[..., typing.Tuple[torch.Tensor, typing.Optional[torch.Tensor], torch.Tensor]]]"},{name:"mask_probs",val:": typing.Union[typing.Mapping[str, float], NoneType] = None"},{name:"min_padding_size",val:": int = 2"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PreprocessorType]</code>) &#x2014;
Dict mapping modality name to preprocessor.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.mask_probs",description:`<strong>mask_probs</strong> (<code>Dict[str, float]</code>) &#x2014;
Dict mapping modality name to masking probability of that modality.`,name:"mask_probs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L3340"}}),xt=new j({}),Et=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2041"}}),jt=new j({}),Ct=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_num_channels",val:": int"},{name:"position_encoding_type",val:": typing.Optional[str] = 'trainable'"},{name:"output_index_dims",val:": typing.Optional[int] = None"},{name:"num_channels",val:": typing.Optional[int] = 128"},{name:"subsampled_index_dims",val:": typing.Optional[int] = None"},{name:"qk_channels",val:": typing.Optional[int] = None"},{name:"v_channels",val:": typing.Optional[int] = None"},{name:"num_heads",val:": typing.Optional[int] = 1"},{name:"widening_factor",val:": typing.Optional[int] = 1"},{name:"use_query_residual",val:": typing.Optional[bool] = False"},{name:"concat_preprocessed_input",val:": typing.Optional[bool] = False"},{name:"final_project",val:": typing.Optional[bool] = True"},{name:"position_encoding_only",val:": typing.Optional[bool] = False"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels in the output. Will only be used in case <em>final_project</em> is set to <code>True</code>.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;trainable&#x201D;) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_index_dims",description:`<strong>output_index_dims</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of dimensions of the output queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"output_index_dims"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The number of channels of the decoder queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the queries and keys in the cross-attention layer.`,name:"qk_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the values in the cross-attention layer.`,name:"v_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of attention heads in the cross-attention layer.`,name:"num_heads"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.widening_factor",description:`<strong>widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The widening factor of the cross-attention layer.`,name:"widening_factor"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.use_query_residual",description:`<strong>use_query_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a residual connection between the query and the output of the cross-attention layer.`,name:"use_query_residual"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.concat_preprocessed_input",description:`<strong>concat_preprocessed_input</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to concatenate the preprocessed input to the query.`,name:"concat_preprocessed_input"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.final_project",description:`<strong>final_project</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to project the output of the cross-attention layer to a target dimension.`,name:"final_project"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_only",description:`<strong>position_encoding_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only use this class to define output queries.`,name:"position_encoding_only"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2067"}}),Ft=new j({}),It=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",parameters:[{name:"config",val:""},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2253"}}),qt=new j({}),zt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",parameters:[{name:"config",val:""},{name:"output_image_shape",val:""},{name:"output_num_channels",val:" = 2"},{name:"rescale_factor",val:" = 100.0"},{name:"**decoder_kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2299"}}),At=new j({}),Dt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_shape",val:": typing.List[int]"},{name:"position_encoding_type",val:": str"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>) &#x2014;
Shape of the output as (batch_size, num_frames, height, width), excluding the channel dimension.`,name:"output_shape"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2334"}}),Nt=new j({}),Lt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"modalities",val:": typing.Dict[str, transformers.models.perceiver.modeling_perceiver.PerceiverAbstractDecoder]"},{name:"num_outputs",val:": int"},{name:"output_num_channels",val:": int"},{name:"min_padding_size",val:": typing.Optional[int] = 2"},{name:"subsampled_index_dims",val:": typing.Union[typing.Dict[str, transformers.models.perceiver.modeling_perceiver.PerceiverAbstractDecoder], NoneType] = None"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>) &#x2014;
Dictionary mapping modality name to the decoder of that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.num_outputs",description:`<strong>num_outputs</strong> (<code>int</code>) &#x2014;
The number of outputs of the decoder.`,name:"num_outputs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>) &#x2014;
The number of channels in the output.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.subsampled_index_dims",description:`<strong>subsampled_index_dims</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>, <em>optional</em>) &#x2014;
Dictionary mapping modality name to the subsampled index dimensions to use for the decoder query of that
modality.`,name:"subsampled_index_dims"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2411"}}),Bt=new j({}),Wt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",parameters:[{name:"in_channels",val:": int"},{name:"out_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the output.`,name:"out_channels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2967"}}),Ht=new j({}),Vt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"},{name:"postproc_type",val:": str = 'patches'"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.postproc_type",description:`<strong>postproc_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Postprocessor type to use. Currently, only &#x201C;patches&#x201D; is supported.`,name:"postproc_type"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2940"}}),Rt=new j({}),Ut=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2920"}}),Kt=new j({}),Gt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",parameters:[{name:"modalities",val:": typing.Mapping[str, typing.Callable[..., typing.Any]]"},{name:"input_is_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PostprocessorType]</code>) &#x2014;
Dictionary mapping modality name to postprocessor class for that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.input_is_dict",description:`<strong>input_is_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, input is assumed to be dictionary structured, and outputs keep the same dictionary shape. If
False, input is a tensor which is sliced up during postprocessing by <em>modality_sizes</em>.`,name:"input_is_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2886"}}),Jt=new j({}),Xt=new x({props:{name:"class transformers.PerceiverModel",anchor:"transformers.PerceiverModel",parameters:[{name:"config",val:""},{name:"decoder",val:" = None"},{name:"input_preprocessor",val:": typing.Callable[..., typing.Tuple[torch.Tensor, typing.Optional[torch.Tensor], torch.Tensor]] = None"},{name:"output_postprocessor",val:": typing.Callable[..., typing.Any] = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.PerceiverModel.decoder",description:`<strong>decoder</strong> (<em>DecoderType</em>, <em>optional</em>) &#x2014;
Optional decoder to use to decode the latent representation of the encoder. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder</em>.`,name:"decoder"},{anchor:"transformers.PerceiverModel.input_preprocessor",description:`<strong>input_preprocessor</strong> (<em>PreprocessorType</em>, <em>optional</em>) &#x2014;
Optional input preprocessor to use. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor</em>.`,name:"input_preprocessor"},{anchor:"transformers.PerceiverModel.output_postprocessor",description:`<strong>output_postprocessor</strong> (<em>PostprocessorType</em>, <em>optional</em>) &#x2014;
Optional output postprocessor to use. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverImagePostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor</em>.`,name:"output_postprocessor"},{anchor:"transformers.PerceiverModel.Note",description:"<strong>Note</strong> that you can define your own decoders, preprocessors and/or postprocessors to fit your use-case. &#x2014;",name:"Note"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L716"}}),Qt=new x({props:{name:"forward",anchor:"transformers.PerceiverModel.forward",parameters:[{name:"inputs",val:": FloatTensor"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"subsampled_output_points",val:": typing.Union[typing.Dict[str, torch.Tensor], NoneType] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L752",returnDescription:`
<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) \u2014 Sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),rr=new Or({props:{$$slots:{default:[z2]},$$scope:{ctx:E}}}),tr=new $o({props:{anchor:"transformers.PerceiverModel.forward.example",$$slots:{default:[A2]},$$scope:{ctx:E}}}),es=new j({}),os=new x({props:{name:"class transformers.PerceiverForMaskedLM",anchor:"transformers.PerceiverForMaskedLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L954"}}),ss=new x({props:{name:"forward",anchor:"transformers.PerceiverForMaskedLM.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L985",returnDescription:`
<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Masked language modeling (MLM) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) \u2014 Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),nr=new Or({props:{$$slots:{default:[D2]},$$scope:{ctx:E}}}),ar=new $o({props:{anchor:"transformers.PerceiverForMaskedLM.forward.example",$$slots:{default:[O2]},$$scope:{ctx:E}}}),ns=new j({}),as=new x({props:{name:"class transformers.PerceiverForSequenceClassification",anchor:"transformers.PerceiverForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1088"}}),ls=new x({props:{name:"forward",anchor:"transformers.PerceiverForSequenceClassification.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1109",returnDescription:`
<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),cr=new Or({props:{$$slots:{default:[N2]},$$scope:{ctx:E}}}),lr=new $o({props:{anchor:"transformers.PerceiverForSequenceClassification.forward.example",$$slots:{default:[L2]},$$scope:{ctx:E}}}),ds=new j({}),ps=new x({props:{name:"class transformers.PerceiverForImageClassificationLearned",anchor:"transformers.PerceiverForImageClassificationLearned",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1213"}}),us=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationLearned.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1244",returnDescription:`
<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),pr=new Or({props:{$$slots:{default:[S2]},$$scope:{ctx:E}}}),mr=new $o({props:{anchor:"transformers.PerceiverForImageClassificationLearned.forward.example",$$slots:{default:[B2]},$$scope:{ctx:E}}}),fs=new j({}),gs=new x({props:{name:"class transformers.PerceiverForImageClassificationFourier",anchor:"transformers.PerceiverForImageClassificationFourier",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1356"}}),Ps=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationFourier.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1385",returnDescription:`
<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ur=new Or({props:{$$slots:{default:[W2]},$$scope:{ctx:E}}}),fr=new $o({props:{anchor:"transformers.PerceiverForImageClassificationFourier.forward.example",$$slots:{default:[H2]},$$scope:{ctx:E}}}),bs=new j({}),ws=new x({props:{name:"class transformers.PerceiverForImageClassificationConvProcessing",anchor:"transformers.PerceiverForImageClassificationConvProcessing",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1496"}}),ks=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1526",returnDescription:`
<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),vr=new Or({props:{$$slots:{default:[V2]},$$scope:{ctx:E}}}),_r=new $o({props:{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.example",$$slots:{default:[R2]},$$scope:{ctx:E}}}),Ts=new j({}),xs=new x({props:{name:"class transformers.PerceiverForOpticalFlow",anchor:"transformers.PerceiverForOpticalFlow",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1637"}}),Cs=new x({props:{name:"forward",anchor:"transformers.PerceiverForOpticalFlow.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForOpticalFlow.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForOpticalFlow.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForOpticalFlow.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the optical flow loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1684",returnDescription:`
<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),br=new Or({props:{$$slots:{default:[U2]},$$scope:{ctx:E}}}),wr=new $o({props:{anchor:"transformers.PerceiverForOpticalFlow.forward.example",$$slots:{default:[K2]},$$scope:{ctx:E}}}),Fs=new j({}),Is=new x({props:{name:"class transformers.PerceiverForMultimodalAutoencoding",anchor:"transformers.PerceiverForMultimodalAutoencoding",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1779"}}),As=new x({props:{name:"forward",anchor:"transformers.PerceiverForMultimodalAutoencoding.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"subsampled_output_points",val:": typing.Union[typing.Dict[str, torch.Tensor], NoneType] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1895",returnDescription:`
<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Tr=new Or({props:{$$slots:{default:[G2]},$$scope:{ctx:E}}}),xr=new $o({props:{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.example",$$slots:{default:[J2]},$$scope:{ctx:E}}}),{c(){u=t("meta"),T=l(),v=t("h1"),g=t("a"),k=t("span"),_(p.$$.fragment),f=l(),C=t("span"),pp=a("Perceiver"),Mc=l(),ye=t("h2"),xo=t("a"),Qn=t("span"),_(Nr.$$.fragment),mp=l(),ea=t("span"),hp=a("Overview"),qc=l(),Eo=t("p"),up=a("The Perceiver IO model was proposed in "),Lr=t("a"),fp=a(`Perceiver IO: A General Architecture for Structured Inputs &
Outputs`),gp=a(` by Andrew Jaegle, Sebastian Borgeaud, Jean-Baptiste Alayrac, Carl Doersch,
Catalin Ionescu, David Ding, Skanda Koppula, Daniel Zoran, Andrew Brock, Evan Shelhamer, Olivier H\xE9naff, Matthew M.
Botvinick, Andrew Zisserman, Oriol Vinyals, Jo\xE3o Carreira.`),zc=l(),jo=t("p"),vp=a("Perceiver IO is a generalization of "),Sr=t("a"),_p=a("Perceiver"),Pp=a(` to handle arbitrary outputs in
addition to arbitrary inputs. The original Perceiver only produced a single classification label. In addition to
classification labels, Perceiver IO can produce (for example) language, optical flow, and multimodal videos with audio.
This is done using the same building blocks as the original Perceiver. The computational complexity of Perceiver IO is
linear in the input and output size and the bulk of the processing occurs in the latent space, allowing us to process
inputs and outputs that are much larger than can be handled by standard Transformers. This means, for example,
Perceiver IO can do BERT-style masked language modeling directly using bytes instead of tokenized inputs.`),Ac=l(),Ws=t("p"),bp=a("The abstract from the paper is the following:"),Dc=l(),Hs=t("p"),oa=t("em"),wp=a(`The recently-proposed Perceiver model obtains good results on several domains (images, audio, multimodal, point
clouds) while scaling linearly in compute and memory with the input size. While the Perceiver supports many kinds of
inputs, it can only produce very simple outputs such as class scores. Perceiver IO overcomes this limitation without
sacrificing the original\u2019s appealing properties by learning to flexibly query the model\u2019s latent space to produce
outputs of arbitrary size and semantics. Perceiver IO still decouples model depth from data size and still scales
linearly with data size, but now with respect to both input and output sizes. The full Perceiver IO model achieves
strong results on tasks with highly structured output spaces, such as natural language and visual understanding,
StarCraft II, and multi-task and multi-modal domains. As highlights, Perceiver IO matches a Transformer-based BERT
baseline on the GLUE language benchmark without the need for input tokenization and achieves state-of-the-art
performance on Sintel optical flow estimation.`),Oc=l(),Vs=t("p"),yp=a("Here\u2019s a TLDR explaining how Perceiver works:"),Nc=l(),Rs=t("p"),$p=a(`The main problem with the self-attention mechanism of the Transformer is that the time and memory requirements scale
quadratically with the sequence length. Hence, models like BERT and RoBERTa are limited to a max sequence length of 512
tokens. Perceiver aims to solve this issue by, instead of performing self-attention on the inputs, perform it on a set
of latent variables, and only use the inputs for cross-attention. In this way, the time and memory requirements don\u2019t
depend on the length of the inputs anymore, as one uses a fixed amount of latent variables, like 256 or 512. These are
randomly initialized, after which they are trained end-to-end using backpropagation.`),Lc=l(),D=t("p"),kp=a("Internally, "),Us=t("a"),Tp=a("PerceiverModel"),xp=a(" will create the latents, which is a tensor of shape "),ra=t("code"),Ep=a("(batch_size, num_latents, d_latents)"),jp=a(". One must provide "),ta=t("code"),Cp=a("inputs"),Fp=a(` (which could be text, images, audio, you name it!) to the model, which it will
use to perform cross-attention with the latents. The output of the Perceiver encoder is a tensor of the same shape. One
can then, similar to BERT, convert the last hidden states of the latents to classification logits by averaging along
the sequence dimension, and placing a linear layer on top of that to project the `),sa=t("code"),Ip=a("d_latents"),Mp=a(" to "),na=t("code"),qp=a("num_labels"),zp=a("."),Sc=l(),Ks=t("p"),Ap=a(`This was the idea of the original Perceiver paper. However, it could only output classification logits. In a follow-up
work, PerceiverIO, they generalized it to let the model also produce outputs of arbitrary size. How, you might ask? The
idea is actually relatively simple: one defines outputs of an arbitrary size, and then applies cross-attention with the
last hidden states of the latents, using the outputs as queries, and the latents as keys and values.`),Bc=l(),I=t("p"),Dp=a(`So let\u2019s say one wants to perform masked language modeling (BERT-style) with the Perceiver. As the Perceiver\u2019s input
length will not have an impact on the computation time of the self-attention layers, one can provide raw bytes,
providing `),aa=t("code"),Op=a("inputs"),Np=a(` of length 2048 to the model. If one now masks out certain of these 2048 tokens, one can define the
`),ia=t("code"),Lp=a("outputs"),Sp=a(" as being of shape: "),ca=t("code"),Bp=a("(batch_size, 2048, 768)"),Wp=a(`. Next, one performs cross-attention with the final hidden states
of the latents to update the `),la=t("code"),Hp=a("outputs"),Vp=a(" tensor. After cross-attention, one still has a tensor of shape "),da=t("code"),Rp=a("(batch_size, 2048, 768)"),Up=a(`. One can then place a regular language modeling head on top, to project the last dimension to the
vocabulary size of the model, i.e. creating logits of shape `),pa=t("code"),Kp=a("(batch_size, 2048, 262)"),Gp=a(` (as Perceiver uses a vocabulary
size of 262 byte IDs).`),Wc=l(),Co=t("img"),Hc=l(),Br=t("small"),Jp=a("Perceiver IO architecture. Taken from the "),Gs=t("a"),Xp=a("original paper"),Vc=l(),ve=t("p"),Zp=a("This model was contributed by "),Wr=t("a"),Yp=a("nielsr"),Qp=a(`. The original code can be found
`),Hr=t("a"),em=a("here"),om=a("."),Rc=l(),Js=t("p"),rm=a("Tips:"),Uc=l(),Fo=t("ul"),Vr=t("li"),tm=a("The quickest way to get started with the Perceiver is by checking the "),Rr=t("a"),sm=a(`tutorial
notebooks`),nm=a("."),am=l(),Ur=t("li"),im=a("Refer to the "),Kr=t("a"),cm=a("blog post"),lm=a(` if you want to fully understand how the model works and
is implemented in the library. Note that the models available in the library only showcase some examples of what you can do
with the Perceiver. There are many more use cases, including question answering, named-entity recognition, object detection,
audio classification, video classification, etc.`),Kc=l(),Gr=t("p"),ma=t("strong"),dm=a("Note"),pm=a(":"),Gc=l(),Xs=t("ul"),_e=t("li"),mm=a("Perceiver does "),ha=t("strong"),hm=a("not"),um=a(" work with "),ua=t("code"),fm=a("torch.nn.DataParallel"),gm=a(" due to a bug in PyTorch, see "),Jr=t("a"),vm=a("issue #36035"),Jc=l(),$e=t("h2"),Io=t("a"),fa=t("span"),_(Xr.$$.fragment),_m=l(),ga=t("span"),Pm=a("Perceiver specific outputs"),Xc=l(),ke=t("div"),_(Zr.$$.fragment),bm=l(),va=t("p"),wm=a("Base class for Perceiver base model\u2019s outputs, with potential hidden states, attentions and cross-attentions."),Zc=l(),Te=t("div"),_(Yr.$$.fragment),ym=l(),_a=t("p"),$m=a("Base class for Perceiver decoder outputs, with potential cross-attentions."),Yc=l(),xe=t("div"),_(Qr.$$.fragment),km=l(),Pa=t("p"),Tm=a("Base class for Perceiver\u2019s masked language model outputs."),Qc=l(),Ee=t("div"),_(et.$$.fragment),xm=l(),ba=t("p"),Em=a(`Base class for Perceiver\u2019s outputs of sequence/image classification models, optical flow and multimodal
autoencoding.`),el=l(),je=t("h2"),Mo=t("a"),wa=t("span"),_(ot.$$.fragment),jm=l(),ya=t("span"),Cm=a("PerceiverConfig"),ol=l(),H=t("div"),_(rt.$$.fragment),Fm=l(),Ce=t("p"),Im=a("This is the configuration class to store the configuration of a "),Zs=t("a"),Mm=a("PerceiverModel"),qm=a(`. It is used to instantiate an
Perceiver model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Perceiver
`),tt=t("a"),zm=a("deepmind/language-perceiver"),Am=a(" architecture."),Dm=l(),Fe=t("p"),Om=a("Configuration objects inherit from "),Ys=t("a"),Nm=a("PretrainedConfig"),Lm=a(` and can be used to control the model outputs. Read the
documentation from `),Qs=t("a"),Sm=a("PretrainedConfig"),Bm=a(" for more information."),Wm=l(),_(qo.$$.fragment),rl=l(),Ie=t("h2"),zo=t("a"),$a=t("span"),_(st.$$.fragment),Hm=l(),ka=t("span"),Vm=a("PerceiverTokenizer"),tl=l(),V=t("div"),_(nt.$$.fragment),Rm=l(),Ta=t("p"),Um=a("Construct a Perceiver tokenizer. The Perceiver simply uses raw bytes utf-8 encoding."),Km=l(),at=t("p"),Gm=a("This tokenizer inherits from "),en=t("a"),Jm=a("PreTrainedTokenizer"),Xm=a(` which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`),Zm=l(),Ao=t("div"),_(it.$$.fragment),Ym=l(),xa=t("p"),Qm=a(`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`),sl=l(),Me=t("h2"),Do=t("a"),Ea=t("span"),_(ct.$$.fragment),eh=l(),ja=t("span"),oh=a("PerceiverFeatureExtractor"),nl=l(),qe=t("div"),_(lt.$$.fragment),rh=l(),Oo=t("div"),_(dt.$$.fragment),th=l(),Ca=t("p"),sh=a("Preprocess an image or a batch of images."),al=l(),ze=t("h2"),No=t("a"),Fa=t("span"),_(pt.$$.fragment),nh=l(),Ia=t("span"),ah=a("PerceiverImageProcessor"),il=l(),ne=t("div"),_(mt.$$.fragment),ih=l(),Ma=t("p"),ch=a("Constructs a Perceiver image processor."),lh=l(),Lo=t("div"),_(ht.$$.fragment),dh=l(),qa=t("p"),ph=a("Preprocess an image or batch of images."),cl=l(),Ae=t("h2"),So=t("a"),za=t("span"),_(ut.$$.fragment),mh=l(),Aa=t("span"),hh=a("PerceiverTextPreprocessor"),ll=l(),ae=t("div"),_(ft.$$.fragment),uh=l(),gt=t("p"),fh=a("Text preprocessing for Perceiver Encoder. Can be used to embed "),Da=t("code"),gh=a("inputs"),vh=a(" and add positional encodings."),_h=l(),vt=t("p"),Ph=a("The dimensionality of the embeddings is determined by the "),Oa=t("code"),bh=a("d_model"),wh=a(" attribute of the configuration."),dl=l(),De=t("h2"),Bo=t("a"),Na=t("span"),_(_t.$$.fragment),yh=l(),La=t("span"),$h=a("PerceiverImagePreprocessor"),pl=l(),ie=t("div"),_(Pt.$$.fragment),kh=l(),Sa=t("p"),Th=a("Image preprocessing for Perceiver Encoder."),xh=l(),R=t("p"),Eh=a("Note: the "),Ba=t("em"),jh=a("out_channels"),Ch=a(" argument refers to the output channels of a convolutional layer, if "),Wa=t("em"),Fh=a("prep_type"),Ih=a(` is set to
\u201Cconv1x1\u201D or \u201Cconv\u201D. If one adds absolute position embeddings, one must make sure the `),Ha=t("em"),Mh=a("num_channels"),qh=a(` of the
position encoding kwargs are set equal to the `),Va=t("em"),zh=a("out_channels"),Ah=a("."),ml=l(),Oe=t("h2"),Wo=t("a"),Ra=t("span"),_(bt.$$.fragment),Dh=l(),Ua=t("span"),Oh=a("PerceiverOneHotPreprocessor"),hl=l(),Ne=t("div"),_(wt.$$.fragment),Nh=l(),Ka=t("p"),Lh=a("One-hot preprocessor for Perceiver Encoder. Can be used to add a dummy index dimension to the input."),ul=l(),Le=t("h2"),Ho=t("a"),Ga=t("span"),_(yt.$$.fragment),Sh=l(),Ja=t("span"),Bh=a("PerceiverAudioPreprocessor"),fl=l(),Se=t("div"),_($t.$$.fragment),Wh=l(),Xa=t("p"),Hh=a("Audio preprocessing for Perceiver Encoder."),gl=l(),Be=t("h2"),Vo=t("a"),Za=t("span"),_(kt.$$.fragment),Vh=l(),Ya=t("span"),Rh=a("PerceiverMultimodalPreprocessor"),vl=l(),ce=t("div"),_(Tt.$$.fragment),Uh=l(),Qa=t("p"),Kh=a("Multimodal preprocessing for Perceiver Encoder."),Gh=l(),ei=t("p"),Jh=a(`Inputs for each modality are preprocessed, then padded with trainable position embeddings to have the same number
of channels.`),_l=l(),We=t("h2"),Ro=t("a"),oi=t("span"),_(xt.$$.fragment),Xh=l(),ri=t("span"),Zh=a("PerceiverProjectionDecoder"),Pl=l(),He=t("div"),_(Et.$$.fragment),Yh=l(),ti=t("p"),Qh=a("Baseline projection decoder (no cross-attention)."),bl=l(),Ve=t("h2"),Uo=t("a"),si=t("span"),_(jt.$$.fragment),eu=l(),ni=t("span"),ou=a("PerceiverBasicDecoder"),wl=l(),le=t("div"),_(Ct.$$.fragment),ru=l(),ai=t("p"),tu=a(`Cross-attention-based decoder. This class can be used to decode the final hidden states of the latents using a
cross-attention operation, in which the latents produce keys and values.`),su=l(),ii=t("p"),nu=a("The shape of the output of this class depends on how one defines the output queries (also called decoder queries)."),yl=l(),Re=t("h2"),Ko=t("a"),ci=t("span"),_(Ft.$$.fragment),au=l(),li=t("span"),iu=a("PerceiverClassificationDecoder"),$l=l(),Ue=t("div"),_(It.$$.fragment),cu=l(),Mt=t("p"),lu=a("Cross-attention based classification decoder. Light-weight wrapper of "),di=t("code"),du=a("PerceiverBasicDecoder"),pu=a(` for logit output.
Will turn the output of the Perceiver encoder which is of shape (batch_size, num_latents, d_latents) to a tensor of
shape (batch_size, num_labels). The queries are of shape (batch_size, 1, num_labels).`),kl=l(),Ke=t("h2"),Go=t("a"),pi=t("span"),_(qt.$$.fragment),mu=l(),mi=t("span"),hu=a("PerceiverOpticalFlowDecoder"),Tl=l(),Ge=t("div"),_(zt.$$.fragment),uu=l(),hi=t("p"),fu=a("Cross-attention based optical flow decoder."),xl=l(),Je=t("h2"),Jo=t("a"),ui=t("span"),_(At.$$.fragment),gu=l(),fi=t("span"),vu=a("PerceiverBasicVideoAutoencodingDecoder"),El=l(),Xe=t("div"),_(Dt.$$.fragment),_u=l(),Ot=t("p"),Pu=a("Cross-attention based video-autoencoding decoder. Light-weight wrapper of ["),gi=t("em"),bu=a("PerceiverBasicDecoder"),wu=a(`] with video
reshaping logic.`),jl=l(),Ze=t("h2"),Xo=t("a"),vi=t("span"),_(Nt.$$.fragment),yu=l(),_i=t("span"),$u=a("PerceiverMultimodalDecoder"),Cl=l(),de=t("div"),_(Lt.$$.fragment),ku=l(),St=t("p"),Tu=a("Multimodal decoding by composing uni-modal decoders. The "),Pi=t("em"),xu=a("modalities"),Eu=a(` argument of the constructor is a dictionary
mapping modality name to the decoder of that modality. That decoder will be used to construct queries for that
modality. Modality-specific queries are padded with trainable modality-specific parameters, after which they are
concatenated along the time dimension.`),ju=l(),bi=t("p"),Cu=a("Next, there is a shared cross attention operation across all modalities."),Fl=l(),Ye=t("h2"),Zo=t("a"),wi=t("span"),_(Bt.$$.fragment),Fu=l(),yi=t("span"),Iu=a("PerceiverProjectionPostprocessor"),Il=l(),Qe=t("div"),_(Wt.$$.fragment),Mu=l(),$i=t("p"),qu=a(`Projection postprocessing for Perceiver. Can be used to project the channels of the decoder output to a lower
dimension.`),Ml=l(),eo=t("h2"),Yo=t("a"),ki=t("span"),_(Ht.$$.fragment),zu=l(),Ti=t("span"),Au=a("PerceiverAudioPostprocessor"),ql=l(),oo=t("div"),_(Vt.$$.fragment),Du=l(),xi=t("p"),Ou=a("Audio postprocessing for Perceiver. Can be used to convert the decoder output to audio features."),zl=l(),ro=t("h2"),Qo=t("a"),Ei=t("span"),_(Rt.$$.fragment),Nu=l(),ji=t("span"),Lu=a("PerceiverClassificationPostprocessor"),Al=l(),to=t("div"),_(Ut.$$.fragment),Su=l(),Ci=t("p"),Bu=a("Classification postprocessing for Perceiver. Can be used to convert the decoder output to classification logits."),Dl=l(),so=t("h2"),er=t("a"),Fi=t("span"),_(Kt.$$.fragment),Wu=l(),Ii=t("span"),Hu=a("PerceiverMultimodalPostprocessor"),Ol=l(),no=t("div"),_(Gt.$$.fragment),Vu=l(),Mi=t("p"),Ru=a(`Multimodal postprocessing for Perceiver. Can be used to combine modality-specific postprocessors into a single
postprocessor.`),Nl=l(),ao=t("h2"),or=t("a"),qi=t("span"),_(Jt.$$.fragment),Uu=l(),zi=t("span"),Ku=a("PerceiverModel"),Ll=l(),pe=t("div"),_(Xt.$$.fragment),Gu=l(),Zt=t("p"),Ju=a(`The Perceiver: a scalable, fully attentional architecture.
This model is a PyTorch `),Yt=t("a"),Xu=a("torch.nn.Module"),Zu=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Yu=l(),U=t("div"),_(Qt.$$.fragment),Qu=l(),io=t("p"),ef=a("The "),on=t("a"),of=a("PerceiverModel"),rf=a(" forward method, overrides the "),Ai=t("code"),tf=a("__call__"),sf=a(" special method."),nf=l(),_(rr.$$.fragment),af=l(),_(tr.$$.fragment),Sl=l(),co=t("h2"),sr=t("a"),Di=t("span"),_(es.$$.fragment),cf=l(),Oi=t("span"),lf=a("PerceiverForMaskedLM"),Bl=l(),me=t("div"),_(os.$$.fragment),df=l(),rs=t("p"),pf=a(`Example use of Perceiver for masked language modeling.
This model is a PyTorch `),ts=t("a"),mf=a("torch.nn.Module"),hf=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),uf=l(),K=t("div"),_(ss.$$.fragment),ff=l(),lo=t("p"),gf=a("The "),rn=t("a"),vf=a("PerceiverForMaskedLM"),_f=a(" forward method, overrides the "),Ni=t("code"),Pf=a("__call__"),bf=a(" special method."),wf=l(),_(nr.$$.fragment),yf=l(),_(ar.$$.fragment),Wl=l(),po=t("h2"),ir=t("a"),Li=t("span"),_(ns.$$.fragment),$f=l(),Si=t("span"),kf=a("PerceiverForSequenceClassification"),Hl=l(),he=t("div"),_(as.$$.fragment),Tf=l(),is=t("p"),xf=a(`Example use of Perceiver for text classification.
This model is a PyTorch `),cs=t("a"),Ef=a("torch.nn.Module"),jf=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Cf=l(),G=t("div"),_(ls.$$.fragment),Ff=l(),mo=t("p"),If=a("The "),tn=t("a"),Mf=a("PerceiverForSequenceClassification"),qf=a(" forward method, overrides the "),Bi=t("code"),zf=a("__call__"),Af=a(" special method."),Df=l(),_(cr.$$.fragment),Of=l(),_(lr.$$.fragment),Vl=l(),ho=t("h2"),dr=t("a"),Wi=t("span"),_(ds.$$.fragment),Nf=l(),Hi=t("span"),Lf=a("PerceiverForImageClassificationLearned"),Rl=l(),q=t("div"),_(ps.$$.fragment),Sf=l(),Vi=t("p"),Bf=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),Wf=l(),Ri=t("p"),Hf=a(`This model uses learned position embeddings. In other words, this model is not given any privileged information about
the structure of images. As shown in the paper, this model can achieve a top-1 accuracy of 72.7 on ImageNet.`),Vf=l(),L=t("p"),sn=t("a"),Rf=a("PerceiverForImageClassificationLearned"),Uf=a(" uses "),nn=t("a"),Kf=a("PerceiverImagePreprocessor"),Gf=a(`
(with `),Ui=t("code"),Jf=a('prep_type="conv1x1"'),Xf=a(`) to preprocess the input images, and
`),an=t("a"),Zf=a("PerceiverClassificationDecoder"),Yf=a(` to decode the latent representation of
`),cn=t("a"),Qf=a("PerceiverModel"),eg=a(" into classification logits."),og=l(),ms=t("p"),rg=a("This model is a PyTorch "),hs=t("a"),tg=a("torch.nn.Module"),sg=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),ng=l(),J=t("div"),_(us.$$.fragment),ag=l(),uo=t("p"),ig=a("The "),ln=t("a"),cg=a("PerceiverForImageClassificationLearned"),lg=a(" forward method, overrides the "),Ki=t("code"),dg=a("__call__"),pg=a(" special method."),mg=l(),_(pr.$$.fragment),hg=l(),_(mr.$$.fragment),Ul=l(),fo=t("h2"),hr=t("a"),Gi=t("span"),_(fs.$$.fragment),ug=l(),Ji=t("span"),fg=a("PerceiverForImageClassificationFourier"),Kl=l(),z=t("div"),_(gs.$$.fragment),gg=l(),Xi=t("p"),vg=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),_g=l(),Zi=t("p"),Pg=a(`This model uses fixed 2D Fourier position embeddings. As shown in the paper, this model can achieve a top-1 accuracy of
79.0 on ImageNet, and 84.5 when pre-trained on a large-scale dataset (i.e. JFT).`),bg=l(),S=t("p"),dn=t("a"),wg=a("PerceiverForImageClassificationLearned"),yg=a(" uses "),pn=t("a"),$g=a("PerceiverImagePreprocessor"),kg=a(`
(with `),Yi=t("code"),Tg=a('prep_type="pixels"'),xg=a(`) to preprocess the input images, and
`),mn=t("a"),Eg=a("PerceiverClassificationDecoder"),jg=a(` to decode the latent representation of
`),hn=t("a"),Cg=a("PerceiverModel"),Fg=a(" into classification logits."),Ig=l(),vs=t("p"),Mg=a("This model is a PyTorch "),_s=t("a"),qg=a("torch.nn.Module"),zg=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Ag=l(),X=t("div"),_(Ps.$$.fragment),Dg=l(),go=t("p"),Og=a("The "),un=t("a"),Ng=a("PerceiverForImageClassificationFourier"),Lg=a(" forward method, overrides the "),Qi=t("code"),Sg=a("__call__"),Bg=a(" special method."),Wg=l(),_(ur.$$.fragment),Hg=l(),_(fr.$$.fragment),Gl=l(),vo=t("h2"),gr=t("a"),ec=t("span"),_(bs.$$.fragment),Vg=l(),oc=t("span"),Rg=a("PerceiverForImageClassificationConvProcessing"),Jl=l(),A=t("div"),_(ws.$$.fragment),Ug=l(),rc=t("p"),Kg=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),Gg=l(),tc=t("p"),Jg=a(`This model uses a 2D conv+maxpool preprocessing network. As shown in the paper, this model can achieve a top-1 accuracy
of 82.1 on ImageNet.`),Xg=l(),B=t("p"),fn=t("a"),Zg=a("PerceiverForImageClassificationLearned"),Yg=a(" uses "),gn=t("a"),Qg=a("PerceiverImagePreprocessor"),ev=a(`
(with `),sc=t("code"),ov=a('prep_type="conv"'),rv=a(`) to preprocess the input images, and
`),vn=t("a"),tv=a("PerceiverClassificationDecoder"),sv=a(` to decode the latent representation of
`),_n=t("a"),nv=a("PerceiverModel"),av=a(" into classification logits."),iv=l(),ys=t("p"),cv=a("This model is a PyTorch "),$s=t("a"),lv=a("torch.nn.Module"),dv=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),pv=l(),Z=t("div"),_(ks.$$.fragment),mv=l(),_o=t("p"),hv=a("The "),Pn=t("a"),uv=a("PerceiverForImageClassificationConvProcessing"),fv=a(" forward method, overrides the "),nc=t("code"),gv=a("__call__"),vv=a(" special method."),_v=l(),_(vr.$$.fragment),Pv=l(),_(_r.$$.fragment),Xl=l(),Po=t("h2"),Pr=t("a"),ac=t("span"),_(Ts.$$.fragment),bv=l(),ic=t("span"),wv=a("PerceiverForOpticalFlow"),Zl=l(),O=t("div"),_(xs.$$.fragment),yv=l(),N=t("p"),$v=a("Example use of Perceiver for optical flow, for tasks such as Sintel and KITTI. "),bn=t("a"),kv=a("PerceiverForOpticalFlow"),Tv=a(` uses
`),wn=t("a"),xv=a("PerceiverImagePreprocessor"),Ev=a(" (with "),cc=t("em"),jv=a("prep_type=\u201Cpatches\u201D"),Cv=a(`) to preprocess the
input images, and `),yn=t("a"),Fv=a("PerceiverOpticalFlowDecoder"),Iv=a(` to decode the latent
representation of `),$n=t("a"),Mv=a("PerceiverModel"),qv=a("."),zv=l(),lc=t("p"),Av=a(`As input, one concatenates 2 subsequent frames along the channel dimension and extract a 3 x 3 patch around each pixel
(leading to 3 x 3 x 3 x 2 = 54 values for each pixel). Fixed Fourier position encodings are used to encode the position
of each pixel in the patch. Next, one applies the Perceiver encoder. To decode, one queries the latent representation
using the same encoding used for the input.`),Dv=l(),Es=t("p"),Ov=a("This model is a PyTorch "),js=t("a"),Nv=a("torch.nn.Module"),Lv=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Sv=l(),Y=t("div"),_(Cs.$$.fragment),Bv=l(),bo=t("p"),Wv=a("The "),kn=t("a"),Hv=a("PerceiverForOpticalFlow"),Vv=a(" forward method, overrides the "),dc=t("code"),Rv=a("__call__"),Uv=a(" special method."),Kv=l(),_(br.$$.fragment),Gv=l(),_(wr.$$.fragment),Yl=l(),wo=t("h2"),yr=t("a"),pc=t("span"),_(Fs.$$.fragment),Jv=l(),mc=t("span"),Xv=a("PerceiverForMultimodalAutoencoding"),Ql=l(),F=t("div"),_(Is.$$.fragment),Zv=l(),hc=t("p"),Yv=a("Example use of Perceiver for multimodal (video) autoencoding, for tasks such as Kinetics-700."),Qv=l(),$r=t("p"),Tn=t("a"),e_=a("PerceiverForMultimodalAutoencoding"),o_=a(" uses "),xn=t("a"),r_=a("PerceiverMultimodalPreprocessor"),t_=a(` to
preprocess the 3 modalities: images, audio and class labels. This preprocessor uses modality-specific preprocessors to
preprocess every modality separately, after which they are concatenated. Trainable position embeddings are used to pad
each modality to the same number of channels to make concatenation along the time dimension possible. Next, one applies
the Perceiver encoder.`),s_=l(),Pe=t("p"),En=t("a"),n_=a("PerceiverMultimodalDecoder"),a_=a(` is used to decode the latent representation of
`),jn=t("a"),i_=a("PerceiverModel"),c_=a(`. This decoder uses each modality-specific decoder to construct queries. The decoder queries are
created based on the inputs after preprocessing. However, autoencoding an entire video in a single forward pass is
computationally infeasible, hence one only uses parts of the decoder queries to do cross-attention with the latent
representation. This is determined by the subsampled indices for each modality, which can be provided as additional
input to the forward pass of `),Cn=t("a"),l_=a("PerceiverForMultimodalAutoencoding"),d_=a("."),p_=l(),kr=t("p"),Fn=t("a"),m_=a("PerceiverMultimodalDecoder"),h_=a(` also pads the decoder queries of the different
modalities to the same number of channels, in order to concatenate them along the time dimension. Next, cross-attention
is performed with the latent representation of `),In=t("a"),u_=a("PerceiverModel"),f_=a("."),g_=l(),Ms=t("p"),v_=a("Finally, "),uc=t("code"),__=a("~models.perceiver.modeling_perceiver.PerceiverMultiModalPostprocessor"),P_=a(` is used to turn this tensor into an
actual video. It first splits up the output into the different modalities, and then applies the respective
postprocessor for each modality.`),b_=l(),fc=t("p"),w_=a(`Note that, by masking the classification label during evaluation (i.e. simply providing a tensor of zeros for the
\u201Clabel\u201D modality), this auto-encoding model becomes a Kinetics 700 video classifier.`),y_=l(),qs=t("p"),$_=a("This model is a PyTorch "),zs=t("a"),k_=a("torch.nn.Module"),T_=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),x_=l(),Q=t("div"),_(As.$$.fragment),E_=l(),yo=t("p"),j_=a("The "),Mn=t("a"),C_=a("PerceiverForMultimodalAutoencoding"),F_=a(" forward method, overrides the "),gc=t("code"),I_=a("__call__"),M_=a(" special method."),q_=l(),_(Tr.$$.fragment),z_=l(),_(xr.$$.fragment),this.h()},l(o){const m=F2('[data-svelte="svelte-1phssyn"]',document.head);u=s(m,"META",{name:!0,content:!0}),m.forEach(r),T=d(o),v=s(o,"H1",{class:!0});var Ds=n(v);g=s(Ds,"A",{id:!0,class:!0,href:!0});var vc=n(g);k=s(vc,"SPAN",{});var _c=n(k);P(p.$$.fragment,_c),_c.forEach(r),vc.forEach(r),f=d(Ds),C=s(Ds,"SPAN",{});var Pc=n(C);pp=i(Pc,"Perceiver"),Pc.forEach(r),Ds.forEach(r),Mc=d(o),ye=s(o,"H2",{class:!0});var Os=n(ye);xo=s(Os,"A",{id:!0,class:!0,href:!0});var bc=n(xo);Qn=s(bc,"SPAN",{});var wc=n(Qn);P(Nr.$$.fragment,wc),wc.forEach(r),bc.forEach(r),mp=d(Os),ea=s(Os,"SPAN",{});var yc=n(ea);hp=i(yc,"Overview"),yc.forEach(r),Os.forEach(r),qc=d(o),Eo=s(o,"P",{});var Ns=n(Eo);up=i(Ns,"The Perceiver IO model was proposed in "),Lr=s(Ns,"A",{href:!0,rel:!0});var $c=n(Lr);fp=i($c,`Perceiver IO: A General Architecture for Structured Inputs &
Outputs`),$c.forEach(r),gp=i(Ns,` by Andrew Jaegle, Sebastian Borgeaud, Jean-Baptiste Alayrac, Carl Doersch,
Catalin Ionescu, David Ding, Skanda Koppula, Daniel Zoran, Andrew Brock, Evan Shelhamer, Olivier H\xE9naff, Matthew M.
Botvinick, Andrew Zisserman, Oriol Vinyals, Jo\xE3o Carreira.`),Ns.forEach(r),zc=d(o),jo=s(o,"P",{});var Ls=n(jo);vp=i(Ls,"Perceiver IO is a generalization of "),Sr=s(Ls,"A",{href:!0,rel:!0});var kc=n(Sr);_p=i(kc,"Perceiver"),kc.forEach(r),Pp=i(Ls,` to handle arbitrary outputs in
addition to arbitrary inputs. The original Perceiver only produced a single classification label. In addition to
classification labels, Perceiver IO can produce (for example) language, optical flow, and multimodal videos with audio.
This is done using the same building blocks as the original Perceiver. The computational complexity of Perceiver IO is
linear in the input and output size and the bulk of the processing occurs in the latent space, allowing us to process
inputs and outputs that are much larger than can be handled by standard Transformers. This means, for example,
Perceiver IO can do BERT-style masked language modeling directly using bytes instead of tokenized inputs.`),Ls.forEach(r),Ac=d(o),Ws=s(o,"P",{});var Tc=n(Ws);bp=i(Tc,"The abstract from the paper is the following:"),Tc.forEach(r),Dc=d(o),Hs=s(o,"P",{});var xc=n(Hs);oa=s(xc,"EM",{});var Ec=n(oa);wp=i(Ec,`The recently-proposed Perceiver model obtains good results on several domains (images, audio, multimodal, point
clouds) while scaling linearly in compute and memory with the input size. While the Perceiver supports many kinds of
inputs, it can only produce very simple outputs such as class scores. Perceiver IO overcomes this limitation without
sacrificing the original\u2019s appealing properties by learning to flexibly query the model\u2019s latent space to produce
outputs of arbitrary size and semantics. Perceiver IO still decouples model depth from data size and still scales
linearly with data size, but now with respect to both input and output sizes. The full Perceiver IO model achieves
strong results on tasks with highly structured output spaces, such as natural language and visual understanding,
StarCraft II, and multi-task and multi-modal domains. As highlights, Perceiver IO matches a Transformer-based BERT
baseline on the GLUE language benchmark without the need for input tokenization and achieves state-of-the-art
performance on Sintel optical flow estimation.`),Ec.forEach(r),xc.forEach(r),Oc=d(o),Vs=s(o,"P",{});var jc=n(Vs);yp=i(jc,"Here\u2019s a TLDR explaining how Perceiver works:"),jc.forEach(r),Nc=d(o),Rs=s(o,"P",{});var Cc=n(Rs);$p=i(Cc,`The main problem with the self-attention mechanism of the Transformer is that the time and memory requirements scale
quadratically with the sequence length. Hence, models like BERT and RoBERTa are limited to a max sequence length of 512
tokens. Perceiver aims to solve this issue by, instead of performing self-attention on the inputs, perform it on a set
of latent variables, and only use the inputs for cross-attention. In this way, the time and memory requirements don\u2019t
depend on the length of the inputs anymore, as one uses a fixed amount of latent variables, like 256 or 512. These are
randomly initialized, after which they are trained end-to-end using backpropagation.`),Cc.forEach(r),Lc=d(o),D=s(o,"P",{});var ee=n(D);kp=i(ee,"Internally, "),Us=s(ee,"A",{href:!0});var N_=n(Us);Tp=i(N_,"PerceiverModel"),N_.forEach(r),xp=i(ee," will create the latents, which is a tensor of shape "),ra=s(ee,"CODE",{});var L_=n(ra);Ep=i(L_,"(batch_size, num_latents, d_latents)"),L_.forEach(r),jp=i(ee,". One must provide "),ta=s(ee,"CODE",{});var S_=n(ta);Cp=i(S_,"inputs"),S_.forEach(r),Fp=i(ee,` (which could be text, images, audio, you name it!) to the model, which it will
use to perform cross-attention with the latents. The output of the Perceiver encoder is a tensor of the same shape. One
can then, similar to BERT, convert the last hidden states of the latents to classification logits by averaging along
the sequence dimension, and placing a linear layer on top of that to project the `),sa=s(ee,"CODE",{});var B_=n(sa);Ip=i(B_,"d_latents"),B_.forEach(r),Mp=i(ee," to "),na=s(ee,"CODE",{});var W_=n(na);qp=i(W_,"num_labels"),W_.forEach(r),zp=i(ee,"."),ee.forEach(r),Sc=d(o),Ks=s(o,"P",{});var H_=n(Ks);Ap=i(H_,`This was the idea of the original Perceiver paper. However, it could only output classification logits. In a follow-up
work, PerceiverIO, they generalized it to let the model also produce outputs of arbitrary size. How, you might ask? The
idea is actually relatively simple: one defines outputs of an arbitrary size, and then applies cross-attention with the
last hidden states of the latents, using the outputs as queries, and the latents as keys and values.`),H_.forEach(r),Bc=d(o),I=s(o,"P",{});var W=n(I);Dp=i(W,`So let\u2019s say one wants to perform masked language modeling (BERT-style) with the Perceiver. As the Perceiver\u2019s input
length will not have an impact on the computation time of the self-attention layers, one can provide raw bytes,
providing `),aa=s(W,"CODE",{});var V_=n(aa);Op=i(V_,"inputs"),V_.forEach(r),Np=i(W,` of length 2048 to the model. If one now masks out certain of these 2048 tokens, one can define the
`),ia=s(W,"CODE",{});var R_=n(ia);Lp=i(R_,"outputs"),R_.forEach(r),Sp=i(W," as being of shape: "),ca=s(W,"CODE",{});var U_=n(ca);Bp=i(U_,"(batch_size, 2048, 768)"),U_.forEach(r),Wp=i(W,`. Next, one performs cross-attention with the final hidden states
of the latents to update the `),la=s(W,"CODE",{});var K_=n(la);Hp=i(K_,"outputs"),K_.forEach(r),Vp=i(W," tensor. After cross-attention, one still has a tensor of shape "),da=s(W,"CODE",{});var G_=n(da);Rp=i(G_,"(batch_size, 2048, 768)"),G_.forEach(r),Up=i(W,`. One can then place a regular language modeling head on top, to project the last dimension to the
vocabulary size of the model, i.e. creating logits of shape `),pa=s(W,"CODE",{});var J_=n(pa);Kp=i(J_,"(batch_size, 2048, 262)"),J_.forEach(r),Gp=i(W,` (as Perceiver uses a vocabulary
size of 262 byte IDs).`),W.forEach(r),Wc=d(o),Co=s(o,"IMG",{src:!0,alt:!0,width:!0}),Hc=d(o),Br=s(o,"SMALL",{});var A_=n(Br);Jp=i(A_,"Perceiver IO architecture. Taken from the "),Gs=s(A_,"A",{href:!0});var X_=n(Gs);Xp=i(X_,"original paper"),X_.forEach(r),A_.forEach(r),Vc=d(o),ve=s(o,"P",{});var qn=n(ve);Zp=i(qn,"This model was contributed by "),Wr=s(qn,"A",{href:!0,rel:!0});var Z_=n(Wr);Yp=i(Z_,"nielsr"),Z_.forEach(r),Qp=i(qn,`. The original code can be found
`),Hr=s(qn,"A",{href:!0,rel:!0});var Y_=n(Hr);em=i(Y_,"here"),Y_.forEach(r),om=i(qn,"."),qn.forEach(r),Rc=d(o),Js=s(o,"P",{});var Q_=n(Js);rm=i(Q_,"Tips:"),Q_.forEach(r),Uc=d(o),Fo=s(o,"UL",{});var od=n(Fo);Vr=s(od,"LI",{});var rd=n(Vr);tm=i(rd,"The quickest way to get started with the Perceiver is by checking the "),Rr=s(rd,"A",{href:!0,rel:!0});var eP=n(Rr);sm=i(eP,`tutorial
notebooks`),eP.forEach(r),nm=i(rd,"."),rd.forEach(r),am=d(od),Ur=s(od,"LI",{});var td=n(Ur);im=i(td,"Refer to the "),Kr=s(td,"A",{href:!0,rel:!0});var oP=n(Kr);cm=i(oP,"blog post"),oP.forEach(r),lm=i(td,` if you want to fully understand how the model works and
is implemented in the library. Note that the models available in the library only showcase some examples of what you can do
with the Perceiver. There are many more use cases, including question answering, named-entity recognition, object detection,
audio classification, video classification, etc.`),td.forEach(r),od.forEach(r),Kc=d(o),Gr=s(o,"P",{});var D_=n(Gr);ma=s(D_,"STRONG",{});var rP=n(ma);dm=i(rP,"Note"),rP.forEach(r),pm=i(D_,":"),D_.forEach(r),Gc=d(o),Xs=s(o,"UL",{});var tP=n(Xs);_e=s(tP,"LI",{});var Ss=n(_e);mm=i(Ss,"Perceiver does "),ha=s(Ss,"STRONG",{});var sP=n(ha);hm=i(sP,"not"),sP.forEach(r),um=i(Ss," work with "),ua=s(Ss,"CODE",{});var nP=n(ua);fm=i(nP,"torch.nn.DataParallel"),nP.forEach(r),gm=i(Ss," due to a bug in PyTorch, see "),Jr=s(Ss,"A",{href:!0,rel:!0});var aP=n(Jr);vm=i(aP,"issue #36035"),aP.forEach(r),Ss.forEach(r),tP.forEach(r),Jc=d(o),$e=s(o,"H2",{class:!0});var sd=n($e);Io=s(sd,"A",{id:!0,class:!0,href:!0});var iP=n(Io);fa=s(iP,"SPAN",{});var cP=n(fa);P(Xr.$$.fragment,cP),cP.forEach(r),iP.forEach(r),_m=d(sd),ga=s(sd,"SPAN",{});var lP=n(ga);Pm=i(lP,"Perceiver specific outputs"),lP.forEach(r),sd.forEach(r),Xc=d(o),ke=s(o,"DIV",{class:!0});var nd=n(ke);P(Zr.$$.fragment,nd),bm=d(nd),va=s(nd,"P",{});var dP=n(va);wm=i(dP,"Base class for Perceiver base model\u2019s outputs, with potential hidden states, attentions and cross-attentions."),dP.forEach(r),nd.forEach(r),Zc=d(o),Te=s(o,"DIV",{class:!0});var ad=n(Te);P(Yr.$$.fragment,ad),ym=d(ad),_a=s(ad,"P",{});var pP=n(_a);$m=i(pP,"Base class for Perceiver decoder outputs, with potential cross-attentions."),pP.forEach(r),ad.forEach(r),Yc=d(o),xe=s(o,"DIV",{class:!0});var id=n(xe);P(Qr.$$.fragment,id),km=d(id),Pa=s(id,"P",{});var mP=n(Pa);Tm=i(mP,"Base class for Perceiver\u2019s masked language model outputs."),mP.forEach(r),id.forEach(r),Qc=d(o),Ee=s(o,"DIV",{class:!0});var cd=n(Ee);P(et.$$.fragment,cd),xm=d(cd),ba=s(cd,"P",{});var hP=n(ba);Em=i(hP,`Base class for Perceiver\u2019s outputs of sequence/image classification models, optical flow and multimodal
autoencoding.`),hP.forEach(r),cd.forEach(r),el=d(o),je=s(o,"H2",{class:!0});var ld=n(je);Mo=s(ld,"A",{id:!0,class:!0,href:!0});var uP=n(Mo);wa=s(uP,"SPAN",{});var fP=n(wa);P(ot.$$.fragment,fP),fP.forEach(r),uP.forEach(r),jm=d(ld),ya=s(ld,"SPAN",{});var gP=n(ya);Cm=i(gP,"PerceiverConfig"),gP.forEach(r),ld.forEach(r),ol=d(o),H=s(o,"DIV",{class:!0});var Er=n(H);P(rt.$$.fragment,Er),Fm=d(Er),Ce=s(Er,"P",{});var zn=n(Ce);Im=i(zn,"This is the configuration class to store the configuration of a "),Zs=s(zn,"A",{href:!0});var vP=n(Zs);Mm=i(vP,"PerceiverModel"),vP.forEach(r),qm=i(zn,`. It is used to instantiate an
Perceiver model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Perceiver
`),tt=s(zn,"A",{href:!0,rel:!0});var _P=n(tt);zm=i(_P,"deepmind/language-perceiver"),_P.forEach(r),Am=i(zn," architecture."),zn.forEach(r),Dm=d(Er),Fe=s(Er,"P",{});var An=n(Fe);Om=i(An,"Configuration objects inherit from "),Ys=s(An,"A",{href:!0});var PP=n(Ys);Nm=i(PP,"PretrainedConfig"),PP.forEach(r),Lm=i(An,` and can be used to control the model outputs. Read the
documentation from `),Qs=s(An,"A",{href:!0});var bP=n(Qs);Sm=i(bP,"PretrainedConfig"),bP.forEach(r),Bm=i(An," for more information."),An.forEach(r),Wm=d(Er),P(qo.$$.fragment,Er),Er.forEach(r),rl=d(o),Ie=s(o,"H2",{class:!0});var dd=n(Ie);zo=s(dd,"A",{id:!0,class:!0,href:!0});var wP=n(zo);$a=s(wP,"SPAN",{});var yP=n($a);P(st.$$.fragment,yP),yP.forEach(r),wP.forEach(r),Hm=d(dd),ka=s(dd,"SPAN",{});var $P=n(ka);Vm=i($P,"PerceiverTokenizer"),$P.forEach(r),dd.forEach(r),tl=d(o),V=s(o,"DIV",{class:!0});var jr=n(V);P(nt.$$.fragment,jr),Rm=d(jr),Ta=s(jr,"P",{});var kP=n(Ta);Um=i(kP,"Construct a Perceiver tokenizer. The Perceiver simply uses raw bytes utf-8 encoding."),kP.forEach(r),Km=d(jr),at=s(jr,"P",{});var pd=n(at);Gm=i(pd,"This tokenizer inherits from "),en=s(pd,"A",{href:!0});var TP=n(en);Jm=i(TP,"PreTrainedTokenizer"),TP.forEach(r),Xm=i(pd,` which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`),pd.forEach(r),Zm=d(jr),Ao=s(jr,"DIV",{class:!0});var md=n(Ao);P(it.$$.fragment,md),Ym=d(md),xa=s(md,"P",{});var xP=n(xa);Qm=i(xP,`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`),xP.forEach(r),md.forEach(r),jr.forEach(r),sl=d(o),Me=s(o,"H2",{class:!0});var hd=n(Me);Do=s(hd,"A",{id:!0,class:!0,href:!0});var EP=n(Do);Ea=s(EP,"SPAN",{});var jP=n(Ea);P(ct.$$.fragment,jP),jP.forEach(r),EP.forEach(r),eh=d(hd),ja=s(hd,"SPAN",{});var CP=n(ja);oh=i(CP,"PerceiverFeatureExtractor"),CP.forEach(r),hd.forEach(r),nl=d(o),qe=s(o,"DIV",{class:!0});var ud=n(qe);P(lt.$$.fragment,ud),rh=d(ud),Oo=s(ud,"DIV",{class:!0});var fd=n(Oo);P(dt.$$.fragment,fd),th=d(fd),Ca=s(fd,"P",{});var FP=n(Ca);sh=i(FP,"Preprocess an image or a batch of images."),FP.forEach(r),fd.forEach(r),ud.forEach(r),al=d(o),ze=s(o,"H2",{class:!0});var gd=n(ze);No=s(gd,"A",{id:!0,class:!0,href:!0});var IP=n(No);Fa=s(IP,"SPAN",{});var MP=n(Fa);P(pt.$$.fragment,MP),MP.forEach(r),IP.forEach(r),nh=d(gd),Ia=s(gd,"SPAN",{});var qP=n(Ia);ah=i(qP,"PerceiverImageProcessor"),qP.forEach(r),gd.forEach(r),il=d(o),ne=s(o,"DIV",{class:!0});var Dn=n(ne);P(mt.$$.fragment,Dn),ih=d(Dn),Ma=s(Dn,"P",{});var zP=n(Ma);ch=i(zP,"Constructs a Perceiver image processor."),zP.forEach(r),lh=d(Dn),Lo=s(Dn,"DIV",{class:!0});var vd=n(Lo);P(ht.$$.fragment,vd),dh=d(vd),qa=s(vd,"P",{});var AP=n(qa);ph=i(AP,"Preprocess an image or batch of images."),AP.forEach(r),vd.forEach(r),Dn.forEach(r),cl=d(o),Ae=s(o,"H2",{class:!0});var _d=n(Ae);So=s(_d,"A",{id:!0,class:!0,href:!0});var DP=n(So);za=s(DP,"SPAN",{});var OP=n(za);P(ut.$$.fragment,OP),OP.forEach(r),DP.forEach(r),mh=d(_d),Aa=s(_d,"SPAN",{});var NP=n(Aa);hh=i(NP,"PerceiverTextPreprocessor"),NP.forEach(r),_d.forEach(r),ll=d(o),ae=s(o,"DIV",{class:!0});var On=n(ae);P(ft.$$.fragment,On),uh=d(On),gt=s(On,"P",{});var Pd=n(gt);fh=i(Pd,"Text preprocessing for Perceiver Encoder. Can be used to embed "),Da=s(Pd,"CODE",{});var LP=n(Da);gh=i(LP,"inputs"),LP.forEach(r),vh=i(Pd," and add positional encodings."),Pd.forEach(r),_h=d(On),vt=s(On,"P",{});var bd=n(vt);Ph=i(bd,"The dimensionality of the embeddings is determined by the "),Oa=s(bd,"CODE",{});var SP=n(Oa);bh=i(SP,"d_model"),SP.forEach(r),wh=i(bd," attribute of the configuration."),bd.forEach(r),On.forEach(r),dl=d(o),De=s(o,"H2",{class:!0});var wd=n(De);Bo=s(wd,"A",{id:!0,class:!0,href:!0});var BP=n(Bo);Na=s(BP,"SPAN",{});var WP=n(Na);P(_t.$$.fragment,WP),WP.forEach(r),BP.forEach(r),yh=d(wd),La=s(wd,"SPAN",{});var HP=n(La);$h=i(HP,"PerceiverImagePreprocessor"),HP.forEach(r),wd.forEach(r),pl=d(o),ie=s(o,"DIV",{class:!0});var Nn=n(ie);P(Pt.$$.fragment,Nn),kh=d(Nn),Sa=s(Nn,"P",{});var VP=n(Sa);Th=i(VP,"Image preprocessing for Perceiver Encoder."),VP.forEach(r),xh=d(Nn),R=s(Nn,"P",{});var be=n(R);Eh=i(be,"Note: the "),Ba=s(be,"EM",{});var RP=n(Ba);jh=i(RP,"out_channels"),RP.forEach(r),Ch=i(be," argument refers to the output channels of a convolutional layer, if "),Wa=s(be,"EM",{});var UP=n(Wa);Fh=i(UP,"prep_type"),UP.forEach(r),Ih=i(be,` is set to
\u201Cconv1x1\u201D or \u201Cconv\u201D. If one adds absolute position embeddings, one must make sure the `),Ha=s(be,"EM",{});var KP=n(Ha);Mh=i(KP,"num_channels"),KP.forEach(r),qh=i(be,` of the
position encoding kwargs are set equal to the `),Va=s(be,"EM",{});var GP=n(Va);zh=i(GP,"out_channels"),GP.forEach(r),Ah=i(be,"."),be.forEach(r),Nn.forEach(r),ml=d(o),Oe=s(o,"H2",{class:!0});var yd=n(Oe);Wo=s(yd,"A",{id:!0,class:!0,href:!0});var JP=n(Wo);Ra=s(JP,"SPAN",{});var XP=n(Ra);P(bt.$$.fragment,XP),XP.forEach(r),JP.forEach(r),Dh=d(yd),Ua=s(yd,"SPAN",{});var ZP=n(Ua);Oh=i(ZP,"PerceiverOneHotPreprocessor"),ZP.forEach(r),yd.forEach(r),hl=d(o),Ne=s(o,"DIV",{class:!0});var $d=n(Ne);P(wt.$$.fragment,$d),Nh=d($d),Ka=s($d,"P",{});var YP=n(Ka);Lh=i(YP,"One-hot preprocessor for Perceiver Encoder. Can be used to add a dummy index dimension to the input."),YP.forEach(r),$d.forEach(r),ul=d(o),Le=s(o,"H2",{class:!0});var kd=n(Le);Ho=s(kd,"A",{id:!0,class:!0,href:!0});var QP=n(Ho);Ga=s(QP,"SPAN",{});var eb=n(Ga);P(yt.$$.fragment,eb),eb.forEach(r),QP.forEach(r),Sh=d(kd),Ja=s(kd,"SPAN",{});var ob=n(Ja);Bh=i(ob,"PerceiverAudioPreprocessor"),ob.forEach(r),kd.forEach(r),fl=d(o),Se=s(o,"DIV",{class:!0});var Td=n(Se);P($t.$$.fragment,Td),Wh=d(Td),Xa=s(Td,"P",{});var rb=n(Xa);Hh=i(rb,"Audio preprocessing for Perceiver Encoder."),rb.forEach(r),Td.forEach(r),gl=d(o),Be=s(o,"H2",{class:!0});var xd=n(Be);Vo=s(xd,"A",{id:!0,class:!0,href:!0});var tb=n(Vo);Za=s(tb,"SPAN",{});var sb=n(Za);P(kt.$$.fragment,sb),sb.forEach(r),tb.forEach(r),Vh=d(xd),Ya=s(xd,"SPAN",{});var nb=n(Ya);Rh=i(nb,"PerceiverMultimodalPreprocessor"),nb.forEach(r),xd.forEach(r),vl=d(o),ce=s(o,"DIV",{class:!0});var Ln=n(ce);P(Tt.$$.fragment,Ln),Uh=d(Ln),Qa=s(Ln,"P",{});var ab=n(Qa);Kh=i(ab,"Multimodal preprocessing for Perceiver Encoder."),ab.forEach(r),Gh=d(Ln),ei=s(Ln,"P",{});var ib=n(ei);Jh=i(ib,`Inputs for each modality are preprocessed, then padded with trainable position embeddings to have the same number
of channels.`),ib.forEach(r),Ln.forEach(r),_l=d(o),We=s(o,"H2",{class:!0});var Ed=n(We);Ro=s(Ed,"A",{id:!0,class:!0,href:!0});var cb=n(Ro);oi=s(cb,"SPAN",{});var lb=n(oi);P(xt.$$.fragment,lb),lb.forEach(r),cb.forEach(r),Xh=d(Ed),ri=s(Ed,"SPAN",{});var db=n(ri);Zh=i(db,"PerceiverProjectionDecoder"),db.forEach(r),Ed.forEach(r),Pl=d(o),He=s(o,"DIV",{class:!0});var jd=n(He);P(Et.$$.fragment,jd),Yh=d(jd),ti=s(jd,"P",{});var pb=n(ti);Qh=i(pb,"Baseline projection decoder (no cross-attention)."),pb.forEach(r),jd.forEach(r),bl=d(o),Ve=s(o,"H2",{class:!0});var Cd=n(Ve);Uo=s(Cd,"A",{id:!0,class:!0,href:!0});var mb=n(Uo);si=s(mb,"SPAN",{});var hb=n(si);P(jt.$$.fragment,hb),hb.forEach(r),mb.forEach(r),eu=d(Cd),ni=s(Cd,"SPAN",{});var ub=n(ni);ou=i(ub,"PerceiverBasicDecoder"),ub.forEach(r),Cd.forEach(r),wl=d(o),le=s(o,"DIV",{class:!0});var Sn=n(le);P(Ct.$$.fragment,Sn),ru=d(Sn),ai=s(Sn,"P",{});var fb=n(ai);tu=i(fb,`Cross-attention-based decoder. This class can be used to decode the final hidden states of the latents using a
cross-attention operation, in which the latents produce keys and values.`),fb.forEach(r),su=d(Sn),ii=s(Sn,"P",{});var gb=n(ii);nu=i(gb,"The shape of the output of this class depends on how one defines the output queries (also called decoder queries)."),gb.forEach(r),Sn.forEach(r),yl=d(o),Re=s(o,"H2",{class:!0});var Fd=n(Re);Ko=s(Fd,"A",{id:!0,class:!0,href:!0});var vb=n(Ko);ci=s(vb,"SPAN",{});var _b=n(ci);P(Ft.$$.fragment,_b),_b.forEach(r),vb.forEach(r),au=d(Fd),li=s(Fd,"SPAN",{});var Pb=n(li);iu=i(Pb,"PerceiverClassificationDecoder"),Pb.forEach(r),Fd.forEach(r),$l=d(o),Ue=s(o,"DIV",{class:!0});var Id=n(Ue);P(It.$$.fragment,Id),cu=d(Id),Mt=s(Id,"P",{});var Md=n(Mt);lu=i(Md,"Cross-attention based classification decoder. Light-weight wrapper of "),di=s(Md,"CODE",{});var bb=n(di);du=i(bb,"PerceiverBasicDecoder"),bb.forEach(r),pu=i(Md,` for logit output.
Will turn the output of the Perceiver encoder which is of shape (batch_size, num_latents, d_latents) to a tensor of
shape (batch_size, num_labels). The queries are of shape (batch_size, 1, num_labels).`),Md.forEach(r),Id.forEach(r),kl=d(o),Ke=s(o,"H2",{class:!0});var qd=n(Ke);Go=s(qd,"A",{id:!0,class:!0,href:!0});var wb=n(Go);pi=s(wb,"SPAN",{});var yb=n(pi);P(qt.$$.fragment,yb),yb.forEach(r),wb.forEach(r),mu=d(qd),mi=s(qd,"SPAN",{});var $b=n(mi);hu=i($b,"PerceiverOpticalFlowDecoder"),$b.forEach(r),qd.forEach(r),Tl=d(o),Ge=s(o,"DIV",{class:!0});var zd=n(Ge);P(zt.$$.fragment,zd),uu=d(zd),hi=s(zd,"P",{});var kb=n(hi);fu=i(kb,"Cross-attention based optical flow decoder."),kb.forEach(r),zd.forEach(r),xl=d(o),Je=s(o,"H2",{class:!0});var Ad=n(Je);Jo=s(Ad,"A",{id:!0,class:!0,href:!0});var Tb=n(Jo);ui=s(Tb,"SPAN",{});var xb=n(ui);P(At.$$.fragment,xb),xb.forEach(r),Tb.forEach(r),gu=d(Ad),fi=s(Ad,"SPAN",{});var Eb=n(fi);vu=i(Eb,"PerceiverBasicVideoAutoencodingDecoder"),Eb.forEach(r),Ad.forEach(r),El=d(o),Xe=s(o,"DIV",{class:!0});var Dd=n(Xe);P(Dt.$$.fragment,Dd),_u=d(Dd),Ot=s(Dd,"P",{});var Od=n(Ot);Pu=i(Od,"Cross-attention based video-autoencoding decoder. Light-weight wrapper of ["),gi=s(Od,"EM",{});var jb=n(gi);bu=i(jb,"PerceiverBasicDecoder"),jb.forEach(r),wu=i(Od,`] with video
reshaping logic.`),Od.forEach(r),Dd.forEach(r),jl=d(o),Ze=s(o,"H2",{class:!0});var Nd=n(Ze);Xo=s(Nd,"A",{id:!0,class:!0,href:!0});var Cb=n(Xo);vi=s(Cb,"SPAN",{});var Fb=n(vi);P(Nt.$$.fragment,Fb),Fb.forEach(r),Cb.forEach(r),yu=d(Nd),_i=s(Nd,"SPAN",{});var Ib=n(_i);$u=i(Ib,"PerceiverMultimodalDecoder"),Ib.forEach(r),Nd.forEach(r),Cl=d(o),de=s(o,"DIV",{class:!0});var Bn=n(de);P(Lt.$$.fragment,Bn),ku=d(Bn),St=s(Bn,"P",{});var Ld=n(St);Tu=i(Ld,"Multimodal decoding by composing uni-modal decoders. The "),Pi=s(Ld,"EM",{});var Mb=n(Pi);xu=i(Mb,"modalities"),Mb.forEach(r),Eu=i(Ld,` argument of the constructor is a dictionary
mapping modality name to the decoder of that modality. That decoder will be used to construct queries for that
modality. Modality-specific queries are padded with trainable modality-specific parameters, after which they are
concatenated along the time dimension.`),Ld.forEach(r),ju=d(Bn),bi=s(Bn,"P",{});var qb=n(bi);Cu=i(qb,"Next, there is a shared cross attention operation across all modalities."),qb.forEach(r),Bn.forEach(r),Fl=d(o),Ye=s(o,"H2",{class:!0});var Sd=n(Ye);Zo=s(Sd,"A",{id:!0,class:!0,href:!0});var zb=n(Zo);wi=s(zb,"SPAN",{});var Ab=n(wi);P(Bt.$$.fragment,Ab),Ab.forEach(r),zb.forEach(r),Fu=d(Sd),yi=s(Sd,"SPAN",{});var Db=n(yi);Iu=i(Db,"PerceiverProjectionPostprocessor"),Db.forEach(r),Sd.forEach(r),Il=d(o),Qe=s(o,"DIV",{class:!0});var Bd=n(Qe);P(Wt.$$.fragment,Bd),Mu=d(Bd),$i=s(Bd,"P",{});var Ob=n($i);qu=i(Ob,`Projection postprocessing for Perceiver. Can be used to project the channels of the decoder output to a lower
dimension.`),Ob.forEach(r),Bd.forEach(r),Ml=d(o),eo=s(o,"H2",{class:!0});var Wd=n(eo);Yo=s(Wd,"A",{id:!0,class:!0,href:!0});var Nb=n(Yo);ki=s(Nb,"SPAN",{});var Lb=n(ki);P(Ht.$$.fragment,Lb),Lb.forEach(r),Nb.forEach(r),zu=d(Wd),Ti=s(Wd,"SPAN",{});var Sb=n(Ti);Au=i(Sb,"PerceiverAudioPostprocessor"),Sb.forEach(r),Wd.forEach(r),ql=d(o),oo=s(o,"DIV",{class:!0});var Hd=n(oo);P(Vt.$$.fragment,Hd),Du=d(Hd),xi=s(Hd,"P",{});var Bb=n(xi);Ou=i(Bb,"Audio postprocessing for Perceiver. Can be used to convert the decoder output to audio features."),Bb.forEach(r),Hd.forEach(r),zl=d(o),ro=s(o,"H2",{class:!0});var Vd=n(ro);Qo=s(Vd,"A",{id:!0,class:!0,href:!0});var Wb=n(Qo);Ei=s(Wb,"SPAN",{});var Hb=n(Ei);P(Rt.$$.fragment,Hb),Hb.forEach(r),Wb.forEach(r),Nu=d(Vd),ji=s(Vd,"SPAN",{});var Vb=n(ji);Lu=i(Vb,"PerceiverClassificationPostprocessor"),Vb.forEach(r),Vd.forEach(r),Al=d(o),to=s(o,"DIV",{class:!0});var Rd=n(to);P(Ut.$$.fragment,Rd),Su=d(Rd),Ci=s(Rd,"P",{});var Rb=n(Ci);Bu=i(Rb,"Classification postprocessing for Perceiver. Can be used to convert the decoder output to classification logits."),Rb.forEach(r),Rd.forEach(r),Dl=d(o),so=s(o,"H2",{class:!0});var Ud=n(so);er=s(Ud,"A",{id:!0,class:!0,href:!0});var Ub=n(er);Fi=s(Ub,"SPAN",{});var Kb=n(Fi);P(Kt.$$.fragment,Kb),Kb.forEach(r),Ub.forEach(r),Wu=d(Ud),Ii=s(Ud,"SPAN",{});var Gb=n(Ii);Hu=i(Gb,"PerceiverMultimodalPostprocessor"),Gb.forEach(r),Ud.forEach(r),Ol=d(o),no=s(o,"DIV",{class:!0});var Kd=n(no);P(Gt.$$.fragment,Kd),Vu=d(Kd),Mi=s(Kd,"P",{});var Jb=n(Mi);Ru=i(Jb,`Multimodal postprocessing for Perceiver. Can be used to combine modality-specific postprocessors into a single
postprocessor.`),Jb.forEach(r),Kd.forEach(r),Nl=d(o),ao=s(o,"H2",{class:!0});var Gd=n(ao);or=s(Gd,"A",{id:!0,class:!0,href:!0});var Xb=n(or);qi=s(Xb,"SPAN",{});var Zb=n(qi);P(Jt.$$.fragment,Zb),Zb.forEach(r),Xb.forEach(r),Uu=d(Gd),zi=s(Gd,"SPAN",{});var Yb=n(zi);Ku=i(Yb,"PerceiverModel"),Yb.forEach(r),Gd.forEach(r),Ll=d(o),pe=s(o,"DIV",{class:!0});var Wn=n(pe);P(Xt.$$.fragment,Wn),Gu=d(Wn),Zt=s(Wn,"P",{});var Jd=n(Zt);Ju=i(Jd,`The Perceiver: a scalable, fully attentional architecture.
This model is a PyTorch `),Yt=s(Jd,"A",{href:!0,rel:!0});var Qb=n(Yt);Xu=i(Qb,"torch.nn.Module"),Qb.forEach(r),Zu=i(Jd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Jd.forEach(r),Yu=d(Wn),U=s(Wn,"DIV",{class:!0});var Cr=n(U);P(Qt.$$.fragment,Cr),Qu=d(Cr),io=s(Cr,"P",{});var Hn=n(io);ef=i(Hn,"The "),on=s(Hn,"A",{href:!0});var e1=n(on);of=i(e1,"PerceiverModel"),e1.forEach(r),rf=i(Hn," forward method, overrides the "),Ai=s(Hn,"CODE",{});var o1=n(Ai);tf=i(o1,"__call__"),o1.forEach(r),sf=i(Hn," special method."),Hn.forEach(r),nf=d(Cr),P(rr.$$.fragment,Cr),af=d(Cr),P(tr.$$.fragment,Cr),Cr.forEach(r),Wn.forEach(r),Sl=d(o),co=s(o,"H2",{class:!0});var Xd=n(co);sr=s(Xd,"A",{id:!0,class:!0,href:!0});var r1=n(sr);Di=s(r1,"SPAN",{});var t1=n(Di);P(es.$$.fragment,t1),t1.forEach(r),r1.forEach(r),cf=d(Xd),Oi=s(Xd,"SPAN",{});var s1=n(Oi);lf=i(s1,"PerceiverForMaskedLM"),s1.forEach(r),Xd.forEach(r),Bl=d(o),me=s(o,"DIV",{class:!0});var Vn=n(me);P(os.$$.fragment,Vn),df=d(Vn),rs=s(Vn,"P",{});var Zd=n(rs);pf=i(Zd,`Example use of Perceiver for masked language modeling.
This model is a PyTorch `),ts=s(Zd,"A",{href:!0,rel:!0});var n1=n(ts);mf=i(n1,"torch.nn.Module"),n1.forEach(r),hf=i(Zd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Zd.forEach(r),uf=d(Vn),K=s(Vn,"DIV",{class:!0});var Fr=n(K);P(ss.$$.fragment,Fr),ff=d(Fr),lo=s(Fr,"P",{});var Rn=n(lo);gf=i(Rn,"The "),rn=s(Rn,"A",{href:!0});var a1=n(rn);vf=i(a1,"PerceiverForMaskedLM"),a1.forEach(r),_f=i(Rn," forward method, overrides the "),Ni=s(Rn,"CODE",{});var i1=n(Ni);Pf=i(i1,"__call__"),i1.forEach(r),bf=i(Rn," special method."),Rn.forEach(r),wf=d(Fr),P(nr.$$.fragment,Fr),yf=d(Fr),P(ar.$$.fragment,Fr),Fr.forEach(r),Vn.forEach(r),Wl=d(o),po=s(o,"H2",{class:!0});var Yd=n(po);ir=s(Yd,"A",{id:!0,class:!0,href:!0});var c1=n(ir);Li=s(c1,"SPAN",{});var l1=n(Li);P(ns.$$.fragment,l1),l1.forEach(r),c1.forEach(r),$f=d(Yd),Si=s(Yd,"SPAN",{});var d1=n(Si);kf=i(d1,"PerceiverForSequenceClassification"),d1.forEach(r),Yd.forEach(r),Hl=d(o),he=s(o,"DIV",{class:!0});var Un=n(he);P(as.$$.fragment,Un),Tf=d(Un),is=s(Un,"P",{});var Qd=n(is);xf=i(Qd,`Example use of Perceiver for text classification.
This model is a PyTorch `),cs=s(Qd,"A",{href:!0,rel:!0});var p1=n(cs);Ef=i(p1,"torch.nn.Module"),p1.forEach(r),jf=i(Qd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Qd.forEach(r),Cf=d(Un),G=s(Un,"DIV",{class:!0});var Ir=n(G);P(ls.$$.fragment,Ir),Ff=d(Ir),mo=s(Ir,"P",{});var Kn=n(mo);If=i(Kn,"The "),tn=s(Kn,"A",{href:!0});var m1=n(tn);Mf=i(m1,"PerceiverForSequenceClassification"),m1.forEach(r),qf=i(Kn," forward method, overrides the "),Bi=s(Kn,"CODE",{});var h1=n(Bi);zf=i(h1,"__call__"),h1.forEach(r),Af=i(Kn," special method."),Kn.forEach(r),Df=d(Ir),P(cr.$$.fragment,Ir),Of=d(Ir),P(lr.$$.fragment,Ir),Ir.forEach(r),Un.forEach(r),Vl=d(o),ho=s(o,"H2",{class:!0});var ep=n(ho);dr=s(ep,"A",{id:!0,class:!0,href:!0});var u1=n(dr);Wi=s(u1,"SPAN",{});var f1=n(Wi);P(ds.$$.fragment,f1),f1.forEach(r),u1.forEach(r),Nf=d(ep),Hi=s(ep,"SPAN",{});var g1=n(Hi);Lf=i(g1,"PerceiverForImageClassificationLearned"),g1.forEach(r),ep.forEach(r),Rl=d(o),q=s(o,"DIV",{class:!0});var oe=n(q);P(ps.$$.fragment,oe),Sf=d(oe),Vi=s(oe,"P",{});var v1=n(Vi);Bf=i(v1,"Example use of Perceiver for image classification, for tasks such as ImageNet."),v1.forEach(r),Wf=d(oe),Ri=s(oe,"P",{});var _1=n(Ri);Hf=i(_1,`This model uses learned position embeddings. In other words, this model is not given any privileged information about
the structure of images. As shown in the paper, this model can achieve a top-1 accuracy of 72.7 on ImageNet.`),_1.forEach(r),Vf=d(oe),L=s(oe,"P",{});var ue=n(L);sn=s(ue,"A",{href:!0});var P1=n(sn);Rf=i(P1,"PerceiverForImageClassificationLearned"),P1.forEach(r),Uf=i(ue," uses "),nn=s(ue,"A",{href:!0});var b1=n(nn);Kf=i(b1,"PerceiverImagePreprocessor"),b1.forEach(r),Gf=i(ue,`
(with `),Ui=s(ue,"CODE",{});var w1=n(Ui);Jf=i(w1,'prep_type="conv1x1"'),w1.forEach(r),Xf=i(ue,`) to preprocess the input images, and
`),an=s(ue,"A",{href:!0});var y1=n(an);Zf=i(y1,"PerceiverClassificationDecoder"),y1.forEach(r),Yf=i(ue,` to decode the latent representation of
`),cn=s(ue,"A",{href:!0});var $1=n(cn);Qf=i($1,"PerceiverModel"),$1.forEach(r),eg=i(ue," into classification logits."),ue.forEach(r),og=d(oe),ms=s(oe,"P",{});var op=n(ms);rg=i(op,"This model is a PyTorch "),hs=s(op,"A",{href:!0,rel:!0});var k1=n(hs);tg=i(k1,"torch.nn.Module"),k1.forEach(r),sg=i(op,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),op.forEach(r),ng=d(oe),J=s(oe,"DIV",{class:!0});var Mr=n(J);P(us.$$.fragment,Mr),ag=d(Mr),uo=s(Mr,"P",{});var Gn=n(uo);ig=i(Gn,"The "),ln=s(Gn,"A",{href:!0});var T1=n(ln);cg=i(T1,"PerceiverForImageClassificationLearned"),T1.forEach(r),lg=i(Gn," forward method, overrides the "),Ki=s(Gn,"CODE",{});var x1=n(Ki);dg=i(x1,"__call__"),x1.forEach(r),pg=i(Gn," special method."),Gn.forEach(r),mg=d(Mr),P(pr.$$.fragment,Mr),hg=d(Mr),P(mr.$$.fragment,Mr),Mr.forEach(r),oe.forEach(r),Ul=d(o),fo=s(o,"H2",{class:!0});var rp=n(fo);hr=s(rp,"A",{id:!0,class:!0,href:!0});var E1=n(hr);Gi=s(E1,"SPAN",{});var j1=n(Gi);P(fs.$$.fragment,j1),j1.forEach(r),E1.forEach(r),ug=d(rp),Ji=s(rp,"SPAN",{});var C1=n(Ji);fg=i(C1,"PerceiverForImageClassificationFourier"),C1.forEach(r),rp.forEach(r),Kl=d(o),z=s(o,"DIV",{class:!0});var re=n(z);P(gs.$$.fragment,re),gg=d(re),Xi=s(re,"P",{});var F1=n(Xi);vg=i(F1,"Example use of Perceiver for image classification, for tasks such as ImageNet."),F1.forEach(r),_g=d(re),Zi=s(re,"P",{});var I1=n(Zi);Pg=i(I1,`This model uses fixed 2D Fourier position embeddings. As shown in the paper, this model can achieve a top-1 accuracy of
79.0 on ImageNet, and 84.5 when pre-trained on a large-scale dataset (i.e. JFT).`),I1.forEach(r),bg=d(re),S=s(re,"P",{});var fe=n(S);dn=s(fe,"A",{href:!0});var M1=n(dn);wg=i(M1,"PerceiverForImageClassificationLearned"),M1.forEach(r),yg=i(fe," uses "),pn=s(fe,"A",{href:!0});var q1=n(pn);$g=i(q1,"PerceiverImagePreprocessor"),q1.forEach(r),kg=i(fe,`
(with `),Yi=s(fe,"CODE",{});var z1=n(Yi);Tg=i(z1,'prep_type="pixels"'),z1.forEach(r),xg=i(fe,`) to preprocess the input images, and
`),mn=s(fe,"A",{href:!0});var A1=n(mn);Eg=i(A1,"PerceiverClassificationDecoder"),A1.forEach(r),jg=i(fe,` to decode the latent representation of
`),hn=s(fe,"A",{href:!0});var D1=n(hn);Cg=i(D1,"PerceiverModel"),D1.forEach(r),Fg=i(fe," into classification logits."),fe.forEach(r),Ig=d(re),vs=s(re,"P",{});var tp=n(vs);Mg=i(tp,"This model is a PyTorch "),_s=s(tp,"A",{href:!0,rel:!0});var O1=n(_s);qg=i(O1,"torch.nn.Module"),O1.forEach(r),zg=i(tp,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),tp.forEach(r),Ag=d(re),X=s(re,"DIV",{class:!0});var qr=n(X);P(Ps.$$.fragment,qr),Dg=d(qr),go=s(qr,"P",{});var Jn=n(go);Og=i(Jn,"The "),un=s(Jn,"A",{href:!0});var N1=n(un);Ng=i(N1,"PerceiverForImageClassificationFourier"),N1.forEach(r),Lg=i(Jn," forward method, overrides the "),Qi=s(Jn,"CODE",{});var L1=n(Qi);Sg=i(L1,"__call__"),L1.forEach(r),Bg=i(Jn," special method."),Jn.forEach(r),Wg=d(qr),P(ur.$$.fragment,qr),Hg=d(qr),P(fr.$$.fragment,qr),qr.forEach(r),re.forEach(r),Gl=d(o),vo=s(o,"H2",{class:!0});var sp=n(vo);gr=s(sp,"A",{id:!0,class:!0,href:!0});var S1=n(gr);ec=s(S1,"SPAN",{});var B1=n(ec);P(bs.$$.fragment,B1),B1.forEach(r),S1.forEach(r),Vg=d(sp),oc=s(sp,"SPAN",{});var W1=n(oc);Rg=i(W1,"PerceiverForImageClassificationConvProcessing"),W1.forEach(r),sp.forEach(r),Jl=d(o),A=s(o,"DIV",{class:!0});var te=n(A);P(ws.$$.fragment,te),Ug=d(te),rc=s(te,"P",{});var H1=n(rc);Kg=i(H1,"Example use of Perceiver for image classification, for tasks such as ImageNet."),H1.forEach(r),Gg=d(te),tc=s(te,"P",{});var V1=n(tc);Jg=i(V1,`This model uses a 2D conv+maxpool preprocessing network. As shown in the paper, this model can achieve a top-1 accuracy
of 82.1 on ImageNet.`),V1.forEach(r),Xg=d(te),B=s(te,"P",{});var ge=n(B);fn=s(ge,"A",{href:!0});var R1=n(fn);Zg=i(R1,"PerceiverForImageClassificationLearned"),R1.forEach(r),Yg=i(ge," uses "),gn=s(ge,"A",{href:!0});var U1=n(gn);Qg=i(U1,"PerceiverImagePreprocessor"),U1.forEach(r),ev=i(ge,`
(with `),sc=s(ge,"CODE",{});var K1=n(sc);ov=i(K1,'prep_type="conv"'),K1.forEach(r),rv=i(ge,`) to preprocess the input images, and
`),vn=s(ge,"A",{href:!0});var G1=n(vn);tv=i(G1,"PerceiverClassificationDecoder"),G1.forEach(r),sv=i(ge,` to decode the latent representation of
`),_n=s(ge,"A",{href:!0});var J1=n(_n);nv=i(J1,"PerceiverModel"),J1.forEach(r),av=i(ge," into classification logits."),ge.forEach(r),iv=d(te),ys=s(te,"P",{});var np=n(ys);cv=i(np,"This model is a PyTorch "),$s=s(np,"A",{href:!0,rel:!0});var X1=n($s);lv=i(X1,"torch.nn.Module"),X1.forEach(r),dv=i(np,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),np.forEach(r),pv=d(te),Z=s(te,"DIV",{class:!0});var zr=n(Z);P(ks.$$.fragment,zr),mv=d(zr),_o=s(zr,"P",{});var Xn=n(_o);hv=i(Xn,"The "),Pn=s(Xn,"A",{href:!0});var Z1=n(Pn);uv=i(Z1,"PerceiverForImageClassificationConvProcessing"),Z1.forEach(r),fv=i(Xn," forward method, overrides the "),nc=s(Xn,"CODE",{});var Y1=n(nc);gv=i(Y1,"__call__"),Y1.forEach(r),vv=i(Xn," special method."),Xn.forEach(r),_v=d(zr),P(vr.$$.fragment,zr),Pv=d(zr),P(_r.$$.fragment,zr),zr.forEach(r),te.forEach(r),Xl=d(o),Po=s(o,"H2",{class:!0});var ap=n(Po);Pr=s(ap,"A",{id:!0,class:!0,href:!0});var Q1=n(Pr);ac=s(Q1,"SPAN",{});var e2=n(ac);P(Ts.$$.fragment,e2),e2.forEach(r),Q1.forEach(r),bv=d(ap),ic=s(ap,"SPAN",{});var o2=n(ic);wv=i(o2,"PerceiverForOpticalFlow"),o2.forEach(r),ap.forEach(r),Zl=d(o),O=s(o,"DIV",{class:!0});var we=n(O);P(xs.$$.fragment,we),yv=d(we),N=s(we,"P",{});var se=n(N);$v=i(se,"Example use of Perceiver for optical flow, for tasks such as Sintel and KITTI. "),bn=s(se,"A",{href:!0});var r2=n(bn);kv=i(r2,"PerceiverForOpticalFlow"),r2.forEach(r),Tv=i(se,` uses
`),wn=s(se,"A",{href:!0});var t2=n(wn);xv=i(t2,"PerceiverImagePreprocessor"),t2.forEach(r),Ev=i(se," (with "),cc=s(se,"EM",{});var s2=n(cc);jv=i(s2,"prep_type=\u201Cpatches\u201D"),s2.forEach(r),Cv=i(se,`) to preprocess the
input images, and `),yn=s(se,"A",{href:!0});var n2=n(yn);Fv=i(n2,"PerceiverOpticalFlowDecoder"),n2.forEach(r),Iv=i(se,` to decode the latent
representation of `),$n=s(se,"A",{href:!0});var a2=n($n);Mv=i(a2,"PerceiverModel"),a2.forEach(r),qv=i(se,"."),se.forEach(r),zv=d(we),lc=s(we,"P",{});var i2=n(lc);Av=i(i2,`As input, one concatenates 2 subsequent frames along the channel dimension and extract a 3 x 3 patch around each pixel
(leading to 3 x 3 x 3 x 2 = 54 values for each pixel). Fixed Fourier position encodings are used to encode the position
of each pixel in the patch. Next, one applies the Perceiver encoder. To decode, one queries the latent representation
using the same encoding used for the input.`),i2.forEach(r),Dv=d(we),Es=s(we,"P",{});var ip=n(Es);Ov=i(ip,"This model is a PyTorch "),js=s(ip,"A",{href:!0,rel:!0});var c2=n(js);Nv=i(c2,"torch.nn.Module"),c2.forEach(r),Lv=i(ip,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),ip.forEach(r),Sv=d(we),Y=s(we,"DIV",{class:!0});var Ar=n(Y);P(Cs.$$.fragment,Ar),Bv=d(Ar),bo=s(Ar,"P",{});var Zn=n(bo);Wv=i(Zn,"The "),kn=s(Zn,"A",{href:!0});var l2=n(kn);Hv=i(l2,"PerceiverForOpticalFlow"),l2.forEach(r),Vv=i(Zn," forward method, overrides the "),dc=s(Zn,"CODE",{});var d2=n(dc);Rv=i(d2,"__call__"),d2.forEach(r),Uv=i(Zn," special method."),Zn.forEach(r),Kv=d(Ar),P(br.$$.fragment,Ar),Gv=d(Ar),P(wr.$$.fragment,Ar),Ar.forEach(r),we.forEach(r),Yl=d(o),wo=s(o,"H2",{class:!0});var cp=n(wo);yr=s(cp,"A",{id:!0,class:!0,href:!0});var p2=n(yr);pc=s(p2,"SPAN",{});var m2=n(pc);P(Fs.$$.fragment,m2),m2.forEach(r),p2.forEach(r),Jv=d(cp),mc=s(cp,"SPAN",{});var h2=n(mc);Xv=i(h2,"PerceiverForMultimodalAutoencoding"),h2.forEach(r),cp.forEach(r),Ql=d(o),F=s(o,"DIV",{class:!0});var M=n(F);P(Is.$$.fragment,M),Zv=d(M),hc=s(M,"P",{});var u2=n(hc);Yv=i(u2,"Example use of Perceiver for multimodal (video) autoencoding, for tasks such as Kinetics-700."),u2.forEach(r),Qv=d(M),$r=s(M,"P",{});var Fc=n($r);Tn=s(Fc,"A",{href:!0});var f2=n(Tn);e_=i(f2,"PerceiverForMultimodalAutoencoding"),f2.forEach(r),o_=i(Fc," uses "),xn=s(Fc,"A",{href:!0});var g2=n(xn);r_=i(g2,"PerceiverMultimodalPreprocessor"),g2.forEach(r),t_=i(Fc,` to
preprocess the 3 modalities: images, audio and class labels. This preprocessor uses modality-specific preprocessors to
preprocess every modality separately, after which they are concatenated. Trainable position embeddings are used to pad
each modality to the same number of channels to make concatenation along the time dimension possible. Next, one applies
the Perceiver encoder.`),Fc.forEach(r),s_=d(M),Pe=s(M,"P",{});var Bs=n(Pe);En=s(Bs,"A",{href:!0});var v2=n(En);n_=i(v2,"PerceiverMultimodalDecoder"),v2.forEach(r),a_=i(Bs,` is used to decode the latent representation of
`),jn=s(Bs,"A",{href:!0});var _2=n(jn);i_=i(_2,"PerceiverModel"),_2.forEach(r),c_=i(Bs,`. This decoder uses each modality-specific decoder to construct queries. The decoder queries are
created based on the inputs after preprocessing. However, autoencoding an entire video in a single forward pass is
computationally infeasible, hence one only uses parts of the decoder queries to do cross-attention with the latent
representation. This is determined by the subsampled indices for each modality, which can be provided as additional
input to the forward pass of `),Cn=s(Bs,"A",{href:!0});var P2=n(Cn);l_=i(P2,"PerceiverForMultimodalAutoencoding"),P2.forEach(r),d_=i(Bs,"."),Bs.forEach(r),p_=d(M),kr=s(M,"P",{});var Ic=n(kr);Fn=s(Ic,"A",{href:!0});var b2=n(Fn);m_=i(b2,"PerceiverMultimodalDecoder"),b2.forEach(r),h_=i(Ic,` also pads the decoder queries of the different
modalities to the same number of channels, in order to concatenate them along the time dimension. Next, cross-attention
is performed with the latent representation of `),In=s(Ic,"A",{href:!0});var w2=n(In);u_=i(w2,"PerceiverModel"),w2.forEach(r),f_=i(Ic,"."),Ic.forEach(r),g_=d(M),Ms=s(M,"P",{});var lp=n(Ms);v_=i(lp,"Finally, "),uc=s(lp,"CODE",{});var y2=n(uc);__=i(y2,"~models.perceiver.modeling_perceiver.PerceiverMultiModalPostprocessor"),y2.forEach(r),P_=i(lp,` is used to turn this tensor into an
actual video. It first splits up the output into the different modalities, and then applies the respective
postprocessor for each modality.`),lp.forEach(r),b_=d(M),fc=s(M,"P",{});var $2=n(fc);w_=i($2,`Note that, by masking the classification label during evaluation (i.e. simply providing a tensor of zeros for the
\u201Clabel\u201D modality), this auto-encoding model becomes a Kinetics 700 video classifier.`),$2.forEach(r),y_=d(M),qs=s(M,"P",{});var dp=n(qs);$_=i(dp,"This model is a PyTorch "),zs=s(dp,"A",{href:!0,rel:!0});var k2=n(zs);k_=i(k2,"torch.nn.Module"),k2.forEach(r),T_=i(dp,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),dp.forEach(r),x_=d(M),Q=s(M,"DIV",{class:!0});var Dr=n(Q);P(As.$$.fragment,Dr),E_=d(Dr),yo=s(Dr,"P",{});var Yn=n(yo);j_=i(Yn,"The "),Mn=s(Yn,"A",{href:!0});var T2=n(Mn);C_=i(T2,"PerceiverForMultimodalAutoencoding"),T2.forEach(r),F_=i(Yn," forward method, overrides the "),gc=s(Yn,"CODE",{});var x2=n(gc);I_=i(x2,"__call__"),x2.forEach(r),M_=i(Yn," special method."),Yn.forEach(r),q_=d(Dr),P(Tr.$$.fragment,Dr),z_=d(Dr),P(xr.$$.fragment,Dr),Dr.forEach(r),M.forEach(r),this.h()},h(){c(u,"name","hf:doc:metadata"),c(u,"content",JSON.stringify(Z2)),c(g,"id","perceiver"),c(g,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(g,"href","#perceiver"),c(v,"class","relative group"),c(xo,"id","overview"),c(xo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(xo,"href","#overview"),c(ye,"class","relative group"),c(Lr,"href","https://arxiv.org/abs/2107.14795"),c(Lr,"rel","nofollow"),c(Sr,"href","https://arxiv.org/abs/2103.03206"),c(Sr,"rel","nofollow"),c(Us,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel"),I2(Co.src,O_="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/perceiver_architecture.jpg")||c(Co,"src",O_),c(Co,"alt","drawing"),c(Co,"width","600"),c(Gs,"href","https://arxiv.org/abs/2105.15203"),c(Wr,"href","https://huggingface.co/nielsr"),c(Wr,"rel","nofollow"),c(Hr,"href","https://github.com/deepmind/deepmind-research/tree/master/perceiver"),c(Hr,"rel","nofollow"),c(Rr,"href","https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Perceiver"),c(Rr,"rel","nofollow"),c(Kr,"href","https://huggingface.co/blog/perceiver"),c(Kr,"rel","nofollow"),c(Jr,"href","https://github.com/pytorch/pytorch/issues/36035"),c(Jr,"rel","nofollow"),c(Io,"id","transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"),c(Io,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Io,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"),c($e,"class","relative group"),c(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Mo,"id","transformers.PerceiverConfig"),c(Mo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Mo,"href","#transformers.PerceiverConfig"),c(je,"class","relative group"),c(Zs,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel"),c(tt,"href","https://huggingface.co/deepmind/language-perceiver"),c(tt,"rel","nofollow"),c(Ys,"href","/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig"),c(Qs,"href","/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig"),c(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(zo,"id","transformers.PerceiverTokenizer"),c(zo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(zo,"href","#transformers.PerceiverTokenizer"),c(Ie,"class","relative group"),c(en,"href","/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer"),c(Ao,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Do,"id","transformers.PerceiverFeatureExtractor"),c(Do,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Do,"href","#transformers.PerceiverFeatureExtractor"),c(Me,"class","relative group"),c(Oo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(No,"id","transformers.PerceiverImageProcessor"),c(No,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(No,"href","#transformers.PerceiverImageProcessor"),c(ze,"class","relative group"),c(Lo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(So,"id","transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor"),c(So,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(So,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor"),c(Ae,"class","relative group"),c(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Bo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(Bo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Bo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(De,"class","relative group"),c(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Wo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor"),c(Wo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Wo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor"),c(Oe,"class","relative group"),c(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ho,"id","transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor"),c(Ho,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ho,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor"),c(Le,"class","relative group"),c(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Vo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(Vo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Vo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(Be,"class","relative group"),c(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ro,"id","transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder"),c(Ro,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ro,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder"),c(We,"class","relative group"),c(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Uo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder"),c(Uo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Uo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder"),c(Ve,"class","relative group"),c(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ko,"id","transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(Ko,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ko,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(Re,"class","relative group"),c(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Go,"id","transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c(Go,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Go,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c(Ke,"class","relative group"),c(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Jo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder"),c(Jo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Jo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder"),c(Je,"class","relative group"),c(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Xo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Xo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Xo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Ze,"class","relative group"),c(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Zo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor"),c(Zo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Zo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor"),c(Ye,"class","relative group"),c(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Yo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor"),c(Yo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Yo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor"),c(eo,"class","relative group"),c(oo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Qo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor"),c(Qo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Qo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor"),c(ro,"class","relative group"),c(to,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(er,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor"),c(er,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(er,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor"),c(so,"class","relative group"),c(no,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(or,"id","transformers.PerceiverModel"),c(or,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(or,"href","#transformers.PerceiverModel"),c(ao,"class","relative group"),c(Yt,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(Yt,"rel","nofollow"),c(on,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel"),c(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(sr,"id","transformers.PerceiverForMaskedLM"),c(sr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(sr,"href","#transformers.PerceiverForMaskedLM"),c(co,"class","relative group"),c(ts,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(ts,"rel","nofollow"),c(rn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForMaskedLM"),c(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ir,"id","transformers.PerceiverForSequenceClassification"),c(ir,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(ir,"href","#transformers.PerceiverForSequenceClassification"),c(po,"class","relative group"),c(cs,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(cs,"rel","nofollow"),c(tn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForSequenceClassification"),c(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(dr,"id","transformers.PerceiverForImageClassificationLearned"),c(dr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(dr,"href","#transformers.PerceiverForImageClassificationLearned"),c(ho,"class","relative group"),c(sn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(nn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(an,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(cn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel"),c(hs,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(hs,"rel","nofollow"),c(ln,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(hr,"id","transformers.PerceiverForImageClassificationFourier"),c(hr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(hr,"href","#transformers.PerceiverForImageClassificationFourier"),c(fo,"class","relative group"),c(dn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(pn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(mn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(hn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel"),c(_s,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(_s,"rel","nofollow"),c(un,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationFourier"),c(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(gr,"id","transformers.PerceiverForImageClassificationConvProcessing"),c(gr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(gr,"href","#transformers.PerceiverForImageClassificationConvProcessing"),c(vo,"class","relative group"),c(fn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(gn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(vn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(_n,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel"),c($s,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c($s,"rel","nofollow"),c(Pn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationConvProcessing"),c(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Pr,"id","transformers.PerceiverForOpticalFlow"),c(Pr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Pr,"href","#transformers.PerceiverForOpticalFlow"),c(Po,"class","relative group"),c(bn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow"),c(wn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(yn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c($n,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel"),c(js,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(js,"rel","nofollow"),c(kn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow"),c(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(yr,"id","transformers.PerceiverForMultimodalAutoencoding"),c(yr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(yr,"href","#transformers.PerceiverForMultimodalAutoencoding"),c(wo,"class","relative group"),c(Tn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c(xn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(En,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(jn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel"),c(Cn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c(Fn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(In,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel"),c(zs,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(zs,"rel","nofollow"),c(Mn,"href","/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(o,m){e(document.head,u),h(o,T,m),h(o,v,m),e(v,g),e(g,k),b(p,k,null),e(v,f),e(v,C),e(C,pp),h(o,Mc,m),h(o,ye,m),e(ye,xo),e(xo,Qn),b(Nr,Qn,null),e(ye,mp),e(ye,ea),e(ea,hp),h(o,qc,m),h(o,Eo,m),e(Eo,up),e(Eo,Lr),e(Lr,fp),e(Eo,gp),h(o,zc,m),h(o,jo,m),e(jo,vp),e(jo,Sr),e(Sr,_p),e(jo,Pp),h(o,Ac,m),h(o,Ws,m),e(Ws,bp),h(o,Dc,m),h(o,Hs,m),e(Hs,oa),e(oa,wp),h(o,Oc,m),h(o,Vs,m),e(Vs,yp),h(o,Nc,m),h(o,Rs,m),e(Rs,$p),h(o,Lc,m),h(o,D,m),e(D,kp),e(D,Us),e(Us,Tp),e(D,xp),e(D,ra),e(ra,Ep),e(D,jp),e(D,ta),e(ta,Cp),e(D,Fp),e(D,sa),e(sa,Ip),e(D,Mp),e(D,na),e(na,qp),e(D,zp),h(o,Sc,m),h(o,Ks,m),e(Ks,Ap),h(o,Bc,m),h(o,I,m),e(I,Dp),e(I,aa),e(aa,Op),e(I,Np),e(I,ia),e(ia,Lp),e(I,Sp),e(I,ca),e(ca,Bp),e(I,Wp),e(I,la),e(la,Hp),e(I,Vp),e(I,da),e(da,Rp),e(I,Up),e(I,pa),e(pa,Kp),e(I,Gp),h(o,Wc,m),h(o,Co,m),h(o,Hc,m),h(o,Br,m),e(Br,Jp),e(Br,Gs),e(Gs,Xp),h(o,Vc,m),h(o,ve,m),e(ve,Zp),e(ve,Wr),e(Wr,Yp),e(ve,Qp),e(ve,Hr),e(Hr,em),e(ve,om),h(o,Rc,m),h(o,Js,m),e(Js,rm),h(o,Uc,m),h(o,Fo,m),e(Fo,Vr),e(Vr,tm),e(Vr,Rr),e(Rr,sm),e(Vr,nm),e(Fo,am),e(Fo,Ur),e(Ur,im),e(Ur,Kr),e(Kr,cm),e(Ur,lm),h(o,Kc,m),h(o,Gr,m),e(Gr,ma),e(ma,dm),e(Gr,pm),h(o,Gc,m),h(o,Xs,m),e(Xs,_e),e(_e,mm),e(_e,ha),e(ha,hm),e(_e,um),e(_e,ua),e(ua,fm),e(_e,gm),e(_e,Jr),e(Jr,vm),h(o,Jc,m),h(o,$e,m),e($e,Io),e(Io,fa),b(Xr,fa,null),e($e,_m),e($e,ga),e(ga,Pm),h(o,Xc,m),h(o,ke,m),b(Zr,ke,null),e(ke,bm),e(ke,va),e(va,wm),h(o,Zc,m),h(o,Te,m),b(Yr,Te,null),e(Te,ym),e(Te,_a),e(_a,$m),h(o,Yc,m),h(o,xe,m),b(Qr,xe,null),e(xe,km),e(xe,Pa),e(Pa,Tm),h(o,Qc,m),h(o,Ee,m),b(et,Ee,null),e(Ee,xm),e(Ee,ba),e(ba,Em),h(o,el,m),h(o,je,m),e(je,Mo),e(Mo,wa),b(ot,wa,null),e(je,jm),e(je,ya),e(ya,Cm),h(o,ol,m),h(o,H,m),b(rt,H,null),e(H,Fm),e(H,Ce),e(Ce,Im),e(Ce,Zs),e(Zs,Mm),e(Ce,qm),e(Ce,tt),e(tt,zm),e(Ce,Am),e(H,Dm),e(H,Fe),e(Fe,Om),e(Fe,Ys),e(Ys,Nm),e(Fe,Lm),e(Fe,Qs),e(Qs,Sm),e(Fe,Bm),e(H,Wm),b(qo,H,null),h(o,rl,m),h(o,Ie,m),e(Ie,zo),e(zo,$a),b(st,$a,null),e(Ie,Hm),e(Ie,ka),e(ka,Vm),h(o,tl,m),h(o,V,m),b(nt,V,null),e(V,Rm),e(V,Ta),e(Ta,Um),e(V,Km),e(V,at),e(at,Gm),e(at,en),e(en,Jm),e(at,Xm),e(V,Zm),e(V,Ao),b(it,Ao,null),e(Ao,Ym),e(Ao,xa),e(xa,Qm),h(o,sl,m),h(o,Me,m),e(Me,Do),e(Do,Ea),b(ct,Ea,null),e(Me,eh),e(Me,ja),e(ja,oh),h(o,nl,m),h(o,qe,m),b(lt,qe,null),e(qe,rh),e(qe,Oo),b(dt,Oo,null),e(Oo,th),e(Oo,Ca),e(Ca,sh),h(o,al,m),h(o,ze,m),e(ze,No),e(No,Fa),b(pt,Fa,null),e(ze,nh),e(ze,Ia),e(Ia,ah),h(o,il,m),h(o,ne,m),b(mt,ne,null),e(ne,ih),e(ne,Ma),e(Ma,ch),e(ne,lh),e(ne,Lo),b(ht,Lo,null),e(Lo,dh),e(Lo,qa),e(qa,ph),h(o,cl,m),h(o,Ae,m),e(Ae,So),e(So,za),b(ut,za,null),e(Ae,mh),e(Ae,Aa),e(Aa,hh),h(o,ll,m),h(o,ae,m),b(ft,ae,null),e(ae,uh),e(ae,gt),e(gt,fh),e(gt,Da),e(Da,gh),e(gt,vh),e(ae,_h),e(ae,vt),e(vt,Ph),e(vt,Oa),e(Oa,bh),e(vt,wh),h(o,dl,m),h(o,De,m),e(De,Bo),e(Bo,Na),b(_t,Na,null),e(De,yh),e(De,La),e(La,$h),h(o,pl,m),h(o,ie,m),b(Pt,ie,null),e(ie,kh),e(ie,Sa),e(Sa,Th),e(ie,xh),e(ie,R),e(R,Eh),e(R,Ba),e(Ba,jh),e(R,Ch),e(R,Wa),e(Wa,Fh),e(R,Ih),e(R,Ha),e(Ha,Mh),e(R,qh),e(R,Va),e(Va,zh),e(R,Ah),h(o,ml,m),h(o,Oe,m),e(Oe,Wo),e(Wo,Ra),b(bt,Ra,null),e(Oe,Dh),e(Oe,Ua),e(Ua,Oh),h(o,hl,m),h(o,Ne,m),b(wt,Ne,null),e(Ne,Nh),e(Ne,Ka),e(Ka,Lh),h(o,ul,m),h(o,Le,m),e(Le,Ho),e(Ho,Ga),b(yt,Ga,null),e(Le,Sh),e(Le,Ja),e(Ja,Bh),h(o,fl,m),h(o,Se,m),b($t,Se,null),e(Se,Wh),e(Se,Xa),e(Xa,Hh),h(o,gl,m),h(o,Be,m),e(Be,Vo),e(Vo,Za),b(kt,Za,null),e(Be,Vh),e(Be,Ya),e(Ya,Rh),h(o,vl,m),h(o,ce,m),b(Tt,ce,null),e(ce,Uh),e(ce,Qa),e(Qa,Kh),e(ce,Gh),e(ce,ei),e(ei,Jh),h(o,_l,m),h(o,We,m),e(We,Ro),e(Ro,oi),b(xt,oi,null),e(We,Xh),e(We,ri),e(ri,Zh),h(o,Pl,m),h(o,He,m),b(Et,He,null),e(He,Yh),e(He,ti),e(ti,Qh),h(o,bl,m),h(o,Ve,m),e(Ve,Uo),e(Uo,si),b(jt,si,null),e(Ve,eu),e(Ve,ni),e(ni,ou),h(o,wl,m),h(o,le,m),b(Ct,le,null),e(le,ru),e(le,ai),e(ai,tu),e(le,su),e(le,ii),e(ii,nu),h(o,yl,m),h(o,Re,m),e(Re,Ko),e(Ko,ci),b(Ft,ci,null),e(Re,au),e(Re,li),e(li,iu),h(o,$l,m),h(o,Ue,m),b(It,Ue,null),e(Ue,cu),e(Ue,Mt),e(Mt,lu),e(Mt,di),e(di,du),e(Mt,pu),h(o,kl,m),h(o,Ke,m),e(Ke,Go),e(Go,pi),b(qt,pi,null),e(Ke,mu),e(Ke,mi),e(mi,hu),h(o,Tl,m),h(o,Ge,m),b(zt,Ge,null),e(Ge,uu),e(Ge,hi),e(hi,fu),h(o,xl,m),h(o,Je,m),e(Je,Jo),e(Jo,ui),b(At,ui,null),e(Je,gu),e(Je,fi),e(fi,vu),h(o,El,m),h(o,Xe,m),b(Dt,Xe,null),e(Xe,_u),e(Xe,Ot),e(Ot,Pu),e(Ot,gi),e(gi,bu),e(Ot,wu),h(o,jl,m),h(o,Ze,m),e(Ze,Xo),e(Xo,vi),b(Nt,vi,null),e(Ze,yu),e(Ze,_i),e(_i,$u),h(o,Cl,m),h(o,de,m),b(Lt,de,null),e(de,ku),e(de,St),e(St,Tu),e(St,Pi),e(Pi,xu),e(St,Eu),e(de,ju),e(de,bi),e(bi,Cu),h(o,Fl,m),h(o,Ye,m),e(Ye,Zo),e(Zo,wi),b(Bt,wi,null),e(Ye,Fu),e(Ye,yi),e(yi,Iu),h(o,Il,m),h(o,Qe,m),b(Wt,Qe,null),e(Qe,Mu),e(Qe,$i),e($i,qu),h(o,Ml,m),h(o,eo,m),e(eo,Yo),e(Yo,ki),b(Ht,ki,null),e(eo,zu),e(eo,Ti),e(Ti,Au),h(o,ql,m),h(o,oo,m),b(Vt,oo,null),e(oo,Du),e(oo,xi),e(xi,Ou),h(o,zl,m),h(o,ro,m),e(ro,Qo),e(Qo,Ei),b(Rt,Ei,null),e(ro,Nu),e(ro,ji),e(ji,Lu),h(o,Al,m),h(o,to,m),b(Ut,to,null),e(to,Su),e(to,Ci),e(Ci,Bu),h(o,Dl,m),h(o,so,m),e(so,er),e(er,Fi),b(Kt,Fi,null),e(so,Wu),e(so,Ii),e(Ii,Hu),h(o,Ol,m),h(o,no,m),b(Gt,no,null),e(no,Vu),e(no,Mi),e(Mi,Ru),h(o,Nl,m),h(o,ao,m),e(ao,or),e(or,qi),b(Jt,qi,null),e(ao,Uu),e(ao,zi),e(zi,Ku),h(o,Ll,m),h(o,pe,m),b(Xt,pe,null),e(pe,Gu),e(pe,Zt),e(Zt,Ju),e(Zt,Yt),e(Yt,Xu),e(Zt,Zu),e(pe,Yu),e(pe,U),b(Qt,U,null),e(U,Qu),e(U,io),e(io,ef),e(io,on),e(on,of),e(io,rf),e(io,Ai),e(Ai,tf),e(io,sf),e(U,nf),b(rr,U,null),e(U,af),b(tr,U,null),h(o,Sl,m),h(o,co,m),e(co,sr),e(sr,Di),b(es,Di,null),e(co,cf),e(co,Oi),e(Oi,lf),h(o,Bl,m),h(o,me,m),b(os,me,null),e(me,df),e(me,rs),e(rs,pf),e(rs,ts),e(ts,mf),e(rs,hf),e(me,uf),e(me,K),b(ss,K,null),e(K,ff),e(K,lo),e(lo,gf),e(lo,rn),e(rn,vf),e(lo,_f),e(lo,Ni),e(Ni,Pf),e(lo,bf),e(K,wf),b(nr,K,null),e(K,yf),b(ar,K,null),h(o,Wl,m),h(o,po,m),e(po,ir),e(ir,Li),b(ns,Li,null),e(po,$f),e(po,Si),e(Si,kf),h(o,Hl,m),h(o,he,m),b(as,he,null),e(he,Tf),e(he,is),e(is,xf),e(is,cs),e(cs,Ef),e(is,jf),e(he,Cf),e(he,G),b(ls,G,null),e(G,Ff),e(G,mo),e(mo,If),e(mo,tn),e(tn,Mf),e(mo,qf),e(mo,Bi),e(Bi,zf),e(mo,Af),e(G,Df),b(cr,G,null),e(G,Of),b(lr,G,null),h(o,Vl,m),h(o,ho,m),e(ho,dr),e(dr,Wi),b(ds,Wi,null),e(ho,Nf),e(ho,Hi),e(Hi,Lf),h(o,Rl,m),h(o,q,m),b(ps,q,null),e(q,Sf),e(q,Vi),e(Vi,Bf),e(q,Wf),e(q,Ri),e(Ri,Hf),e(q,Vf),e(q,L),e(L,sn),e(sn,Rf),e(L,Uf),e(L,nn),e(nn,Kf),e(L,Gf),e(L,Ui),e(Ui,Jf),e(L,Xf),e(L,an),e(an,Zf),e(L,Yf),e(L,cn),e(cn,Qf),e(L,eg),e(q,og),e(q,ms),e(ms,rg),e(ms,hs),e(hs,tg),e(ms,sg),e(q,ng),e(q,J),b(us,J,null),e(J,ag),e(J,uo),e(uo,ig),e(uo,ln),e(ln,cg),e(uo,lg),e(uo,Ki),e(Ki,dg),e(uo,pg),e(J,mg),b(pr,J,null),e(J,hg),b(mr,J,null),h(o,Ul,m),h(o,fo,m),e(fo,hr),e(hr,Gi),b(fs,Gi,null),e(fo,ug),e(fo,Ji),e(Ji,fg),h(o,Kl,m),h(o,z,m),b(gs,z,null),e(z,gg),e(z,Xi),e(Xi,vg),e(z,_g),e(z,Zi),e(Zi,Pg),e(z,bg),e(z,S),e(S,dn),e(dn,wg),e(S,yg),e(S,pn),e(pn,$g),e(S,kg),e(S,Yi),e(Yi,Tg),e(S,xg),e(S,mn),e(mn,Eg),e(S,jg),e(S,hn),e(hn,Cg),e(S,Fg),e(z,Ig),e(z,vs),e(vs,Mg),e(vs,_s),e(_s,qg),e(vs,zg),e(z,Ag),e(z,X),b(Ps,X,null),e(X,Dg),e(X,go),e(go,Og),e(go,un),e(un,Ng),e(go,Lg),e(go,Qi),e(Qi,Sg),e(go,Bg),e(X,Wg),b(ur,X,null),e(X,Hg),b(fr,X,null),h(o,Gl,m),h(o,vo,m),e(vo,gr),e(gr,ec),b(bs,ec,null),e(vo,Vg),e(vo,oc),e(oc,Rg),h(o,Jl,m),h(o,A,m),b(ws,A,null),e(A,Ug),e(A,rc),e(rc,Kg),e(A,Gg),e(A,tc),e(tc,Jg),e(A,Xg),e(A,B),e(B,fn),e(fn,Zg),e(B,Yg),e(B,gn),e(gn,Qg),e(B,ev),e(B,sc),e(sc,ov),e(B,rv),e(B,vn),e(vn,tv),e(B,sv),e(B,_n),e(_n,nv),e(B,av),e(A,iv),e(A,ys),e(ys,cv),e(ys,$s),e($s,lv),e(ys,dv),e(A,pv),e(A,Z),b(ks,Z,null),e(Z,mv),e(Z,_o),e(_o,hv),e(_o,Pn),e(Pn,uv),e(_o,fv),e(_o,nc),e(nc,gv),e(_o,vv),e(Z,_v),b(vr,Z,null),e(Z,Pv),b(_r,Z,null),h(o,Xl,m),h(o,Po,m),e(Po,Pr),e(Pr,ac),b(Ts,ac,null),e(Po,bv),e(Po,ic),e(ic,wv),h(o,Zl,m),h(o,O,m),b(xs,O,null),e(O,yv),e(O,N),e(N,$v),e(N,bn),e(bn,kv),e(N,Tv),e(N,wn),e(wn,xv),e(N,Ev),e(N,cc),e(cc,jv),e(N,Cv),e(N,yn),e(yn,Fv),e(N,Iv),e(N,$n),e($n,Mv),e(N,qv),e(O,zv),e(O,lc),e(lc,Av),e(O,Dv),e(O,Es),e(Es,Ov),e(Es,js),e(js,Nv),e(Es,Lv),e(O,Sv),e(O,Y),b(Cs,Y,null),e(Y,Bv),e(Y,bo),e(bo,Wv),e(bo,kn),e(kn,Hv),e(bo,Vv),e(bo,dc),e(dc,Rv),e(bo,Uv),e(Y,Kv),b(br,Y,null),e(Y,Gv),b(wr,Y,null),h(o,Yl,m),h(o,wo,m),e(wo,yr),e(yr,pc),b(Fs,pc,null),e(wo,Jv),e(wo,mc),e(mc,Xv),h(o,Ql,m),h(o,F,m),b(Is,F,null),e(F,Zv),e(F,hc),e(hc,Yv),e(F,Qv),e(F,$r),e($r,Tn),e(Tn,e_),e($r,o_),e($r,xn),e(xn,r_),e($r,t_),e(F,s_),e(F,Pe),e(Pe,En),e(En,n_),e(Pe,a_),e(Pe,jn),e(jn,i_),e(Pe,c_),e(Pe,Cn),e(Cn,l_),e(Pe,d_),e(F,p_),e(F,kr),e(kr,Fn),e(Fn,m_),e(kr,h_),e(kr,In),e(In,u_),e(kr,f_),e(F,g_),e(F,Ms),e(Ms,v_),e(Ms,uc),e(uc,__),e(Ms,P_),e(F,b_),e(F,fc),e(fc,w_),e(F,y_),e(F,qs),e(qs,$_),e(qs,zs),e(zs,k_),e(qs,T_),e(F,x_),e(F,Q),b(As,Q,null),e(Q,E_),e(Q,yo),e(yo,j_),e(yo,Mn),e(Mn,C_),e(yo,F_),e(yo,gc),e(gc,I_),e(yo,M_),e(Q,q_),b(Tr,Q,null),e(Q,z_),b(xr,Q,null),ed=!0},p(o,[m]){const Ds={};m&2&&(Ds.$$scope={dirty:m,ctx:o}),qo.$set(Ds);const vc={};m&2&&(vc.$$scope={dirty:m,ctx:o}),rr.$set(vc);const _c={};m&2&&(_c.$$scope={dirty:m,ctx:o}),tr.$set(_c);const Pc={};m&2&&(Pc.$$scope={dirty:m,ctx:o}),nr.$set(Pc);const Os={};m&2&&(Os.$$scope={dirty:m,ctx:o}),ar.$set(Os);const bc={};m&2&&(bc.$$scope={dirty:m,ctx:o}),cr.$set(bc);const wc={};m&2&&(wc.$$scope={dirty:m,ctx:o}),lr.$set(wc);const yc={};m&2&&(yc.$$scope={dirty:m,ctx:o}),pr.$set(yc);const Ns={};m&2&&(Ns.$$scope={dirty:m,ctx:o}),mr.$set(Ns);const $c={};m&2&&($c.$$scope={dirty:m,ctx:o}),ur.$set($c);const Ls={};m&2&&(Ls.$$scope={dirty:m,ctx:o}),fr.$set(Ls);const kc={};m&2&&(kc.$$scope={dirty:m,ctx:o}),vr.$set(kc);const Tc={};m&2&&(Tc.$$scope={dirty:m,ctx:o}),_r.$set(Tc);const xc={};m&2&&(xc.$$scope={dirty:m,ctx:o}),br.$set(xc);const Ec={};m&2&&(Ec.$$scope={dirty:m,ctx:o}),wr.$set(Ec);const jc={};m&2&&(jc.$$scope={dirty:m,ctx:o}),Tr.$set(jc);const Cc={};m&2&&(Cc.$$scope={dirty:m,ctx:o}),xr.$set(Cc)},i(o){ed||(w(p.$$.fragment,o),w(Nr.$$.fragment,o),w(Xr.$$.fragment,o),w(Zr.$$.fragment,o),w(Yr.$$.fragment,o),w(Qr.$$.fragment,o),w(et.$$.fragment,o),w(ot.$$.fragment,o),w(rt.$$.fragment,o),w(qo.$$.fragment,o),w(st.$$.fragment,o),w(nt.$$.fragment,o),w(it.$$.fragment,o),w(ct.$$.fragment,o),w(lt.$$.fragment,o),w(dt.$$.fragment,o),w(pt.$$.fragment,o),w(mt.$$.fragment,o),w(ht.$$.fragment,o),w(ut.$$.fragment,o),w(ft.$$.fragment,o),w(_t.$$.fragment,o),w(Pt.$$.fragment,o),w(bt.$$.fragment,o),w(wt.$$.fragment,o),w(yt.$$.fragment,o),w($t.$$.fragment,o),w(kt.$$.fragment,o),w(Tt.$$.fragment,o),w(xt.$$.fragment,o),w(Et.$$.fragment,o),w(jt.$$.fragment,o),w(Ct.$$.fragment,o),w(Ft.$$.fragment,o),w(It.$$.fragment,o),w(qt.$$.fragment,o),w(zt.$$.fragment,o),w(At.$$.fragment,o),w(Dt.$$.fragment,o),w(Nt.$$.fragment,o),w(Lt.$$.fragment,o),w(Bt.$$.fragment,o),w(Wt.$$.fragment,o),w(Ht.$$.fragment,o),w(Vt.$$.fragment,o),w(Rt.$$.fragment,o),w(Ut.$$.fragment,o),w(Kt.$$.fragment,o),w(Gt.$$.fragment,o),w(Jt.$$.fragment,o),w(Xt.$$.fragment,o),w(Qt.$$.fragment,o),w(rr.$$.fragment,o),w(tr.$$.fragment,o),w(es.$$.fragment,o),w(os.$$.fragment,o),w(ss.$$.fragment,o),w(nr.$$.fragment,o),w(ar.$$.fragment,o),w(ns.$$.fragment,o),w(as.$$.fragment,o),w(ls.$$.fragment,o),w(cr.$$.fragment,o),w(lr.$$.fragment,o),w(ds.$$.fragment,o),w(ps.$$.fragment,o),w(us.$$.fragment,o),w(pr.$$.fragment,o),w(mr.$$.fragment,o),w(fs.$$.fragment,o),w(gs.$$.fragment,o),w(Ps.$$.fragment,o),w(ur.$$.fragment,o),w(fr.$$.fragment,o),w(bs.$$.fragment,o),w(ws.$$.fragment,o),w(ks.$$.fragment,o),w(vr.$$.fragment,o),w(_r.$$.fragment,o),w(Ts.$$.fragment,o),w(xs.$$.fragment,o),w(Cs.$$.fragment,o),w(br.$$.fragment,o),w(wr.$$.fragment,o),w(Fs.$$.fragment,o),w(Is.$$.fragment,o),w(As.$$.fragment,o),w(Tr.$$.fragment,o),w(xr.$$.fragment,o),ed=!0)},o(o){y(p.$$.fragment,o),y(Nr.$$.fragment,o),y(Xr.$$.fragment,o),y(Zr.$$.fragment,o),y(Yr.$$.fragment,o),y(Qr.$$.fragment,o),y(et.$$.fragment,o),y(ot.$$.fragment,o),y(rt.$$.fragment,o),y(qo.$$.fragment,o),y(st.$$.fragment,o),y(nt.$$.fragment,o),y(it.$$.fragment,o),y(ct.$$.fragment,o),y(lt.$$.fragment,o),y(dt.$$.fragment,o),y(pt.$$.fragment,o),y(mt.$$.fragment,o),y(ht.$$.fragment,o),y(ut.$$.fragment,o),y(ft.$$.fragment,o),y(_t.$$.fragment,o),y(Pt.$$.fragment,o),y(bt.$$.fragment,o),y(wt.$$.fragment,o),y(yt.$$.fragment,o),y($t.$$.fragment,o),y(kt.$$.fragment,o),y(Tt.$$.fragment,o),y(xt.$$.fragment,o),y(Et.$$.fragment,o),y(jt.$$.fragment,o),y(Ct.$$.fragment,o),y(Ft.$$.fragment,o),y(It.$$.fragment,o),y(qt.$$.fragment,o),y(zt.$$.fragment,o),y(At.$$.fragment,o),y(Dt.$$.fragment,o),y(Nt.$$.fragment,o),y(Lt.$$.fragment,o),y(Bt.$$.fragment,o),y(Wt.$$.fragment,o),y(Ht.$$.fragment,o),y(Vt.$$.fragment,o),y(Rt.$$.fragment,o),y(Ut.$$.fragment,o),y(Kt.$$.fragment,o),y(Gt.$$.fragment,o),y(Jt.$$.fragment,o),y(Xt.$$.fragment,o),y(Qt.$$.fragment,o),y(rr.$$.fragment,o),y(tr.$$.fragment,o),y(es.$$.fragment,o),y(os.$$.fragment,o),y(ss.$$.fragment,o),y(nr.$$.fragment,o),y(ar.$$.fragment,o),y(ns.$$.fragment,o),y(as.$$.fragment,o),y(ls.$$.fragment,o),y(cr.$$.fragment,o),y(lr.$$.fragment,o),y(ds.$$.fragment,o),y(ps.$$.fragment,o),y(us.$$.fragment,o),y(pr.$$.fragment,o),y(mr.$$.fragment,o),y(fs.$$.fragment,o),y(gs.$$.fragment,o),y(Ps.$$.fragment,o),y(ur.$$.fragment,o),y(fr.$$.fragment,o),y(bs.$$.fragment,o),y(ws.$$.fragment,o),y(ks.$$.fragment,o),y(vr.$$.fragment,o),y(_r.$$.fragment,o),y(Ts.$$.fragment,o),y(xs.$$.fragment,o),y(Cs.$$.fragment,o),y(br.$$.fragment,o),y(wr.$$.fragment,o),y(Fs.$$.fragment,o),y(Is.$$.fragment,o),y(As.$$.fragment,o),y(Tr.$$.fragment,o),y(xr.$$.fragment,o),ed=!1},d(o){r(u),o&&r(T),o&&r(v),$(p),o&&r(Mc),o&&r(ye),$(Nr),o&&r(qc),o&&r(Eo),o&&r(zc),o&&r(jo),o&&r(Ac),o&&r(Ws),o&&r(Dc),o&&r(Hs),o&&r(Oc),o&&r(Vs),o&&r(Nc),o&&r(Rs),o&&r(Lc),o&&r(D),o&&r(Sc),o&&r(Ks),o&&r(Bc),o&&r(I),o&&r(Wc),o&&r(Co),o&&r(Hc),o&&r(Br),o&&r(Vc),o&&r(ve),o&&r(Rc),o&&r(Js),o&&r(Uc),o&&r(Fo),o&&r(Kc),o&&r(Gr),o&&r(Gc),o&&r(Xs),o&&r(Jc),o&&r($e),$(Xr),o&&r(Xc),o&&r(ke),$(Zr),o&&r(Zc),o&&r(Te),$(Yr),o&&r(Yc),o&&r(xe),$(Qr),o&&r(Qc),o&&r(Ee),$(et),o&&r(el),o&&r(je),$(ot),o&&r(ol),o&&r(H),$(rt),$(qo),o&&r(rl),o&&r(Ie),$(st),o&&r(tl),o&&r(V),$(nt),$(it),o&&r(sl),o&&r(Me),$(ct),o&&r(nl),o&&r(qe),$(lt),$(dt),o&&r(al),o&&r(ze),$(pt),o&&r(il),o&&r(ne),$(mt),$(ht),o&&r(cl),o&&r(Ae),$(ut),o&&r(ll),o&&r(ae),$(ft),o&&r(dl),o&&r(De),$(_t),o&&r(pl),o&&r(ie),$(Pt),o&&r(ml),o&&r(Oe),$(bt),o&&r(hl),o&&r(Ne),$(wt),o&&r(ul),o&&r(Le),$(yt),o&&r(fl),o&&r(Se),$($t),o&&r(gl),o&&r(Be),$(kt),o&&r(vl),o&&r(ce),$(Tt),o&&r(_l),o&&r(We),$(xt),o&&r(Pl),o&&r(He),$(Et),o&&r(bl),o&&r(Ve),$(jt),o&&r(wl),o&&r(le),$(Ct),o&&r(yl),o&&r(Re),$(Ft),o&&r($l),o&&r(Ue),$(It),o&&r(kl),o&&r(Ke),$(qt),o&&r(Tl),o&&r(Ge),$(zt),o&&r(xl),o&&r(Je),$(At),o&&r(El),o&&r(Xe),$(Dt),o&&r(jl),o&&r(Ze),$(Nt),o&&r(Cl),o&&r(de),$(Lt),o&&r(Fl),o&&r(Ye),$(Bt),o&&r(Il),o&&r(Qe),$(Wt),o&&r(Ml),o&&r(eo),$(Ht),o&&r(ql),o&&r(oo),$(Vt),o&&r(zl),o&&r(ro),$(Rt),o&&r(Al),o&&r(to),$(Ut),o&&r(Dl),o&&r(so),$(Kt),o&&r(Ol),o&&r(no),$(Gt),o&&r(Nl),o&&r(ao),$(Jt),o&&r(Ll),o&&r(pe),$(Xt),$(Qt),$(rr),$(tr),o&&r(Sl),o&&r(co),$(es),o&&r(Bl),o&&r(me),$(os),$(ss),$(nr),$(ar),o&&r(Wl),o&&r(po),$(ns),o&&r(Hl),o&&r(he),$(as),$(ls),$(cr),$(lr),o&&r(Vl),o&&r(ho),$(ds),o&&r(Rl),o&&r(q),$(ps),$(us),$(pr),$(mr),o&&r(Ul),o&&r(fo),$(fs),o&&r(Kl),o&&r(z),$(gs),$(Ps),$(ur),$(fr),o&&r(Gl),o&&r(vo),$(bs),o&&r(Jl),o&&r(A),$(ws),$(ks),$(vr),$(_r),o&&r(Xl),o&&r(Po),$(Ts),o&&r(Zl),o&&r(O),$(xs),$(Cs),$(br),$(wr),o&&r(Yl),o&&r(wo),$(Fs),o&&r(Ql),o&&r(F),$(Is),$(As),$(Tr),$(xr)}}}const Z2={local:"perceiver",sections:[{local:"overview",title:"Overview"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",title:"Perceiver specific outputs"},{local:"transformers.PerceiverConfig",title:"PerceiverConfig"},{local:"transformers.PerceiverTokenizer",title:"PerceiverTokenizer"},{local:"transformers.PerceiverFeatureExtractor",title:"PerceiverFeatureExtractor"},{local:"transformers.PerceiverImageProcessor",title:"PerceiverImageProcessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",title:"PerceiverTextPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",title:"PerceiverImagePreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",title:"PerceiverOneHotPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",title:"PerceiverAudioPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",title:"PerceiverMultimodalPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",title:"PerceiverProjectionDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",title:"PerceiverBasicDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",title:"PerceiverClassificationDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",title:"PerceiverOpticalFlowDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",title:"PerceiverBasicVideoAutoencodingDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",title:"PerceiverMultimodalDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",title:"PerceiverProjectionPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",title:"PerceiverAudioPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",title:"PerceiverClassificationPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",title:"PerceiverMultimodalPostprocessor"},{local:"transformers.PerceiverModel",title:"PerceiverModel"},{local:"transformers.PerceiverForMaskedLM",title:"PerceiverForMaskedLM"},{local:"transformers.PerceiverForSequenceClassification",title:"PerceiverForSequenceClassification"},{local:"transformers.PerceiverForImageClassificationLearned",title:"PerceiverForImageClassificationLearned"},{local:"transformers.PerceiverForImageClassificationFourier",title:"PerceiverForImageClassificationFourier"},{local:"transformers.PerceiverForImageClassificationConvProcessing",title:"PerceiverForImageClassificationConvProcessing"},{local:"transformers.PerceiverForOpticalFlow",title:"PerceiverForOpticalFlow"},{local:"transformers.PerceiverForMultimodalAutoencoding",title:"PerceiverForMultimodalAutoencoding"}],title:"Perceiver"};function Y2(E){return M2(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nw extends E2{constructor(u){super();j2(this,u,Y2,X2,C2,{})}}export{nw as default,Z2 as metadata};
