import{s as ze,f as De,n as qe,o as Ae}from"../chunks/scheduler.7bc62968.js";import{S as Pe,i as Ke,g as n,s as i,r as H,A as Oe,h as o,f as l,c as s,j as $e,u as S,x as r,k as E,y as et,a,v as Y,d as Q,t as R,w as V}from"../chunks/index.66556066.js";import{C as Te}from"../chunks/CodeBlock.a759539a.js";import{H as Ue}from"../chunks/Heading.3f0870db.js";function tt(Ze){let p,$,L,z,d,D,c,We=`This chapter introduces the building blocks of Stable Diffusion which is a generative artificial intelligence (generative AI) model that produces unique photorealistic images from text and image prompts. It originally launched in 2022 and was made possible thanks to a collaboration with
<a href="https://stability.ai/" rel="nofollow">Stability AI</a>, <a href="https://runwayml.com/" rel="nofollow">RunwayML</a> and CompVis Group at LMU Munich following the <a href="https://arxiv.org/pdf/2112.10752.pdf" rel="nofollow">paper</a>.`,q,u,Be="What will you learn from this chapter?",A,M,je="<li>Fundamental components of Stable Diffusion</li> <li>How to use <code>text-to-image</code>, <code>image2image</code>, inpainting</li>",P,h,K,f,ve=`To make this section interesting we will try to answer some questions to understand the basic components of the Stable Diffusion process.
We will briefly discuss each component as they are already covered in our Diffusers course. Also, you can visit our previous section, which talks about GANS and Diffusion models in details.`,O,y,Ie="<li>What strategies does Stable Diffusion employ to learn new information?<ul><li>It uses forward and reverse processes of diffusion models. In the forward process, we add Gaussian noise to an image until all that remains is the random noise. Usually we cannot identify the final noisy version of the image.</li> <li>In the reserve process, we have a learned neural network trained to gradually denoise an image starting from pure noise, until you end up with an actual image.</li></ul></li>",ee,w,ke='Both of these processes happens for a finite number of steps <code>T</code>(as per DDPM paper T=1000). You begin the process at time $t_0$ by sampling a real image from your data distribution, and the forward process samples some noise from a Gaussian distribution at each time step t, which is added to the image of the previous time step. To get more mathematical intuition, please read <a href="https://huggingface.co/blog/annotated-diffusion" rel="nofollow">Hugging Face Blog</a> on Diffusion Models.',te,J,Ge="<li>Since our images can be huge how can we compress it?</li>",le,g,xe=`When you have large images, they require more computing power to process. This becomes very noticeable in a specific operation known as self-attention. The bigger the image, the more calculations are needed, and these calculations increase very quickly (in a way mathematicians call “quadratically”) with the size of the image.
For example, if you have an image that’s 128 pixels wide and tall, it has four times more pixels than an image that’s only 64 pixels wide and tall. Because of how self-attention works, dealing with this larger image doesn’t just need four times more memory and computing power, it actually needs sixteen times more (since 4 times 4 equals 16). This makes it challenging to work with very high-resolution images, as they require a lot of resources to process.
Latent diffusion models address the high computational demands of processing large images by using a Variational Auto-Encoder (VAE) to shrink the images into a more manageable size. The idea is that many images have repetitive or unnecessary information. A VAE, after being trained on a lot of data, can compress an image into a much smaller, condensed form. This smaller version still retains the essential features of the original image.`,ae,b,Xe="<li>How are we fusing texts with images since we are using prompts?</li>",ie,T,Ce=`We know that during inference time, we can feed in the description of an image we’d like to see and some pure noise as a starting point, and the model does its best to ‘denoise’ the random input into something that matches the caption.
SD leverages a pre-trained transformer model based on something called <a href="https://github.com/johko/computer-vision-course/blob/main/chapters/en/Unit%204%20-%20Mulitmodal%20Models/CLIP%20and%20relatives/clip.mdx" rel="nofollow">CLIP</a>. CLIP’s text encoder was designed to process image captions into a form that could be used to compare images and text, so it is well suited to the task of creating useful representations from image descriptions. An input prompt is first tokenized (based on a large vocabulary where each word or sub-word is assigned a specific token) and then fed through the CLIP text encoder, producing a 768-dimensional (in the case of SD 1.X) or 1024-dimensional (SD 2.X) vector for each token. To keep things consistent prompts are always padded/truncated to be 77 tokens long, and so the final representation which we use as conditioning is a tensor of shape 77x1024 per prompt.`,se,U,_e="<li>How can we add-in good inductive biases?</li>",ne,Z,Fe=`Since, we are trying to generate something new(e.g., a realistic Pokemon), we need a way to go beyond the images we have seen before(e.g., an anime Pokemon). That’s where U-Net and self-attention come into the picture. Given a noisy version of an image, the model is tasked with predicting the denoised version based on additional clues such as a text description of the image. Ok, how do we actually feed this conditioning information into the U-Net for it to use as it makes predictions? The answer is something called cross-attention. Scattered throughout the U-Net are cross-attention layers.
Each spatial location in the U-Net can ‘attend’ to different tokens in the text conditioning, bringing in relevant information from the prompt.`,oe,W,re,B,He='This section introduces helpful usecases and how we can perform these tasks using the <a href="https://github.com/huggingface/diffusers" rel="nofollow">Diffusers</a> library.',me,j,Se=`<li>Steps for <code>text-to-image</code> inference
The idea is to pass in the text prompt, which is converted to the output image.</li>`,pe,m,Ye="",Qe,de,v,Re="Using the <code>diffusers</code> library you can get <code>text-to-image</code> working in 2 steps.",ce,I,Ve="Let’s install the <code>diffusers</code> library first.",ue,k,Me,G,he,x,Ee="<li>Steps for image-to-image inference</li>",fe,X,ye,C,Le="<li>Steps for Inpainting</li>",we,_,Je,F,Ne=`For more details and tutorials please checkout out diffusers <a href="https://huggingface.co/docs/diffusers/using-diffusers/pipeline_overview" rel="nofollow">Documentation</a>.
For installing diffusers please checkout diffusers <a href="https://huggingface.co/docs/diffusers/installation" rel="nofollow">installation</a> guide.`,ge,N,be;return d=new Ue({props:{title:"Introduction to Stable Diffusion",local:"introduction-to-stable-diffusion",headingTag:"h1"}}),h=new Ue({props:{title:"What Do We Need for Stable Diffusion to Work?",local:"what-do-we-need-for-stable-diffusion-to-work",headingTag:"h2"}}),W=new Ue({props:{title:"How to use text-to-image , image-to-image , Inpainting Models in Diffusers",local:"how-to-use-text-to-image--image-to-image--inpainting-models-in-diffusers",headingTag:"h2"}}),k=new Te({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2Vycw==",highlighted:"pip install diffusers",wrap:!1}}),G=new Te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMzEpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">31</span>)
image = pipeline(
    <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),X=new Te({props:{code:"JTIzJTIwU3RlcCUyMDElMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEElMjMlMjBTdGVwJTIwMiUwQSUyMyUyMExvYWQlMjBhbiUyMGltYWdlJTIwdG8lMjBwYXNzJTIwdG8lMjB0aGUlMjBwaXBlbGluZSUzQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmNhdC5wbmclMjIlMEEpJTBBJTBBJTIzJTIwU3RlcCUyMDMlMEElMjMlMjBQYXNzJTIwYSUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjB0aGUlMjBwaXBlbGluZSUyMHRvJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTNBJTBBcHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwd2l6YXJkJTJDJTIwZ2FuZGFsZiUyQyUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwZGV0YWlsZWQlMkMlMjBmYW50YXN5JTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwUGl4YXIlMkMlMjBEaXNuZXklMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-comment"># Step 1</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># Step 2</span>
<span class="hljs-comment"># Load an image to pass to the pipeline:</span>
init_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png&quot;</span>
)

<span class="hljs-comment"># Step 3</span>
<span class="hljs-comment"># Pass a prompt and image to the pipeline to generate an image:</span>
prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),_=new Te({props:{code:"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",highlighted:`<span class="hljs-comment"># Step 1</span>
<span class="hljs-comment"># Load the pipeline</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># Step 2</span>
<span class="hljs-comment"># Load the base and mask images:</span>
init_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>
)
mask_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>
)

<span class="hljs-comment"># Step 3</span>
<span class="hljs-comment"># Create a prompt to inpaint the image with and pass it to the pipeline with the base and mask images:</span>
prompt = (
    <span class="hljs-string">&quot;a black cat with glowing eyes, cute, adorable, disney, pixar, highly detailed, 8k&quot;</span>
)
negative_prompt = <span class="hljs-string">&quot;bad anatomy, deformed, ugly, disfigured&quot;</span>
image = pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    image=init_image,
    mask_image=mask_image,
).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),{c(){p=n("meta"),$=i(),L=n("p"),z=i(),H(d.$$.fragment),D=i(),c=n("p"),c.innerHTML=We,q=i(),u=n("p"),u.textContent=Be,A=i(),M=n("ul"),M.innerHTML=je,P=i(),H(h.$$.fragment),K=i(),f=n("p"),f.textContent=ve,O=i(),y=n("ul"),y.innerHTML=Ie,ee=i(),w=n("p"),w.innerHTML=ke,te=i(),J=n("ul"),J.innerHTML=Ge,le=i(),g=n("p"),g.textContent=xe,ae=i(),b=n("ul"),b.innerHTML=Xe,ie=i(),T=n("p"),T.innerHTML=Ce,se=i(),U=n("ul"),U.innerHTML=_e,ne=i(),Z=n("p"),Z.textContent=Fe,oe=i(),H(W.$$.fragment),re=i(),B=n("p"),B.innerHTML=He,me=i(),j=n("ul"),j.innerHTML=Se,pe=i(),m=n("iframe"),m.innerHTML=Ye,de=i(),v=n("p"),v.innerHTML=Re,ce=i(),I=n("p"),I.innerHTML=Ve,ue=i(),H(k.$$.fragment),Me=i(),H(G.$$.fragment),he=i(),x=n("ul"),x.innerHTML=Ee,fe=i(),H(X.$$.fragment),ye=i(),C=n("ul"),C.innerHTML=Le,we=i(),H(_.$$.fragment),Je=i(),F=n("p"),F.innerHTML=Ne,ge=i(),N=n("p"),this.h()},l(e){const t=Oe("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),$=s(e),L=o(e,"P",{}),$e(L).forEach(l),z=s(e),S(d.$$.fragment,e),D=s(e),c=o(e,"P",{"data-svelte-h":!0}),r(c)!=="svelte-z66int"&&(c.innerHTML=We),q=s(e),u=o(e,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1sm6n8h"&&(u.textContent=Be),A=s(e),M=o(e,"UL",{"data-svelte-h":!0}),r(M)!=="svelte-1hq5rsc"&&(M.innerHTML=je),P=s(e),S(h.$$.fragment,e),K=s(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-15v5s0q"&&(f.textContent=ve),O=s(e),y=o(e,"UL",{"data-svelte-h":!0}),r(y)!=="svelte-cbr84n"&&(y.innerHTML=Ie),ee=s(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-12isq36"&&(w.innerHTML=ke),te=s(e),J=o(e,"UL",{"data-svelte-h":!0}),r(J)!=="svelte-nhvgmx"&&(J.innerHTML=Ge),le=s(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-ghqky8"&&(g.textContent=xe),ae=s(e),b=o(e,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-wgoof5"&&(b.innerHTML=Xe),ie=s(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-2rrp3n"&&(T.innerHTML=Ce),se=s(e),U=o(e,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-1gci2og"&&(U.innerHTML=_e),ne=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-ceb1g8"&&(Z.textContent=Fe),oe=s(e),S(W.$$.fragment,e),re=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1tbjqci"&&(B.innerHTML=He),me=s(e),j=o(e,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-4vkcyc"&&(j.innerHTML=Se),pe=s(e),m=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0,"data-svelte-h":!0}),r(m)!=="svelte-1du1c08"&&(m.innerHTML=Ye),de=s(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1xlt128"&&(v.innerHTML=Re),ce=s(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-3yyytc"&&(I.innerHTML=Ve),ue=s(e),S(k.$$.fragment,e),Me=s(e),S(G.$$.fragment,e),he=s(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-1h65wx"&&(x.innerHTML=Ee),fe=s(e),S(X.$$.fragment,e),ye=s(e),C=o(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-bisteq"&&(C.innerHTML=Le),we=s(e),S(_.$$.fragment,e),Je=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1rzf1ug"&&(F.innerHTML=Ne),ge=s(e),N=o(e,"P",{}),$e(N).forEach(l),this.h()},h(){E(p,"name","hf:doc:metadata"),E(p,"content",lt),De(m.src,Qe="https://hysts-controlnet-v1-1.hf.space/")||E(m,"src",Qe),E(m,"frameborder","0"),E(m,"width","850"),E(m,"height","450")},m(e,t){et(document.head,p),a(e,$,t),a(e,L,t),a(e,z,t),Y(d,e,t),a(e,D,t),a(e,c,t),a(e,q,t),a(e,u,t),a(e,A,t),a(e,M,t),a(e,P,t),Y(h,e,t),a(e,K,t),a(e,f,t),a(e,O,t),a(e,y,t),a(e,ee,t),a(e,w,t),a(e,te,t),a(e,J,t),a(e,le,t),a(e,g,t),a(e,ae,t),a(e,b,t),a(e,ie,t),a(e,T,t),a(e,se,t),a(e,U,t),a(e,ne,t),a(e,Z,t),a(e,oe,t),Y(W,e,t),a(e,re,t),a(e,B,t),a(e,me,t),a(e,j,t),a(e,pe,t),a(e,m,t),a(e,de,t),a(e,v,t),a(e,ce,t),a(e,I,t),a(e,ue,t),Y(k,e,t),a(e,Me,t),Y(G,e,t),a(e,he,t),a(e,x,t),a(e,fe,t),Y(X,e,t),a(e,ye,t),a(e,C,t),a(e,we,t),Y(_,e,t),a(e,Je,t),a(e,F,t),a(e,ge,t),a(e,N,t),be=!0},p:qe,i(e){be||(Q(d.$$.fragment,e),Q(h.$$.fragment,e),Q(W.$$.fragment,e),Q(k.$$.fragment,e),Q(G.$$.fragment,e),Q(X.$$.fragment,e),Q(_.$$.fragment,e),be=!0)},o(e){R(d.$$.fragment,e),R(h.$$.fragment,e),R(W.$$.fragment,e),R(k.$$.fragment,e),R(G.$$.fragment,e),R(X.$$.fragment,e),R(_.$$.fragment,e),be=!1},d(e){e&&(l($),l(L),l(z),l(D),l(c),l(q),l(u),l(A),l(M),l(P),l(K),l(f),l(O),l(y),l(ee),l(w),l(te),l(J),l(le),l(g),l(ae),l(b),l(ie),l(T),l(se),l(U),l(ne),l(Z),l(oe),l(re),l(B),l(me),l(j),l(pe),l(m),l(de),l(v),l(ce),l(I),l(ue),l(Me),l(he),l(x),l(fe),l(ye),l(C),l(we),l(Je),l(F),l(ge),l(N)),l(p),V(d,e),V(h,e),V(W,e),V(k,e),V(G,e),V(X,e),V(_,e)}}}const lt='{"title":"Introduction to Stable Diffusion","local":"introduction-to-stable-diffusion","sections":[{"title":"What Do We Need for Stable Diffusion to Work?","local":"what-do-we-need-for-stable-diffusion-to-work","sections":[],"depth":2},{"title":"How to use text-to-image , image-to-image , Inpainting Models in Diffusers","local":"how-to-use-text-to-image--image-to-image--inpainting-models-in-diffusers","sections":[],"depth":2}],"depth":1}';function at(Ze){return Ae(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rt extends Pe{constructor(p){super(),Ke(this,p,at,tt,ze,{})}}export{rt as component};
