import{s as Ki,n as Ei,o as Ui}from"../chunks/scheduler.7bc62968.js";import{S as Xi,i as Yi,g as o,s as a,r as d,A as Ni,h as s,f as i,c as l,j as Fi,u as c,x as r,k as Kt,y as Vi,a as n,v as f,d as h,t as m,w as p}from"../chunks/index.66556066.js";import{H as g}from"../chunks/Heading.3f0870db.js";function Bi(Et){let u,He,Pe,Me,w,Ie,_,Ut="This section explains how stereo vision works and how it can be used to find the 3-dimensional structure of surrounding objects. Stereo vision involves capturing two or more images of the same scene from varying positions and viewpoints. These images can be obtained using multiple cameras or by repositioning the same camera.",Re,x,ke,b,Xt="Let’s understand the problem statement of finding the 3D structure of objects by understanding the geometry of image formation. As shown in Figure 1, we have a point P in 3D with x, y, z coordinates. Point P gets projected to the camera’s image plane via the pinhole. This can also be viewed as projecting a 3D point to a 2D image plane.",Oe,C,Yt="Now, let’s say we are given this 2D image and the location of the pixel coordinates of point P in this image. We want to find the 3D coordinates of point P. Is this possible? Is point P unique, or are there other 3D points that also map to the same pixel coordinates as point P? Answer is that all 3D points that lie on the line joining point P, and the pinhole will map to the same pixel coordinates in the 2D image plane.",ze,y,Nt="We aim to solve the problem of determining the 3D structure of objects. In our problem statement, we can represent an object in 3D as a set of 3D points. Finding the 3D coordinates of each of these points helps us determine the 3D structure of the object.",Ae,L,Vt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/image_formation_single_camera.png?download=true" alt="Figure 1: Image formation using single camera"/>',qe,T,Bt="Figure 1: Image formation using single camera",je,P,Se,D,Zt="Let’s assume we are given the following information:",We,H,Gt="<li>Single image of a scene point P</li> <li>Pixel coordinates of point P in the image</li> <li>Position and orientation of the camera used to capture the image. For simplicity, we can also place an XYZ coordinate system at the location of the pinhole, with the z-axis perpendicular to the image place and the x-axis, and y-axis parallel to the image plane like in Figure 1.</li> <li>Internal parameters of the camera, such as focal length and location of principal point. The principal point is where the optical axis intersects the image plane. Its location in the image plane is usually denoted as (Ox,Oy).</li>",Fe,M,Jt="With the information provided above, we can find a 3D line that originates from the pixel coordinates of point P (the projection of point P in the image plane), passes through the pinhole, and extends to infinity. Based on the principles of image formation geometry, we can conclude that point P must exist somewhere along this line.",Ke,I,Qt="<li>Initially (without an image) point P could have been present anywhere in the 3D space.</li> <li>Using a single image, we reduced possible locations of point P to a single line in 3D.</li> <li>Now, let’s consider whether we can further narrow down the potential locations to pinpoint the precise location of point P on this 3D line.</li> <li>Imagine moving the camera to a different position. Let the coordinate system remain fixed at the previous position. The 3D line we found also remains the same and point P still lies somewhere on this line.</li> <li>From this new location of the camera, capture another image of the same scene point P. Once more, utilizing the pixel coordinates of point P within this new image and considering the updated location of the camera pinhole, find the 3D line on which point P must lie.</li> <li>Now we have 2 lines in 3D and point P lies somewhere on both of these lines. So, point P must lie on the intersection of these 2 lines.</li>",Ee,R,ei="Given 2 lines in 3D, there are are three possibilities for their intersection:",Ue,k,ti="<li>Intersect at exactly 1 point</li> <li>Intersect at infinite number of points</li> <li>Do not intersect</li>",Xe,O,ii="If both images (with original and new camera positions) contain point P, we can conclude that the 3D lines must intersect at least once and that the intersection point is point P. Furthermore, we can envision infinite points where both lines intersect only if the two lines are collinear. This is achievable if the pinhole at the new camera position lies somewhere on the original 3D line. For all other positions and orientations of the new camera location, the two 3D lines must intersect precisely at one point, where point P lies.",Ye,z,ni="Therefore, using 2 images of the same scene point P, known positions and orientations of the camera locations, and known internal parameters of the camera, we can precisely find where point P lies in the 3D space.",Ne,A,Ve,q,ai="Since there are many different positions and orientations for the camera locations which can be selected, we can select a location that makes the math simpler, less complex, and reduces computational processing when running on a computer or an embedded device. One configuration that is popular and generally used is shown in Figure 2. We use 2 cameras in this configuration, which is equivalent to a single camera for capturing 2 images from 2 different locations.",Be,j,li='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/image_formation_simple_stereo.jpg?download=true" alt="Figure 2: Image formation using 2 cameras"/>',Ze,S,oi="Figure 2: Image formation using 2 cameras",Ge,W,si="<li>Origin of the coordinate system is placed at the pinhole of the first camera which is usually the left camera.</li> <li>Z axis of the coordinate system is defined perpendicular to the image plane.</li> <li>X and Y axis of the coordinate system are defined parallel to the image plane.</li> <li>We also have X and Y directions in a 2D image. X is the horizontal direction and Y is the vertical direction. We will refer to these directions in the image plane as u and v respectively. Therefore, pixel coordinates of a point are defined using (u,v) values.</li> <li>X axis of the coordinate system is defined as the u direction / horizontal direction in the image plane.</li> <li>Similarly Y axis of the coordinate system is defined as the v direction / vertical direction in the image plane.</li> <li>Second camera (more precisely the pinhole of the second camera) is placed at a distance b called baseline in the positive x direction to the right of the first camera. Therefore, x,y,z coordinates of pinhole of second camera are (b,0,0)</li> <li>Image plane of the second camera is oriented parallel to the image plane of the first camera.</li> <li>u and v directions in the image plane of second/right camera are aligned with the u and v directions in the image plane of the first/left camera</li> <li>Both left and right cameras are assumed to have the same intrinsic parameters like focal length and location of principal point</li>",Je,F,ri="With the above configuration in place, we have the below equations which map a point in 3D to the image plane in 2D.",Qe,K,di="<li>Left camera<ol><li>$$u_left = f_x * \\frac{x}{z} + O_x$$</li> <li>$$v_left = f_y * \\frac{y}{z} + O_y$$</li></ol></li> <li>Right camera <ol><li>$$u_right = f_x * \\frac{x-b}{z} + O_x$$</li> <li>$$v_right = f_y * \\frac{y}{z} + O_y$$</li></ol></li>",et,E,ci="Different symbols used in above equations are defined below:",tt,U,fi="<li>$$u_left$$, $$v_left$$ refer to pixel coordinates of point P in the left image</li> <li>$$u_right$$, $$v_right$$ refer to pixel coordinates of point P in the right image</li> <li>$$f_x$$ refers to the focal length (in pixels) in x direction and $$f_y$$ refers to the focal length (in pixels) in y direction. Actually, there is only 1 focal length for a camera which is the distance between the pinhole (/ optical center of the lens) to the image plane. However, pixels may be rectangular and not perfect squares, resulting in different fx and fy values when we represent f in terms of pixels.</li> <li>x,y,z are 3D coordinates of the point P (any unit like cm, feet, etc can be used)</li> <li>$$O_x$$ and $$O_y$$ refer to pixel coordinates of the principal point</li> <li>b is called the baseline and refers to the distance between the left and right cameras. Same units are used for both b and x,y,z coordinates (any unit like cm, feet, etc can be used)</li>",it,X,hi="We have 4 equations above and 3 unknowns - x, y and z coordinates of a 3D point P. Intrinsic camera parameters - focal lengths and principal point are assumed to be known. Equations 1.2 and 2.2 indicate that the v coordinate value in the left and right images is the same.",nt,v,mi="<li>$$v_left = v_right$$</li>",at,Y,pi="Using equations 1.1, 1.2 and 2.1 we can derive the x,y,z coordinates of point P.",lt,$,gi="<li>$$x = \\frac{b * (u_left - O_x)}{u_left - u_right}$$</li> <li>$$y = \\frac{b <em>f_x</em> (v_left - O_y)}{ f_y * (u_left - u_right)}$$</li> <li>$$z = \\frac{b * f_x}{u_left - u_right}$$</li>",ot,N,ui="Note that the x and y values above concern the left camera since the origin of the coordinate system is aligned with the left camera. The above equations show that we can find 3D coordinates of a point P using its 2 images captured from 2 different camera locations. z value is also referred to as the depth value. Using this technique, we can find the depth values for different pixels within an image and their real-world x and y coordinates. We can also find real-world distances between different points in an image.",st,V,rt,B,dt,Z,vi="We’ll work through an example, capture some images, and perform some calculations to find out if our above assumptions and math work out! For capturing the images we’ll use a hardware known as OAK-D Lite (OAK stands for OpenCV AI Kit). This device has 3 cameras - left and right mono (black and white) and a center color cameras. We’ll use the left and right mono cameras for our experiment. A regular smartphone camera could also be used, but OAK-D lite has some advantages listed below.",ct,G,$i="<li>Intrinsic camera parameters like focal length and location of principal point are known for an OAK-D Lite since the device comes pre-calibrated, and these parameters can be read from the device using its Python API. For a smartphone camera, intrinsic parameters need to be determined and could be found by performing camera calibration or sometimes present in the metadata of the image captured using the smartphone.</li> <li>One of the main assumptions above is that the position and orientation of the left and right cameras are known. Using a smartphone camera, it may be difficult to determine this information or additional calibration may be required.  On the other hand, for an OAK-D Lite device, the position and orientation of the left and right cameras are fixed, known, pre-calibrated, and very similar to the geometry of the simplified solution mentioned above. Although some post-processing/image rectification detailed below on the raw images is still required.</li>",ft,J,ht,Q,wi="The left and right cameras in OAK-D Lite are oriented similarly to the geometry of the simplified solution detailed above. The baseline distance between the left and right cameras is 7.5cm. Left and right images of a scene captured using this device are shown below. The figure also shows these images stacked horizontally with a red line drawn at a constant height (i.e. at a constant v value ). We’ll refer to the horizontal x-axis as u and the vertical y-axis as v.",mt,ee,_i=`Raw Left Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/unrectified_left_frame.jpg?download=true" alt="Raw Left Image"/>`,pt,te,xi=`Raw Right Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/unrectified_right_frame.jpg?download=true" alt="Raw Right Image"/>`,gt,ie,bi=`<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/unrectified_stacked_frames.jpg?download=true" alt="Raw Stacked Left and Right Images "/>
Raw Stacked Left and Right Images`,ut,ne,Ci="Let’s focus on a single point - the top left corner of the laptop. As per equation 3 above, $$v_left = v_right$$ for the same point in the left and right images. However, notice that the red line, which is at a constant v value, touches the top-left corner of the laptop in the left image but misses this point by a few pixels in the right image. There are two main reasons for this discrepancy:",vt,ae,yi="<li>The intrinsic parameters for the left and right cameras are different. The principal point for the left camera is at (319.13, 233.86), whereas it is (298.85, 245.52) for the right camera. The focal length for the left camera is 450.9, whereas it is 452.9 for the right camera. The values of fx are equal to fy for both the left and right cameras. These intrinsic parameters were read from the device using it’s python API and could be different for different OAK-D Lite devices.</li> <li>Left and right camera orientations differ slightly from the geometry of the simplified solution detailed above.</li>",$t,le,wt,oe,Li='We can perform image rectification/post-processing to correct for differences in intrinsic parameters and orientations of the left and right cameras. This process involves performing 3x3 matrix transformations. In the OAK-D Lite API, a stereo node performs these calculations and outputs the rectified left and right images. Details and source code can be viewed <a href="https://github.com/luxonis/depthai-experiments/blob/master/gen2-stereo-on-host/main.py" rel="nofollow">here</a>. In this specific implementation, correction for intrinsic parameters is performed using intrinsic camera matrices, and correction for orientation is performed using rotation matrices(part of calibration parameters) for the left and right cameras. The rectified left image is transformed as if the left camera had the same intrinsic parameters as the right one. Therefore, in all our following calculations, we’ll use the intrinsic parameters for the right camera i.e. focal length of 452.9 and principal point at (298.85, 245.52). In the rectified and stacked images below, notice that the red line at constant v touches the top-left corner of the laptop in both the left and right images.',_t,se,Ti=`Rectified Left Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_left_frame.jpg?download=true" alt="Rectified Left Image"/>`,xt,re,Pi=`Rectified Right Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_right_frame.jpg?download=true" alt="Rectified Right Image"/>`,bt,de,Di=`Rectified and Stacked Left and Right Images
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_stacked_frames.jpg?download=true" alt="Rectified and Stacked Left and Right Images"/>`,Ct,ce,Hi="Let’s also overlap the rectified left and right images to see the difference. We can see that the v values for different points remain mostly constant in the left and right images. However, the u values change, and this difference in the u values helps us find the depth information for different points in the scene, as shown in Equation 6 above. This difference in ‘u’ values ($$u_left - u_right$$) is called disparity, and we can notice that the disparity for points near the camera is greater compared to points further away. Depth z and disparity ($$u_left - u_right$$) are inversely proportional, as shown in equation 6.",yt,fe,Mi=`Rectified and Overlapped Left and Right Images
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_overlapping_frames.jpg?download=true" alt="Rectified and Overlapped Left and Right Images"/>`,Lt,he,Tt,me,Ii="Let’s find the 3D coordinates for some points in the scene. A few points are selected and manually annotated with their (u,v) values, as shown in the figures below. Instead of manual annotations, we can also use template-based matching, feature detection algorithms like SIFT, etc for finding corresponding points in left and right images.",Pt,pe,Ri=`Annotated Left Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/annotated_left_img.jpg?download=true" alt="Annotated Left Image"/>`,Dt,ge,ki=`Annotated Right Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/annotated_right_img.jpg?download=true" alt="Annotated Right Image"/>`,Ht,ue,Mt,ve,Oi="Twelve points are selected in the scene, and their (u,v) values in the left and right images are tabulated below. Using equations 4, 5, and 6, (x,y,z) coordinates for these points are also calculated and tabulated below. X and Y coordinates concerning the left camera, and the origin is at the left camera’s pinhole (or optical center of the lens). Therefore, 3D points left and above the pinhole have negative X and Y values, respectively.",It,$e,zi='<thead><tr><th align="center">point</th> <th align="center">$$u_left$$</th> <th align="center">$$v_left$$</th> <th align="center">$$u_right$$</th> <th align="center">$$v_right$$</th> <th align="center">depth/z(cm)</th> <th align="center">$$x_wrt_left(cm)$$</th> <th align="center">$$y_wrt_left(cm)$$</th></tr></thead> <tbody><tr><td align="center">pt1</td> <td align="center">138</td> <td align="center">219</td> <td align="center">102</td> <td align="center">219</td> <td align="center">94.36</td> <td align="center">-33.51</td> <td align="center">-5.53</td></tr> <tr><td align="center">pt2</td> <td align="center">264</td> <td align="center">216</td> <td align="center">234</td> <td align="center">217</td> <td align="center">113.23</td> <td align="center">-8.72</td> <td align="center">-7.38</td></tr> <tr><td align="center">pt3</td> <td align="center">137</td> <td align="center">320</td> <td align="center">101</td> <td align="center">321</td> <td align="center">94.36</td> <td align="center">-33.72</td> <td align="center">15.52</td></tr> <tr><td align="center">pt4</td> <td align="center">263</td> <td align="center">303</td> <td align="center">233</td> <td align="center">302</td> <td align="center">113.23</td> <td align="center">-8.97</td> <td align="center">14.37</td></tr> <tr><td align="center">pt5</td> <td align="center">307</td> <td align="center">211</td> <td align="center">280</td> <td align="center">211</td> <td align="center">125.81</td> <td align="center">2.26</td> <td align="center">-9.59</td></tr> <tr><td align="center">pt6</td> <td align="center">367</td> <td align="center">212</td> <td align="center">339</td> <td align="center">212</td> <td align="center">121.32</td> <td align="center">18.25</td> <td align="center">-8.98</td></tr> <tr><td align="center">pt7</td> <td align="center">305</td> <td align="center">298</td> <td align="center">278</td> <td align="center">298</td> <td align="center">125.81</td> <td align="center">1.71</td> <td align="center">14.58</td></tr> <tr><td align="center">pt8</td> <td align="center">365</td> <td align="center">299</td> <td align="center">338</td> <td align="center">299</td> <td align="center">125.81</td> <td align="center">18.37</td> <td align="center">14.86</td></tr> <tr><td align="center">pt9</td> <td align="center">466</td> <td align="center">225</td> <td align="center">415</td> <td align="center">225</td> <td align="center">66.61</td> <td align="center">24.58</td> <td align="center">-3.02</td></tr> <tr><td align="center">pt10</td> <td align="center">581</td> <td align="center">225</td> <td align="center">530</td> <td align="center">226</td> <td align="center">66.61</td> <td align="center">41.49</td> <td align="center">-3.02</td></tr> <tr><td align="center">pt11</td> <td align="center">464</td> <td align="center">387</td> <td align="center">413</td> <td align="center">388</td> <td align="center">66.61</td> <td align="center">24.29</td> <td align="center">20.81</td></tr> <tr><td align="center">pt12</td> <td align="center">579</td> <td align="center">388</td> <td align="center">528</td> <td align="center">390</td> <td align="center">66.61</td> <td align="center">41.2</td> <td align="center">20.95</td></tr></tbody>',Rt,we,kt,_e,Ai="We can also compute 3D distances between different points using their (x,y,z) values using the formulae $$distance = \\sqrt{(x_2 - x_1)^2 + (y_2 - y_1)^2 + (z_2 - z_1)^2}$$. Computed distances between some of the points are tabulated below along with their actual measured values. Percentage error ($\\frac{(actual-measured) * 100}{actual}$) is also computed and tabulated. Notice that the calculated and actual values match very well with a percentage error of 1.2% or less.",Ot,xe,qi='<thead><tr><th align="center">dimension</th> <th align="center">calculated(cm)</th> <th align="center">actual(cm)</th> <th align="center">% error</th></tr></thead> <tbody><tr><td align="center">d1(1-2)</td> <td align="center">31.2</td> <td align="center">31.2</td> <td align="center">0</td></tr> <tr><td align="center">d2(1-3)</td> <td align="center">21.1</td> <td align="center">21.3</td> <td align="center">0.94</td></tr> <tr><td align="center">d3(5-6)</td> <td align="center">16.6</td> <td align="center">16.7</td> <td align="center">0.6</td></tr> <tr><td align="center">d4(5-7)</td> <td align="center">24.2</td> <td align="center">24</td> <td align="center">0.83</td></tr> <tr><td align="center">d5(9-10)</td> <td align="center">16.9</td> <td align="center">16.7</td> <td align="center">1.2</td></tr> <tr><td align="center">d6(9-11)</td> <td align="center">23.8</td> <td align="center">24</td> <td align="center">0.83</td></tr></tbody>',zt,be,ji=`Calculated Dimension Results
![Calculated Dimension Results] (<a href="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/calculated_dim_results.png?download=true" rel="nofollow">https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/calculated_dim_results.png?download=true</a>)`,At,Ce,qt,ye,Si="<li>In summary, we learned how stereo vision works, the equations used to find the real-world coordinates (x, y, z) of a point P given its two images captured from different viewpoints, and compared theoretical values with experimental results.</li> <li>We assumed that the intrinsic parameters - focal length and principal point of the cameras - are known, along with their position and orientation information. This is also referred to as calibrated stereo vision.</li> <li>Interestingly, it is also possible to find the 3D coordinates of a point, P, if the position and orientation of the cameras are unknown. In fact, the position and orientation of the cameras with respect to each other can be found using the images themselves. This is referred to as uncalibrated stereo vision!</li>",jt,Le,St,Te,Wi='<li>3D Reconstruction - Multiple Viewpoints <a href="https://www.coursera.org/learn/3d-reconstruction-multiple-viewpoints" rel="nofollow">Coursera</a></li> <li>Stereo Vision and Depth Estimation using OpenCV AI Kit <a href="https://learnopencv.com/stereo-vision-and-depth-estimation-using-opencv-ai-kit/" rel="nofollow">LearnOpenCV</a></li> <li>OAK-D Lite <a href="https://docs.luxonis.com/projects/hardware/en/latest/pages/DM9095/" rel="nofollow">Luxonics</a></li>',Wt,De,Ft;return w=new g({props:{title:"Introduction",local:"introduction",headingTag:"h1"}}),x=new g({props:{title:"Problem Statement",local:"problem-statement",headingTag:"h2"}}),P=new g({props:{title:"Solution",local:"solution",headingTag:"h2"}}),A=new g({props:{title:"Simplified Solution",local:"simplified-solution",headingTag:"h2"}}),V=new g({props:{title:"Demo",local:"demo",headingTag:"h2"}}),B=new g({props:{title:"Setup",local:"setup",headingTag:"h3"}}),J=new g({props:{title:"Raw Left and Right Images",local:"raw-left-and-right-images",headingTag:"h3"}}),le=new g({props:{title:"Rectified Left and Right Images",local:"rectified-left-and-right-images",headingTag:"h3"}}),he=new g({props:{title:"Annotated Left and Right Rectified Images",local:"annotated-left-and-right-rectified-images",headingTag:"h3"}}),ue=new g({props:{title:"3D Coordinate Calculations",local:"3d-coordinate-calculations",headingTag:"h3"}}),we=new g({props:{title:"Dimension Calculations and Accuracy",local:"dimension-calculations-and-accuracy",headingTag:"h3"}}),Ce=new g({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Le=new g({props:{title:"References",local:"references",headingTag:"h2"}}),{c(){u=o("meta"),He=a(),Pe=o("p"),Me=a(),d(w.$$.fragment),Ie=a(),_=o("p"),_.textContent=Ut,Re=a(),d(x.$$.fragment),ke=a(),b=o("p"),b.textContent=Xt,Oe=a(),C=o("p"),C.textContent=Yt,ze=a(),y=o("p"),y.textContent=Nt,Ae=a(),L=o("p"),L.innerHTML=Vt,qe=a(),T=o("p"),T.textContent=Bt,je=a(),d(P.$$.fragment),Se=a(),D=o("p"),D.textContent=Zt,We=a(),H=o("ol"),H.innerHTML=Gt,Fe=a(),M=o("p"),M.textContent=Jt,Ke=a(),I=o("ol"),I.innerHTML=Qt,Ee=a(),R=o("p"),R.textContent=ei,Ue=a(),k=o("ol"),k.innerHTML=ti,Xe=a(),O=o("p"),O.textContent=ii,Ye=a(),z=o("p"),z.textContent=ni,Ne=a(),d(A.$$.fragment),Ve=a(),q=o("p"),q.textContent=ai,Be=a(),j=o("p"),j.innerHTML=li,Ze=a(),S=o("p"),S.textContent=oi,Ge=a(),W=o("ol"),W.innerHTML=si,Je=a(),F=o("p"),F.textContent=ri,Qe=a(),K=o("ol"),K.innerHTML=di,et=a(),E=o("p"),E.textContent=ci,tt=a(),U=o("ul"),U.innerHTML=fi,it=a(),X=o("p"),X.textContent=hi,nt=a(),v=o("ol"),v.innerHTML=mi,at=a(),Y=o("p"),Y.textContent=pi,lt=a(),$=o("ol"),$.innerHTML=gi,ot=a(),N=o("p"),N.textContent=ui,st=a(),d(V.$$.fragment),rt=a(),d(B.$$.fragment),dt=a(),Z=o("p"),Z.textContent=vi,ct=a(),G=o("ul"),G.innerHTML=$i,ft=a(),d(J.$$.fragment),ht=a(),Q=o("p"),Q.textContent=wi,mt=a(),ee=o("p"),ee.innerHTML=_i,pt=a(),te=o("p"),te.innerHTML=xi,gt=a(),ie=o("p"),ie.innerHTML=bi,ut=a(),ne=o("p"),ne.textContent=Ci,vt=a(),ae=o("ul"),ae.innerHTML=yi,$t=a(),d(le.$$.fragment),wt=a(),oe=o("p"),oe.innerHTML=Li,_t=a(),se=o("p"),se.innerHTML=Ti,xt=a(),re=o("p"),re.innerHTML=Pi,bt=a(),de=o("p"),de.innerHTML=Di,Ct=a(),ce=o("p"),ce.textContent=Hi,yt=a(),fe=o("p"),fe.innerHTML=Mi,Lt=a(),d(he.$$.fragment),Tt=a(),me=o("p"),me.textContent=Ii,Pt=a(),pe=o("p"),pe.innerHTML=Ri,Dt=a(),ge=o("p"),ge.innerHTML=ki,Ht=a(),d(ue.$$.fragment),Mt=a(),ve=o("p"),ve.textContent=Oi,It=a(),$e=o("table"),$e.innerHTML=zi,Rt=a(),d(we.$$.fragment),kt=a(),_e=o("p"),_e.textContent=Ai,Ot=a(),xe=o("table"),xe.innerHTML=qi,zt=a(),be=o("p"),be.innerHTML=ji,At=a(),d(Ce.$$.fragment),qt=a(),ye=o("ol"),ye.innerHTML=Si,jt=a(),d(Le.$$.fragment),St=a(),Te=o("ol"),Te.innerHTML=Wi,Wt=a(),De=o("p"),this.h()},l(e){const t=Ni("svelte-u9bgzb",document.head);u=s(t,"META",{name:!0,content:!0}),t.forEach(i),He=l(e),Pe=s(e,"P",{}),Fi(Pe).forEach(i),Me=l(e),c(w.$$.fragment,e),Ie=l(e),_=s(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-dalhkv"&&(_.textContent=Ut),Re=l(e),c(x.$$.fragment,e),ke=l(e),b=s(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1uco4qc"&&(b.textContent=Xt),Oe=l(e),C=s(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-kimr6l"&&(C.textContent=Yt),ze=l(e),y=s(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-q94rlb"&&(y.textContent=Nt),Ae=l(e),L=s(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1vrgbq7"&&(L.innerHTML=Vt),qe=l(e),T=s(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1wa9vwi"&&(T.textContent=Bt),je=l(e),c(P.$$.fragment,e),Se=l(e),D=s(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1nrdwlc"&&(D.textContent=Zt),We=l(e),H=s(e,"OL",{"data-svelte-h":!0}),r(H)!=="svelte-1thy4kf"&&(H.innerHTML=Gt),Fe=l(e),M=s(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-16e7hw4"&&(M.textContent=Jt),Ke=l(e),I=s(e,"OL",{"data-svelte-h":!0}),r(I)!=="svelte-t58y5k"&&(I.innerHTML=Qt),Ee=l(e),R=s(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-iezcon"&&(R.textContent=ei),Ue=l(e),k=s(e,"OL",{"data-svelte-h":!0}),r(k)!=="svelte-2e63hu"&&(k.innerHTML=ti),Xe=l(e),O=s(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-zaapl6"&&(O.textContent=ii),Ye=l(e),z=s(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1t8agog"&&(z.textContent=ni),Ne=l(e),c(A.$$.fragment,e),Ve=l(e),q=s(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-qw6123"&&(q.textContent=ai),Be=l(e),j=s(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-k5jegy"&&(j.innerHTML=li),Ze=l(e),S=s(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1tyi8k4"&&(S.textContent=oi),Ge=l(e),W=s(e,"OL",{"data-svelte-h":!0}),r(W)!=="svelte-9ofcil"&&(W.innerHTML=si),Je=l(e),F=s(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1tijo6x"&&(F.textContent=ri),Qe=l(e),K=s(e,"OL",{"data-svelte-h":!0}),r(K)!=="svelte-7zsg68"&&(K.innerHTML=di),et=l(e),E=s(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-vdlr52"&&(E.textContent=ci),tt=l(e),U=s(e,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-2r2299"&&(U.innerHTML=fi),it=l(e),X=s(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-uxu6gh"&&(X.textContent=hi),nt=l(e),v=s(e,"OL",{start:!0,"data-svelte-h":!0}),r(v)!=="svelte-1amo0fx"&&(v.innerHTML=mi),at=l(e),Y=s(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1q7g05j"&&(Y.textContent=pi),lt=l(e),$=s(e,"OL",{start:!0,"data-svelte-h":!0}),r($)!=="svelte-1kh2b0g"&&($.innerHTML=gi),ot=l(e),N=s(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-6ra58q"&&(N.textContent=ui),st=l(e),c(V.$$.fragment,e),rt=l(e),c(B.$$.fragment,e),dt=l(e),Z=s(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1d7pwai"&&(Z.textContent=vi),ct=l(e),G=s(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-woii1q"&&(G.innerHTML=$i),ft=l(e),c(J.$$.fragment,e),ht=l(e),Q=s(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1p5cc63"&&(Q.textContent=wi),mt=l(e),ee=s(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1gg0qex"&&(ee.innerHTML=_i),pt=l(e),te=s(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-vckj40"&&(te.innerHTML=xi),gt=l(e),ie=s(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1i90nqk"&&(ie.innerHTML=bi),ut=l(e),ne=s(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1i77jph"&&(ne.textContent=Ci),vt=l(e),ae=s(e,"UL",{"data-svelte-h":!0}),r(ae)!=="svelte-1dzlzv2"&&(ae.innerHTML=yi),$t=l(e),c(le.$$.fragment,e),wt=l(e),oe=s(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-7ct0rj"&&(oe.innerHTML=Li),_t=l(e),se=s(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1ck938e"&&(se.innerHTML=Ti),xt=l(e),re=s(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-pcxnrd"&&(re.innerHTML=Pi),bt=l(e),de=s(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-4x8yv3"&&(de.innerHTML=Di),Ct=l(e),ce=s(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-16f2pd7"&&(ce.textContent=Hi),yt=l(e),fe=s(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-14rdbyn"&&(fe.innerHTML=Mi),Lt=l(e),c(he.$$.fragment,e),Tt=l(e),me=s(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1qtzgo8"&&(me.textContent=Ii),Pt=l(e),pe=s(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1c4jor3"&&(pe.innerHTML=Ri),Dt=l(e),ge=s(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1ydw2mm"&&(ge.innerHTML=ki),Ht=l(e),c(ue.$$.fragment,e),Mt=l(e),ve=s(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-g4rd26"&&(ve.textContent=Oi),It=l(e),$e=s(e,"TABLE",{"data-svelte-h":!0}),r($e)!=="svelte-15yngd8"&&($e.innerHTML=zi),Rt=l(e),c(we.$$.fragment,e),kt=l(e),_e=s(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1olh060"&&(_e.textContent=Ai),Ot=l(e),xe=s(e,"TABLE",{"data-svelte-h":!0}),r(xe)!=="svelte-1mrocde"&&(xe.innerHTML=qi),zt=l(e),be=s(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-b396qj"&&(be.innerHTML=ji),At=l(e),c(Ce.$$.fragment,e),qt=l(e),ye=s(e,"OL",{"data-svelte-h":!0}),r(ye)!=="svelte-8n4kzy"&&(ye.innerHTML=Si),jt=l(e),c(Le.$$.fragment,e),St=l(e),Te=s(e,"OL",{"data-svelte-h":!0}),r(Te)!=="svelte-vggie1"&&(Te.innerHTML=Wi),Wt=l(e),De=s(e,"P",{}),Fi(De).forEach(i),this.h()},h(){Kt(u,"name","hf:doc:metadata"),Kt(u,"content",Zi),Kt(v,"start","3"),Kt($,"start","4")},m(e,t){Vi(document.head,u),n(e,He,t),n(e,Pe,t),n(e,Me,t),f(w,e,t),n(e,Ie,t),n(e,_,t),n(e,Re,t),f(x,e,t),n(e,ke,t),n(e,b,t),n(e,Oe,t),n(e,C,t),n(e,ze,t),n(e,y,t),n(e,Ae,t),n(e,L,t),n(e,qe,t),n(e,T,t),n(e,je,t),f(P,e,t),n(e,Se,t),n(e,D,t),n(e,We,t),n(e,H,t),n(e,Fe,t),n(e,M,t),n(e,Ke,t),n(e,I,t),n(e,Ee,t),n(e,R,t),n(e,Ue,t),n(e,k,t),n(e,Xe,t),n(e,O,t),n(e,Ye,t),n(e,z,t),n(e,Ne,t),f(A,e,t),n(e,Ve,t),n(e,q,t),n(e,Be,t),n(e,j,t),n(e,Ze,t),n(e,S,t),n(e,Ge,t),n(e,W,t),n(e,Je,t),n(e,F,t),n(e,Qe,t),n(e,K,t),n(e,et,t),n(e,E,t),n(e,tt,t),n(e,U,t),n(e,it,t),n(e,X,t),n(e,nt,t),n(e,v,t),n(e,at,t),n(e,Y,t),n(e,lt,t),n(e,$,t),n(e,ot,t),n(e,N,t),n(e,st,t),f(V,e,t),n(e,rt,t),f(B,e,t),n(e,dt,t),n(e,Z,t),n(e,ct,t),n(e,G,t),n(e,ft,t),f(J,e,t),n(e,ht,t),n(e,Q,t),n(e,mt,t),n(e,ee,t),n(e,pt,t),n(e,te,t),n(e,gt,t),n(e,ie,t),n(e,ut,t),n(e,ne,t),n(e,vt,t),n(e,ae,t),n(e,$t,t),f(le,e,t),n(e,wt,t),n(e,oe,t),n(e,_t,t),n(e,se,t),n(e,xt,t),n(e,re,t),n(e,bt,t),n(e,de,t),n(e,Ct,t),n(e,ce,t),n(e,yt,t),n(e,fe,t),n(e,Lt,t),f(he,e,t),n(e,Tt,t),n(e,me,t),n(e,Pt,t),n(e,pe,t),n(e,Dt,t),n(e,ge,t),n(e,Ht,t),f(ue,e,t),n(e,Mt,t),n(e,ve,t),n(e,It,t),n(e,$e,t),n(e,Rt,t),f(we,e,t),n(e,kt,t),n(e,_e,t),n(e,Ot,t),n(e,xe,t),n(e,zt,t),n(e,be,t),n(e,At,t),f(Ce,e,t),n(e,qt,t),n(e,ye,t),n(e,jt,t),f(Le,e,t),n(e,St,t),n(e,Te,t),n(e,Wt,t),n(e,De,t),Ft=!0},p:Ei,i(e){Ft||(h(w.$$.fragment,e),h(x.$$.fragment,e),h(P.$$.fragment,e),h(A.$$.fragment,e),h(V.$$.fragment,e),h(B.$$.fragment,e),h(J.$$.fragment,e),h(le.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(we.$$.fragment,e),h(Ce.$$.fragment,e),h(Le.$$.fragment,e),Ft=!0)},o(e){m(w.$$.fragment,e),m(x.$$.fragment,e),m(P.$$.fragment,e),m(A.$$.fragment,e),m(V.$$.fragment,e),m(B.$$.fragment,e),m(J.$$.fragment,e),m(le.$$.fragment,e),m(he.$$.fragment,e),m(ue.$$.fragment,e),m(we.$$.fragment,e),m(Ce.$$.fragment,e),m(Le.$$.fragment,e),Ft=!1},d(e){e&&(i(He),i(Pe),i(Me),i(Ie),i(_),i(Re),i(ke),i(b),i(Oe),i(C),i(ze),i(y),i(Ae),i(L),i(qe),i(T),i(je),i(Se),i(D),i(We),i(H),i(Fe),i(M),i(Ke),i(I),i(Ee),i(R),i(Ue),i(k),i(Xe),i(O),i(Ye),i(z),i(Ne),i(Ve),i(q),i(Be),i(j),i(Ze),i(S),i(Ge),i(W),i(Je),i(F),i(Qe),i(K),i(et),i(E),i(tt),i(U),i(it),i(X),i(nt),i(v),i(at),i(Y),i(lt),i($),i(ot),i(N),i(st),i(rt),i(dt),i(Z),i(ct),i(G),i(ft),i(ht),i(Q),i(mt),i(ee),i(pt),i(te),i(gt),i(ie),i(ut),i(ne),i(vt),i(ae),i($t),i(wt),i(oe),i(_t),i(se),i(xt),i(re),i(bt),i(de),i(Ct),i(ce),i(yt),i(fe),i(Lt),i(Tt),i(me),i(Pt),i(pe),i(Dt),i(ge),i(Ht),i(Mt),i(ve),i(It),i($e),i(Rt),i(kt),i(_e),i(Ot),i(xe),i(zt),i(be),i(At),i(qt),i(ye),i(jt),i(St),i(Te),i(Wt),i(De)),i(u),p(w,e),p(x,e),p(P,e),p(A,e),p(V,e),p(B,e),p(J,e),p(le,e),p(he,e),p(ue,e),p(we,e),p(Ce,e),p(Le,e)}}}const Zi='{"title":"Introduction","local":"introduction","sections":[{"title":"Problem Statement","local":"problem-statement","sections":[],"depth":2},{"title":"Solution","local":"solution","sections":[],"depth":2},{"title":"Simplified Solution","local":"simplified-solution","sections":[],"depth":2},{"title":"Demo","local":"demo","sections":[{"title":"Setup","local":"setup","sections":[],"depth":3},{"title":"Raw Left and Right Images","local":"raw-left-and-right-images","sections":[],"depth":3},{"title":"Rectified Left and Right Images","local":"rectified-left-and-right-images","sections":[],"depth":3},{"title":"Annotated Left and Right Rectified Images","local":"annotated-left-and-right-rectified-images","sections":[],"depth":3},{"title":"3D Coordinate Calculations","local":"3d-coordinate-calculations","sections":[],"depth":3},{"title":"Dimension Calculations and Accuracy","local":"dimension-calculations-and-accuracy","sections":[],"depth":3}],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function Gi(Et){return Ui(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tn extends Xi{constructor(u){super(),Yi(this,u,Gi,Bi,Ki,{})}}export{tn as component};
