import{s as Ka,n as Oa,o as st}from"../chunks/scheduler.7bc62968.js";import{S as at,i as tt,g as p,s as n,r as c,m as Da,H as Xa,A as lt,h as i,f as t,c as e,j as ia,u as r,x as m,n as qa,E as Ha,k as Fa,y as ya,a as l,v as o,d as y,t as h,w as M}from"../chunks/index.66556066.js";import{C as rs}from"../chunks/CodeBlock.a759539a.js";import{H as is}from"../chunks/Heading.3f0870db.js";function nt(ha){let u,os,ms,ys,d,hs,J,Ms,b,Ma="Most three-dimensional data consists of objects such as points which have a defined position in space, often represented by their three Cartesian coordinates $[x,y,z]$.",us,w,ua='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/axes_handedness.png" alt="Axis handedness"/>',ds,T,da="However, various systems have different conventions for this coordinate system. The most important difference is handedness, which is the relative orientation of the X, Y and Z axes. The easiest way to remember the difference is to point your middle finger inwards, such that your thumb, index, and middle fingers are roughly at right angles to each other. On your left hand, your thumb (X), index finger (Y), and middle finger (Z) form a left-handed coordinate system. Similarly, the fingers of your right hand make a right-handed coordinate system.",Js,U,Ja="In mathematics and physics, a right-handed system is usually used. However, in computer graphics, different libraries and environments have different conventions. Notably, Blender, Pytorch3d and OpenGL (mostly) use right-handed coordinates, whilst DirectX uses left-handed coordinates.Here we will use the right-handed convention, following Blender and NerfStudio.",bs,j,ws,g,ba="It is useful to be able to rotate, scale, and translate these coordinates in space. For example, if an object is moving, or if we want to change these coordinates from world coordinates relative to some fixed set of axes, to coordinates relative to our camera.",Ts,v,wa="These transformations can be represented by matrices. Here we’ll use <code>@</code> to denote matrix multiplication. To allow us to represent translation, rotation and scaling in a consistent manner, we take the three dimensional coordinates $[x,y,z]$, and add an extra coordinate $w=1$. These are known as homogeneous coordinates - more generally, $w$ can take any value, and all points on the four-dimensional line $[wx, wy, wz, w]$ correspond to the same point $[x,y,z]$ in three-dimensional space. However, here, $w$ will always be 1.",Us,f,Ta='Libraries such as <a href="https://pytorch3d.org/" rel="nofollow">Pytorch3d</a> provide a range of functions for generating and manipulating transformations.',js,C,Ua="Yet another convention to note - OpenGL treats positions as column vectors <code>x</code> (of shape 4x1), and applies a transformation <code>M</code> by pre-multiplying the vector by the matrix (<code>M @ x</code>), whereas DirectX and Pytorch3d consider positions as row vectors of shape (1x4), and apply a transformation by post-multiplying the vector by the matrix ( <code>x @ M</code> ). To convert between the two conventions we need to take the transpose of the matrix <code>M.T</code>. We will show how a cube transforms under different transfotmation matrices in a few code snippets. For these code snippets, we will use the OpenGL convention.",gs,x,vs,I,ma,fs,La=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>T</mi><mo>=</mo><mrow><mo fence="true">(</mo><mtable rowspacing="0.16em" columnalign="center center center center" columnspacing="1em"><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>1</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><msub><mi>t</mi><mi>x</mi></msub></mstyle></mtd></mtr><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>1</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><msub><mi>t</mi><mi>y</mi></msub></mstyle></mtd></mtr><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>1</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><msub><mi>t</mi><mi>z</mi></msub></mstyle></mtd></mtr><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>1</mn></mstyle></mtd></mtr></mtable><mo fence="true">)</mo></mrow></mrow><annotation encoding="application/x-tex">
T = \\begin{pmatrix}
1 &amp; 0 &amp; 0 &amp; t_x \\\\
0 &amp; 1 &amp; 0 &amp; t_y \\\\
0 &amp; 0 &amp; 1 &amp; t_z \\\\
0 &amp; 0 &amp; 0 &amp; 1
\\end{pmatrix}
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">T</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:4.8em;vertical-align:-2.15em;"></span><span class="minner"><span class="mopen"><span class="delimsizing mult"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.65em;"><span style="top:-4.65em;"><span class="pstrut" style="height:6.8em;"></span><span style="width:0.875em;height:4.800em;"><svg xmlns="http://www.w3.org/2000/svg" width='0.875em' height='4.800em' viewBox='0 0 875 4800'><path d='M863,9c0,-2,-2,-5,-6,-9c0,0,-17,0,-17,0c-12.7,0,-19.3,0.3,-20,1
c-5.3,5.3,-10.3,11,-15,17c-242.7,294.7,-395.3,682,-458,1162c-21.3,163.3,-33.3,349,
-36,557 l0,1284c0.2,6,0,26,0,60c2,159.3,10,310.7,24,454c53.3,528,210,
949.7,470,1265c4.7,6,9.7,11.7,15,17c0.7,0.7,7,1,19,1c0,0,18,0,18,0c4,-4,6,-7,6,-9
c0,-2.7,-3.3,-8.7,-10,-18c-135.3,-192.7,-235.5,-414.3,-300.5,-665c-65,-250.7,-102.5,
-544.7,-112.5,-882c-2,-104,-3,-167,-3,-189
l0,-1292c0,-162.7,5.7,-314,17,-454c20.7,-272,63.7,-513,129,-723c65.3,
-210,155.3,-396.3,270,-559c6.7,-9.3,10,-15.3,10,-18z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:2.15em;"><span></span></span></span></span></span></span><span class="mord"><span class="mtable"><span class="col-align-c"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.65em;"><span style="top:-4.81em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">1</span></span></span><span style="top:-3.61em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-2.41em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-1.21em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:2.15em;"><span></span></span></span></span></span><span class="arraycolsep" style="width:0.5em;"></span><span class="arraycolsep" style="width:0.5em;"></span><span class="col-align-c"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.65em;"><span style="top:-4.81em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-3.61em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">1</span></span></span><span style="top:-2.41em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-1.21em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:2.15em;"><span></span></span></span></span></span><span class="arraycolsep" style="width:0.5em;"></span><span class="arraycolsep" style="width:0.5em;"></span><span class="col-align-c"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.65em;"><span style="top:-4.81em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-3.61em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-2.41em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">1</span></span></span><span style="top:-1.21em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:2.15em;"><span></span></span></span></span></span><span class="arraycolsep" style="width:0.5em;"></span><span class="arraycolsep" style="width:0.5em;"></span><span class="col-align-c"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.65em;"><span style="top:-4.81em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord"><span class="mord mathnormal">t</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">x</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span><span style="top:-3.61em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord"><span class="mord mathnormal">t</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span><span style="top:-2.41em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord"><span class="mord mathnormal">t</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.04398em;">z</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span><span style="top:-1.21em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:2.15em;"><span></span></span></span></span></span></span></span><span class="mclose"><span class="delimsizing mult"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.65em;"><span style="top:-4.65em;"><span class="pstrut" style="height:6.8em;"></span><span style="width:0.875em;height:4.800em;"><svg xmlns="http://www.w3.org/2000/svg" width='0.875em' height='4.800em' viewBox='0 0 875 4800'><path d='M76,0c-16.7,0,-25,3,-25,9c0,2,2,6.3,6,13c21.3,28.7,42.3,60.3,
63,95c96.7,156.7,172.8,332.5,228.5,527.5c55.7,195,92.8,416.5,111.5,664.5
c11.3,139.3,17,290.7,17,454c0,28,1.7,43,3.3,45l0,1209
c-3,4,-3.3,16.7,-3.3,38c0,162,-5.7,313.7,-17,455c-18.7,248,-55.8,469.3,-111.5,664
c-55.7,194.7,-131.8,370.3,-228.5,527c-20.7,34.7,-41.7,66.3,-63,95c-2,3.3,-4,7,-6,11
c0,7.3,5.7,11,17,11c0,0,11,0,11,0c9.3,0,14.3,-0.3,15,-1c5.3,-5.3,10.3,-11,15,-17
c242.7,-294.7,395.3,-681.7,458,-1161c21.3,-164.7,33.3,-350.7,36,-558
l0,-1344c-2,-159.3,-10,-310.7,-24,-454c-53.3,-528,-210,-949.7,
-470,-1265c-4.7,-6,-9.7,-11.7,-15,-17c-0.7,-0.7,-6.7,-1,-18,-1z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:2.15em;"><span></span></span></span></span></span></span></span></span></span></span></span>`,Cs,Q,ja="where $t = [t_x,t_y,t_z]$ is the direction vector to translate all the points.",xs,B,ga="To try out a translation ourselves, let us first write a little helper function to visualise a cube:",Is,$,Qs,A,va="Now, we can create a cube and pre-multiply it with a translation matrix:",Bs,k,$s,_,fa="The output should look something like this:",As,E,Ca='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/translation.png" alt="output_translation"/>',ks,Y,_s,S,ca,Es,Pa=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>S</mi><mo>=</mo><mrow><mo fence="true">(</mo><mtable rowspacing="0.16em" columnalign="center center center center" columnspacing="1em"><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><msub><mi>s</mi><mi>x</mi></msub></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd></mtr><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><msub><mi>s</mi><mi>y</mi></msub></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd></mtr><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><msub><mi>s</mi><mi>z</mi></msub></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd></mtr><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>0</mn></mstyle></mtd><mtd><mstyle scriptlevel="0" displaystyle="false"><mn>1</mn></mstyle></mtd></mtr></mtable><mo fence="true">)</mo></mrow></mrow><annotation encoding="application/x-tex">
S = \\begin{pmatrix}
s_x &amp; 0 &amp; 0 &amp; 0 \\\\
0 &amp; s_y &amp; 0 &amp; 0 \\\\
0 &amp; 0 &amp; s_z &amp; 0 \\\\
0 &amp; 0 &amp; 0 &amp; 1
\\end{pmatrix}
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">S</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:4.8em;vertical-align:-2.15em;"></span><span class="minner"><span class="mopen"><span class="delimsizing mult"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.65em;"><span style="top:-4.65em;"><span class="pstrut" style="height:6.8em;"></span><span style="width:0.875em;height:4.800em;"><svg xmlns="http://www.w3.org/2000/svg" width='0.875em' height='4.800em' viewBox='0 0 875 4800'><path d='M863,9c0,-2,-2,-5,-6,-9c0,0,-17,0,-17,0c-12.7,0,-19.3,0.3,-20,1
c-5.3,5.3,-10.3,11,-15,17c-242.7,294.7,-395.3,682,-458,1162c-21.3,163.3,-33.3,349,
-36,557 l0,1284c0.2,6,0,26,0,60c2,159.3,10,310.7,24,454c53.3,528,210,
949.7,470,1265c4.7,6,9.7,11.7,15,17c0.7,0.7,7,1,19,1c0,0,18,0,18,0c4,-4,6,-7,6,-9
c0,-2.7,-3.3,-8.7,-10,-18c-135.3,-192.7,-235.5,-414.3,-300.5,-665c-65,-250.7,-102.5,
-544.7,-112.5,-882c-2,-104,-3,-167,-3,-189
l0,-1292c0,-162.7,5.7,-314,17,-454c20.7,-272,63.7,-513,129,-723c65.3,
-210,155.3,-396.3,270,-559c6.7,-9.3,10,-15.3,10,-18z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:2.15em;"><span></span></span></span></span></span></span><span class="mord"><span class="mtable"><span class="col-align-c"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.65em;"><span style="top:-4.81em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">x</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span><span style="top:-3.61em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-2.41em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-1.21em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:2.15em;"><span></span></span></span></span></span><span class="arraycolsep" style="width:0.5em;"></span><span class="arraycolsep" style="width:0.5em;"></span><span class="col-align-c"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.65em;"><span style="top:-4.81em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-3.61em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span><span style="top:-2.41em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-1.21em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:2.15em;"><span></span></span></span></span></span><span class="arraycolsep" style="width:0.5em;"></span><span class="arraycolsep" style="width:0.5em;"></span><span class="col-align-c"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.65em;"><span style="top:-4.81em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-3.61em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-2.41em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.04398em;">z</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span><span style="top:-1.21em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:2.15em;"><span></span></span></span></span></span><span class="arraycolsep" style="width:0.5em;"></span><span class="arraycolsep" style="width:0.5em;"></span><span class="col-align-c"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.65em;"><span style="top:-4.81em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-3.61em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-2.41em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">0</span></span></span><span style="top:-1.21em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:2.15em;"><span></span></span></span></span></span></span></span><span class="mclose"><span class="delimsizing mult"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.65em;"><span style="top:-4.65em;"><span class="pstrut" style="height:6.8em;"></span><span style="width:0.875em;height:4.800em;"><svg xmlns="http://www.w3.org/2000/svg" width='0.875em' height='4.800em' viewBox='0 0 875 4800'><path d='M76,0c-16.7,0,-25,3,-25,9c0,2,2,6.3,6,13c21.3,28.7,42.3,60.3,
63,95c96.7,156.7,172.8,332.5,228.5,527.5c55.7,195,92.8,416.5,111.5,664.5
c11.3,139.3,17,290.7,17,454c0,28,1.7,43,3.3,45l0,1209
c-3,4,-3.3,16.7,-3.3,38c0,162,-5.7,313.7,-17,455c-18.7,248,-55.8,469.3,-111.5,664
c-55.7,194.7,-131.8,370.3,-228.5,527c-20.7,34.7,-41.7,66.3,-63,95c-2,3.3,-4,7,-6,11
c0,7.3,5.7,11,17,11c0,0,11,0,11,0c9.3,0,14.3,-0.3,15,-1c5.3,-5.3,10.3,-11,15,-17
c242.7,-294.7,395.3,-681.7,458,-1161c21.3,-164.7,33.3,-350.7,36,-558
l0,-1344c-2,-159.3,-10,-310.7,-24,-454c-53.3,-528,-210,-949.7,
-470,-1265c-4.7,-6,-9.7,-11.7,-15,-17c-0.7,-0.7,-6.7,-1,-18,-1z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:2.15em;"><span></span></span></span></span></span></span></span></span></span></span></span>`,Ys,G,xa="where $s_x$, $s_y$, and $s_z$ are the scaling factors along the X, Y, and Z axes, respectively.",Ss,N,Ia="Let us try the following example of a scaling our cube by a factor of $2$ along the X-axis and $0.5$ along the Y-axis.",Gs,W,Ns,z,Qa="The output should look something like this:",Ws,R,Ba='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/scaling.png" alt="output_scaling"/>',zs,Z,Rs,V,$a="Rotations around an axis are another commonly used transformation. There are a number of different ways of representing rotations, including Euler angles and quaternions, which can be very useful in some applications. Again, libraries such as Pytorch3d include a wide range of functionalities for performing rotations. However, as a simple example, we will just show how to construct rotations about each of the three axes.",Zs,D,Aa=`<li><p>Rotation around the X-axis</p> <p>$$
R_x(\\alpha) = \\begin{pmatrix}
1 &amp; 0 &amp; 0 &amp; 0 \\
0 &amp; \\cos\\alpha &amp; -\\sin\\alpha &amp; 0 \\
0 &amp; \\sin\\alpha &amp; \\cos\\alpha &amp; 0 \\
0 &amp; 0 &amp; 0 &amp; 1
\\end{pmatrix}
$$</p></li>`,Vs,X,ka="A little example for a positive 20 degree roation around the X-axis is given below:",Ds,q,Xs,H,_a="The output should look something like this:",qs,F,Ea='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/rotation.png" alt="output_rotation"/>',Hs,L,Ya=`<li><p>Rotation around the Y-axis</p> <p>$$
R_y(\\beta) = \\begin{pmatrix}
\\cos\\beta &amp; 0 &amp; \\sin\\beta &amp; 0 \\
0 &amp; 1 &amp; 0 &amp; 0 \\
-\\sin\\beta &amp; 0 &amp; \\cos\\beta &amp; 0 \\
0 &amp; 0 &amp; 0 &amp; 1
\\end{pmatrix}
$$</p></li>`,Fs,P,Sa="We are sure you can use the example snippet above and figure out how to implement a rotation around the Y-axis.😎😎",Ls,K,Ga=`<li><p>Rotation around the Z-axis</p> <p>$$
R_z(\\gamma) = \\begin{pmatrix}
\\cos\\gamma &amp; -\\sin\\gamma &amp; 0 &amp; 0 \\
\\sin\\gamma &amp; \\cos\\gamma &amp; 0 &amp; 0 \\
0 &amp; 0 &amp; 1 &amp; 0 \\
0 &amp; 0 &amp; 0 &amp; 1
\\end{pmatrix}
$$</p></li>`,Ps,O,Na="Again, can you use the last code snippet and implement a rotation around the Z-axis❓",Ks,ss,Wa=`Note that the standard convention is that a positive rotation angle corresponds to an anti-clockwise rotation when the axis of rotation is pointing toward the viewer. Also note that in most libraries the cosine function requires the angle to be in radians. To convert from
degrees to radians, multiply by $\\pi/180$.`,Os,as,sa,ts,za="Multiple transformations can be combined by multiplying together their matrices. Note that the order that matricies are multiplied matters - with the the matrices being applied right to left. To make a matrix that applies the transforms P, Q, and R, in that order, the composite transformation is given by $C = R @ Q @ P $.",aa,ls,Ra="If we want to do first the translation, then the rotation, and then the scaling that we did above in one operation, it looks as follows:",ta,ns,la,es,Za="The output should look something like this:",na,ps,Va='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/combined.png" alt="output_rotation"/>',ea,cs,pa;return d=new is({props:{title:"Basics of Linear Algebra for 3D Data",local:"basics-of-linear-algebra-for-3d-data",headingTag:"h1"}}),J=new is({props:{title:"Coordinate systems",local:"coordinate-systems",headingTag:"h2"}}),j=new is({props:{title:"Transformations",local:"transformations",headingTag:"h2"}}),x=new is({props:{title:"Translations",local:"translations",headingTag:"h3"}}),$=new rs({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQSUwQWRlZiUyMHBsb3RfY3ViZShheCUyQyUyMGN1YmUlMkMlMjBsYWJlbCUyQyUyMGNvbG9yJTNEJTIyYmxhY2slMjIpJTNBJTBBJTIwJTIwJTIwJTIwYXguc2NhdHRlcjNEKGN1YmUlNUIwJTJDJTIwJTNBJTVEJTJDJTIwY3ViZSU1QjElMkMlMjAlM0ElNUQlMkMlMjBjdWJlJTVCMiUyQyUyMCUzQSU1RCUyQyUyMGxhYmVsJTNEbGFiZWwlMkMlMjBjb2xvciUzRGNvbG9yKSUwQSUyMCUyMCUyMCUyMGxpbmVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMCUyQyUyMDElNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIxJTJDJTIwMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjIlMkMlMjAzJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMyUyQyUyMDAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUI0JTJDJTIwNSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjUlMkMlMjA2JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCNiUyQyUyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUI3JTJDJTIwNCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjAlMkMlMjA0JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMSUyQyUyMDUlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIyJTJDJTIwNiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjMlMkMlMjA3JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwbGluZSUyMGluJTIwbGluZXMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBheC5wbG90M0QoY3ViZSU1QjAlMkMlMjBsaW5lJTVEJTJDJTIwY3ViZSU1QjElMkMlMjBsaW5lJTVEJTJDJTIwY3ViZSU1QjIlMkMlMjBsaW5lJTVEJTJDJTIwY29sb3IlM0Rjb2xvciklMEElMjAlMjAlMjAlMjBheC5zZXRfeGxhYmVsKCUyMlglMjIpJTBBJTIwJTIwJTIwJTIwYXguc2V0X3lsYWJlbCglMjJZJTIyKSUwQSUyMCUyMCUyMCUyMGF4LnNldF96bGFiZWwoJTIyWiUyMiklMEElMjAlMjAlMjAlMjBheC5sZWdlbmQoKSUwQSUyMCUyMCUyMCUyMGF4LnNldF94bGltKCU1Qi0yJTJDJTIwMiU1RCklMEElMjAlMjAlMjAlMjBheC5zZXRfeWxpbSglNUItMiUyQyUyMDIlNUQpJTBBJTIwJTIwJTIwJTIwYXguc2V0X3psaW0oJTVCLTIlMkMlMjAyJTVEKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt


<span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_cube</span>(<span class="hljs-params">ax, cube, label, color=<span class="hljs-string">&quot;black&quot;</span></span>):
    ax.scatter3D(cube[<span class="hljs-number">0</span>, :], cube[<span class="hljs-number">1</span>, :], cube[<span class="hljs-number">2</span>, :], label=label, color=color)
    lines = [
        [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>],
        [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
        [<span class="hljs-number">2</span>, <span class="hljs-number">3</span>],
        [<span class="hljs-number">3</span>, <span class="hljs-number">0</span>],
        [<span class="hljs-number">4</span>, <span class="hljs-number">5</span>],
        [<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],
        [<span class="hljs-number">6</span>, <span class="hljs-number">7</span>],
        [<span class="hljs-number">7</span>, <span class="hljs-number">4</span>],
        [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>],
        [<span class="hljs-number">1</span>, <span class="hljs-number">5</span>],
        [<span class="hljs-number">2</span>, <span class="hljs-number">6</span>],
        [<span class="hljs-number">3</span>, <span class="hljs-number">7</span>],
    ]
    <span class="hljs-keyword">for</span> line <span class="hljs-keyword">in</span> lines:
        ax.plot3D(cube[<span class="hljs-number">0</span>, line], cube[<span class="hljs-number">1</span>, line], cube[<span class="hljs-number">2</span>, line], color=color)
    ax.set_xlabel(<span class="hljs-string">&quot;X&quot;</span>)
    ax.set_ylabel(<span class="hljs-string">&quot;Y&quot;</span>)
    ax.set_zlabel(<span class="hljs-string">&quot;Z&quot;</span>)
    ax.legend()
    ax.set_xlim([-<span class="hljs-number">2</span>, <span class="hljs-number">2</span>])
    ax.set_ylim([-<span class="hljs-number">2</span>, <span class="hljs-number">2</span>])
    ax.set_zlim([-<span class="hljs-number">2</span>, <span class="hljs-number">2</span>])`,wrap:!1}}),k=new rs({props:{code:"JTIzJTIwZGVmaW5lJTIwOCUyMGNvcm5lcnMlMjBvZiUyMG91ciUyMGN1YmUlMjB3aXRoJTIwY29vcmRpbmF0ZXMlMjAoeCUyQ3klMkN6JTJDdyklMjBhbmQlMjB3JTIwaXMlMjBhbHdheXMlMjAxJTIwaW4lMjBvdXIlMjBjYXNlJTBBY3ViZSUyMCUzRCUyMG5wLmFycmF5KCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qi0xJTJDJTIwLTElMkMlMjAtMSUyQyUyMDElNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIxJTJDJTIwLTElMkMlMjAtMSUyQyUyMDElNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIxJTJDJTIwMSUyQyUyMC0xJTJDJTIwMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qi0xJTJDJTIwMSUyQyUyMC0xJTJDJTIwMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qi0xJTJDJTIwLTElMkMlMjAxJTJDJTIwMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjElMkMlMjAtMSUyQyUyMDElMkMlMjAxJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1Qi0xJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQSUwQSUyMyUyMHRyYW5zbGF0ZSUyMHRvJTIwZm9sbG93JTIwT3BlbkdMJTIwbm90YXRpb24lMEFjdWJlJTIwJTNEJTIwY3ViZS5UJTBBJTBBJTIzJTIwc2V0JTIwdXAlMjBmaWd1cmUlMEFmaWclMjAlM0QlMjBwbHQuZmlndXJlKCklMEFheCUyMCUzRCUyMGZpZy5hZGRfc3VicGxvdCgxMTElMkMlMjBwcm9qZWN0aW9uJTNEJTIyM2QlMjIpJTBBJTBBJTIzJTIwcGxvdCUyMG9yaWdpbmFsJTIwY3ViZSUwQXBsb3RfY3ViZShheCUyQyUyMGN1YmUlMkMlMjBsYWJlbCUzRCUyMk9yaWdpbmFsJTIyJTJDJTIwY29sb3IlM0QlMjJibHVlJTIyKSUwQSUwQSUyMyUyMHRyYW5zbGF0aW9uJTIwbWF0cml4JTIwKHNoaWZ0JTIwMSUyMGluJTIwcG9zaXRpdmUlMjB4JTIwYW5kJTIwMSUyMGluJTIwcG9zaXRpdmUlMjB5LWF4aXMpJTBBdHJhbnNsYXRpb25fbWF0cml4JTIwJTNEJTIwbnAuYXJyYXkoJTVCJTVCMSUyQyUyMDAlMkMlMjAwJTJDJTIwMSU1RCUyQyUyMCU1QjAlMkMlMjAxJTJDJTIwMCUyQyUyMDElNUQlMkMlMjAlNUIwJTJDJTIwMCUyQyUyMDElMkMlMjAwJTVEJTJDJTIwJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMSU1RCU1RCklMEElMEElMjMlMjB0cmFuc2xhdGlvbiUwQXRyYW5zbGF0ZWRfY3ViZSUyMCUzRCUyMHRyYW5zbGF0aW9uX21hdHJpeCUyMCU0MCUyMGN1YmUlMEFwbG90X2N1YmUoYXglMkMlMjB0cmFuc2xhdGVkX2N1YmUlMkMlMjBsYWJlbCUzRCUyMlRyYW5zbGF0ZWQlMjIlMkMlMjBjb2xvciUzRCUyMnJlZCUyMik=",highlighted:`<span class="hljs-comment"># define 8 corners of our cube with coordinates (x,y,z,w) and w is always 1 in our case</span>
cube = np.array(
    [
        [-<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
        [<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
        [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
        [-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
        [-<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
        [<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
        [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
        [-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
    ]
)

<span class="hljs-comment"># translate to follow OpenGL notation</span>
cube = cube.T

<span class="hljs-comment"># set up figure</span>
fig = plt.figure()
ax = fig.add_subplot(<span class="hljs-number">111</span>, projection=<span class="hljs-string">&quot;3d&quot;</span>)

<span class="hljs-comment"># plot original cube</span>
plot_cube(ax, cube, label=<span class="hljs-string">&quot;Original&quot;</span>, color=<span class="hljs-string">&quot;blue&quot;</span>)

<span class="hljs-comment"># translation matrix (shift 1 in positive x and 1 in positive y-axis)</span>
translation_matrix = np.array([[<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>], [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>], [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>]])

<span class="hljs-comment"># translation</span>
translated_cube = translation_matrix @ cube
plot_cube(ax, translated_cube, label=<span class="hljs-string">&quot;Translated&quot;</span>, color=<span class="hljs-string">&quot;red&quot;</span>)`,wrap:!1}}),Y=new is({props:{title:"Scaling",local:"scaling",headingTag:"h3"}}),W=new rs({props:{code:"JTIzJTIwc2V0JTIwdXAlMjBmaWd1cmUlMEFmaWclMjAlM0QlMjBwbHQuZmlndXJlKCklMEFheCUyMCUzRCUyMGZpZy5hZGRfc3VicGxvdCgxMTElMkMlMjBwcm9qZWN0aW9uJTNEJTIyM2QlMjIpJTBBJTBBJTIzJTIwcGxvdCUyMG9yaWdpbmFsJTIwY3ViZSUwQXBsb3RfY3ViZShheCUyQyUyMGN1YmUlMkMlMjBsYWJlbCUzRCUyMk9yaWdpbmFsJTIyJTJDJTIwY29sb3IlM0QlMjJibHVlJTIyKSUwQSUwQSUyMyUyMHNjYWxpbmclMjBtYXRyaXglMjAoc2NhbGUlMjBieSUyMDIlMjBhbG9uZyUyMHgtYXhpcyUyMGFuZCUyMGJ5JTIwMC41JTIwYWxvbmclMjB5LWF4aXMpJTBBc2NhbGluZ19tYXRyaXglMjAlM0QlMjBucC5hcnJheSglNUIlNUIyJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTVEJTJDJTIwJTVCMCUyQyUyMDAuNSUyQyUyMDAlMkMlMjAwJTVEJTJDJTIwJTVCMCUyQyUyMDAlMkMlMjAxJTJDJTIwMCU1RCUyQyUyMCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDElNUQlNUQpJTBBJTBBJTBBc2NhbGVkX2N1YmUlMjAlM0QlMjBzY2FsaW5nX21hdHJpeCUyMCU0MCUyMGN1YmUlMEElMEFwbG90X2N1YmUoYXglMkMlMjBzY2FsZWRfY3ViZSUyQyUyMGxhYmVsJTNEJTIyU2NhbGVkJTIyJTJDJTIwY29sb3IlM0QlMjJncmVlbiUyMik=",highlighted:`<span class="hljs-comment"># set up figure</span>
fig = plt.figure()
ax = fig.add_subplot(<span class="hljs-number">111</span>, projection=<span class="hljs-string">&quot;3d&quot;</span>)

<span class="hljs-comment"># plot original cube</span>
plot_cube(ax, cube, label=<span class="hljs-string">&quot;Original&quot;</span>, color=<span class="hljs-string">&quot;blue&quot;</span>)

<span class="hljs-comment"># scaling matrix (scale by 2 along x-axis and by 0.5 along y-axis)</span>
scaling_matrix = np.array([[<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">0</span>, <span class="hljs-number">0.5</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>]])


scaled_cube = scaling_matrix @ cube

plot_cube(ax, scaled_cube, label=<span class="hljs-string">&quot;Scaled&quot;</span>, color=<span class="hljs-string">&quot;green&quot;</span>)`,wrap:!1}}),Z=new is({props:{title:"Rotations",local:"rotations",headingTag:"h3"}}),q=new rs({props:{code:"JTIzJTIwc2V0JTIwdXAlMjBmaWd1cmUlMEFmaWclMjAlM0QlMjBwbHQuZmlndXJlKCklMEFheCUyMCUzRCUyMGZpZy5hZGRfc3VicGxvdCgxMTElMkMlMjBwcm9qZWN0aW9uJTNEJTIyM2QlMjIpJTBBJTBBJTIzJTIwcGxvdCUyMG9yaWdpbmFsJTIwY3ViZSUwQXBsb3RfY3ViZShheCUyQyUyMGN1YmUlMkMlMjBsYWJlbCUzRCUyMk9yaWdpbmFsJTIyJTJDJTIwY29sb3IlM0QlMjJibHVlJTIyKSUwQSUwQSUyMyUyMHJvdGF0aW9uJTIwbWF0cml4JTNBJTIwJTJCMjAlMjBkZWclMjBhcm91bmQlMjB4LWF4aXMlMEFhbmdsZSUyMCUzRCUyMDIwJTIwKiUyMG5wLnBpJTIwJTJGJTIwMTgwJTBBcm90YXRpb25fbWF0cml4JTIwJTNEJTIwbnAuYXJyYXkoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMSUyQyUyMDAlMkMlMjAwJTJDJTIwMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjAlMkMlMjBucC5jb3MoYW5nbGUpJTJDJTIwLW5wLnNpbihhbmdsZSklMkMlMjAwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMCUyQyUyMG5wLnNpbihhbmdsZSklMkMlMjBucC5jb3MoYW5nbGUpJTJDJTIwMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDElNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBJTBBcm90YXRlZF9jdWJlJTIwJTNEJTIwcm90YXRpb25fbWF0cml4JTIwJTQwJTIwY3ViZSUwQSUwQXBsb3RfY3ViZShheCUyQyUyMHJvdGF0ZWRfY3ViZSUyQyUyMGxhYmVsJTNEJTIyUm90YXRlZCUyMiUyQyUyMGNvbG9yJTNEJTIyb3JhbmdlJTIyKQ==",highlighted:`<span class="hljs-comment"># set up figure</span>
fig = plt.figure()
ax = fig.add_subplot(<span class="hljs-number">111</span>, projection=<span class="hljs-string">&quot;3d&quot;</span>)

<span class="hljs-comment"># plot original cube</span>
plot_cube(ax, cube, label=<span class="hljs-string">&quot;Original&quot;</span>, color=<span class="hljs-string">&quot;blue&quot;</span>)

<span class="hljs-comment"># rotation matrix: +20 deg around x-axis</span>
angle = <span class="hljs-number">20</span> * np.pi / <span class="hljs-number">180</span>
rotation_matrix = np.array(
    [
        [<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
        [<span class="hljs-number">0</span>, np.cos(angle), -np.sin(angle), <span class="hljs-number">0</span>],
        [<span class="hljs-number">0</span>, np.sin(angle), np.cos(angle), <span class="hljs-number">0</span>],
        [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>],
    ]
)


rotated_cube = rotation_matrix @ cube

plot_cube(ax, rotated_cube, label=<span class="hljs-string">&quot;Rotated&quot;</span>, color=<span class="hljs-string">&quot;orange&quot;</span>)`,wrap:!1}}),as=new is({props:{title:"Combining transformations",local:"combining-transformations",headingTag:"h3"}}),ns=new rs({props:{code:"JTIzJTIwc2V0JTIwdXAlMjBmaWd1cmUlMEFmaWclMjAlM0QlMjBwbHQuZmlndXJlKCklMEFheCUyMCUzRCUyMGZpZy5hZGRfc3VicGxvdCgxMTElMkMlMjBwcm9qZWN0aW9uJTNEJTIyM2QlMjIpJTBBJTBBJTIzJTIwcGxvdCUyMG9yaWdpbmFsJTIwY3ViZSUwQXBsb3RfY3ViZShheCUyQyUyMGN1YmUlMkMlMjBsYWJlbCUzRCUyMk9yaWdpbmFsJTIyJTJDJTIwY29sb3IlM0QlMjJibHVlJTIyKSUwQSUwQSUyMyUyMGNvbWJpbmF0aW9uJTIwb2YlMjB0cmFuc29mb3JtcyUwQWNvbWJpbmF0aW9uX3RyYW5zZm9ybSUyMCUzRCUyMHJvdGF0aW9uX21hdHJpeC5kb3Qoc2NhbGluZ19tYXRyaXguZG90KHRyYW5zbGF0aW9uX21hdHJpeCkpJTBBZmluYWxfcmVzdWx0JTIwJTNEJTIwY29tYmluYXRpb25fdHJhbnNmb3JtLmRvdChjdWJlKSUwQXBsb3RfY3ViZShheCUyQyUyMGZpbmFsX3Jlc3VsdCUyQyUyMGxhYmVsJTNEJTIyQ29tYmluZWQlMjIlMkMlMjBjb2xvciUzRCUyMnZpb2xldCUyMik=",highlighted:`<span class="hljs-comment"># set up figure</span>
fig = plt.figure()
ax = fig.add_subplot(<span class="hljs-number">111</span>, projection=<span class="hljs-string">&quot;3d&quot;</span>)

<span class="hljs-comment"># plot original cube</span>
plot_cube(ax, cube, label=<span class="hljs-string">&quot;Original&quot;</span>, color=<span class="hljs-string">&quot;blue&quot;</span>)

<span class="hljs-comment"># combination of transoforms</span>
combination_transform = rotation_matrix.dot(scaling_matrix.dot(translation_matrix))
final_result = combination_transform.dot(cube)
plot_cube(ax, final_result, label=<span class="hljs-string">&quot;Combined&quot;</span>, color=<span class="hljs-string">&quot;violet&quot;</span>)`,wrap:!1}}),{c(){u=p("meta"),os=n(),ms=p("p"),ys=n(),c(d.$$.fragment),hs=n(),c(J.$$.fragment),Ms=n(),b=p("p"),b.textContent=Ma,us=n(),w=p("p"),w.innerHTML=ua,ds=n(),T=p("p"),T.textContent=da,Js=n(),U=p("p"),U.textContent=Ja,bs=n(),c(j.$$.fragment),ws=n(),g=p("p"),g.textContent=ba,Ts=n(),v=p("p"),v.innerHTML=wa,Us=n(),f=p("p"),f.innerHTML=Ta,js=n(),C=p("p"),C.innerHTML=Ua,gs=n(),c(x.$$.fragment),vs=n(),I=p("p"),ma=Da(`Translations, moving all the points in space by the same distance and direction, can be represented as
`),fs=new Xa(!1),Cs=n(),Q=p("p"),Q.textContent=ja,xs=n(),B=p("p"),B.textContent=ga,Is=n(),c($.$$.fragment),Qs=n(),A=p("p"),A.textContent=va,Bs=n(),c(k.$$.fragment),$s=n(),_=p("p"),_.textContent=fa,As=n(),E=p("p"),E.innerHTML=Ca,ks=n(),c(Y.$$.fragment),_s=n(),S=p("p"),ca=Da(`Scaling is the process of uniformly increasing or decreasing the size of an object. A scaling transformation is represented by a matrix that multiplies each coordinate by a scale factor. The scaling matrix is given by:
`),Es=new Xa(!1),Ys=n(),G=p("p"),G.textContent=xa,Ss=n(),N=p("p"),N.textContent=Ia,Gs=n(),c(W.$$.fragment),Ns=n(),z=p("p"),z.textContent=Qa,Ws=n(),R=p("p"),R.innerHTML=Ba,zs=n(),c(Z.$$.fragment),Rs=n(),V=p("p"),V.textContent=$a,Zs=n(),D=p("ul"),D.innerHTML=Aa,Vs=n(),X=p("p"),X.textContent=ka,Ds=n(),c(q.$$.fragment),Xs=n(),H=p("p"),H.textContent=_a,qs=n(),F=p("p"),F.innerHTML=Ea,Hs=n(),L=p("ul"),L.innerHTML=Ya,Fs=n(),P=p("p"),P.textContent=Sa,Ls=n(),K=p("ul"),K.innerHTML=Ga,Ps=n(),O=p("p"),O.textContent=Na,Ks=n(),ss=p("p"),ss.textContent=Wa,Os=n(),c(as.$$.fragment),sa=n(),ts=p("p"),ts.textContent=za,aa=n(),ls=p("p"),ls.textContent=Ra,ta=n(),c(ns.$$.fragment),la=n(),es=p("p"),es.textContent=Za,na=n(),ps=p("p"),ps.innerHTML=Va,ea=n(),cs=p("p"),this.h()},l(s){const a=lt("svelte-u9bgzb",document.head);u=i(a,"META",{name:!0,content:!0}),a.forEach(t),os=e(s),ms=i(s,"P",{}),ia(ms).forEach(t),ys=e(s),r(d.$$.fragment,s),hs=e(s),r(J.$$.fragment,s),Ms=e(s),b=i(s,"P",{"data-svelte-h":!0}),m(b)!=="svelte-1uemupp"&&(b.textContent=Ma),us=e(s),w=i(s,"P",{"data-svelte-h":!0}),m(w)!=="svelte-16423fj"&&(w.innerHTML=ua),ds=e(s),T=i(s,"P",{"data-svelte-h":!0}),m(T)!=="svelte-189faof"&&(T.textContent=da),Js=e(s),U=i(s,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1h13vy2"&&(U.textContent=Ja),bs=e(s),r(j.$$.fragment,s),ws=e(s),g=i(s,"P",{"data-svelte-h":!0}),m(g)!=="svelte-zx2vo6"&&(g.textContent=ba),Ts=e(s),v=i(s,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1ib2fgl"&&(v.innerHTML=wa),Us=e(s),f=i(s,"P",{"data-svelte-h":!0}),m(f)!=="svelte-w38ybr"&&(f.innerHTML=Ta),js=e(s),C=i(s,"P",{"data-svelte-h":!0}),m(C)!=="svelte-a7n9yi"&&(C.innerHTML=Ua),gs=e(s),r(x.$$.fragment,s),vs=e(s),I=i(s,"P",{});var ra=ia(I);ma=qa(ra,`Translations, moving all the points in space by the same distance and direction, can be represented as
`),fs=Ha(ra,!1),ra.forEach(t),Cs=e(s),Q=i(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-teiol3"&&(Q.textContent=ja),xs=e(s),B=i(s,"P",{"data-svelte-h":!0}),m(B)!=="svelte-10411jr"&&(B.textContent=ga),Is=e(s),r($.$$.fragment,s),Qs=e(s),A=i(s,"P",{"data-svelte-h":!0}),m(A)!=="svelte-wq5235"&&(A.textContent=va),Bs=e(s),r(k.$$.fragment,s),$s=e(s),_=i(s,"P",{"data-svelte-h":!0}),m(_)!=="svelte-4aqv5j"&&(_.textContent=fa),As=e(s),E=i(s,"P",{"data-svelte-h":!0}),m(E)!=="svelte-34blfs"&&(E.innerHTML=Ca),ks=e(s),r(Y.$$.fragment,s),_s=e(s),S=i(s,"P",{});var oa=ia(S);ca=qa(oa,`Scaling is the process of uniformly increasing or decreasing the size of an object. A scaling transformation is represented by a matrix that multiplies each coordinate by a scale factor. The scaling matrix is given by:
`),Es=Ha(oa,!1),oa.forEach(t),Ys=e(s),G=i(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1nrhti5"&&(G.textContent=xa),Ss=e(s),N=i(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1errapb"&&(N.textContent=Ia),Gs=e(s),r(W.$$.fragment,s),Ns=e(s),z=i(s,"P",{"data-svelte-h":!0}),m(z)!=="svelte-4aqv5j"&&(z.textContent=Qa),Ws=e(s),R=i(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-17rj8ek"&&(R.innerHTML=Ba),zs=e(s),r(Z.$$.fragment,s),Rs=e(s),V=i(s,"P",{"data-svelte-h":!0}),m(V)!=="svelte-p58q7t"&&(V.textContent=$a),Zs=e(s),D=i(s,"UL",{"data-svelte-h":!0}),m(D)!=="svelte-1yh3q2v"&&(D.innerHTML=Aa),Vs=e(s),X=i(s,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1u4enqq"&&(X.textContent=ka),Ds=e(s),r(q.$$.fragment,s),Xs=e(s),H=i(s,"P",{"data-svelte-h":!0}),m(H)!=="svelte-4aqv5j"&&(H.textContent=_a),qs=e(s),F=i(s,"P",{"data-svelte-h":!0}),m(F)!=="svelte-3l0ozo"&&(F.innerHTML=Ea),Hs=e(s),L=i(s,"UL",{"data-svelte-h":!0}),m(L)!=="svelte-3h03wx"&&(L.innerHTML=Ya),Fs=e(s),P=i(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1kwruon"&&(P.textContent=Sa),Ls=e(s),K=i(s,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-137qjty"&&(K.innerHTML=Ga),Ps=e(s),O=i(s,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1y7cwj9"&&(O.textContent=Na),Ks=e(s),ss=i(s,"P",{"data-svelte-h":!0}),m(ss)!=="svelte-zbrdyo"&&(ss.textContent=Wa),Os=e(s),r(as.$$.fragment,s),sa=e(s),ts=i(s,"P",{"data-svelte-h":!0}),m(ts)!=="svelte-7oomkl"&&(ts.textContent=za),aa=e(s),ls=i(s,"P",{"data-svelte-h":!0}),m(ls)!=="svelte-pckksd"&&(ls.textContent=Ra),ta=e(s),r(ns.$$.fragment,s),la=e(s),es=i(s,"P",{"data-svelte-h":!0}),m(es)!=="svelte-4aqv5j"&&(es.textContent=Za),na=e(s),ps=i(s,"P",{"data-svelte-h":!0}),m(ps)!=="svelte-1lf8q8t"&&(ps.innerHTML=Va),ea=e(s),cs=i(s,"P",{}),ia(cs).forEach(t),this.h()},h(){Fa(u,"name","hf:doc:metadata"),Fa(u,"content",et),fs.a=null,Es.a=null},m(s,a){ya(document.head,u),l(s,os,a),l(s,ms,a),l(s,ys,a),o(d,s,a),l(s,hs,a),o(J,s,a),l(s,Ms,a),l(s,b,a),l(s,us,a),l(s,w,a),l(s,ds,a),l(s,T,a),l(s,Js,a),l(s,U,a),l(s,bs,a),o(j,s,a),l(s,ws,a),l(s,g,a),l(s,Ts,a),l(s,v,a),l(s,Us,a),l(s,f,a),l(s,js,a),l(s,C,a),l(s,gs,a),o(x,s,a),l(s,vs,a),l(s,I,a),ya(I,ma),fs.m(La,I),l(s,Cs,a),l(s,Q,a),l(s,xs,a),l(s,B,a),l(s,Is,a),o($,s,a),l(s,Qs,a),l(s,A,a),l(s,Bs,a),o(k,s,a),l(s,$s,a),l(s,_,a),l(s,As,a),l(s,E,a),l(s,ks,a),o(Y,s,a),l(s,_s,a),l(s,S,a),ya(S,ca),Es.m(Pa,S),l(s,Ys,a),l(s,G,a),l(s,Ss,a),l(s,N,a),l(s,Gs,a),o(W,s,a),l(s,Ns,a),l(s,z,a),l(s,Ws,a),l(s,R,a),l(s,zs,a),o(Z,s,a),l(s,Rs,a),l(s,V,a),l(s,Zs,a),l(s,D,a),l(s,Vs,a),l(s,X,a),l(s,Ds,a),o(q,s,a),l(s,Xs,a),l(s,H,a),l(s,qs,a),l(s,F,a),l(s,Hs,a),l(s,L,a),l(s,Fs,a),l(s,P,a),l(s,Ls,a),l(s,K,a),l(s,Ps,a),l(s,O,a),l(s,Ks,a),l(s,ss,a),l(s,Os,a),o(as,s,a),l(s,sa,a),l(s,ts,a),l(s,aa,a),l(s,ls,a),l(s,ta,a),o(ns,s,a),l(s,la,a),l(s,es,a),l(s,na,a),l(s,ps,a),l(s,ea,a),l(s,cs,a),pa=!0},p:Oa,i(s){pa||(y(d.$$.fragment,s),y(J.$$.fragment,s),y(j.$$.fragment,s),y(x.$$.fragment,s),y($.$$.fragment,s),y(k.$$.fragment,s),y(Y.$$.fragment,s),y(W.$$.fragment,s),y(Z.$$.fragment,s),y(q.$$.fragment,s),y(as.$$.fragment,s),y(ns.$$.fragment,s),pa=!0)},o(s){h(d.$$.fragment,s),h(J.$$.fragment,s),h(j.$$.fragment,s),h(x.$$.fragment,s),h($.$$.fragment,s),h(k.$$.fragment,s),h(Y.$$.fragment,s),h(W.$$.fragment,s),h(Z.$$.fragment,s),h(q.$$.fragment,s),h(as.$$.fragment,s),h(ns.$$.fragment,s),pa=!1},d(s){s&&(t(os),t(ms),t(ys),t(hs),t(Ms),t(b),t(us),t(w),t(ds),t(T),t(Js),t(U),t(bs),t(ws),t(g),t(Ts),t(v),t(Us),t(f),t(js),t(C),t(gs),t(vs),t(I),t(Cs),t(Q),t(xs),t(B),t(Is),t(Qs),t(A),t(Bs),t($s),t(_),t(As),t(E),t(ks),t(_s),t(S),t(Ys),t(G),t(Ss),t(N),t(Gs),t(Ns),t(z),t(Ws),t(R),t(zs),t(Rs),t(V),t(Zs),t(D),t(Vs),t(X),t(Ds),t(Xs),t(H),t(qs),t(F),t(Hs),t(L),t(Fs),t(P),t(Ls),t(K),t(Ps),t(O),t(Ks),t(ss),t(Os),t(sa),t(ts),t(aa),t(ls),t(ta),t(la),t(es),t(na),t(ps),t(ea),t(cs)),t(u),M(d,s),M(J,s),M(j,s),M(x,s),M($,s),M(k,s),M(Y,s),M(W,s),M(Z,s),M(q,s),M(as,s),M(ns,s)}}}const et='{"title":"Basics of Linear Algebra for 3D Data","local":"basics-of-linear-algebra-for-3d-data","sections":[{"title":"Coordinate systems","local":"coordinate-systems","sections":[],"depth":2},{"title":"Transformations","local":"transformations","sections":[{"title":"Translations","local":"translations","sections":[],"depth":3},{"title":"Scaling","local":"scaling","sections":[],"depth":3},{"title":"Rotations","local":"rotations","sections":[],"depth":3},{"title":"Combining transformations","local":"combining-transformations","sections":[],"depth":3}],"depth":2}],"depth":1}';function pt(ha){return st(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ot extends at{constructor(u){super(),tt(this,u,pt,nt,Ka,{})}}export{ot as component};
