import{s as yl,n as Ml,o as wl}from"../chunks/scheduler.39a43cde.js";import{S as gl,i as Tl,g as i,s as n,r as p,A as Jl,h as o,f as l,c as a,j as bl,u as m,x as r,k as fl,y as vl,a as s,v as d,d as u,t as h,w as c}from"../chunks/index.23ec2204.js";import{D as Ul,C as b}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as Te}from"../chunks/Heading.c42e7061.js";function $l(kt){let f,Ue,Je,$e,y,je,M,xe,w,Zt='<em>Authored by: <a href="https://github.com/MKhalusova" rel="nofollow">Maria Khalusova</a></em>',Ge,g,_t='This notebook demonstrates how you can quickly build a RAG (Retrieval Augmented Generation) for a project’s GitHub issues using <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a> model, and LangChain.',Ce,T,It="<strong>What is RAG?</strong>",Be,J,Ht="RAG is a popular approach to address the issue of a powerful LLM not being aware of specific content due to said content not being in its training data, or hallucinating even when it has seen it before. Such specific content may be proprietary, sensitive, or, as in this example, recent and updated often.",ke,v,Rt="If your data is static and doesn’t change regularly, you may consider fine-tuning a large model. In many cases, however, fine-tuning can be costly, and, when done repeatedly (e.g. to address data drift), leads to “model shift”. This is when the model’s behavior changes in ways that are not desirable.",Ze,U,Wt="<strong>RAG (Retrieval Augmented Generation)</strong> does not require model fine-tuning. Instead, RAG works by providing an LLM with additional context that is retrieved from relevant data so that it can generate a better-informed response.",_e,$,Xt="Here’s a quick illustration:",Ie,j,Nt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/rag-diagram.png" alt="RAG diagram"/>',He,x,Vt="<li><p>The external data is converted into embedding vectors with a separate embeddings model, and the vectors are kept in a database. Embeddings models are typically small, so updating the embedding vectors on a regular basis is faster, cheaper, and easier than fine-tuning a model.</p></li> <li><p>At the same time, the fact that fine-tuning is not required gives you the freedom to swap your LLM for a more powerful one when it becomes available, or switch to a smaller distilled version, should you need faster inference.</p></li>",Re,G,Ft="Let’s illustrate building a RAG using an open-source LLM, embeddings model, and LangChain.",We,C,zt="First, install the required dependencies:",Xe,B,Ne,k,Ve,Z,Fe,_,ze,I,Lt='In this example, we’ll load all of the issues (both open and closed) from <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT library’s repo</a>.',Le,H,St='First, you need to acquire a <a href="https://github.com/settings/tokens?type=beta" rel="nofollow">GitHub personal access token</a> to access the GitHub API.',Se,R,qe,W,qt='Next, we’ll load all of the issues in the <a href="https://github.com/huggingface/peft" rel="nofollow">huggingface/peft</a> repo:',Ee,X,Et="<li>By default, pull requests are considered issues as well, here we chose to exclude them from data with by setting <code>include_prs=False</code></li> <li>Setting <code>state = &quot;all&quot;</code> means we will load both open and closed issues.</li>",Qe,N,Ae,V,Qt="The content of individual GitHub issues may be longer than what an embedding model can take as input. If we want to embed all of the available content, we need to chunk the documents into appropriately sized pieces.",Ye,F,At='The most common and straightforward approach to chunking is to define a fixed size of chunks and whether there should be any overlap between them. Keeping some overlap between chunks allows us to preserve some semantic context between the chunks. The recommended splitter for generic text is the <a href="https://python.langchain.com/docs/modules/data_connection/document_transformers/recursive_text_splitter" rel="nofollow">RecursiveCharacterTextSplitter</a>, and that’s what we’ll use here.',Pe,z,De,L,Ke,S,Yt="Now that the docs are all of the appropriate size, we can create a database with their embeddings.",Oe,q,Pt='To create document chunk embeddings we’ll use the <code>HuggingFaceEmbeddings</code> and the <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-base-en-v1.5</code></a> embeddings model. There are many other embeddings models available on the Hub, and you can keep an eye on the best performing ones by checking the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">Massive Text Embedding Benchmark (MTEB) Leaderboard</a>.',et,E,Dt="To create the vector database, we’ll use <code>FAISS</code>, a library developed by Facebook AI. This library offers efficient similarity search and clustering of dense vectors, which is what we need here. FAISS is currently one of the most used libraries for NN search in massive datasets.",tt,Q,Kt="We’ll access both the embeddings model and FAISS via LangChain API.",lt,A,st,Y,Ot="We need a way to return(retrieve) the documents given an unstructured query. For that, we’ll use the <code>as_retriever</code> method using the <code>db</code> as a backbone:",nt,P,el="<li><code>search_type=&quot;similarity&quot;</code> means we want to perform similarity search between the query and documents</li> <li><code>search_kwargs={&#39;k&#39;: 4}</code> instructs the retriever to return top 4 results.</li>",at,D,it,K,tl="The vector database and retriever are now set up, next we need to set up the next piece of the chain - the model.",ot,O,rt,ee,ll='For this example, we chose <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a>, a small but powerful model.',pt,te,sl='With many models being released every week, you may want to substitute this model to the latest and greatest. The best way to keep track of open source LLMs is to check the <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open-source LLM leaderboard</a>.',mt,le,nl="To make inference faster, we will load the quantized version of the model:",dt,se,ut,ne,ht,ae,al="Finally, we have all the pieces we need to set up the LLM chain.",ct,ie,il="First, create a text_generation pipeline using the loaded model and its tokenizer.",bt,oe,ol="Next, create a prompt template - this should follow the format of the model, so if you substitute the model checkpoint, make sure to use the appropriate formatting.",ft,re,yt,pe,rl="Note: <em>You can also use <code>tokenizer.apply_chat_template</code> to convert a list of messages (as dicts: <code>{&#39;role&#39;: &#39;user&#39;, &#39;content&#39;: &#39;(...)&#39;}</code>) into a string with the appropriate chat format.</em>",Mt,me,pl="Finally, we need to combine the <code>llm_chain</code> with the retriever to create a RAG chain. We pass the original question through to the final generation step, as well as the retrieved context docs:",wt,de,gt,ue,Tt,he,ml="Let’s see the difference RAG makes in generating answers to the library-specific questions.",Jt,ce,vt,be,dl="First, let’s see what kind of answer we can get with just the model itself, no context added:",Ut,fe,$t,ye,ul=`As you can see, the model interpreted the question as one about physical computer adapters, while in the context of PEFT, “adapters” refer to LoRA adapters.
Let’s see if adding context from GitHub issues helps the model give a more relevant answer:`,jt,Me,xt,we,hl="As we can see, the added context, really helps the exact same model, provide a much more relevant and informed answer to the library-specific question.",Gt,ge,cl="Notably, combining multiple adapters for inference has been added to the library, and one can find this information in the documentation, so for the next iteration of this RAG it may be worth including documentation embeddings.",Ct,ve,Bt;return y=new Ul({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_zephyr_langchain.ipynb"}]}}),M=new Te({props:{title:"Simple RAG for GitHub issues using Hugging Face Zephyr and LangChain",local:"simple-rag-for-github-issues-using-hugging-face-zephyr-and-langchain",headingTag:"h1"}}),B=new b({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMHRyYW5zZm9ybWVycyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWdwdQ==",highlighted:"!pip install -q torch transformers accelerate bitsandbytes transformers sentence-transformers faiss-gpu",wrap:!1}}),k=new b({props:{code:"JTIzJTIwSWYlMjBydW5uaW5nJTIwaW4lMjBHb29nbGUlMjBDb2xhYiUyQyUyMHlvdSUyMG1heSUyMG5lZWQlMjB0byUyMHJ1biUyMHRoaXMlMjBjZWxsJTIwdG8lMjBtYWtlJTIwc3VyZSUyMHlvdSdyZSUyMHVzaW5nJTIwVVRGLTglMjBsb2NhbGUlMjB0byUyMGluc3RhbGwlMjBMYW5nQ2hhaW4lMEFpbXBvcnQlMjBsb2NhbGUlMEElMEFsb2NhbGUuZ2V0cHJlZmVycmVkZW5jb2RpbmclMjAlM0QlMjBsYW1iZGElM0ElMjAlMjJVVEYtOCUyMg==",highlighted:`<span class="hljs-comment"># If running in Google Colab, you may need to run this cell to make sure you&#x27;re using UTF-8 locale to install LangChain</span>
<span class="hljs-keyword">import</span> locale

locale.getpreferredencoding = <span class="hljs-keyword">lambda</span>: <span class="hljs-string">&quot;UTF-8&quot;</span>`,wrap:!1}}),Z=new b({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGxhbmdjaGFpbg==",highlighted:"!pip install -q langchain",wrap:!1}}),_=new Te({props:{title:"Prepare the data",local:"prepare-the-data",headingTag:"h2"}}),R=new b({props:{code:"ZnJvbSUyMGdldHBhc3MlMjBpbXBvcnQlMjBnZXRwYXNzJTBBJTBBQUNDRVNTX1RPS0VOJTIwJTNEJTIwZ2V0cGFzcyglMjJZT1VSX0dJVEhVQl9QRVJTT05BTF9UT0tFTiUyMik=",highlighted:`<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass

ACCESS_TOKEN = getpass(<span class="hljs-string">&quot;YOUR_GITHUB_PERSONAL_TOKEN&quot;</span>)`,wrap:!1}}),N=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2N1bWVudF9sb2FkZXJzJTIwaW1wb3J0JTIwR2l0SHViSXNzdWVzTG9hZGVyJTBBJTBBbG9hZGVyJTIwJTNEJTIwR2l0SHViSXNzdWVzTG9hZGVyKHJlcG8lM0QlMjJodWdnaW5nZmFjZSUyRnBlZnQlMjIlMkMlMjBhY2Nlc3NfdG9rZW4lM0RBQ0NFU1NfVE9LRU4lMkMlMjBpbmNsdWRlX3BycyUzREZhbHNlJTJDJTIwc3RhdGUlM0QlMjJhbGwlMjIpJTBBJTBBZG9jcyUyMCUzRCUyMGxvYWRlci5sb2FkKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.document_loaders <span class="hljs-keyword">import</span> GitHubIssuesLoader

loader = GitHubIssuesLoader(repo=<span class="hljs-string">&quot;huggingface/peft&quot;</span>, access_token=ACCESS_TOKEN, include_prs=<span class="hljs-literal">False</span>, state=<span class="hljs-string">&quot;all&quot;</span>)

docs = loader.load()`,wrap:!1}}),z=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBJTBBc3BsaXR0ZXIlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUxMiUyQyUyMGNodW5rX292ZXJsYXAlM0QzMCklMEElMEFjaHVua2VkX2RvY3MlMjAlM0QlMjBzcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoZG9jcyk=",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter

splitter = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">512</span>, chunk_overlap=<span class="hljs-number">30</span>)

chunked_docs = splitter.split_documents(docs)`,wrap:!1}}),L=new Te({props:{title:"Create the embeddings + retriever",local:"create-the-embeddings--retriever",headingTag:"h2"}}),A=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW4uZW1iZWRkaW5ncyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyUwQSUwQWRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoY2h1bmtlZF9kb2NzJTJDJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLWJhc2UtZW4tdjEuNSUyMikp",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

db = FAISS.from_documents(chunked_docs, HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;BAAI/bge-base-en-v1.5&quot;</span>))`,wrap:!1}}),D=new b({props:{code:"cmV0cmlldmVyJTIwJTNEJTIwZGIuYXNfcmV0cmlldmVyKHNlYXJjaF90eXBlJTNEJTIyc2ltaWxhcml0eSUyMiUyQyUyMHNlYXJjaF9rd2FyZ3MlM0QlN0IlMjJrJTIyJTNBJTIwNCU3RCk=",highlighted:'retriever = db.as_retriever(search_type=<span class="hljs-string">&quot;similarity&quot;</span>, search_kwargs={<span class="hljs-string">&quot;k&quot;</span>: <span class="hljs-number">4</span>})',wrap:!1}}),O=new Te({props:{title:"Load quantized model",local:"load-quantized-model",headingTag:"h2"}}),se=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiUwQSUwQWJuYl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9jb25maWcpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>, bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>, bnb_4bit_compute_dtype=torch.bfloat16
)

model = AutoModelForCausalLM.from_pretrained(model_name, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(model_name)`,wrap:!1}}),ne=new Te({props:{title:"Setup the LLM chain",local:"setup-the-llm-chain",headingTag:"h2"}}),re=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5sbG1zJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VQaXBlbGluZSUwQWZyb20lMjBsYW5nY2hhaW4ucHJvbXB0cyUyMGltcG9ydCUyMFByb21wdFRlbXBsYXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm91dHB1dF9wYXJzZXJzJTIwaW1wb3J0JTIwU3RyT3V0cHV0UGFyc2VyJTBBJTBBdGV4dF9nZW5lcmF0aW9uX3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMiUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDAwJTJDJTBBKSUwQSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlUGlwZWxpbmUocGlwZWxpbmUlM0R0ZXh0X2dlbmVyYXRpb25fcGlwZWxpbmUpJTBBJTBBcHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIyJTIyJTBBJTNDJTdDc3lzdGVtJTdDJTNFJTBBQW5zd2VyJTIwdGhlJTIwcXVlc3Rpb24lMjBiYXNlZCUyMG9uJTIweW91ciUyMGtub3dsZWRnZS4lMjBVc2UlMjB0aGUlMjBmb2xsb3dpbmclMjBjb250ZXh0JTIwdG8lMjBoZWxwJTNBJTBBJTBBJTdCY29udGV4dCU3RCUwQSUwQSUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBJTdCcXVlc3Rpb24lN0QlMEElM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBJTBBJTIwJTIyJTIyJTIyJTBBJTBBcHJvbXB0JTIwJTNEJTIwUHJvbXB0VGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwaW5wdXRfdmFyaWFibGVzJTNEJTVCJTIyY29udGV4dCUyMiUyQyUyMCUyMnF1ZXN0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGxhdGUlM0Rwcm9tcHRfdGVtcGxhdGUlMkMlMEEpJTBBJTBBbGxtX2NoYWluJTIwJTNEJTIwcHJvbXB0JTIwJTdDJTIwbGxtJTIwJTdDJTIwU3RyT3V0cHV0UGFyc2VyKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.llms <span class="hljs-keyword">import</span> HuggingFacePipeline
<span class="hljs-keyword">from</span> langchain.prompts <span class="hljs-keyword">import</span> PromptTemplate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> langchain_core.output_parsers <span class="hljs-keyword">import</span> StrOutputParser

text_generation_pipeline = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    temperature=<span class="hljs-number">0.2</span>,
    do_sample=<span class="hljs-literal">True</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">True</span>,
    max_new_tokens=<span class="hljs-number">400</span>,
)

llm = HuggingFacePipeline(pipeline=text_generation_pipeline)

prompt_template = <span class="hljs-string">&quot;&quot;&quot;
&lt;|system|&gt;
Answer the question based on your knowledge. Use the following context to help:

{context}

&lt;/s&gt;
&lt;|user|&gt;
{question}
&lt;/s&gt;
&lt;|assistant|&gt;

 &quot;&quot;&quot;</span>

prompt = PromptTemplate(
    input_variables=[<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>],
    template=prompt_template,
)

llm_chain = prompt | llm | StrOutputParser()`,wrap:!1}}),de=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb3JlLnJ1bm5hYmxlcyUyMGltcG9ydCUyMFJ1bm5hYmxlUGFzc3Rocm91Z2glMEElMEFyZXRyaWV2ZXIlMjAlM0QlMjBkYi5hc19yZXRyaWV2ZXIoKSUwQSUwQXJhZ19jaGFpbiUyMCUzRCUyMCU3QiUyMmNvbnRleHQlMjIlM0ElMjByZXRyaWV2ZXIlMkMlMjAlMjJxdWVzdGlvbiUyMiUzQSUyMFJ1bm5hYmxlUGFzc3Rocm91Z2goKSU3RCUyMCU3QyUyMGxsbV9jaGFpbg==",highlighted:`<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnablePassthrough

retriever = db.as_retriever()

rag_chain = {<span class="hljs-string">&quot;context&quot;</span>: retriever, <span class="hljs-string">&quot;question&quot;</span>: RunnablePassthrough()} | llm_chain`,wrap:!1}}),ue=new Te({props:{title:"Compare the results",local:"compare-the-results",headingTag:"h2"}}),ce=new b({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJIb3clMjBkbyUyMHlvdSUyMGNvbWJpbmUlMjBtdWx0aXBsZSUyMGFkYXB0ZXJzJTNGJTIy",highlighted:'question = <span class="hljs-string">&quot;How do you combine multiple adapters?&quot;</span>',wrap:!1}}),fe=new b({props:{code:"bGxtX2NoYWluLmludm9rZSglN0IlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBxdWVzdGlvbiU3RCk=",highlighted:'llm_chain.invoke({<span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>: question})',wrap:!1}}),Me=new b({props:{code:"cmFnX2NoYWluLmludm9rZShxdWVzdGlvbik=",highlighted:"rag_chain.invoke(question)",wrap:!1}}),{c(){f=i("meta"),Ue=n(),Je=i("p"),$e=n(),p(y.$$.fragment),je=n(),p(M.$$.fragment),xe=n(),w=i("p"),w.innerHTML=Zt,Ge=n(),g=i("p"),g.innerHTML=_t,Ce=n(),T=i("p"),T.innerHTML=It,Be=n(),J=i("p"),J.textContent=Ht,ke=n(),v=i("p"),v.textContent=Rt,Ze=n(),U=i("p"),U.innerHTML=Wt,_e=n(),$=i("p"),$.textContent=Xt,Ie=n(),j=i("p"),j.innerHTML=Nt,He=n(),x=i("ul"),x.innerHTML=Vt,Re=n(),G=i("p"),G.textContent=Ft,We=n(),C=i("p"),C.textContent=zt,Xe=n(),p(B.$$.fragment),Ne=n(),p(k.$$.fragment),Ve=n(),p(Z.$$.fragment),Fe=n(),p(_.$$.fragment),ze=n(),I=i("p"),I.innerHTML=Lt,Le=n(),H=i("p"),H.innerHTML=St,Se=n(),p(R.$$.fragment),qe=n(),W=i("p"),W.innerHTML=qt,Ee=n(),X=i("ul"),X.innerHTML=Et,Qe=n(),p(N.$$.fragment),Ae=n(),V=i("p"),V.textContent=Qt,Ye=n(),F=i("p"),F.innerHTML=At,Pe=n(),p(z.$$.fragment),De=n(),p(L.$$.fragment),Ke=n(),S=i("p"),S.textContent=Yt,Oe=n(),q=i("p"),q.innerHTML=Pt,et=n(),E=i("p"),E.innerHTML=Dt,tt=n(),Q=i("p"),Q.textContent=Kt,lt=n(),p(A.$$.fragment),st=n(),Y=i("p"),Y.innerHTML=Ot,nt=n(),P=i("ul"),P.innerHTML=el,at=n(),p(D.$$.fragment),it=n(),K=i("p"),K.textContent=tl,ot=n(),p(O.$$.fragment),rt=n(),ee=i("p"),ee.innerHTML=ll,pt=n(),te=i("p"),te.innerHTML=sl,mt=n(),le=i("p"),le.textContent=nl,dt=n(),p(se.$$.fragment),ut=n(),p(ne.$$.fragment),ht=n(),ae=i("p"),ae.textContent=al,ct=n(),ie=i("p"),ie.textContent=il,bt=n(),oe=i("p"),oe.textContent=ol,ft=n(),p(re.$$.fragment),yt=n(),pe=i("p"),pe.innerHTML=rl,Mt=n(),me=i("p"),me.innerHTML=pl,wt=n(),p(de.$$.fragment),gt=n(),p(ue.$$.fragment),Tt=n(),he=i("p"),he.textContent=ml,Jt=n(),p(ce.$$.fragment),vt=n(),be=i("p"),be.textContent=dl,Ut=n(),p(fe.$$.fragment),$t=n(),ye=i("p"),ye.textContent=ul,jt=n(),p(Me.$$.fragment),xt=n(),we=i("p"),we.textContent=hl,Gt=n(),ge=i("p"),ge.textContent=cl,Ct=n(),ve=i("p"),this.h()},l(e){const t=Jl("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(l),Ue=a(e),Je=o(e,"P",{}),bl(Je).forEach(l),$e=a(e),m(y.$$.fragment,e),je=a(e),m(M.$$.fragment,e),xe=a(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-26mfp8"&&(w.innerHTML=Zt),Ge=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1ef5fle"&&(g.innerHTML=_t),Ce=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1ty8bu"&&(T.innerHTML=It),Be=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-7wteio"&&(J.textContent=Ht),ke=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1x9vu2c"&&(v.textContent=Rt),Ze=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-14i5lt5"&&(U.innerHTML=Wt),_e=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-5qqm02"&&($.textContent=Xt),Ie=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1c1z86r"&&(j.innerHTML=Nt),He=a(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-8anxeq"&&(x.innerHTML=Vt),Re=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-r4q734"&&(G.textContent=Ft),We=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1f3oki6"&&(C.textContent=zt),Xe=a(e),m(B.$$.fragment,e),Ne=a(e),m(k.$$.fragment,e),Ve=a(e),m(Z.$$.fragment,e),Fe=a(e),m(_.$$.fragment,e),ze=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1htvfcb"&&(I.innerHTML=Lt),Le=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1y7zwpt"&&(H.innerHTML=St),Se=a(e),m(R.$$.fragment,e),qe=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1sitgme"&&(W.innerHTML=qt),Ee=a(e),X=o(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-ktvuvk"&&(X.innerHTML=Et),Qe=a(e),m(N.$$.fragment,e),Ae=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-oungvg"&&(V.textContent=Qt),Ye=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-jsadt6"&&(F.innerHTML=At),Pe=a(e),m(z.$$.fragment,e),De=a(e),m(L.$$.fragment,e),Ke=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1ng4z3s"&&(S.textContent=Yt),Oe=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-z63x34"&&(q.innerHTML=Pt),et=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1hq28ne"&&(E.innerHTML=Dt),tt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1n2sms8"&&(Q.textContent=Kt),lt=a(e),m(A.$$.fragment,e),st=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-140j4it"&&(Y.innerHTML=Ot),nt=a(e),P=o(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-hejw60"&&(P.innerHTML=el),at=a(e),m(D.$$.fragment,e),it=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-4c9ypi"&&(K.textContent=tl),ot=a(e),m(O.$$.fragment,e),rt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1fynfov"&&(ee.innerHTML=ll),pt=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-gklra8"&&(te.innerHTML=sl),mt=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1bs26eu"&&(le.textContent=nl),dt=a(e),m(se.$$.fragment,e),ut=a(e),m(ne.$$.fragment,e),ht=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-dvcewb"&&(ae.textContent=al),ct=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-8iwm5k"&&(ie.textContent=il),bt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-qz9rvk"&&(oe.textContent=ol),ft=a(e),m(re.$$.fragment,e),yt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-15zr00j"&&(pe.innerHTML=rl),Mt=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1plvon"&&(me.innerHTML=pl),wt=a(e),m(de.$$.fragment,e),gt=a(e),m(ue.$$.fragment,e),Tt=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1m90it0"&&(he.textContent=ml),Jt=a(e),m(ce.$$.fragment,e),vt=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1m8rs90"&&(be.textContent=dl),Ut=a(e),m(fe.$$.fragment,e),$t=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-10i2mx0"&&(ye.textContent=ul),jt=a(e),m(Me.$$.fragment,e),xt=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1gvzgod"&&(we.textContent=hl),Gt=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-rlk7jz"&&(ge.textContent=cl),Ct=a(e),ve=o(e,"P",{}),bl(ve).forEach(l),this.h()},h(){fl(f,"name","hf:doc:metadata"),fl(f,"content",jl)},m(e,t){vl(document.head,f),s(e,Ue,t),s(e,Je,t),s(e,$e,t),d(y,e,t),s(e,je,t),d(M,e,t),s(e,xe,t),s(e,w,t),s(e,Ge,t),s(e,g,t),s(e,Ce,t),s(e,T,t),s(e,Be,t),s(e,J,t),s(e,ke,t),s(e,v,t),s(e,Ze,t),s(e,U,t),s(e,_e,t),s(e,$,t),s(e,Ie,t),s(e,j,t),s(e,He,t),s(e,x,t),s(e,Re,t),s(e,G,t),s(e,We,t),s(e,C,t),s(e,Xe,t),d(B,e,t),s(e,Ne,t),d(k,e,t),s(e,Ve,t),d(Z,e,t),s(e,Fe,t),d(_,e,t),s(e,ze,t),s(e,I,t),s(e,Le,t),s(e,H,t),s(e,Se,t),d(R,e,t),s(e,qe,t),s(e,W,t),s(e,Ee,t),s(e,X,t),s(e,Qe,t),d(N,e,t),s(e,Ae,t),s(e,V,t),s(e,Ye,t),s(e,F,t),s(e,Pe,t),d(z,e,t),s(e,De,t),d(L,e,t),s(e,Ke,t),s(e,S,t),s(e,Oe,t),s(e,q,t),s(e,et,t),s(e,E,t),s(e,tt,t),s(e,Q,t),s(e,lt,t),d(A,e,t),s(e,st,t),s(e,Y,t),s(e,nt,t),s(e,P,t),s(e,at,t),d(D,e,t),s(e,it,t),s(e,K,t),s(e,ot,t),d(O,e,t),s(e,rt,t),s(e,ee,t),s(e,pt,t),s(e,te,t),s(e,mt,t),s(e,le,t),s(e,dt,t),d(se,e,t),s(e,ut,t),d(ne,e,t),s(e,ht,t),s(e,ae,t),s(e,ct,t),s(e,ie,t),s(e,bt,t),s(e,oe,t),s(e,ft,t),d(re,e,t),s(e,yt,t),s(e,pe,t),s(e,Mt,t),s(e,me,t),s(e,wt,t),d(de,e,t),s(e,gt,t),d(ue,e,t),s(e,Tt,t),s(e,he,t),s(e,Jt,t),d(ce,e,t),s(e,vt,t),s(e,be,t),s(e,Ut,t),d(fe,e,t),s(e,$t,t),s(e,ye,t),s(e,jt,t),d(Me,e,t),s(e,xt,t),s(e,we,t),s(e,Gt,t),s(e,ge,t),s(e,Ct,t),s(e,ve,t),Bt=!0},p:Ml,i(e){Bt||(u(y.$$.fragment,e),u(M.$$.fragment,e),u(B.$$.fragment,e),u(k.$$.fragment,e),u(Z.$$.fragment,e),u(_.$$.fragment,e),u(R.$$.fragment,e),u(N.$$.fragment,e),u(z.$$.fragment,e),u(L.$$.fragment,e),u(A.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(ce.$$.fragment,e),u(fe.$$.fragment,e),u(Me.$$.fragment,e),Bt=!0)},o(e){h(y.$$.fragment,e),h(M.$$.fragment,e),h(B.$$.fragment,e),h(k.$$.fragment,e),h(Z.$$.fragment,e),h(_.$$.fragment,e),h(R.$$.fragment,e),h(N.$$.fragment,e),h(z.$$.fragment,e),h(L.$$.fragment,e),h(A.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(ce.$$.fragment,e),h(fe.$$.fragment,e),h(Me.$$.fragment,e),Bt=!1},d(e){e&&(l(Ue),l(Je),l($e),l(je),l(xe),l(w),l(Ge),l(g),l(Ce),l(T),l(Be),l(J),l(ke),l(v),l(Ze),l(U),l(_e),l($),l(Ie),l(j),l(He),l(x),l(Re),l(G),l(We),l(C),l(Xe),l(Ne),l(Ve),l(Fe),l(ze),l(I),l(Le),l(H),l(Se),l(qe),l(W),l(Ee),l(X),l(Qe),l(Ae),l(V),l(Ye),l(F),l(Pe),l(De),l(Ke),l(S),l(Oe),l(q),l(et),l(E),l(tt),l(Q),l(lt),l(st),l(Y),l(nt),l(P),l(at),l(it),l(K),l(ot),l(rt),l(ee),l(pt),l(te),l(mt),l(le),l(dt),l(ut),l(ht),l(ae),l(ct),l(ie),l(bt),l(oe),l(ft),l(yt),l(pe),l(Mt),l(me),l(wt),l(gt),l(Tt),l(he),l(Jt),l(vt),l(be),l(Ut),l($t),l(ye),l(jt),l(xt),l(we),l(Gt),l(ge),l(Ct),l(ve)),l(f),c(y,e),c(M,e),c(B,e),c(k,e),c(Z,e),c(_,e),c(R,e),c(N,e),c(z,e),c(L,e),c(A,e),c(D,e),c(O,e),c(se,e),c(ne,e),c(re,e),c(de,e),c(ue,e),c(ce,e),c(fe,e),c(Me,e)}}}const jl='{"title":"Simple RAG for GitHub issues using Hugging Face Zephyr and LangChain","local":"simple-rag-for-github-issues-using-hugging-face-zephyr-and-langchain","sections":[{"title":"Prepare the data","local":"prepare-the-data","sections":[],"depth":2},{"title":"Create the embeddings + retriever","local":"create-the-embeddings--retriever","sections":[],"depth":2},{"title":"Load quantized model","local":"load-quantized-model","sections":[],"depth":2},{"title":"Setup the LLM chain","local":"setup-the-llm-chain","sections":[],"depth":2},{"title":"Compare the results","local":"compare-the-results","sections":[],"depth":2}],"depth":1}';function xl(kt){return wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zl extends gl{constructor(f){super(),Tl(this,f,xl,$l,yl,{})}}export{Zl as component};
