import{s as na,f as la,n as aa,o as ia}from"../chunks/scheduler.39a43cde.js";import{S as oa,i as pa,g as i,s as n,r,A as ra,h as o,f as l,c as a,j as sa,u as M,x as p,k as ft,y as Ma,a as s,v as c,d as m,t as u,w as d}from"../chunks/index.23ec2204.js";import{D as ca,C as y}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as h}from"../chunks/Heading.c42e7061.js";function ma(Gs){let T,It,gt,Rt,J,kt,U,Et,j,_s='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',Nt,w,As="This notebook demonstrates how you can build an advanced RAG (Retrieval Augmented Generation) for answering a user’s question about a specific knowledge base (here, the HuggingFace documentation), using LangChain.",vt,b,Ws='For an introduction to RAG, you can check <a href="rag_zephyr_langchain">this other cookbook</a>!',Zt,f,Vs="RAG systems are complex, with many moving parts: here a RAG diagram, where we noted in blue all possibilities for system enhancement:",Bt,g,xs,Gt,C,Qs="<p>💡 As you can see, there are many steps to tune in this architecture: tuning the system properly will yield significant performance gains.</p>",_t,I,zs="In this notebook, we will take a look into many of these blue notes to see how to tune your RAG system and get the best performance.",At,R,Xs="<strong>Let’s dig into the model building!</strong> First, we install the required model dependancies.",Wt,k,Vt,E,xt,N,Qt,v,zt,Z,Xt,B,St,G,$t,_,Ss="The <strong>retriever acts like an internal search engine</strong>: given the user query, it returns a few relevant snippets from your knowledge base.",Ht,A,$s="These snippets will then be fed to the Reader Model to help it generate its answer.",qt,W,Hs="So <strong>our objective here is, given a user question, to find the most snippets from our knowledge base to answer that question.</strong>",Ft,V,qs="This is a wide objective, it leaves open some questions. How many snippets should we retrieve? This parameter will be named <code>top_k</code>.",Yt,x,Fs="How long should these snippets be? This is called the <code>chunk size</code>. There’s no one-size-fits-all answers, but here are a few elements:",Lt,Q,Ys='<li>🔀 Your <code>chunk size</code> is allowed to vary from one snippet to the other.</li> <li>Since there will always be some noise in your retrieval, increasing the <code>top_k</code> increases the chance to get relevant elements in your retrieved snippets. 🎯 Shooting more arrows increases your probability to hit your target.</li> <li>Meanwhile, the summed length of your retrieved documents should not be too high: for instance, for most current models 16k tokens will probably drown your Reader model in information due to <a href="https://huggingface.co/papers/2307.03172" rel="nofollow">Lost-in-the-middle phenomenon</a>. 🎯 Give your reader model only the most relevant insights, not a huge pile of books!</li>',Pt,z,Ls="<p>In this notebook, we use Langchain library since <strong>it offers a huge variety of options for vector databases and allows us to keep document metadata throughout the processing</strong>.</p>",Dt,X,Kt,S,Ps="<li>In this part, <strong>we split the documents from our knowledge base into smaller chunks</strong> which will be the snippets on which the reader LLM will base its answer.</li> <li>The goal is to prepare a collection of <strong>semantically relevant snippets</strong>. So their size should be adapted to precise ideas: too small will truncate ideas, too large will dilute them.</li>",Ot,$,Ds='💡 <em>Many options exist for text splitting: splitting on words, on sentence boundaries, recursive chunking that processes documents in a tree-like way to preserve structure information… To learn more about chunking, I recommend you read <a href="https://github.com/FullStackRetrieval-com/RetrievalTutorials/blob/main/5_Levels_Of_Text_Splitting.ipynb" rel="nofollow">this great notebook</a> by Greg Kamradt.</em>',el,H,Ks="<li><p><strong>Recursive chunking</strong> breaks down the text into smaller parts step by step using a given list of separators sorted from the most important to the least important separator. If the first split doesn’t give the right size or shape chunks, the method repeats itself on the new chunks using a different separator. For instance with the list of separators <code>[&quot;\\n\\n&quot;, &quot;\\n&quot;, &quot;.&quot;, &quot;&quot;]</code>:</p> <ul><li>The method will first break down the document wherever there is a double line break <code>&quot;\\n\\n&quot;</code>.</li> <li>Resulting documents will be split again on simple line breaks <code>&quot;\\n&quot;</code>, then on sentence ends <code>&quot;.&quot;</code>.</li> <li>And finally, if some chunks are still too big, they will be split whenever they overflow the maximum size.</li></ul></li> <li><p>With this method, the global structure is well preserved, at the expense of getting slight variations in chunk size.</p></li>",tl,q,Os='<p><a href="https://huggingface.co/spaces/A-Roucher/chunk_visualizer" rel="nofollow">This space</a> lets you visualize how different splitting options affect the chunks you get.</p>',ll,F,en="🔬 Let’s experiment a bit with chunk sizes, beginning with an arbitrary size, and see how splits work. We use Langchain’s implementation of recursive chunking with <code>RecursiveCharacterTextSplitter</code>.",sl,Y,tn="<li>Parameter <code>chunk_size</code> controls the length of individual chunks: this length is counted by default as the number of characters in the chunk.</li> <li>Parameter <code>chunk_overlap</code> lets adjacent chunks get a bit of overlap on each other. This reduces the probability that an idea could be cut in half by the split between two adjacent chunks. We ~arbitrarily set this to 1/10th of the chunk size, you could try different values!</li>",nl,L,al,P,ln="We also have to keep in mind that when embedding documents, we will use an embedding model that has accepts a certain maximum sequence length <code>max_seq_length</code>.",il,D,sn="So we should make sure that our chunk sizes are below this limit, because any longer chunk will be truncated before processing, thus losing relevancy.",ol,K,pl,O,nn=`Model's maximum sequence length: 512
`,rl,ee,an="👀 As you can see, <strong>the chunk lengths are not aligned with our limit of 512 tokens</strong>, and some documents are above the limit, thus some part of them will be lost in truncation!",Ml,te,on="<li>So we should change the <code>RecursiveCharacterTextSplitter</code> class to count length in number of tokens instead of number of characters.</li> <li>Then we can choose a specific chunk size, here we would choose a lower threshold than 512:<ul><li>smaller documents could allow the split to focus more on specific ideas.</li> <li>But too small chunks would split sentences in half, thus losing meaning again: the proper tuning is a matter of balance.</li></ul></li>",cl,le,ml,se,pn="➡️ Now the chunk length distribution looks better!",ul,ne,dl,ae,rn='We want to compute the embeddings for all the chunks of our knowledge base: to learn more on sentence embeddings, we recommend reading <a href="https://osanseviero.github.io/hackerllama/blog/posts/sentence_embeddings/" rel="nofollow">this guide</a>.',yl,ie,hl,oe,Mn="Once the chunks are all embedded, we store them into a vector database. When the user types in a query, it gets embedded by the same model previously used, and a similarity search returns the closest documents from the vector database.",Tl,pe,cn="The technical challenge is thus, given a query vector, to quickly find the nearest neighbours of this vector in the vector database. To do this, we need to choose two things: a distance, and a search algorithm to find the nearest neighbors quickly within a database of thousands of records.",Jl,re,Ul,Me,mn='There are plentiful choices for the nearest neighbor search algorithm: we go with Facebook’s <a href="https://github.com/facebookresearch/faiss" rel="nofollow">FAISS</a>, since FAISS is performant enough for most use cases, and it is well known thus widely implemented.',jl,ce,wl,me,un='Regarding distances, you can find a good guide <a href="https://osanseviero.github.io/hackerllama/blog/posts/sentence_embeddings/#distance-between-embeddings" rel="nofollow">here</a>. In short:',bl,ue,dn="<li><strong>Cosine similarity</strong> computes similarity between two vectors as the cosinus of their relative angle: it allows us to compare vector directions are regardless of their magnitude. Using it requires to normalize all vectors, to rescale them into unit norm.</li> <li><strong>Dot product</strong> takes into account magnitude, with the sometimes undesirable effect that increasing a vector’s length will make it more similar to all others.</li> <li><strong>Euclidean distance</strong> is the distance between the ends of vectors.</li>",fl,de,yn='You can try <a href="https://developers.google.com/machine-learning/clustering/similarity/check-your-understanding" rel="nofollow">this small exercise</a> to check your understanding of these concepts. But once vectors are normalized, <a href="https://platform.openai.com/docs/guides/embeddings/which-distance-function-should-i-use" rel="nofollow">the choice of a specific distance does not matter much</a>.',gl,ye,hn="Our particular model works well with cosine similarity, so choose this distance, and we set it up both in the Embedding model, and in the <code>distance_strategy</code> argument of our FAISS index. With cosine similarity, we have to normalize our embeddings.",Cl,he,Tn="🚨👇 The cell below takes a few minutes to run on A10G!",Il,Te,Rl,Je,Jn="👀 To visualize the search for the closest documents, let’s project our embeddings from 384 dimensions down to 2 dimensions using PaCMAP.",kl,Ue,Un='💡 <em>We chose PaCMAP rather than other techniques such as t-SNE or UMAP, since <a href="https://www.nature.com/articles/s42003-022-03628-x#Abs1" rel="nofollow">it is efficient (preserves local and global structure), robust to initialization parameters and fast</a>.</em>',El,je,Nl,we,vl,be,Zl,fe,jn,Bl,ge,wn="➡️ On the graph above, you can see a spatial representation of the kowledge base documents. As the vector embeddings represent the document’s meaning, their closeness in meaning should be reflected in their embedding’s closeness.",Gl,Ce,bn="The user query’s embedding is also shown : we want to find the <code>k</code> document that have the closest meaning, thus we pick the <code>k</code> closest vectors.",_l,Ie,fn="In the LangChain vector database implementation, this search operation is performed by the method <code>vector_database.similarity_search(query)</code>.",Al,Re,gn="Here is the result:",Wl,ke,Vl,Ee,Cn=`Starting retrieval for user_query='How to create a pipeline object?'...

==================================Top document==================================
\`\`\`

## Available Pipelines:
==================================Metadata==================================
&#123;'source': 'huggingface/diffusers/blob/main/docs/source/en/api/pipelines/deepfloyd_if.md', 'start_index': 16887}
`,xl,Ne,Ql,ve,In="In this part, the <strong>LLM Reader reads the retrieved context to formulate its answer.</strong>",zl,Ze,Rn="There are actually substeps that can all be tuned:",Xl,Be,kn="<li>The content of the retrieved documents is aggregated together into the “context”, with many processing options like <em>prompt compression</em>.</li> <li>The context and the user query are aggregated into a prompt then given to the LLM to generate its answer.</li>",Sl,Ge,$l,_e,En="The choice of a reader model is important on a few aspects:",Hl,Ae,Nn="<li>the reader model’s <code>max_seq_length</code> must accomodate our prompt, which includes the context output by the retriever call: the context consists in 5 documents of 512 tokens each, so we aim for a context length of 4k tokens at least.</li> <li>the reader model</li>",ql,We,vn='For this example, we chose <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a>, a small but powerful model.',Fl,Ve,Zn='With many models being released every week, you may want to substitute this model to the latest and greatest. The best way to keep track of open source LLMs is to check the <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open-source LLM leaderboard</a>.',Yl,xe,Bn="To make inference faster, we will load the quantized version of the model:",Ll,Qe,Pl,ze,Dl,Xe,Kl,Se,Gn="The RAG prompt template below is what we will feed to the Reader LLM: it is important to have it formatted in the Reader LLM’s chat template.",Ol,$e,_n="We give it our context and the user’s question.",es,He,ts,qe,An=`<|system|>
Using the information contained in the context, 
give a comprehensive answer to the question.
Respond only to the question asked, response should be concise and relevant to the question.
Provide the number of the source document when relevant.
If the answer cannot be deduced from the context, do not give an answer.
<|user|>
Context:
&#123;context}
---
Now here is the question you need to answer.

Question: &#123;question}
<|assistant|>
`,ls,Fe,Wn="Let’s test our Reader on our previously retrieved documents!",ss,Ye,ns,Le,Vn=`To create a pipeline object, follow these steps:

1. Define the inputs and outputs of your pipeline. These could be strings, dictionaries, or any other format that best suits your use case.

2. Inherit the \`Pipeline\` class from the \`transformers\` module and implement the following methods:

   - \`preprocess\`: This method takes the raw inputs and returns a preprocessed dictionary that can be passed to the model.

   - \`_forward\`: This method performs the actual inference using the model and returns the output tensor.

   - \`postprocess\`: This method takes the output tensor and returns the final output in the desired format.

   - \`_sanitize_parameters\`: This method is used to sanitize the input parameters before passing them to the model.

3. Load the necessary components, such as the model and scheduler, into the pipeline object.

4. Instantiate the pipeline object and return it.

Here's an example implementation based on the given context:

\`\`\`python
from transformers import Pipeline
import torch
from diffusers import StableDiffusionPipeline

class MyPipeline(Pipeline):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.pipe = StableDiffusionPipeline.from_pretrained("my_model")

    def preprocess(self, inputs):
        # Preprocess the inputs as needed
        return &#123;"input_ids":...}

    def _forward(self, inputs):
        # Run the forward pass of the model
        return self.pipe(**inputs).images[0]

    def postprocess(self, outputs):
        # Postprocess the outputs as needed
        return outputs["sample"]

    def _sanitize_parameters(self, params):
        # Sanitize the input parameters
        return params

my_pipeline = MyPipeline()
result = my_pipeline("My input string")
print(result)
\`\`\`

Note that this implementation assumes that the model and scheduler are already loaded into memory. If they need to be loaded dynamically, you can modify the \`__init__\` method accordingly.
`,as,Pe,is,De,xn="A good option for RAG is to retrieve more documents than you want in the end, then rerank the results with a more powerful retrieval model before keeping only the <code>top_k</code>.",os,Ke,Qn='For this, <a href="https://arxiv.org/abs/2112.01488" rel="nofollow">Colbertv2</a> is a great choice: instead of a bi-encoder like our classical embedding models, it is a cross-encoder that computes more fine-grained interactions between the query tokens and each document’s tokens.',ps,Oe,zn='It is easily usable thanks to <a href="https://github.com/bclavie/RAGatouille" rel="nofollow">the RAGatouille library</a>.',rs,et,Ms,tt,cs,lt,ms,st,Xn="Let’s see how our RAG pipeline answers a user query.",us,nt,ds,at,Sn=`=> Retrieving documents...
`,ys,it,hs,ot,$n=`==================================Answer==================================
To create a pipeline object, follow these steps:

1. Import the \`pipeline\` function from the \`transformers\` module:

   \`\`\`python
   from transformers import pipeline
   \`\`\`

2. Choose the task you want to perform, such as object detection, sentiment analysis, or image generation, and pass it as an argument to the \`pipeline\` function:

   - For object detection:

     \`\`\`python
     >>> object_detector = pipeline('object-detection')
     >>> object_detector(image)
     [&#123;'score': 0.9982201457023621,
       'label':'remote',
       'box': &#123;'xmin': 40, 'ymin': 70, 'xmax': 175, 'ymax': 117}},
     ...]
     \`\`\`

   - For sentiment analysis:

     \`\`\`python
     >>> classifier = pipeline("sentiment-analysis")
     >>> classifier("This is a great product!")
     &#123;'labels': ['POSITIVE'],'scores': tensor([0.9999], device='cpu', dtype=torch.float32)}
     \`\`\`

   - For image generation:

     \`\`\`python
     >>> image = pipeline(
    ... "stained glass of darth vader, backlight, centered composition, masterpiece, photorealistic, 8k"
    ... ).images[0]
     >>> image
     PILImage mode RGB size 7680x4320 at 0 DPI
     \`\`\`

Note that the exact syntax may vary depending on the specific pipeline being used. Refer to the documentation for more details on how to use each pipeline.

In general, the process involves importing the necessary modules, selecting the desired pipeline task, and passing it to the \`pipeline\` function along with any required arguments. The resulting pipeline object can then be used to perform the selected task on input data.
==================================Source docs==================================
Document 0------------------------------------------------------------
# Allocate a pipeline for object detection
>>> object_detector = pipeline('object-detection')
>>> object_detector(image)
[&#123;'score': 0.9982201457023621,
  'label': 'remote',
  'box': &#123;'xmin': 40, 'ymin': 70, 'xmax': 175, 'ymax': 117}},
 &#123;'score': 0.9960021376609802,
  'label': 'remote',
  'box': &#123;'xmin': 333, 'ymin': 72, 'xmax': 368, 'ymax': 187}},
 &#123;'score': 0.9954745173454285,
  'label': 'couch',
  'box': &#123;'xmin': 0, 'ymin': 1, 'xmax': 639, 'ymax': 473}},
 &#123;'score': 0.9988006353378296,
  'label': 'cat',
  'box': &#123;'xmin': 13, 'ymin': 52, 'xmax': 314, 'ymax': 470}},
 &#123;'score': 0.9986783862113953,
  'label': 'cat',
  'box': &#123;'xmin': 345, 'ymin': 23, 'xmax': 640, 'ymax': 368}}]
Document 1------------------------------------------------------------
# Allocate a pipeline for object detection
>>> object_detector = pipeline('object_detection')
>>> object_detector(image)
[&#123;'score': 0.9982201457023621,
  'label': 'remote',
  'box': &#123;'xmin': 40, 'ymin': 70, 'xmax': 175, 'ymax': 117}},
 &#123;'score': 0.9960021376609802,
  'label': 'remote',
  'box': &#123;'xmin': 333, 'ymin': 72, 'xmax': 368, 'ymax': 187}},
 &#123;'score': 0.9954745173454285,
  'label': 'couch',
  'box': &#123;'xmin': 0, 'ymin': 1, 'xmax': 639, 'ymax': 473}},
 &#123;'score': 0.9988006353378296,
  'label': 'cat',
  'box': &#123;'xmin': 13, 'ymin': 52, 'xmax': 314, 'ymax': 470}},
 &#123;'score': 0.9986783862113953,
  'label': 'cat',
  'box': &#123;'xmin': 345, 'ymin': 23, 'xmax': 640, 'ymax': 368}}]
Document 2------------------------------------------------------------
Start by creating an instance of [\`pipeline\`] and specifying a task you want to use it for. In this guide, you'll use the [\`pipeline\`] for sentiment analysis as an example:

\`\`\`py
>>> from transformers import pipeline

>>> classifier = pipeline("sentiment-analysis")
Document 3------------------------------------------------------------
\`\`\`

## Add the pipeline to 🤗 Transformers

If you want to contribute your pipeline to 🤗 Transformers, you will need to add a new module in the \`pipelines\` submodule
with the code of your pipeline, then add it to the list of tasks defined in \`pipelines/__init__.py\`.

Then you will need to add tests. Create a new file \`tests/test_pipelines_MY_PIPELINE.py\` with examples of the other tests.

The \`run_pipeline_test\` function will be very generic and run on small random models on every possible
architecture as defined by \`model_mapping\` and \`tf_model_mapping\`.

This is very important to test future compatibility, meaning if someone adds a new model for
\`XXXForQuestionAnswering\` then the pipeline test will attempt to run on it. Because the models are random it's
impossible to check for actual values, that's why there is a helper \`ANY\` that will simply attempt to match the
output of the pipeline TYPE.

You also *need* to implement 2 (ideally 4) tests.

- \`test_small_model_pt\` : Define 1 small model for this pipeline (doesn't matter if the results don't make sense)
  and test the pipeline outputs. The results should be the same as \`test_small_model_tf\`.
- \`test_small_model_tf\` : Define 1 small model for this pipeline (doesn't matter if the results don't make sense)
  and test the pipeline outputs. The results should be the same as \`test_small_model_pt\`.
- \`test_large_model_pt\` (\`optional\`): Tests the pipeline on a real pipeline where the results are supposed to
  make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
  sure there is no drift in future releases.
- \`test_large_model_tf\` (\`optional\`): Tests the pipeline on a real pipeline where the results are supposed to
  make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
  sure there is no drift in future releases.
Document 4------------------------------------------------------------
\`\`\`

2. Pass a prompt to the pipeline to generate an image:

\`\`\`py
image = pipeline(
	"stained glass of darth vader, backlight, centered composition, masterpiece, photorealistic, 8k"
).images[0]
image
`,Ts,pt,Hn="✅ We now have a fully functional, performant RAG sytem. That’s it for today! Congratulations for making it to the end 🥳",Js,rt,Us,Mt,qn="This is not the end of the journey! You can try many steps to improve your RAG system. We recommend doing so in an iterative way: bring small changes to the system and see what improves performance.",js,ct,ws,mt,Fn="<li>💬 “You cannot improve the model performance that you do not measure”, said Gandhi… or at least Llama2 told me he said it. Anyway, you should absolutely start by measuring performance: this means building a small evaluation dataset, then monitor the performance of your RAG system on this evaluation dataset.</li>",bs,ut,fs,dt,Yn="🛠️ <strong>You can use these options to tune the results:</strong>",gs,yt,Ln='<li>Tune the chunking method:<ul><li>Size of the chunks</li> <li>Method: split on different separators, use <a href="https://python.langchain.com/docs/modules/data_connection/document_transformers/semantic-chunker" rel="nofollow">semantic chunking</a>…</li></ul></li> <li>Change the embedding model</li>',Cs,ht,Pn="👷‍♀️ <strong>More could be considered:</strong>",Is,Tt,Dn="<li>Try another chunking method, like semantic chunking</li> <li>Change the index used (here, FAISS)</li> <li>Query expansion: reformulate the user query in slightly different ways to retrieve more documents.</li>",Rs,Jt,ks,Ut,Kn="🛠️ <strong>Here you can try the following options to improve results:</strong>",Es,jt,On="<li>Tune the prompt</li> <li>Switch reranking on/off</li> <li>Choose a more powerful reader model</li>",Ns,wt,ea="💡 <strong>Many options could be considered here to further improve the results:</strong>",vs,bt,ta="<li>Compress the retrieved context to keep only the most relevant parts to answer the query.</li> <li>Extend the RAG system to make it more user-friendly:<ul><li>cite source</li> <li>make conversational</li></ul></li>",Zs,Ct,Bs;return J=new ca({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/advanced_rag.ipynb"}]}}),U=new h({props:{title:"Advanced RAG on HuggingFace documentation using langchain",local:"advanced-rag-on-huggingface-documentation-using-langchain",headingTag:"h1"}}),k=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMGxhbmdjaGFpbiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWdwdSUyMG9wZW5weXhsJTIwcGFjbWFw",highlighted:"!pip install -q torch transformers transformers accelerate bitsandbytes langchain sentence-transformers faiss-gpu openpyxl pacmap",wrap:!1}}),E=new y({props:{code:"JTI1cmVsb2FkX2V4dCUyMGRvdGVudiUwQSUyNWRvdGVudg==",highlighted:`%reload_ext dotenv
%dotenv`,wrap:!1}}),N=new y({props:{code:"ZnJvbSUyMHRxZG0ubm90ZWJvb2slMjBpbXBvcnQlMjB0cWRtJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBPcHRpb25hbCUyQyUyMExpc3QlMkMlMjBUdXBsZSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMERhdGFzZXQlMEFpbXBvcnQlMjBtYXRwbG90bGliLnB5cGxvdCUyMGFzJTIwcGx0JTBBJTBBcGQuc2V0X29wdGlvbiglMjJkaXNwbGF5Lm1heF9jb2x3aWR0aCUyMiUyQyUyME5vbmUpJTIwJTIwJTIzJTIwdGhpcyUyMHdpbGwlMjBiZSUyMGhlbHBmdWwlMjB3aGVuJTIwdmlzdWFsaXppbmclMjByZXRyaWV2ZXIlMjBvdXRwdXRz",highlighted:`<span class="hljs-keyword">from</span> tqdm.notebook <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Tuple</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

pd.set_option(<span class="hljs-string">&quot;display.max_colwidth&quot;</span>, <span class="hljs-literal">None</span>)  <span class="hljs-comment"># this will be helpful when visualizing retriever outputs</span>`,wrap:!1}}),v=new h({props:{title:"Load your knowledge base",local:"load-your-knowledge-base",headingTag:"h3"}}),Z=new y({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFkcyUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

ds = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),B=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTIwYXMlMjBMYW5nY2hhaW5Eb2N1bWVudCUwQSUwQVJBV19LTk9XTEVER0VfQkFTRSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMExhbmdjaGFpbkRvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMHRxZG0oZHMpJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document <span class="hljs-keyword">as</span> LangchainDocument

RAW_KNOWLEDGE_BASE = [
    LangchainDocument(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(ds)
]`,wrap:!1}}),G=new h({props:{title:"1. Retriever - embeddings 🗂️",local:"1-retriever---embeddings-",headingTag:"h1"}}),X=new h({props:{title:"1.1 Split the documents into chunks",local:"11-split-the-documents-into-chunks",headingTag:"h3"}}),L=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBJTBBJTIzJTIwV2UlMjB1c2UlMjBhJTIwaGllcmFyY2hpY2FsJTIwbGlzdCUyMG9mJTIwc2VwYXJhdG9ycyUyMHNwZWNpZmljYWxseSUyMHRhaWxvcmVkJTIwZm9yJTIwc3BsaXR0aW5nJTIwTWFya2Rvd24lMjBkb2N1bWVudHMlMEElMjMlMjBUaGlzJTIwbGlzdCUyMGlzJTIwdGFrZW4lMjBmcm9tJTIwTGFuZ0NoYWluJ3MlMjBNYXJrZG93blRleHRTcGxpdHRlciUyMGNsYXNzLiUwQU1BUktET1dOX1NFUEFSQVRPUlMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjIlNUNuJTIzJTdCMSUyQzYlN0QlMjAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjIlNjAlNjAlNjAlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTVDbiU1QyU1QyolNUMlNUMqJTVDJTVDKiUyQiU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjIlNUNuLS0tJTJCJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMiU1Q25fX18lMkIlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTVDbiU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjIlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTJDJTBBJTVEJTBBJTBBdGV4dF9zcGxpdHRlciUyMCUzRCUyMFJlY3Vyc2l2ZUNoYXJhY3RlclRleHRTcGxpdHRlciglMEElMjAlMjAlMjAlMjBjaHVua19zaXplJTNEMTAwMCUyQyUyMCUyMCUyMyUyMHRoZSUyMG1heGltdW0lMjBudW1iZXIlMjBvZiUyMGNoYXJhY3RlcnMlMjBpbiUyMGElMjBjaHVuayUzQSUyMHdlJTIwc2VsZWN0ZWQlMjB0aGlzJTIwdmFsdWUlMjBhcmJpdHJhcmlseSUwQSUyMCUyMCUyMCUyMGNodW5rX292ZXJsYXAlM0QxMDAlMkMlMjAlMjAlMjMlMjB0aGUlMjBudW1iZXIlMjBvZiUyMGNoYXJhY3RlcnMlMjB0byUyMG92ZXJsYXAlMjBiZXR3ZWVuJTIwY2h1bmtzJTBBJTIwJTIwJTIwJTIwYWRkX3N0YXJ0X2luZGV4JTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMElmJTIwJTYwVHJ1ZSU2MCUyQyUyMGluY2x1ZGVzJTIwY2h1bmsncyUyMHN0YXJ0JTIwaW5kZXglMjBpbiUyMG1ldGFkYXRhJTBBJTIwJTIwJTIwJTIwc3RyaXBfd2hpdGVzcGFjZSUzRFRydWUlMkMlMjAlMjAlMjMlMjBJZiUyMCU2MFRydWUlNjAlMkMlMjBzdHJpcHMlMjB3aGl0ZXNwYWNlJTIwZnJvbSUyMHRoZSUyMHN0YXJ0JTIwYW5kJTIwZW5kJTIwb2YlMjBldmVyeSUyMGRvY3VtZW50JTBBJTIwJTIwJTIwJTIwc2VwYXJhdG9ycyUzRE1BUktET1dOX1NFUEFSQVRPUlMlMkMlMEEpJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjBkb2MlMjBpbiUyMFJBV19LTk9XTEVER0VfQkFTRSUzQSUwQSUyMCUyMCUyMCUyMGRvY3NfcHJvY2Vzc2VkJTIwJTJCJTNEJTIwdGV4dF9zcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoJTVCZG9jJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter

<span class="hljs-comment"># We use a hierarchical list of separators specifically tailored for splitting Markdown documents</span>
<span class="hljs-comment"># This list is taken from LangChain&#x27;s MarkdownTextSplitter class.</span>
MARKDOWN_SEPARATORS = [
    <span class="hljs-string">&quot;\\n#{1,6} &quot;</span>,
    <span class="hljs-string">&quot;\`\`\`\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n\\\\*\\\\*\\\\*+\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n---+\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n___+\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n&quot;</span>,
    <span class="hljs-string">&quot; &quot;</span>,
    <span class="hljs-string">&quot;&quot;</span>,
]

text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">1000</span>,  <span class="hljs-comment"># the maximum number of characters in a chunk: we selected this value arbitrarily</span>
    chunk_overlap=<span class="hljs-number">100</span>,  <span class="hljs-comment"># the number of characters to overlap between chunks</span>
    add_start_index=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># If \`True\`, includes chunk&#x27;s start index in metadata</span>
    strip_whitespace=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># If \`True\`, strips whitespace from the start and end of every document</span>
    separators=MARKDOWN_SEPARATORS,
)

docs_processed = []
<span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> RAW_KNOWLEDGE_BASE:
    docs_processed += text_splitter.split_documents([doc])`,wrap:!1}}),K=new y({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEElMjMlMjBUbyUyMGdldCUyMHRoZSUyMHZhbHVlJTIwb2YlMjB0aGUlMjBtYXglMjBzZXF1ZW5jZV9sZW5ndGglMkMlMjB3ZSUyMHdpbGwlMjBxdWVyeSUyMHRoZSUyMHVuZGVybHlpbmclMjAlNjBTZW50ZW5jZVRyYW5zZm9ybWVyJTYwJTIwb2JqZWN0JTIwdXNlZCUyMGluJTIwdGhlJTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyLiUwQXByaW50KGYlMjJNb2RlbCdzJTIwbWF4aW11bSUyMHNlcXVlbmNlJTIwbGVuZ3RoJTNBJTIwJTdCU2VudGVuY2VUcmFuc2Zvcm1lcigndGhlbmxwZXIlMkZndGUtc21hbGwnKS5tYXhfc2VxX2xlbmd0aCU3RCUyMiklMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQWxlbmd0aHMlMjAlM0QlMjAlNUJsZW4odG9rZW5pemVyLmVuY29kZShkb2MucGFnZV9jb250ZW50KSklMjBmb3IlMjBkb2MlMjBpbiUyMHRxZG0oZG9jc19wcm9jZXNzZWQpJTVEJTBBJTBBJTIzJTIwUGxvdCUyMHRoZSUyMGRpc3RydWJ1dGlvbiUyMG9mJTIwZG9jdW1lbnQlMjBsZW5ndGhzJTJDJTIwY291bnRlZCUyMGFzJTIwdGhlJTIwbnVtYmVyJTIwb2YlMjB0b2tlbnMlMEFmaWclMjAlM0QlMjBwZC5TZXJpZXMobGVuZ3RocykuaGlzdCgpJTBBcGx0LnRpdGxlKCUyMkRpc3RyaWJ1dGlvbiUyMG9mJTIwZG9jdW1lbnQlMjBsZW5ndGhzJTIwaW4lMjB0aGUlMjBrbm93bGVkZ2UlMjBiYXNlJTIwKGluJTIwY291bnQlMjBvZiUyMHRva2VucyklMjIpJTBBcGx0LnNob3coKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To get the value of the max sequence_length, we will query the underlying \`SentenceTransformer\` object used in the RecursiveCharacterTextSplitter.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model&#x27;s maximum sequence length: <span class="hljs-subst">{SentenceTransformer(<span class="hljs-string">&#x27;thenlper/gte-small&#x27;</span>).max_seq_length}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>lengths = [<span class="hljs-built_in">len</span>(tokenizer.encode(doc.page_content)) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(docs_processed)]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Plot the distrubution of document lengths, counted as the number of tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig = pd.Series(lengths).hist()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.title(<span class="hljs-string">&quot;Distribution of document lengths in the knowledge base (in count of tokens)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),le=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

EMBEDDING_MODEL_NAME = <span class="hljs-string">&quot;thenlper/gte-small&quot;</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">split_documents</span>(<span class="hljs-params">
    chunk_size: <span class="hljs-built_in">int</span>,
    knowledge_base: <span class="hljs-type">List</span>[LangchainDocument],
    tokenizer_name: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] = EMBEDDING_MODEL_NAME,
</span>) -&gt; <span class="hljs-type">List</span>[LangchainDocument]:
    <span class="hljs-string">&quot;&quot;&quot;
    Split documents into chunks of maximum size \`chunk_size\` tokens and return a list of documents.
    &quot;&quot;&quot;</span>
    text_splitter = RecursiveCharacterTextSplitter.from_huggingface_tokenizer(
        AutoTokenizer.from_pretrained(tokenizer_name),
        chunk_size=chunk_size,
        chunk_overlap=<span class="hljs-built_in">int</span>(chunk_size / <span class="hljs-number">10</span>),
        add_start_index=<span class="hljs-literal">True</span>,
        strip_whitespace=<span class="hljs-literal">True</span>,
        separators=MARKDOWN_SEPARATORS,
    )

    docs_processed = []
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base:
        docs_processed += text_splitter.split_documents([doc])

    <span class="hljs-comment"># Remove duplicates</span>
    unique_texts = {}
    docs_processed_unique = []
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed:
        <span class="hljs-keyword">if</span> doc.page_content <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> unique_texts:
            unique_texts[doc.page_content] = <span class="hljs-literal">True</span>
            docs_processed_unique.append(doc)

    <span class="hljs-keyword">return</span> docs_processed_unique


docs_processed = split_documents(
    <span class="hljs-number">512</span>,  <span class="hljs-comment"># We choose a chunk size adapted to our model</span>
    RAW_KNOWLEDGE_BASE,
    tokenizer_name=EMBEDDING_MODEL_NAME,
)

<span class="hljs-comment"># Let&#x27;s visualize the chunk sizes we would have in tokens from a common model</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(EMBEDDING_MODEL_NAME)
lengths = [<span class="hljs-built_in">len</span>(tokenizer.encode(doc.page_content)) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(docs_processed)]
fig = pd.Series(lengths).hist()
plt.title(<span class="hljs-string">&quot;Distribution of document lengths in the knowledge base (in count of tokens)&quot;</span>)
plt.show()`,wrap:!1}}),ne=new h({props:{title:"1.2 Building the vector database",local:"12-building-the-vector-database",headingTag:"h3"}}),ie=new h({props:{title:"How does retrieval work ?",local:"how-does-retrieval-work-",headingTag:"h4"}}),re=new h({props:{title:"Nearest Neighbor search algorithm",local:"nearest-neighbor-search-algorithm",headingTag:"h5"}}),ce=new h({props:{title:"Distances",local:"distances",headingTag:"h5"}}),Te=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEFmcm9tJTIwbGFuZ2NoYWluX2NvbW11bml0eS52ZWN0b3JzdG9yZXMudXRpbHMlMjBpbXBvcnQlMjBEaXN0YW5jZVN0cmF0ZWd5JTBBJTBBZW1iZWRkaW5nX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlM0RFTUJFRERJTkdfTU9ERUxfTkFNRSUyQyUwQSUyMCUyMCUyMCUyMG11bHRpX3Byb2Nlc3MlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfa3dhcmdzJTNEJTdCJTIyZGV2aWNlJTIyJTNBJTIwJTIyY3VkYSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGVuY29kZV9rd2FyZ3MlM0QlN0IlMjJub3JtYWxpemVfZW1iZWRkaW5ncyUyMiUzQSUyMFRydWUlN0QlMkMlMjAlMjAlMjMlMjBzZXQlMjBUcnVlJTIwZm9yJTIwY29zaW5lJTIwc2ltaWxhcml0eSUwQSklMEElMEFLTk9XTEVER0VfVkVDVE9SX0RBVEFCQVNFJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoJTBBJTIwJTIwJTIwJTIwZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmdfbW9kZWwlMkMlMjBkaXN0YW5jZV9zdHJhdGVneSUzRERpc3RhbmNlU3RyYXRlZ3kuQ09TSU5FJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings
<span class="hljs-keyword">from</span> langchain_community.vectorstores.utils <span class="hljs-keyword">import</span> DistanceStrategy

embedding_model = HuggingFaceEmbeddings(
    model_name=EMBEDDING_MODEL_NAME,
    multi_process=<span class="hljs-literal">True</span>,
    model_kwargs={<span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cuda&quot;</span>},
    encode_kwargs={<span class="hljs-string">&quot;normalize_embeddings&quot;</span>: <span class="hljs-literal">True</span>},  <span class="hljs-comment"># set True for cosine similarity</span>
)

KNOWLEDGE_VECTOR_DATABASE = FAISS.from_documents(
    docs_processed, embedding_model, distance_strategy=DistanceStrategy.COSINE
)`,wrap:!1}}),je=new y({props:{code:"JTIzJTIwZW1iZWQlMjBhJTIwdXNlciUyMHF1ZXJ5JTIwaW4lMjB0aGUlMjBzYW1lJTIwc3BhY2UlMEF1c2VyX3F1ZXJ5JTIwJTNEJTIwJTIySG93JTIwdG8lMjBjcmVhdGUlMjBhJTIwcGlwZWxpbmUlMjBvYmplY3QlM0YlMjIlMEFxdWVyeV92ZWN0b3IlMjAlM0QlMjBlbWJlZGRpbmdfbW9kZWwuZW1iZWRfcXVlcnkodXNlcl9xdWVyeSk=",highlighted:`<span class="hljs-comment"># embed a user query in the same space</span>
user_query = <span class="hljs-string">&quot;How to create a pipeline object?&quot;</span>
query_vector = embedding_model.embed_query(user_query)`,wrap:!1}}),we=new y({props:{code:"aW1wb3J0JTIwcGFjbWFwJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwcGxvdGx5LmV4cHJlc3MlMjBhcyUyMHB4JTBBJTBBZW1iZWRkaW5nX3Byb2plY3RvciUyMCUzRCUyMHBhY21hcC5QYUNNQVAobl9jb21wb25lbnRzJTNEMiUyQyUyMG5fbmVpZ2hib3JzJTNETm9uZSUyQyUyME1OX3JhdGlvJTNEMC41JTJDJTIwRlBfcmF0aW8lM0QyLjAlMkMlMjByYW5kb21fc3RhdGUlM0QxKSUwQSUwQWVtYmVkZGluZ3NfMmQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBsaXN0KEtOT1dMRURHRV9WRUNUT1JfREFUQUJBU0UuaW5kZXgucmVjb25zdHJ1Y3RfbihpZHglMkMlMjAxKSU1QjAlNUQpJTIwZm9yJTIwaWR4JTIwaW4lMjByYW5nZShsZW4oZG9jc19wcm9jZXNzZWQpKSUwQSU1RCUyMCUyQiUyMCU1QnF1ZXJ5X3ZlY3RvciU1RCUwQSUwQSUyMyUyMGZpdCUyMHRoZSUyMGRhdGElMjAoVGhlJTIwaW5kZXglMjBvZiUyMHRyYW5zZm9ybWVkJTIwZGF0YSUyMGNvcnJlc3BvbmRzJTIwdG8lMjB0aGUlMjBpbmRleCUyMG9mJTIwdGhlJTIwb3JpZ2luYWwlMjBkYXRhKSUwQWRvY3VtZW50c19wcm9qZWN0ZWQlMjAlM0QlMjBlbWJlZGRpbmdfcHJvamVjdG9yLmZpdF90cmFuc2Zvcm0obnAuYXJyYXkoZW1iZWRkaW5nc18yZCklMkMlMjBpbml0JTNEJTIycGNhJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> pacmap
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> plotly.express <span class="hljs-keyword">as</span> px

embedding_projector = pacmap.PaCMAP(n_components=<span class="hljs-number">2</span>, n_neighbors=<span class="hljs-literal">None</span>, MN_ratio=<span class="hljs-number">0.5</span>, FP_ratio=<span class="hljs-number">2.0</span>, random_state=<span class="hljs-number">1</span>)

embeddings_2d = [
    <span class="hljs-built_in">list</span>(KNOWLEDGE_VECTOR_DATABASE.index.reconstruct_n(idx, <span class="hljs-number">1</span>)[<span class="hljs-number">0</span>]) <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(docs_processed))
] + [query_vector]

<span class="hljs-comment"># fit the data (The index of transformed data corresponds to the index of the original data)</span>
documents_projected = embedding_projector.fit_transform(np.array(embeddings_2d), init=<span class="hljs-string">&quot;pca&quot;</span>)`,wrap:!1}}),be=new y({props:{code:"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",highlighted:`df = pd.DataFrame.from_dict(
    [
        {
            <span class="hljs-string">&quot;x&quot;</span>: documents_projected[i, <span class="hljs-number">0</span>],
            <span class="hljs-string">&quot;y&quot;</span>: documents_projected[i, <span class="hljs-number">1</span>],
            <span class="hljs-string">&quot;source&quot;</span>: docs_processed[i].metadata[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>],
            <span class="hljs-string">&quot;extract&quot;</span>: docs_processed[i].page_content[:<span class="hljs-number">100</span>] + <span class="hljs-string">&quot;...&quot;</span>,
            <span class="hljs-string">&quot;symbol&quot;</span>: <span class="hljs-string">&quot;circle&quot;</span>,
            <span class="hljs-string">&quot;size_col&quot;</span>: <span class="hljs-number">4</span>,
        }
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(docs_processed))
    ]
    + [
        {
            <span class="hljs-string">&quot;x&quot;</span>: documents_projected[-<span class="hljs-number">1</span>, <span class="hljs-number">0</span>],
            <span class="hljs-string">&quot;y&quot;</span>: documents_projected[-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
            <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;User query&quot;</span>,
            <span class="hljs-string">&quot;extract&quot;</span>: user_query,
            <span class="hljs-string">&quot;size_col&quot;</span>: <span class="hljs-number">100</span>,
            <span class="hljs-string">&quot;symbol&quot;</span>: <span class="hljs-string">&quot;star&quot;</span>,
        }
    ]
)

<span class="hljs-comment"># visualize the embedding</span>
fig = px.scatter(
    df,
    x=<span class="hljs-string">&quot;x&quot;</span>,
    y=<span class="hljs-string">&quot;y&quot;</span>,
    color=<span class="hljs-string">&quot;source&quot;</span>,
    hover_data=<span class="hljs-string">&quot;extract&quot;</span>,
    size=<span class="hljs-string">&quot;size_col&quot;</span>,
    symbol=<span class="hljs-string">&quot;symbol&quot;</span>,
    color_discrete_map={<span class="hljs-string">&quot;User query&quot;</span>: <span class="hljs-string">&quot;black&quot;</span>},
    width=<span class="hljs-number">1000</span>,
    height=<span class="hljs-number">700</span>,
)
fig.update_traces(marker=<span class="hljs-built_in">dict</span>(opacity=<span class="hljs-number">1</span>, line=<span class="hljs-built_in">dict</span>(width=<span class="hljs-number">0</span>, color=<span class="hljs-string">&quot;DarkSlateGrey&quot;</span>)), selector=<span class="hljs-built_in">dict</span>(mode=<span class="hljs-string">&quot;markers&quot;</span>))
fig.update_layout(
    legend_title_text=<span class="hljs-string">&quot;&lt;b&gt;Chunk source&lt;/b&gt;&quot;</span>,
    title=<span class="hljs-string">&quot;&lt;b&gt;2D Projection of Chunk Embeddings via PaCMAP&lt;/b&gt;&quot;</span>,
)
fig.show()`,wrap:!1}}),ke=new y({props:{code:"cHJpbnQoZiUyMiU1Q25TdGFydGluZyUyMHJldHJpZXZhbCUyMGZvciUyMCU3QnVzZXJfcXVlcnklM0QlN0QuLi4lMjIpJTBBcmV0cmlldmVkX2RvY3MlMjAlM0QlMjBLTk9XTEVER0VfVkVDVE9SX0RBVEFCQVNFLnNpbWlsYXJpdHlfc2VhcmNoKHF1ZXJ5JTNEdXNlcl9xdWVyeSUyQyUyMGslM0Q1KSUwQXByaW50KCUyMiU1Q24lM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0RUb3AlMjBkb2N1bWVudCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUyMiklMEFwcmludChyZXRyaWV2ZWRfZG9jcyU1QjAlNUQucGFnZV9jb250ZW50KSUwQXByaW50KCUyMiUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRE1ldGFkYXRhJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIyKSUwQXByaW50KHJldHJpZXZlZF9kb2NzJTVCMCU1RC5tZXRhZGF0YSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nStarting retrieval for <span class="hljs-subst">{user_query=}</span>...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>retrieved_docs = KNOWLEDGE_VECTOR_DATABASE.similarity_search(query=user_query, k=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n==================================Top document==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_docs[<span class="hljs-number">0</span>].page_content)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;==================================Metadata==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_docs[<span class="hljs-number">0</span>].metadata)`,wrap:!1}}),Ne=new h({props:{title:"2. Reader - LLM 💬",local:"2-reader---llm-",headingTag:"h1"}}),Ge=new h({props:{title:"2.1. Reader model",local:"21-reader-model",headingTag:"h3"}}),Qe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBUkVBREVSX01PREVMX05BTUUlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoUkVBREVSX01PREVMX05BTUUlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChSRUFERVJfTU9ERUxfTkFNRSklMEElMEFSRUFERVJfTExNJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjIlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDUwMCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

READER_MODEL_NAME = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)
model = AutoModelForCausalLM.from_pretrained(READER_MODEL_NAME, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(READER_MODEL_NAME)

READER_LLM = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    do_sample=<span class="hljs-literal">True</span>,
    temperature=<span class="hljs-number">0.2</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">False</span>,
    max_new_tokens=<span class="hljs-number">500</span>,
)`,wrap:!1}}),ze=new y({props:{code:"UkVBREVSX0xMTSglMjJXaGF0JTIwaXMlMjA0JTJCNCUzRiUyMEFuc3dlciUzQSUyMik=",highlighted:'READER_LLM(<span class="hljs-string">&quot;What is 4+4? Answer:&quot;</span>)',wrap:!1}}),Xe=new h({props:{title:"2.2. Prompt",local:"22-prompt",headingTag:"h3"}}),He=new y({props:{code:"cHJvbXB0X2luX2NoYXRfZm9ybWF0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIlMjIlMjJVc2luZyUyMHRoZSUyMGluZm9ybWF0aW9uJTIwY29udGFpbmVkJTIwaW4lMjB0aGUlMjBjb250ZXh0JTJDJTBBZ2l2ZSUyMGElMjBjb21wcmVoZW5zaXZlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjBxdWVzdGlvbi4lMEFSZXNwb25kJTIwb25seSUyMHRvJTIwdGhlJTIwcXVlc3Rpb24lMjBhc2tlZCUyQyUyMHJlc3BvbnNlJTIwc2hvdWxkJTIwYmUlMjBjb25jaXNlJTIwYW5kJTIwcmVsZXZhbnQlMjB0byUyMHRoZSUyMHF1ZXN0aW9uLiUwQVByb3ZpZGUlMjB0aGUlMjBudW1iZXIlMjBvZiUyMHRoZSUyMHNvdXJjZSUyMGRvY3VtZW50JTIwd2hlbiUyMHJlbGV2YW50LiUwQUlmJTIwdGhlJTIwYW5zd2VyJTIwY2Fubm90JTIwYmUlMjBkZWR1Y2VkJTIwZnJvbSUyMHRoZSUyMGNvbnRleHQlMkMlMjBkbyUyMG5vdCUyMGdpdmUlMjBhbiUyMGFuc3dlci4lMjIlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIlMjIlMjJDb250ZXh0JTNBJTBBJTdCY29udGV4dCU3RCUwQS0tLSUwQU5vdyUyMGhlcmUlMjBpcyUyMHRoZSUyMHF1ZXN0aW9uJTIweW91JTIwbmVlZCUyMHRvJTIwYW5zd2VyLiUwQSUwQVF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb24lN0QlMjIlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElNUQlMEFSQUdfUFJPTVBUX1RFTVBMQVRFJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2luX2NoYXRfZm9ybWF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMEEpJTBBcHJpbnQoUkFHX1BST01QVF9URU1QTEFURSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_in_chat_format = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;&quot;&quot;Using the information contained in the context,
<span class="hljs-meta">... </span>give a comprehensive answer to the question.
<span class="hljs-meta">... </span>Respond only to the question asked, response should be concise and relevant to the question.
<span class="hljs-meta">... </span>Provide the number of the source document when relevant.
<span class="hljs-meta">... </span>If the answer cannot be deduced from the context, do not give an answer.&quot;&quot;&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;&quot;&quot;Context:
<span class="hljs-meta">... </span>{context}
<span class="hljs-meta">... </span>---
<span class="hljs-meta">... </span>Now here is the question you need to answer.

<span class="hljs-meta">... </span>Question: {question}&quot;&quot;&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>RAG_PROMPT_TEMPLATE = tokenizer.apply_chat_template(
<span class="hljs-meta">... </span>    prompt_in_chat_format, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(RAG_PROMPT_TEMPLATE)`,wrap:!1}}),Ye=new y({props:{code:"cmV0cmlldmVkX2RvY3NfdGV4dCUyMCUzRCUyMCU1QmRvYy5wYWdlX2NvbnRlbnQlMjBmb3IlMjBkb2MlMjBpbiUyMHJldHJpZXZlZF9kb2NzJTVEJTIwJTIwJTIzJTIwd2UlMjBvbmx5JTIwbmVlZCUyMHRoZSUyMHRleHQlMjBvZiUyMHRoZSUyMGRvY3VtZW50cyUwQWNvbnRleHQlMjAlM0QlMjAlMjIlNUNuRXh0cmFjdGVkJTIwZG9jdW1lbnRzJTNBJTVDbiUyMiUwQWNvbnRleHQlMjAlMkIlM0QlMjAlMjIlMjIuam9pbiglNUJmJTIyRG9jdW1lbnQlMjAlN0JzdHIoaSklN0QlM0ElM0ElM0ElNUNuJTIyJTIwJTJCJTIwZG9jJTIwZm9yJTIwaSUyQyUyMGRvYyUyMGluJTIwZW51bWVyYXRlKHJldHJpZXZlZF9kb2NzX3RleHQpJTVEKSUwQSUwQWZpbmFsX3Byb21wdCUyMCUzRCUyMFJBR19QUk9NUFRfVEVNUExBVEUuZm9ybWF0KHF1ZXN0aW9uJTNEJTIySG93JTIwdG8lMjBjcmVhdGUlMjBhJTIwcGlwZWxpbmUlMjBvYmplY3QlM0YlMjIlMkMlMjBjb250ZXh0JTNEY29udGV4dCklMEElMEElMjMlMjBSZWRhY3QlMjBhbiUyMGFuc3dlciUwQWFuc3dlciUyMCUzRCUyMFJFQURFUl9MTE0oZmluYWxfcHJvbXB0KSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCUwQXByaW50KGFuc3dlcik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>retrieved_docs_text = [doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> retrieved_docs]  <span class="hljs-comment"># we only need the text of the documents</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = <span class="hljs-string">&quot;\\nExtracted documents:\\n&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context += <span class="hljs-string">&quot;&quot;</span>.join([<span class="hljs-string">f&quot;Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span>:::\\n&quot;</span> + doc <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(retrieved_docs_text)])

<span class="hljs-meta">&gt;&gt;&gt; </span>final_prompt = RAG_PROMPT_TEMPLATE.<span class="hljs-built_in">format</span>(question=<span class="hljs-string">&quot;How to create a pipeline object?&quot;</span>, context=context)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Redact an answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>answer = READER_LLM(final_prompt)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(answer)`,wrap:!1}}),Pe=new h({props:{title:"2.3. Reranking",local:"23-reranking",headingTag:"h3"}}),et=new y({props:{code:"ZnJvbSUyMHJhZ2F0b3VpbGxlJTIwaW1wb3J0JTIwUkFHUHJldHJhaW5lZE1vZGVsJTBBJTBBUkVSQU5LRVIlMjAlM0QlMjBSQUdQcmV0cmFpbmVkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmNvbGJlcnQtaXIlMkZjb2xiZXJ0djIuMCUyMik=",highlighted:`<span class="hljs-keyword">from</span> ragatouille <span class="hljs-keyword">import</span> RAGPretrainedModel

RERANKER = RAGPretrainedModel.from_pretrained(<span class="hljs-string">&quot;colbert-ir/colbertv2.0&quot;</span>)`,wrap:!1}}),tt=new h({props:{title:"3. Assembling it all!",local:"3-assembling-it-all",headingTag:"h1"}}),lt=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">answer_with_rag</span>(<span class="hljs-params">
    question: <span class="hljs-built_in">str</span>,
    llm: Pipeline,
    knowledge_index: FAISS,
    reranker: <span class="hljs-type">Optional</span>[RAGPretrainedModel] = <span class="hljs-literal">None</span>,
    num_retrieved_docs: <span class="hljs-built_in">int</span> = <span class="hljs-number">30</span>,
    num_docs_final: <span class="hljs-built_in">int</span> = <span class="hljs-number">5</span>,
</span>) -&gt; <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">List</span>[LangchainDocument]]:
    <span class="hljs-comment"># Gather documents with retriever</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&gt; Retrieving documents...&quot;</span>)
    relevant_docs = knowledge_index.similarity_search(query=question, k=num_retrieved_docs)
    relevant_docs = [doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> relevant_docs]  <span class="hljs-comment"># keep only the text</span>

    <span class="hljs-comment"># Optionally rerank results</span>
    <span class="hljs-keyword">if</span> reranker:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&gt; Reranking documents...&quot;</span>)
        relevant_docs = reranker.rerank(question, relevant_docs, k=num_docs_final)
        relevant_docs = [doc[<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> relevant_docs]

    relevant_docs = relevant_docs[:num_docs_final]

    <span class="hljs-comment"># Build the final prompt</span>
    context = <span class="hljs-string">&quot;\\nExtracted documents:\\n&quot;</span>
    context += <span class="hljs-string">&quot;&quot;</span>.join([<span class="hljs-string">f&quot;Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span>:::\\n&quot;</span> + doc <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(relevant_docs)])

    final_prompt = RAG_PROMPT_TEMPLATE.<span class="hljs-built_in">format</span>(question=question, context=context)

    <span class="hljs-comment"># Redact an answer</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&gt; Generating answer...&quot;</span>)
    answer = llm(final_prompt)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]

    <span class="hljs-keyword">return</span> answer, relevant_docs`,wrap:!1}}),nt=new y({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJob3clMjB0byUyMGNyZWF0ZSUyMGElMjBwaXBlbGluZSUyMG9iamVjdCUzRiUyMiUwQSUwQWFuc3dlciUyQyUyMHJlbGV2YW50X2RvY3MlMjAlM0QlMjBhbnN3ZXJfd2l0aF9yYWcocXVlc3Rpb24lMkMlMjBSRUFERVJfTExNJTJDJTIwS05PV0xFREdFX1ZFQ1RPUl9EQVRBQkFTRSUyQyUyMHJlcmFua2VyJTNEUkVSQU5LRVIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;how to create a pipeline object?&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>answer, relevant_docs = answer_with_rag(question, READER_LLM, KNOWLEDGE_VECTOR_DATABASE, reranker=RERANKER)`,wrap:!1}}),it=new y({props:{code:"cHJpbnQoJTIyJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEQW5zd2VyJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIyKSUwQXByaW50KGYlMjIlN0JhbnN3ZXIlN0QlMjIpJTBBcHJpbnQoJTIyJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEU291cmNlJTIwZG9jcyUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUyMiklMEFmb3IlMjBpJTJDJTIwZG9jJTIwaW4lMjBlbnVtZXJhdGUocmVsZXZhbnRfZG9jcyklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyRG9jdW1lbnQlMjAlN0JpJTdELS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGRvYyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;==================================Answer==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{answer}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;==================================Source docs==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(relevant_docs):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Document <span class="hljs-subst">{i}</span>------------------------------------------------------------&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(doc)`,wrap:!1}}),rt=new h({props:{title:"To go further 🗺️",local:"to-go-further-",headingTag:"h1"}}),ct=new h({props:{title:"Setting up an evaluation pipeline",local:"setting-up-an-evaluation-pipeline",headingTag:"h3"}}),ut=new h({props:{title:"Improving the retriever",local:"improving-the-retriever",headingTag:"h3"}}),Jt=new h({props:{title:"Improving the reader",local:"improving-the-reader",headingTag:"h3"}}),{c(){T=i("meta"),It=n(),gt=i("p"),Rt=n(),r(J.$$.fragment),kt=n(),r(U.$$.fragment),Et=n(),j=i("p"),j.innerHTML=_s,Nt=n(),w=i("p"),w.textContent=As,vt=n(),b=i("p"),b.innerHTML=Ws,Zt=n(),f=i("p"),f.textContent=Vs,Bt=n(),g=i("img"),Gt=n(),C=i("blockquote"),C.innerHTML=Qs,_t=n(),I=i("p"),I.textContent=zs,At=n(),R=i("p"),R.innerHTML=Xs,Wt=n(),r(k.$$.fragment),Vt=n(),r(E.$$.fragment),xt=n(),r(N.$$.fragment),Qt=n(),r(v.$$.fragment),zt=n(),r(Z.$$.fragment),Xt=n(),r(B.$$.fragment),St=n(),r(G.$$.fragment),$t=n(),_=i("p"),_.innerHTML=Ss,Ht=n(),A=i("p"),A.textContent=$s,qt=n(),W=i("p"),W.innerHTML=Hs,Ft=n(),V=i("p"),V.innerHTML=qs,Yt=n(),x=i("p"),x.innerHTML=Fs,Lt=n(),Q=i("ul"),Q.innerHTML=Ys,Pt=n(),z=i("blockquote"),z.innerHTML=Ls,Dt=n(),r(X.$$.fragment),Kt=n(),S=i("ul"),S.innerHTML=Ps,Ot=n(),$=i("p"),$.innerHTML=Ds,el=n(),H=i("ul"),H.innerHTML=Ks,tl=n(),q=i("blockquote"),q.innerHTML=Os,ll=n(),F=i("p"),F.innerHTML=en,sl=n(),Y=i("ul"),Y.innerHTML=tn,nl=n(),r(L.$$.fragment),al=n(),P=i("p"),P.innerHTML=ln,il=n(),D=i("p"),D.textContent=sn,ol=n(),r(K.$$.fragment),pl=n(),O=i("pre"),O.textContent=nn,rl=n(),ee=i("p"),ee.innerHTML=an,Ml=n(),te=i("ul"),te.innerHTML=on,cl=n(),r(le.$$.fragment),ml=n(),se=i("p"),se.textContent=pn,ul=n(),r(ne.$$.fragment),dl=n(),ae=i("p"),ae.innerHTML=rn,yl=n(),r(ie.$$.fragment),hl=n(),oe=i("p"),oe.textContent=Mn,Tl=n(),pe=i("p"),pe.textContent=cn,Jl=n(),r(re.$$.fragment),Ul=n(),Me=i("p"),Me.innerHTML=mn,jl=n(),r(ce.$$.fragment),wl=n(),me=i("p"),me.innerHTML=un,bl=n(),ue=i("ul"),ue.innerHTML=dn,fl=n(),de=i("p"),de.innerHTML=yn,gl=n(),ye=i("p"),ye.innerHTML=hn,Cl=n(),he=i("p"),he.textContent=Tn,Il=n(),r(Te.$$.fragment),Rl=n(),Je=i("p"),Je.textContent=Jn,kl=n(),Ue=i("p"),Ue.innerHTML=Un,El=n(),r(je.$$.fragment),Nl=n(),r(we.$$.fragment),vl=n(),r(be.$$.fragment),Zl=n(),fe=i("img"),Bl=n(),ge=i("p"),ge.textContent=wn,Gl=n(),Ce=i("p"),Ce.innerHTML=bn,_l=n(),Ie=i("p"),Ie.innerHTML=fn,Al=n(),Re=i("p"),Re.textContent=gn,Wl=n(),r(ke.$$.fragment),Vl=n(),Ee=i("pre"),Ee.textContent=Cn,xl=n(),r(Ne.$$.fragment),Ql=n(),ve=i("p"),ve.innerHTML=In,zl=n(),Ze=i("p"),Ze.textContent=Rn,Xl=n(),Be=i("ol"),Be.innerHTML=kn,Sl=n(),r(Ge.$$.fragment),$l=n(),_e=i("p"),_e.textContent=En,Hl=n(),Ae=i("ul"),Ae.innerHTML=Nn,ql=n(),We=i("p"),We.innerHTML=vn,Fl=n(),Ve=i("p"),Ve.innerHTML=Zn,Yl=n(),xe=i("p"),xe.textContent=Bn,Ll=n(),r(Qe.$$.fragment),Pl=n(),r(ze.$$.fragment),Dl=n(),r(Xe.$$.fragment),Kl=n(),Se=i("p"),Se.textContent=Gn,Ol=n(),$e=i("p"),$e.textContent=_n,es=n(),r(He.$$.fragment),ts=n(),qe=i("pre"),qe.textContent=An,ls=n(),Fe=i("p"),Fe.textContent=Wn,ss=n(),r(Ye.$$.fragment),ns=n(),Le=i("pre"),Le.textContent=Vn,as=n(),r(Pe.$$.fragment),is=n(),De=i("p"),De.innerHTML=xn,os=n(),Ke=i("p"),Ke.innerHTML=Qn,ps=n(),Oe=i("p"),Oe.innerHTML=zn,rs=n(),r(et.$$.fragment),Ms=n(),r(tt.$$.fragment),cs=n(),r(lt.$$.fragment),ms=n(),st=i("p"),st.textContent=Xn,us=n(),r(nt.$$.fragment),ds=n(),at=i("pre"),at.textContent=Sn,ys=n(),r(it.$$.fragment),hs=n(),ot=i("pre"),ot.textContent=$n,Ts=n(),pt=i("p"),pt.textContent=Hn,Js=n(),r(rt.$$.fragment),Us=n(),Mt=i("p"),Mt.textContent=qn,js=n(),r(ct.$$.fragment),ws=n(),mt=i("ul"),mt.innerHTML=Fn,bs=n(),r(ut.$$.fragment),fs=n(),dt=i("p"),dt.innerHTML=Yn,gs=n(),yt=i("ul"),yt.innerHTML=Ln,Cs=n(),ht=i("p"),ht.innerHTML=Pn,Is=n(),Tt=i("ul"),Tt.innerHTML=Dn,Rs=n(),r(Jt.$$.fragment),ks=n(),Ut=i("p"),Ut.innerHTML=Kn,Es=n(),jt=i("ul"),jt.innerHTML=On,Ns=n(),wt=i("p"),wt.innerHTML=ea,vs=n(),bt=i("ul"),bt.innerHTML=ta,Zs=n(),Ct=i("p"),this.h()},l(e){const t=ra("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),It=a(e),gt=o(e,"P",{}),sa(gt).forEach(l),Rt=a(e),M(J.$$.fragment,e),kt=a(e),M(U.$$.fragment,e),Et=a(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1xlqnsv"&&(j.innerHTML=_s),Nt=a(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-5vl97w"&&(w.textContent=As),vt=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1460hpm"&&(b.innerHTML=Ws),Zt=a(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1g8xjnn"&&(f.textContent=Vs),Bt=a(e),g=o(e,"IMG",{src:!0,height:!0}),Gt=a(e),C=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(C)!=="svelte-1ypu0z8"&&(C.innerHTML=Qs),_t=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-5upzaq"&&(I.textContent=zs),At=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1e4x2to"&&(R.innerHTML=Xs),Wt=a(e),M(k.$$.fragment,e),Vt=a(e),M(E.$$.fragment,e),xt=a(e),M(N.$$.fragment,e),Qt=a(e),M(v.$$.fragment,e),zt=a(e),M(Z.$$.fragment,e),Xt=a(e),M(B.$$.fragment,e),St=a(e),M(G.$$.fragment,e),$t=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1cgegoz"&&(_.innerHTML=Ss),Ht=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-de3wl4"&&(A.textContent=$s),qt=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-pfz3xi"&&(W.innerHTML=Hs),Ft=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-9pws45"&&(V.innerHTML=qs),Yt=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-s89bs3"&&(x.innerHTML=Fs),Lt=a(e),Q=o(e,"UL",{"data-svelte-h":!0}),p(Q)!=="svelte-17bvglu"&&(Q.innerHTML=Ys),Pt=a(e),z=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(z)!=="svelte-vilhzk"&&(z.innerHTML=Ls),Dt=a(e),M(X.$$.fragment,e),Kt=a(e),S=o(e,"UL",{"data-svelte-h":!0}),p(S)!=="svelte-1i1nmq7"&&(S.innerHTML=Ps),Ot=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1cfvsgq"&&($.innerHTML=Ds),el=a(e),H=o(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-f2nwi9"&&(H.innerHTML=Ks),tl=a(e),q=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(q)!=="svelte-jl40ww"&&(q.innerHTML=Os),ll=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1a9w1td"&&(F.innerHTML=en),sl=a(e),Y=o(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-o9tjxj"&&(Y.innerHTML=tn),nl=a(e),M(L.$$.fragment,e),al=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1oqmm4c"&&(P.innerHTML=ln),il=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-p8hfve"&&(D.textContent=sn),ol=a(e),M(K.$$.fragment,e),pl=a(e),O=o(e,"PRE",{"data-svelte-h":!0}),p(O)!=="svelte-h6hpdk"&&(O.textContent=nn),rl=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1u0zp66"&&(ee.innerHTML=an),Ml=a(e),te=o(e,"UL",{"data-svelte-h":!0}),p(te)!=="svelte-1dgvkl"&&(te.innerHTML=on),cl=a(e),M(le.$$.fragment,e),ml=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1wkfpn7"&&(se.textContent=pn),ul=a(e),M(ne.$$.fragment,e),dl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-4rm0h0"&&(ae.innerHTML=rn),yl=a(e),M(ie.$$.fragment,e),hl=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-18hvug7"&&(oe.textContent=Mn),Tl=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-poib7"&&(pe.textContent=cn),Jl=a(e),M(re.$$.fragment,e),Ul=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1a62l1c"&&(Me.innerHTML=mn),jl=a(e),M(ce.$$.fragment,e),wl=a(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-19o59c4"&&(me.innerHTML=un),bl=a(e),ue=o(e,"UL",{"data-svelte-h":!0}),p(ue)!=="svelte-3yq871"&&(ue.innerHTML=dn),fl=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-9bv8uv"&&(de.innerHTML=yn),gl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1dn8cpx"&&(ye.innerHTML=hn),Cl=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1a80c74"&&(he.textContent=Tn),Il=a(e),M(Te.$$.fragment,e),Rl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1fnnff6"&&(Je.textContent=Jn),kl=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-18egjso"&&(Ue.innerHTML=Un),El=a(e),M(je.$$.fragment,e),Nl=a(e),M(we.$$.fragment,e),vl=a(e),M(be.$$.fragment,e),Zl=a(e),fe=o(e,"IMG",{src:!0,height:!0}),Bl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1ugaan7"&&(ge.textContent=wn),Gl=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1kkmgl0"&&(Ce.innerHTML=bn),_l=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1odqot8"&&(Ie.innerHTML=fn),Al=a(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-yo6uco"&&(Re.textContent=gn),Wl=a(e),M(ke.$$.fragment,e),Vl=a(e),Ee=o(e,"PRE",{"data-svelte-h":!0}),p(Ee)!=="svelte-1q4z1pg"&&(Ee.textContent=Cn),xl=a(e),M(Ne.$$.fragment,e),Ql=a(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1h9voqr"&&(ve.innerHTML=In),zl=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1jrsttj"&&(Ze.textContent=Rn),Xl=a(e),Be=o(e,"OL",{"data-svelte-h":!0}),p(Be)!=="svelte-1vegmii"&&(Be.innerHTML=kn),Sl=a(e),M(Ge.$$.fragment,e),$l=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1ybxulx"&&(_e.textContent=En),Hl=a(e),Ae=o(e,"UL",{"data-svelte-h":!0}),p(Ae)!=="svelte-8duvrk"&&(Ae.innerHTML=Nn),ql=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1fynfov"&&(We.innerHTML=vn),Fl=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-gklra8"&&(Ve.innerHTML=Zn),Yl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1bs26eu"&&(xe.textContent=Bn),Ll=a(e),M(Qe.$$.fragment,e),Pl=a(e),M(ze.$$.fragment,e),Dl=a(e),M(Xe.$$.fragment,e),Kl=a(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1wx4m3n"&&(Se.textContent=Gn),Ol=a(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1qxfgga"&&($e.textContent=_n),es=a(e),M(He.$$.fragment,e),ts=a(e),qe=o(e,"PRE",{"data-svelte-h":!0}),p(qe)!=="svelte-aa4a7a"&&(qe.textContent=An),ls=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-614ha4"&&(Fe.textContent=Wn),ss=a(e),M(Ye.$$.fragment,e),ns=a(e),Le=o(e,"PRE",{"data-svelte-h":!0}),p(Le)!=="svelte-lv1631"&&(Le.textContent=Vn),as=a(e),M(Pe.$$.fragment,e),is=a(e),De=o(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1sru2hu"&&(De.innerHTML=xn),os=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-1cssdsg"&&(Ke.innerHTML=Qn),ps=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-1uj89yq"&&(Oe.innerHTML=zn),rs=a(e),M(et.$$.fragment,e),Ms=a(e),M(tt.$$.fragment,e),cs=a(e),M(lt.$$.fragment,e),ms=a(e),st=o(e,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1g0apvv"&&(st.textContent=Xn),us=a(e),M(nt.$$.fragment,e),ds=a(e),at=o(e,"PRE",{"data-svelte-h":!0}),p(at)!=="svelte-drvpbm"&&(at.textContent=Sn),ys=a(e),M(it.$$.fragment,e),hs=a(e),ot=o(e,"PRE",{"data-svelte-h":!0}),p(ot)!=="svelte-8jp8ub"&&(ot.textContent=$n),Ts=a(e),pt=o(e,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-1mmnapg"&&(pt.textContent=Hn),Js=a(e),M(rt.$$.fragment,e),Us=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-lra2n0"&&(Mt.textContent=qn),js=a(e),M(ct.$$.fragment,e),ws=a(e),mt=o(e,"UL",{"data-svelte-h":!0}),p(mt)!=="svelte-2h1iks"&&(mt.innerHTML=Fn),bs=a(e),M(ut.$$.fragment,e),fs=a(e),dt=o(e,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-127rp0u"&&(dt.innerHTML=Yn),gs=a(e),yt=o(e,"UL",{"data-svelte-h":!0}),p(yt)!=="svelte-1w0jpt6"&&(yt.innerHTML=Ln),Cs=a(e),ht=o(e,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-1u0vmui"&&(ht.innerHTML=Pn),Is=a(e),Tt=o(e,"UL",{"data-svelte-h":!0}),p(Tt)!=="svelte-9v8l4l"&&(Tt.innerHTML=Dn),Rs=a(e),M(Jt.$$.fragment,e),ks=a(e),Ut=o(e,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-14us1de"&&(Ut.innerHTML=Kn),Es=a(e),jt=o(e,"UL",{"data-svelte-h":!0}),p(jt)!=="svelte-7re88b"&&(jt.innerHTML=On),Ns=a(e),wt=o(e,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-ly5dt2"&&(wt.innerHTML=ea),vs=a(e),bt=o(e,"UL",{"data-svelte-h":!0}),p(bt)!=="svelte-hrog46"&&(bt.innerHTML=ta),Zs=a(e),Ct=o(e,"P",{}),sa(Ct).forEach(l),this.h()},h(){ft(T,"name","hf:doc:metadata"),ft(T,"content",ua),la(g.src,xs="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/RAG_workflow.png")||ft(g,"src",xs),ft(g,"height","700"),la(fe.src,jn="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/PaCMAP_embeddings.png")||ft(fe,"src",jn),ft(fe,"height","700")},m(e,t){Ma(document.head,T),s(e,It,t),s(e,gt,t),s(e,Rt,t),c(J,e,t),s(e,kt,t),c(U,e,t),s(e,Et,t),s(e,j,t),s(e,Nt,t),s(e,w,t),s(e,vt,t),s(e,b,t),s(e,Zt,t),s(e,f,t),s(e,Bt,t),s(e,g,t),s(e,Gt,t),s(e,C,t),s(e,_t,t),s(e,I,t),s(e,At,t),s(e,R,t),s(e,Wt,t),c(k,e,t),s(e,Vt,t),c(E,e,t),s(e,xt,t),c(N,e,t),s(e,Qt,t),c(v,e,t),s(e,zt,t),c(Z,e,t),s(e,Xt,t),c(B,e,t),s(e,St,t),c(G,e,t),s(e,$t,t),s(e,_,t),s(e,Ht,t),s(e,A,t),s(e,qt,t),s(e,W,t),s(e,Ft,t),s(e,V,t),s(e,Yt,t),s(e,x,t),s(e,Lt,t),s(e,Q,t),s(e,Pt,t),s(e,z,t),s(e,Dt,t),c(X,e,t),s(e,Kt,t),s(e,S,t),s(e,Ot,t),s(e,$,t),s(e,el,t),s(e,H,t),s(e,tl,t),s(e,q,t),s(e,ll,t),s(e,F,t),s(e,sl,t),s(e,Y,t),s(e,nl,t),c(L,e,t),s(e,al,t),s(e,P,t),s(e,il,t),s(e,D,t),s(e,ol,t),c(K,e,t),s(e,pl,t),s(e,O,t),s(e,rl,t),s(e,ee,t),s(e,Ml,t),s(e,te,t),s(e,cl,t),c(le,e,t),s(e,ml,t),s(e,se,t),s(e,ul,t),c(ne,e,t),s(e,dl,t),s(e,ae,t),s(e,yl,t),c(ie,e,t),s(e,hl,t),s(e,oe,t),s(e,Tl,t),s(e,pe,t),s(e,Jl,t),c(re,e,t),s(e,Ul,t),s(e,Me,t),s(e,jl,t),c(ce,e,t),s(e,wl,t),s(e,me,t),s(e,bl,t),s(e,ue,t),s(e,fl,t),s(e,de,t),s(e,gl,t),s(e,ye,t),s(e,Cl,t),s(e,he,t),s(e,Il,t),c(Te,e,t),s(e,Rl,t),s(e,Je,t),s(e,kl,t),s(e,Ue,t),s(e,El,t),c(je,e,t),s(e,Nl,t),c(we,e,t),s(e,vl,t),c(be,e,t),s(e,Zl,t),s(e,fe,t),s(e,Bl,t),s(e,ge,t),s(e,Gl,t),s(e,Ce,t),s(e,_l,t),s(e,Ie,t),s(e,Al,t),s(e,Re,t),s(e,Wl,t),c(ke,e,t),s(e,Vl,t),s(e,Ee,t),s(e,xl,t),c(Ne,e,t),s(e,Ql,t),s(e,ve,t),s(e,zl,t),s(e,Ze,t),s(e,Xl,t),s(e,Be,t),s(e,Sl,t),c(Ge,e,t),s(e,$l,t),s(e,_e,t),s(e,Hl,t),s(e,Ae,t),s(e,ql,t),s(e,We,t),s(e,Fl,t),s(e,Ve,t),s(e,Yl,t),s(e,xe,t),s(e,Ll,t),c(Qe,e,t),s(e,Pl,t),c(ze,e,t),s(e,Dl,t),c(Xe,e,t),s(e,Kl,t),s(e,Se,t),s(e,Ol,t),s(e,$e,t),s(e,es,t),c(He,e,t),s(e,ts,t),s(e,qe,t),s(e,ls,t),s(e,Fe,t),s(e,ss,t),c(Ye,e,t),s(e,ns,t),s(e,Le,t),s(e,as,t),c(Pe,e,t),s(e,is,t),s(e,De,t),s(e,os,t),s(e,Ke,t),s(e,ps,t),s(e,Oe,t),s(e,rs,t),c(et,e,t),s(e,Ms,t),c(tt,e,t),s(e,cs,t),c(lt,e,t),s(e,ms,t),s(e,st,t),s(e,us,t),c(nt,e,t),s(e,ds,t),s(e,at,t),s(e,ys,t),c(it,e,t),s(e,hs,t),s(e,ot,t),s(e,Ts,t),s(e,pt,t),s(e,Js,t),c(rt,e,t),s(e,Us,t),s(e,Mt,t),s(e,js,t),c(ct,e,t),s(e,ws,t),s(e,mt,t),s(e,bs,t),c(ut,e,t),s(e,fs,t),s(e,dt,t),s(e,gs,t),s(e,yt,t),s(e,Cs,t),s(e,ht,t),s(e,Is,t),s(e,Tt,t),s(e,Rs,t),c(Jt,e,t),s(e,ks,t),s(e,Ut,t),s(e,Es,t),s(e,jt,t),s(e,Ns,t),s(e,wt,t),s(e,vs,t),s(e,bt,t),s(e,Zs,t),s(e,Ct,t),Bs=!0},p:aa,i(e){Bs||(m(J.$$.fragment,e),m(U.$$.fragment,e),m(k.$$.fragment,e),m(E.$$.fragment,e),m(N.$$.fragment,e),m(v.$$.fragment,e),m(Z.$$.fragment,e),m(B.$$.fragment,e),m(G.$$.fragment,e),m(X.$$.fragment,e),m(L.$$.fragment,e),m(K.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(ce.$$.fragment,e),m(Te.$$.fragment,e),m(je.$$.fragment,e),m(we.$$.fragment,e),m(be.$$.fragment,e),m(ke.$$.fragment,e),m(Ne.$$.fragment,e),m(Ge.$$.fragment,e),m(Qe.$$.fragment,e),m(ze.$$.fragment,e),m(Xe.$$.fragment,e),m(He.$$.fragment,e),m(Ye.$$.fragment,e),m(Pe.$$.fragment,e),m(et.$$.fragment,e),m(tt.$$.fragment,e),m(lt.$$.fragment,e),m(nt.$$.fragment,e),m(it.$$.fragment,e),m(rt.$$.fragment,e),m(ct.$$.fragment,e),m(ut.$$.fragment,e),m(Jt.$$.fragment,e),Bs=!0)},o(e){u(J.$$.fragment,e),u(U.$$.fragment,e),u(k.$$.fragment,e),u(E.$$.fragment,e),u(N.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(B.$$.fragment,e),u(G.$$.fragment,e),u(X.$$.fragment,e),u(L.$$.fragment,e),u(K.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(Te.$$.fragment,e),u(je.$$.fragment,e),u(we.$$.fragment,e),u(be.$$.fragment,e),u(ke.$$.fragment,e),u(Ne.$$.fragment,e),u(Ge.$$.fragment,e),u(Qe.$$.fragment,e),u(ze.$$.fragment,e),u(Xe.$$.fragment,e),u(He.$$.fragment,e),u(Ye.$$.fragment,e),u(Pe.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(lt.$$.fragment,e),u(nt.$$.fragment,e),u(it.$$.fragment,e),u(rt.$$.fragment,e),u(ct.$$.fragment,e),u(ut.$$.fragment,e),u(Jt.$$.fragment,e),Bs=!1},d(e){e&&(l(It),l(gt),l(Rt),l(kt),l(Et),l(j),l(Nt),l(w),l(vt),l(b),l(Zt),l(f),l(Bt),l(g),l(Gt),l(C),l(_t),l(I),l(At),l(R),l(Wt),l(Vt),l(xt),l(Qt),l(zt),l(Xt),l(St),l($t),l(_),l(Ht),l(A),l(qt),l(W),l(Ft),l(V),l(Yt),l(x),l(Lt),l(Q),l(Pt),l(z),l(Dt),l(Kt),l(S),l(Ot),l($),l(el),l(H),l(tl),l(q),l(ll),l(F),l(sl),l(Y),l(nl),l(al),l(P),l(il),l(D),l(ol),l(pl),l(O),l(rl),l(ee),l(Ml),l(te),l(cl),l(ml),l(se),l(ul),l(dl),l(ae),l(yl),l(hl),l(oe),l(Tl),l(pe),l(Jl),l(Ul),l(Me),l(jl),l(wl),l(me),l(bl),l(ue),l(fl),l(de),l(gl),l(ye),l(Cl),l(he),l(Il),l(Rl),l(Je),l(kl),l(Ue),l(El),l(Nl),l(vl),l(Zl),l(fe),l(Bl),l(ge),l(Gl),l(Ce),l(_l),l(Ie),l(Al),l(Re),l(Wl),l(Vl),l(Ee),l(xl),l(Ql),l(ve),l(zl),l(Ze),l(Xl),l(Be),l(Sl),l($l),l(_e),l(Hl),l(Ae),l(ql),l(We),l(Fl),l(Ve),l(Yl),l(xe),l(Ll),l(Pl),l(Dl),l(Kl),l(Se),l(Ol),l($e),l(es),l(ts),l(qe),l(ls),l(Fe),l(ss),l(ns),l(Le),l(as),l(is),l(De),l(os),l(Ke),l(ps),l(Oe),l(rs),l(Ms),l(cs),l(ms),l(st),l(us),l(ds),l(at),l(ys),l(hs),l(ot),l(Ts),l(pt),l(Js),l(Us),l(Mt),l(js),l(ws),l(mt),l(bs),l(fs),l(dt),l(gs),l(yt),l(Cs),l(ht),l(Is),l(Tt),l(Rs),l(ks),l(Ut),l(Es),l(jt),l(Ns),l(wt),l(vs),l(bt),l(Zs),l(Ct)),l(T),d(J,e),d(U,e),d(k,e),d(E,e),d(N,e),d(v,e),d(Z,e),d(B,e),d(G,e),d(X,e),d(L,e),d(K,e),d(le,e),d(ne,e),d(ie,e),d(re,e),d(ce,e),d(Te,e),d(je,e),d(we,e),d(be,e),d(ke,e),d(Ne,e),d(Ge,e),d(Qe,e),d(ze,e),d(Xe,e),d(He,e),d(Ye,e),d(Pe,e),d(et,e),d(tt,e),d(lt,e),d(nt,e),d(it,e),d(rt,e),d(ct,e),d(ut,e),d(Jt,e)}}}const ua='{"title":"Advanced RAG on HuggingFace documentation using langchain","local":"advanced-rag-on-huggingface-documentation-using-langchain","sections":[{"title":"Load your knowledge base","local":"load-your-knowledge-base","sections":[],"depth":3}],"depth":1}';function da(Gs){return ia(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ua extends oa{constructor(T){super(),pa(this,T,da,ma,na,{})}}export{Ua as component};
