import{s as _s,n as Ss,o as xs}from"../chunks/scheduler.39a43cde.js";import{S as Hs,i as qs,g as p,s as n,r as i,A as Xs,h as M,f as s,c as a,j as vs,u as o,x as u,k as Vs,y as Ys,a as l,v as d,d as j,t as m,w as r}from"../chunks/index.23ec2204.js";import{D as zs,C as c}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as h}from"../chunks/Heading.c42e7061.js";function Fs(ls){let y,Nt,Et,vt,w,Vt,T,_t,U,ns='<em>Authored by: <a href="https://huggingface.co/derek-thomas" rel="nofollow">Derek Thomas</a></em>',St,J,xt,g,as="I have a dataset I want to embed for semantic search (or QA, or RAG), I want the easiest way to do embed this and put it in a new dataset.",Ht,b,qt,f,ps='I’m using a dataset from my favorite subreddit <a href="https://www.reddit.com/r/bestofredditorupdates/" rel="nofollow">r/bestofredditorupdates</a>. Because it has long entries, I will use the new <a href="https://huggingface.co/jinaai/jina-embeddings-v2-base-en" rel="nofollow">jinaai/jina-embeddings-v2-base-en</a> since it has an 8k context length. I will deploy this using <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoint</a> to save time and money. To follow this tutorial, you will need to <strong>have already added a payment method</strong>. If you haven’t, you can add one here in <a href="https://huggingface.co/docs/hub/billing#billing" rel="nofollow">billing</a>. To make it even easier, I’ll make this fully API based.',Xt,I,is='To make this MUCH faster I will use the <a href="https://github.com/huggingface/text-embeddings-inference" rel="nofollow">Text Embeddings Inference</a> image. This has many benefits like:',Yt,A,Ms="<li>No model graph compilation step</li> <li>Small docker images and fast boot times. Get ready for true serverless!</li> <li>Token based dynamic batching</li> <li>Optimized transformers code for inference using Flash Attention, Candle and cuBLASLt</li> <li>Safetensors weight loading</li> <li>Production ready (distributed tracing with Open Telemetry, Prometheus metrics)</li>",zt,$,os='<img src="https://media.githubusercontent.com/media/huggingface/text-embeddings-inference/main/assets/bs1-tp.png" alt="img"/>',Ft,C,Lt,B,Dt,k,Pt,W,Kt,Z,Ot,G,ds=`<code>DATASET_IN</code> is where your text data is
<code>DATASET_OUT</code> is where your embeddings will be stored`,te,R,js="Note I used 5 for the <code>MAX_WORKERS</code> since <code>jina-embeddings-v2</code> are quite memory hungry.",ee,E,se,Q,ms="Hugging Face offers a number of GPUs that you can choose from a number of GPUs that you can choose in Inference Endpoints. Here they are in table form:",le,N,rs="<thead><tr><th>GPU</th> <th>instanceType</th> <th>instanceSize</th> <th>vRAM</th></tr></thead> <tbody><tr><td>1x Nvidia Tesla T4</td> <td>g4dn.xlarge</td> <td>small</td> <td>16GB</td></tr> <tr><td>4x Nvidia Tesla T4</td> <td>g4dn.12xlarge</td> <td>large</td> <td>64GB</td></tr> <tr><td>1x Nvidia A10G</td> <td>g5.2xlarge</td> <td>medium</td> <td>24GB</td></tr> <tr><td>4x Nvidia A10G</td> <td>g5.12xlarge</td> <td>xxlarge</td> <td>96GB</td></tr> <tr><td>1x Nvidia A100*</td> <td>p4de</td> <td>xlarge</td> <td>80GB</td></tr> <tr><td>2x Nvidia A100*</td> <td>p4de</td> <td>2xlarge</td> <td>160GB</td></tr></tbody>",ne,v,us="*Note that for A100s you might get a note to email us to get access.",ae,V,pe,_,ie,S,cs="Some users might have payment registered in an organization. This allows you to connect to an organization (that you are a member of) with a payment method.",Me,x,hs="Leave it blank is you want to use your username.",oe,H,de,q,je,X,me,Y,re,z,ue,F,ce,L,ys='We are going to use the <a href="https://huggingface.co/docs/inference-endpoints/api_reference" rel="nofollow">API</a> to create an <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoint</a>. This should provide a few main benefits:',he,D,ws="<li>It’s convenient (No clicking)</li> <li>It’s repeatable (We have the code to run it easily)</li> <li>It’s cheaper (No time spent waiting for it to load, and automatically shut it down)</li>",ye,P,we,K,Ts="There are a few design choices here:",Te,O,Us='<li>As discussed before we are using <code>jinaai/jina-embeddings-v2-base-en</code> as our model. <ul><li>For reproducibility we are pinning it to a specific revision.</li></ul></li> <li>If you are interested in more models, check out the supported list <a href="https://huggingface.co/docs/text-embeddings-inference/supported_models" rel="nofollow">here</a>. <ul><li>Note that most embedding models are based on the BERT architecture.</li></ul></li> <li><code>MAX_BATCH_TOKENS</code> is chosen based on our number of workers and the context window of our embedding model.</li> <li><code>type=&quot;protected&quot;</code> utilized the security from Inference Endpoints detailed here.</li> <li>I’m using <strong>1x Nvidia A10</strong> since <code>jina-embeddings-v2</code> is memory hungry (remember the 8k context length).</li> <li>You should consider further tuning <code>MAX_BATCH_TOKENS</code> and <code>MAX_CONCURRENT_REQUESTS</code> if you have high workloads</li>',Ue,tt,Je,et,ge,st,Js=`CPU times: user 48.1 ms, sys: 15.7 ms, total: 63.8 ms
Wall time: 52.6 s
`,be,lt,gs="When we use <code>endpoint.client.post</code> we get a bytes string back. This is a little tedious because we need to convert this to an <code>np.array</code>, but it’s just a couple quick lines in python.",fe,nt,Ie,at,bs="You may have inputs that exceed the context. In such scenarios, it’s up to you to handle them. In my case, I’d like to truncate rather than have an error. Let’s test that it works.",Ae,pt,$e,it,fs=`The length of the embedding_input is: 300000
`,Ce,Mt,Be,ot,Is="Here I send a document, update it with the embedding, and return it. This happens in parallel with <code>MAX_WORKERS</code>.",ke,dt,We,jt,Ze,mt,As=`Embeddings = 100 documents = 100
0 min 21.33 sec
`,Ge,rt,Re,ut,$s="Now that we have finished, let’s pause the endpoint so we don’t incur any extra charges, this will also allow us to analyze the cost.",Ee,ct,Qe,ht,Cs=`Endpoint Status: paused
`,Ne,yt,ve,wt,Bs="We now have our documents updated with the embeddings we wanted. First we need to convert it back to a <code>Dataset</code> format. I find it easiest to go from list of dicts -&gt; <code>pd.DataFrame</code> -&gt; <code>Dataset</code>",Ve,Tt,_e,Ut,ks="I’m uploading it to the user’s account by default (as opposed to uploading to an organization) but feel free to push to wherever you want by setting the user in the <code>repo_id</code> or in the config by setting <code>DATASET_OUT</code>",Se,Jt,xe,gt,He,bt,Ws=`Dataset is at https://huggingface.co/datasets/derek-thomas/processed-subset-bestofredditorupdates
`,qe,ft,Xe,It,Zs="<li>Go to your <code>dashboard_url</code> printed below</li> <li>Click on the Usage &amp; Cost tab</li> <li>See how much you have spent</li>",Ye,At,ze,$t,Gs=`https://ui.endpoints.huggingface.co/HF-test-lab/endpoints/boru-jina-embeddings-demo-ie
`,Fe,Ct,Le,Bt,Rs="We can see that it only took <code>$0.04</code> to pay for this!",De,kt,Pe,Wt,Es="Now that we are done, we don’t need our endpoint anymore. We can delete our endpoint programmatically.",Ke,Zt,Qs='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/automatic_embedding_tei_inference_endpoints.png" alt="Cost"/>',Oe,Gt,ts,Rt,Ns=`Endpoint deleted successfully
`,es,Qt,ss;return w=new zs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/automatic_embedding_tei_inference_endpoints.ipynb"}]}}),T=new h({props:{title:"How to use Inference Endpoints to Embed Documents",local:"how-to-use-inference-endpoints-to-embed-documents",headingTag:"h1"}}),J=new h({props:{title:"Goal",local:"goal",headingTag:"h2"}}),b=new h({props:{title:"Approach",local:"approach",headingTag:"h2"}}),C=new h({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),B=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGFpb2h0dHAlM0QlM0QzLjguMyUyMGRhdGFzZXRzJTNEJTNEMi4xNC42JTIwcGFuZGFzJTNEJTNEMS41LjMlMjByZXF1ZXN0cyUzRCUzRDIuMzEuMCUyMHRxZG0lM0QlM0Q0LjY2LjElMjBodWdnaW5nZmFjZS1odWIlM0UlM0QwLjIw",highlighted:'!pip install -q aiohttp==<span class="hljs-number">3.8</span><span class="hljs-number">.3</span> datasets==<span class="hljs-number">2.14</span><span class="hljs-number">.6</span> pandas==<span class="hljs-number">1.5</span><span class="hljs-number">.3</span> requests==<span class="hljs-number">2.31</span><span class="hljs-number">.0</span> tqdm==<span class="hljs-number">4.66</span><span class="hljs-number">.1</span> huggingface-hub&gt;=<span class="hljs-number">0.20</span>',wrap:!1}}),k=new h({props:{title:"Imports",local:"imports",headingTag:"h2"}}),W=new c({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBnZXRwYXNzJTIwaW1wb3J0JTIwZ2V0cGFzcyUwQWltcG9ydCUyMGpzb24lMEFmcm9tJTIwcGF0aGxpYiUyMGltcG9ydCUyMFBhdGglMEFpbXBvcnQlMjB0aW1lJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyME9wdGlvbmFsJTBBJTBBZnJvbSUyMGFpb2h0dHAlMjBpbXBvcnQlMjBDbGllbnRTZXNzaW9uJTJDJTIwQ2xpZW50VGltZW91dCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUyQyUyMERhdGFzZXQlMkMlMjBEYXRhc2V0RGljdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBub3RlYm9va19sb2dpbiUyQyUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMkMlMjB3aG9hbWklMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHFkbS5hdXRvJTIwaW1wb3J0JTIwdHFkbQ==",highlighted:`<span class="hljs-keyword">import</span> asyncio
<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">from</span> aiohttp <span class="hljs-keyword">import</span> ClientSession, ClientTimeout
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Dataset, DatasetDict
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login, create_inference_endpoint, list_inference_endpoints, whoami
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm`,wrap:!1}}),Z=new h({props:{title:"Config",local:"config",headingTag:"h2"}}),E=new c({props:{code:"REFUQVNFVF9JTiUyMCUzRCUyMCUyMmRlcmVrLXRob21hcyUyRmRhdGFzZXQtY3JlYXRvci1yZWRkaXQtYmVzdG9mcmVkZGl0b3J1cGRhdGVzJTIyJTBBREFUQVNFVF9PVVQlMjAlM0QlMjAlMjJwcm9jZXNzZWQtc3Vic2V0LWJlc3RvZnJlZGRpdG9ydXBkYXRlcyUyMiUwQUVORFBPSU5UX05BTUUlMjAlM0QlMjAlMjJib3J1LWppbmEtZW1iZWRkaW5ncy1kZW1vLWllJTIyJTBBJTBBTUFYX1dPUktFUlMlMjAlM0QlMjA1JTIwJTIwJTIzJTIwVGhpcyUyMGlzJTIwZm9yJTIwaG93JTIwbWFueSUyMGFzeW5jJTIwd29ya2VycyUyMHlvdSUyMHdhbnQuJTIwQ2hvb3NlJTIwYmFzZWQlMjBvbiUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwaGFyZHdhcmUlMEFST1dfQ09VTlQlMjAlM0QlMjAxMDAlMjAlMjAlMjMlMjBDaG9vc2UlMjBOb25lJTIwdG8lMjB1c2UlMjBhbGwlMjByb3dzJTJDJTIwSW0lMjB1c2luZyUyMDEwMCUyMGp1c3QlMjBmb3IlMjBhJTIwZGVtbw==",highlighted:`DATASET_IN = <span class="hljs-string">&quot;derek-thomas/dataset-creator-reddit-bestofredditorupdates&quot;</span>
DATASET_OUT = <span class="hljs-string">&quot;processed-subset-bestofredditorupdates&quot;</span>
ENDPOINT_NAME = <span class="hljs-string">&quot;boru-jina-embeddings-demo-ie&quot;</span>

MAX_WORKERS = <span class="hljs-number">5</span>  <span class="hljs-comment"># This is for how many async workers you want. Choose based on the model and hardware</span>
ROW_COUNT = <span class="hljs-number">100</span>  <span class="hljs-comment"># Choose None to use all rows, Im using 100 just for a demo</span>`,wrap:!1}}),V=new c({props:{code:"JTIzJTIwR1BVJTIwQ2hvaWNlJTBBVkVORE9SJTIwJTNEJTIwJTIyYXdzJTIyJTBBUkVHSU9OJTIwJTNEJTIwJTIydXMtZWFzdC0xJTIyJTBBSU5TVEFOQ0VfU0laRSUyMCUzRCUyMCUyMm1lZGl1bSUyMiUwQUlOU1RBTkNFX1RZUEUlMjAlM0QlMjAlMjJnNS4yeGxhcmdlJTIy",highlighted:`<span class="hljs-comment"># GPU Choice</span>
VENDOR = <span class="hljs-string">&quot;aws&quot;</span>
REGION = <span class="hljs-string">&quot;us-east-1&quot;</span>
INSTANCE_SIZE = <span class="hljs-string">&quot;medium&quot;</span>
INSTANCE_TYPE = <span class="hljs-string">&quot;g5.2xlarge&quot;</span>`,wrap:!1}}),_=new c({props:{code:"bm90ZWJvb2tfbG9naW4oKQ==",highlighted:"notebook_login()",wrap:!1}}),H=new c({props:{code:"d2hvJTIwJTNEJTIwd2hvYW1pKCklMEFvcmdhbml6YXRpb24lMjAlM0QlMjBnZXRwYXNzKHByb21wdCUzRCUyMldoYXQlMjBpcyUyMHlvdXIlMjBIdWdnaW5nJTIwRmFjZSUyMCVGMCU5RiVBNCU5NyUyMHVzZXJuYW1lJTIwb3IlMjBvcmdhbml6YXRpb24lM0YlMjAod2l0aCUyMGFuJTIwYWRkZWQlMjBwYXltZW50JTIwbWV0aG9kKSUyMiklMEElMEFuYW1lc3BhY2UlMjAlM0QlMjBvcmdhbml6YXRpb24lMjBvciUyMHdobyU1QiUyMm5hbWUlMjIlNUQ=",highlighted:`who = whoami()
organization = getpass(prompt=<span class="hljs-string">&quot;What is your Hugging Face 🤗 username or organization? (with an added payment method)&quot;</span>)

namespace = organization <span class="hljs-keyword">or</span> who[<span class="hljs-string">&quot;name&quot;</span>]`,wrap:!1}}),q=new h({props:{title:"Get Dataset",local:"get-dataset",headingTag:"h2"}}),X=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldChEQVRBU0VUX0lOKSUwQWRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RA==",highlighted:`dataset = load_dataset(DATASET_IN)
dataset[<span class="hljs-string">&quot;train&quot;</span>]`,wrap:!1}}),Y=new c({props:{code:"ZG9jdW1lbnRzJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELnRvX3BhbmRhcygpLnRvX2RpY3QoJTIycmVjb3JkcyUyMiklNUIlM0FST1dfQ09VTlQlNUQlMEFsZW4oZG9jdW1lbnRzKSUyQyUyMGRvY3VtZW50cyU1QjAlNUQ=",highlighted:`documents = dataset[<span class="hljs-string">&quot;train&quot;</span>].to_pandas().to_dict(<span class="hljs-string">&quot;records&quot;</span>)[:ROW_COUNT]
<span class="hljs-built_in">len</span>(documents), documents[<span class="hljs-number">0</span>]`,wrap:!1}}),z=new h({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),F=new h({props:{title:"Create Inference Endpoint",local:"create-inference-endpoint",headingTag:"h2"}}),P=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">try</span>:
    endpoint = create_inference_endpoint(
        ENDPOINT_NAME,
        repository=<span class="hljs-string">&quot;jinaai/jina-embeddings-v2-base-en&quot;</span>,
        revision=<span class="hljs-string">&quot;7302ac470bed880590f9344bfeee32ff8722d0e5&quot;</span>,
        task=<span class="hljs-string">&quot;sentence-embeddings&quot;</span>,
        framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
        accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
        instance_size=INSTANCE_SIZE,
        instance_type=INSTANCE_TYPE,
        region=REGION,
        vendor=VENDOR,
        namespace=namespace,
        custom_image={
            <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
            <span class="hljs-string">&quot;env&quot;</span>: {
                <span class="hljs-string">&quot;MAX_BATCH_TOKENS&quot;</span>: <span class="hljs-built_in">str</span>(MAX_WORKERS * <span class="hljs-number">2048</span>),
                <span class="hljs-string">&quot;MAX_CONCURRENT_REQUESTS&quot;</span>: <span class="hljs-string">&quot;512&quot;</span>,
                <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>,
            },
            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-embeddings-inference:0.5.0&quot;</span>,
        },
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
    )
<span class="hljs-keyword">except</span>:
    endpoint = [ie <span class="hljs-keyword">for</span> ie <span class="hljs-keyword">in</span> list_inference_endpoints(namespace=namespace) <span class="hljs-keyword">if</span> ie.name == ENDPOINT_NAME][<span class="hljs-number">0</span>]
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loaded endpoint&quot;</span>)`,wrap:!1}}),tt=new h({props:{title:"Wait until it’s running",local:"wait-until-its-running",headingTag:"h2"}}),et=new c({props:{code:"JTI1JTI1dGltZSUwQWVuZHBvaW50LndhaXQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>%%time
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()`,wrap:!1}}),nt=new c({props:{code:"cmVzcG9uc2UlMjAlM0QlMjBlbmRwb2ludC5jbGllbnQucG9zdCglMEElMjAlMjAlMjAlMjBqc29uJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRydW5jYXRlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMEEpJTBBcmVzcG9uc2UlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3BvbnNlLmRlY29kZSgpKSklMEFyZXNwb25zZSU1QjAlNUQlNUIlM0EyMCU1RA==",highlighted:`response = endpoint.client.post(
    json={
        <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it even to people who hate vid. game music!&quot;</span>,
        <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>,
    },
    task=<span class="hljs-string">&quot;feature-extraction&quot;</span>,
)
response = np.array(json.loads(response.decode()))
response[<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]`,wrap:!1}}),pt=new c({props:{code:"ZW1iZWRkaW5nX2lucHV0JTIwJTNEJTIwJTIyVGhpcyUyMGlucHV0JTIwd2lsbCUyMGdldCUyMG11bHRpcGxpZWQlMjIlMjAqJTIwMTAwMDAlMEFwcmludChmJTIyVGhlJTIwbGVuZ3RoJTIwb2YlMjB0aGUlMjBlbWJlZGRpbmdfaW5wdXQlMjBpcyUzQSUyMCU3QmxlbihlbWJlZGRpbmdfaW5wdXQpJTdEJTIyKSUwQXJlc3BvbnNlJTIwJTNEJTIwZW5kcG9pbnQuY2xpZW50LnBvc3QoanNvbiUzRCU3QiUyMmlucHV0cyUyMiUzQSUyMGVtYmVkZGluZ19pbnB1dCUyQyUyMCUyMnRydW5jYXRlJTIyJTNBJTIwVHJ1ZSU3RCUyQyUyMHRhc2slM0QlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIpJTBBcmVzcG9uc2UlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3BvbnNlLmRlY29kZSgpKSklMEFyZXNwb25zZSU1QjAlNUQlNUIlM0EyMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_input = <span class="hljs-string">&quot;This input will get multiplied&quot;</span> * <span class="hljs-number">10000</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;The length of the embedding_input is: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(embedding_input)}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = endpoint.client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: embedding_input, <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = np.array(json.loads(response.decode()))
<span class="hljs-meta">&gt;&gt;&gt; </span>response[<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]`,wrap:!1}}),Mt=new h({props:{title:"Get Embeddings",local:"get-embeddings",headingTag:"h1"}}),dt=new c({props:{code:"YXN5bmMlMjBkZWYlMjByZXF1ZXN0KGRvY3VtZW50JTJDJTIwc2VtYXBob3JlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNlbWFwaG9yZSUyMGd1YXJkJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjB3aXRoJTIwc2VtYXBob3JlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQucG9zdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwZG9jdW1lbnQlNUIlMjJjb250ZW50JTIyJTVEJTJDJTIwJTIydHJ1bmNhdGUlMjIlM0ElMjBUcnVlJTdEJTJDJTIwdGFzayUzRCUyMmZlYXR1cmUtZXh0cmFjdGlvbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3VsdC5kZWNvZGUoKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9jdW1lbnQlNUIlMjJlbWJlZGRpbmclMjIlNUQlMjAlM0QlMjByZXN1bHQlNUIwJTVEJTIwJTIwJTIzJTIwQXNzdW1pbmclMjB0aGUlMjBBUEkncyUyMG91dHB1dCUyMGNhbiUyMGJlJTIwZGlyZWN0bHklMjBhc3NpZ25lZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGRvY3VtZW50JTBBJTBBJTBBYXN5bmMlMjBkZWYlMjBtYWluKGRvY3VtZW50cyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBTZW1hcGhvcmUlMjB0byUyMGxpbWl0JTIwY29uY3VycmVudCUyMHJlcXVlc3RzLiUyMEFkanVzdCUyMHRoZSUyMG51bWJlciUyMGFzJTIwbmVlZGVkLiUwQSUyMCUyMCUyMCUyMHNlbWFwaG9yZSUyMCUzRCUyMGFzeW5jaW8uQm91bmRlZFNlbWFwaG9yZShNQVhfV09SS0VSUyklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDcmVhdGluZyUyMGElMjBsaXN0JTIwb2YlMjB0YXNrcyUwQSUyMCUyMCUyMCUyMHRhc2tzJTIwJTNEJTIwJTVCcmVxdWVzdChkb2N1bWVudCUyQyUyMHNlbWFwaG9yZSklMjBmb3IlMjBkb2N1bWVudCUyMGluJTIwZG9jdW1lbnRzJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNpbmclMjB0cWRtJTIwdG8lMjBzaG93JTIwcHJvZ3Jlc3MuJTIwSXQncyUyMGJlZW4lMjBpbnRlZ3JhdGVkJTIwaW50byUyMHRoZSUyMGFzeW5jJTIwbG9vcC4lMEElMjAlMjAlMjAlMjBmb3IlMjBmJTIwaW4lMjB0cWRtKGFzeW5jaW8uYXNfY29tcGxldGVkKHRhc2tzKSUyQyUyMHRvdGFsJTNEbGVuKGRvY3VtZW50cykpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXdhaXQlMjBm",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">request</span>(<span class="hljs-params">document, semaphore</span>):
    <span class="hljs-comment"># Semaphore guard</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">with</span> semaphore:
        result = <span class="hljs-keyword">await</span> endpoint.async_client.post(
            json={<span class="hljs-string">&quot;inputs&quot;</span>: document[<span class="hljs-string">&quot;content&quot;</span>], <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>
        )
        result = np.array(json.loads(result.decode()))
        document[<span class="hljs-string">&quot;embedding&quot;</span>] = result[<span class="hljs-number">0</span>]  <span class="hljs-comment"># Assuming the API&#x27;s output can be directly assigned</span>
        <span class="hljs-keyword">return</span> document


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>(<span class="hljs-params">documents</span>):
    <span class="hljs-comment"># Semaphore to limit concurrent requests. Adjust the number as needed.</span>
    semaphore = asyncio.BoundedSemaphore(MAX_WORKERS)

    <span class="hljs-comment"># Creating a list of tasks</span>
    tasks = [request(document, semaphore) <span class="hljs-keyword">for</span> document <span class="hljs-keyword">in</span> documents]

    <span class="hljs-comment"># Using tqdm to show progress. It&#x27;s been integrated into the async loop.</span>
    <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> tqdm(asyncio.as_completed(tasks), total=<span class="hljs-built_in">len</span>(documents)):
        <span class="hljs-keyword">await</span> f`,wrap:!1}}),jt=new c({props:{code:"c3RhcnQlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTBBJTBBJTIzJTIwR2V0JTIwZW1iZWRkaW5ncyUwQWF3YWl0JTIwbWFpbihkb2N1bWVudHMpJTBBJTBBJTIzJTIwTWFrZSUyMHN1cmUlMjB3ZSUyMGdvdCUyMGl0JTIwYWxsJTBBY291bnQlMjAlM0QlMjAwJTBBZm9yJTIwZG9jdW1lbnQlMjBpbiUyMGRvY3VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwJTIyZW1iZWRkaW5nJTIyJTIwaW4lMjBkb2N1bWVudC5rZXlzKCklMjBhbmQlMjBsZW4oZG9jdW1lbnQlNUIlMjJlbWJlZGRpbmclMjIlNUQpJTIwJTNEJTNEJTIwNzY4JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY291bnQlMjAlMkIlM0QlMjAxJTBBcHJpbnQoZiUyMkVtYmVkZGluZ3MlMjAlM0QlMjAlN0Jjb3VudCU3RCUyMGRvY3VtZW50cyUyMCUzRCUyMCU3Qmxlbihkb2N1bWVudHMpJTdEJTIyKSUwQSUwQSUwQSUyMyUyMFByaW50JTIwZWxhcHNlZCUyMHRpbWUlMEFlbGFwc2VkX3RpbWUlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTIwLSUyMHN0YXJ0JTBBbWludXRlcyUyQyUyMHNlY29uZHMlMjAlM0QlMjBkaXZtb2QoZWxhcHNlZF90aW1lJTJDJTIwNjApJTBBcHJpbnQoZiUyMiU3QmludChtaW51dGVzKSU3RCUyMG1pbiUyMCU3QnNlY29uZHMlM0EuMmYlN0QlMjBzZWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>start = time.perf_counter()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> main(documents)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Make sure we got it all</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>count = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> document <span class="hljs-keyword">in</span> documents:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;embedding&quot;</span> <span class="hljs-keyword">in</span> document.keys() <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(document[<span class="hljs-string">&quot;embedding&quot;</span>]) == <span class="hljs-number">768</span>:
<span class="hljs-meta">... </span>        count += <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Embeddings = <span class="hljs-subst">{count}</span> documents = <span class="hljs-subst">{<span class="hljs-built_in">len</span>(documents)}</span>&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print elapsed time</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>elapsed_time = time.perf_counter() - start
<span class="hljs-meta">&gt;&gt;&gt; </span>minutes, seconds = <span class="hljs-built_in">divmod</span>(elapsed_time, <span class="hljs-number">60</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">int</span>(minutes)}</span> min <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> sec&quot;</span>)`,wrap:!1}}),rt=new h({props:{title:"Pause Inference Endpoint",local:"pause-inference-endpoint",headingTag:"h2"}}),ct=new c({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBlbmRwb2ludC5wYXVzZSgpJTBBJTBBcHJpbnQoZiUyMkVuZHBvaW50JTIwU3RhdHVzJTNBJTIwJTdCZW5kcG9pbnQuc3RhdHVzJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = endpoint.pause()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Endpoint Status: <span class="hljs-subst">{endpoint.status}</span>&quot;</span>)`,wrap:!1}}),yt=new h({props:{title:"Push updated dataset to Hub",local:"push-updated-dataset-to-hub",headingTag:"h1"}}),Tt=new c({props:{code:"ZGYlMjAlM0QlMjBwZC5EYXRhRnJhbWUoZG9jdW1lbnRzKSUwQWRkJTIwJTNEJTIwRGF0YXNldERpY3QoJTdCJTIydHJhaW4lMjIlM0ElMjBEYXRhc2V0LmZyb21fcGFuZGFzKGRmKSU3RCk=",highlighted:`df = pd.DataFrame(documents)
dd = DatasetDict({<span class="hljs-string">&quot;train&quot;</span>: Dataset.from_pandas(df)})`,wrap:!1}}),Jt=new c({props:{code:"ZGQucHVzaF90b19odWIocmVwb19pZCUzRERBVEFTRVRfT1VUKQ==",highlighted:"dd.push_to_hub(repo_id=DATASET_OUT)",wrap:!1}}),gt=new c({props:{code:"cHJpbnQoZidEYXRhc2V0JTIwaXMlMjBhdCUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRiU3QndobyU1QiUyMm5hbWUlMjIlNUQlN0QlMkYlN0JEQVRBU0VUX09VVCU3RCcp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Dataset is at https://huggingface.co/datasets/<span class="hljs-subst">{who[<span class="hljs-string">&quot;name&quot;</span>]}</span>/<span class="hljs-subst">{DATASET_OUT}</span>&#x27;</span>)',wrap:!1}}),ft=new h({props:{title:"Analyze Usage",local:"analyze-usage",headingTag:"h1"}}),At=new c({props:{code:"ZGFzaGJvYXJkX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRnVpLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbyUyRiU3Qm5hbWVzcGFjZSU3RCUyRmVuZHBvaW50cyUyRiU3QkVORFBPSU5UX05BTUUlN0QlMjIlMEFwcmludChkYXNoYm9hcmRfdXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dashboard_url = <span class="hljs-string">f&quot;https://ui.endpoints.huggingface.co/<span class="hljs-subst">{namespace}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_NAME}</span>&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dashboard_url)`,wrap:!1}}),Ct=new c({props:{code:"aW5wdXQoJTIySGl0JTIwZW50ZXIlMjB0byUyMGNvbnRpbnVlJTIwd2l0aCUyMHRoZSUyMG5vdGVib29rJTIyKQ==",highlighted:'<span class="hljs-built_in">input</span>(<span class="hljs-string">&quot;Hit enter to continue with the notebook&quot;</span>)',wrap:!1}}),kt=new h({props:{title:"Delete Endpoint",local:"delete-endpoint",headingTag:"h1"}}),Gt=new c({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBlbmRwb2ludC5kZWxldGUoKSUwQSUwQWlmJTIwbm90JTIwZW5kcG9pbnQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJFbmRwb2ludCUyMGRlbGV0ZWQlMjBzdWNjZXNzZnVsbHklMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkRlbGV0ZSUyMEVuZHBvaW50JTIwaW4lMjBtYW51YWxseSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = endpoint.delete()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> endpoint:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint deleted successfully&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Delete Endpoint in manually&quot;</span>)`,wrap:!1}}),{c(){y=p("meta"),Nt=n(),Et=p("p"),vt=n(),i(w.$$.fragment),Vt=n(),i(T.$$.fragment),_t=n(),U=p("p"),U.innerHTML=ns,St=n(),i(J.$$.fragment),xt=n(),g=p("p"),g.textContent=as,Ht=n(),i(b.$$.fragment),qt=n(),f=p("p"),f.innerHTML=ps,Xt=n(),I=p("p"),I.innerHTML=is,Yt=n(),A=p("ul"),A.innerHTML=Ms,zt=n(),$=p("p"),$.innerHTML=os,Ft=n(),i(C.$$.fragment),Lt=n(),i(B.$$.fragment),Dt=n(),i(k.$$.fragment),Pt=n(),i(W.$$.fragment),Kt=n(),i(Z.$$.fragment),Ot=n(),G=p("p"),G.innerHTML=ds,te=n(),R=p("p"),R.innerHTML=js,ee=n(),i(E.$$.fragment),se=n(),Q=p("p"),Q.textContent=ms,le=n(),N=p("table"),N.innerHTML=rs,ne=n(),v=p("p"),v.textContent=us,ae=n(),i(V.$$.fragment),pe=n(),i(_.$$.fragment),ie=n(),S=p("p"),S.textContent=cs,Me=n(),x=p("p"),x.textContent=hs,oe=n(),i(H.$$.fragment),de=n(),i(q.$$.fragment),je=n(),i(X.$$.fragment),me=n(),i(Y.$$.fragment),re=n(),i(z.$$.fragment),ue=n(),i(F.$$.fragment),ce=n(),L=p("p"),L.innerHTML=ys,he=n(),D=p("ul"),D.innerHTML=ws,ye=n(),i(P.$$.fragment),we=n(),K=p("p"),K.textContent=Ts,Te=n(),O=p("ul"),O.innerHTML=Us,Ue=n(),i(tt.$$.fragment),Je=n(),i(et.$$.fragment),ge=n(),st=p("pre"),st.textContent=Js,be=n(),lt=p("p"),lt.innerHTML=gs,fe=n(),i(nt.$$.fragment),Ie=n(),at=p("p"),at.textContent=bs,Ae=n(),i(pt.$$.fragment),$e=n(),it=p("pre"),it.textContent=fs,Ce=n(),i(Mt.$$.fragment),Be=n(),ot=p("p"),ot.innerHTML=Is,ke=n(),i(dt.$$.fragment),We=n(),i(jt.$$.fragment),Ze=n(),mt=p("pre"),mt.textContent=As,Ge=n(),i(rt.$$.fragment),Re=n(),ut=p("p"),ut.textContent=$s,Ee=n(),i(ct.$$.fragment),Qe=n(),ht=p("pre"),ht.textContent=Cs,Ne=n(),i(yt.$$.fragment),ve=n(),wt=p("p"),wt.innerHTML=Bs,Ve=n(),i(Tt.$$.fragment),_e=n(),Ut=p("p"),Ut.innerHTML=ks,Se=n(),i(Jt.$$.fragment),xe=n(),i(gt.$$.fragment),He=n(),bt=p("pre"),bt.textContent=Ws,qe=n(),i(ft.$$.fragment),Xe=n(),It=p("ol"),It.innerHTML=Zs,Ye=n(),i(At.$$.fragment),ze=n(),$t=p("pre"),$t.textContent=Gs,Fe=n(),i(Ct.$$.fragment),Le=n(),Bt=p("p"),Bt.innerHTML=Rs,De=n(),i(kt.$$.fragment),Pe=n(),Wt=p("p"),Wt.textContent=Es,Ke=n(),Zt=p("p"),Zt.innerHTML=Qs,Oe=n(),i(Gt.$$.fragment),ts=n(),Rt=p("pre"),Rt.textContent=Ns,es=n(),Qt=p("p"),this.h()},l(t){const e=Xs("svelte-u9bgzb",document.head);y=M(e,"META",{name:!0,content:!0}),e.forEach(s),Nt=a(t),Et=M(t,"P",{}),vs(Et).forEach(s),vt=a(t),o(w.$$.fragment,t),Vt=a(t),o(T.$$.fragment,t),_t=a(t),U=M(t,"P",{"data-svelte-h":!0}),u(U)!=="svelte-kkdsiw"&&(U.innerHTML=ns),St=a(t),o(J.$$.fragment,t),xt=a(t),g=M(t,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1qwdsg4"&&(g.textContent=as),Ht=a(t),o(b.$$.fragment,t),qt=a(t),f=M(t,"P",{"data-svelte-h":!0}),u(f)!=="svelte-cznpu6"&&(f.innerHTML=ps),Xt=a(t),I=M(t,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1bpd7g5"&&(I.innerHTML=is),Yt=a(t),A=M(t,"UL",{"data-svelte-h":!0}),u(A)!=="svelte-amjqu"&&(A.innerHTML=Ms),zt=a(t),$=M(t,"P",{"data-svelte-h":!0}),u($)!=="svelte-12ly3c2"&&($.innerHTML=os),Ft=a(t),o(C.$$.fragment,t),Lt=a(t),o(B.$$.fragment,t),Dt=a(t),o(k.$$.fragment,t),Pt=a(t),o(W.$$.fragment,t),Kt=a(t),o(Z.$$.fragment,t),Ot=a(t),G=M(t,"P",{"data-svelte-h":!0}),u(G)!=="svelte-roo1xs"&&(G.innerHTML=ds),te=a(t),R=M(t,"P",{"data-svelte-h":!0}),u(R)!=="svelte-10xqojr"&&(R.innerHTML=js),ee=a(t),o(E.$$.fragment,t),se=a(t),Q=M(t,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1gpfxhe"&&(Q.textContent=ms),le=a(t),N=M(t,"TABLE",{"data-svelte-h":!0}),u(N)!=="svelte-e98cgk"&&(N.innerHTML=rs),ne=a(t),v=M(t,"P",{"data-svelte-h":!0}),u(v)!=="svelte-a1rv50"&&(v.textContent=us),ae=a(t),o(V.$$.fragment,t),pe=a(t),o(_.$$.fragment,t),ie=a(t),S=M(t,"P",{"data-svelte-h":!0}),u(S)!=="svelte-1oubx8o"&&(S.textContent=cs),Me=a(t),x=M(t,"P",{"data-svelte-h":!0}),u(x)!=="svelte-13so4pe"&&(x.textContent=hs),oe=a(t),o(H.$$.fragment,t),de=a(t),o(q.$$.fragment,t),je=a(t),o(X.$$.fragment,t),me=a(t),o(Y.$$.fragment,t),re=a(t),o(z.$$.fragment,t),ue=a(t),o(F.$$.fragment,t),ce=a(t),L=M(t,"P",{"data-svelte-h":!0}),u(L)!=="svelte-8d5fhe"&&(L.innerHTML=ys),he=a(t),D=M(t,"UL",{"data-svelte-h":!0}),u(D)!=="svelte-16ejamp"&&(D.innerHTML=ws),ye=a(t),o(P.$$.fragment,t),we=a(t),K=M(t,"P",{"data-svelte-h":!0}),u(K)!=="svelte-1whwkpr"&&(K.textContent=Ts),Te=a(t),O=M(t,"UL",{"data-svelte-h":!0}),u(O)!=="svelte-9i31ws"&&(O.innerHTML=Us),Ue=a(t),o(tt.$$.fragment,t),Je=a(t),o(et.$$.fragment,t),ge=a(t),st=M(t,"PRE",{"data-svelte-h":!0}),u(st)!=="svelte-19liytu"&&(st.textContent=Js),be=a(t),lt=M(t,"P",{"data-svelte-h":!0}),u(lt)!=="svelte-il5t0k"&&(lt.innerHTML=gs),fe=a(t),o(nt.$$.fragment,t),Ie=a(t),at=M(t,"P",{"data-svelte-h":!0}),u(at)!=="svelte-16s019k"&&(at.textContent=bs),Ae=a(t),o(pt.$$.fragment,t),$e=a(t),it=M(t,"PRE",{"data-svelte-h":!0}),u(it)!=="svelte-11ebe9s"&&(it.textContent=fs),Ce=a(t),o(Mt.$$.fragment,t),Be=a(t),ot=M(t,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-iwjedl"&&(ot.innerHTML=Is),ke=a(t),o(dt.$$.fragment,t),We=a(t),o(jt.$$.fragment,t),Ze=a(t),mt=M(t,"PRE",{"data-svelte-h":!0}),u(mt)!=="svelte-ff4u6w"&&(mt.textContent=As),Ge=a(t),o(rt.$$.fragment,t),Re=a(t),ut=M(t,"P",{"data-svelte-h":!0}),u(ut)!=="svelte-80w8ff"&&(ut.textContent=$s),Ee=a(t),o(ct.$$.fragment,t),Qe=a(t),ht=M(t,"PRE",{"data-svelte-h":!0}),u(ht)!=="svelte-v5xolv"&&(ht.textContent=Cs),Ne=a(t),o(yt.$$.fragment,t),ve=a(t),wt=M(t,"P",{"data-svelte-h":!0}),u(wt)!=="svelte-13ozgsg"&&(wt.innerHTML=Bs),Ve=a(t),o(Tt.$$.fragment,t),_e=a(t),Ut=M(t,"P",{"data-svelte-h":!0}),u(Ut)!=="svelte-1t2e8el"&&(Ut.innerHTML=ks),Se=a(t),o(Jt.$$.fragment,t),xe=a(t),o(gt.$$.fragment,t),He=a(t),bt=M(t,"PRE",{"data-svelte-h":!0}),u(bt)!=="svelte-dj57zs"&&(bt.textContent=Ws),qe=a(t),o(ft.$$.fragment,t),Xe=a(t),It=M(t,"OL",{"data-svelte-h":!0}),u(It)!=="svelte-seqler"&&(It.innerHTML=Zs),Ye=a(t),o(At.$$.fragment,t),ze=a(t),$t=M(t,"PRE",{"data-svelte-h":!0}),u($t)!=="svelte-109618w"&&($t.textContent=Gs),Fe=a(t),o(Ct.$$.fragment,t),Le=a(t),Bt=M(t,"P",{"data-svelte-h":!0}),u(Bt)!=="svelte-1ga4kzi"&&(Bt.innerHTML=Rs),De=a(t),o(kt.$$.fragment,t),Pe=a(t),Wt=M(t,"P",{"data-svelte-h":!0}),u(Wt)!=="svelte-3kjw6t"&&(Wt.textContent=Es),Ke=a(t),Zt=M(t,"P",{"data-svelte-h":!0}),u(Zt)!=="svelte-1124toy"&&(Zt.innerHTML=Qs),Oe=a(t),o(Gt.$$.fragment,t),ts=a(t),Rt=M(t,"PRE",{"data-svelte-h":!0}),u(Rt)!=="svelte-ulyp9n"&&(Rt.textContent=Ns),es=a(t),Qt=M(t,"P",{}),vs(Qt).forEach(s),this.h()},h(){Vs(y,"name","hf:doc:metadata"),Vs(y,"content",Ls)},m(t,e){Ys(document.head,y),l(t,Nt,e),l(t,Et,e),l(t,vt,e),d(w,t,e),l(t,Vt,e),d(T,t,e),l(t,_t,e),l(t,U,e),l(t,St,e),d(J,t,e),l(t,xt,e),l(t,g,e),l(t,Ht,e),d(b,t,e),l(t,qt,e),l(t,f,e),l(t,Xt,e),l(t,I,e),l(t,Yt,e),l(t,A,e),l(t,zt,e),l(t,$,e),l(t,Ft,e),d(C,t,e),l(t,Lt,e),d(B,t,e),l(t,Dt,e),d(k,t,e),l(t,Pt,e),d(W,t,e),l(t,Kt,e),d(Z,t,e),l(t,Ot,e),l(t,G,e),l(t,te,e),l(t,R,e),l(t,ee,e),d(E,t,e),l(t,se,e),l(t,Q,e),l(t,le,e),l(t,N,e),l(t,ne,e),l(t,v,e),l(t,ae,e),d(V,t,e),l(t,pe,e),d(_,t,e),l(t,ie,e),l(t,S,e),l(t,Me,e),l(t,x,e),l(t,oe,e),d(H,t,e),l(t,de,e),d(q,t,e),l(t,je,e),d(X,t,e),l(t,me,e),d(Y,t,e),l(t,re,e),d(z,t,e),l(t,ue,e),d(F,t,e),l(t,ce,e),l(t,L,e),l(t,he,e),l(t,D,e),l(t,ye,e),d(P,t,e),l(t,we,e),l(t,K,e),l(t,Te,e),l(t,O,e),l(t,Ue,e),d(tt,t,e),l(t,Je,e),d(et,t,e),l(t,ge,e),l(t,st,e),l(t,be,e),l(t,lt,e),l(t,fe,e),d(nt,t,e),l(t,Ie,e),l(t,at,e),l(t,Ae,e),d(pt,t,e),l(t,$e,e),l(t,it,e),l(t,Ce,e),d(Mt,t,e),l(t,Be,e),l(t,ot,e),l(t,ke,e),d(dt,t,e),l(t,We,e),d(jt,t,e),l(t,Ze,e),l(t,mt,e),l(t,Ge,e),d(rt,t,e),l(t,Re,e),l(t,ut,e),l(t,Ee,e),d(ct,t,e),l(t,Qe,e),l(t,ht,e),l(t,Ne,e),d(yt,t,e),l(t,ve,e),l(t,wt,e),l(t,Ve,e),d(Tt,t,e),l(t,_e,e),l(t,Ut,e),l(t,Se,e),d(Jt,t,e),l(t,xe,e),d(gt,t,e),l(t,He,e),l(t,bt,e),l(t,qe,e),d(ft,t,e),l(t,Xe,e),l(t,It,e),l(t,Ye,e),d(At,t,e),l(t,ze,e),l(t,$t,e),l(t,Fe,e),d(Ct,t,e),l(t,Le,e),l(t,Bt,e),l(t,De,e),d(kt,t,e),l(t,Pe,e),l(t,Wt,e),l(t,Ke,e),l(t,Zt,e),l(t,Oe,e),d(Gt,t,e),l(t,ts,e),l(t,Rt,e),l(t,es,e),l(t,Qt,e),ss=!0},p:Ss,i(t){ss||(j(w.$$.fragment,t),j(T.$$.fragment,t),j(J.$$.fragment,t),j(b.$$.fragment,t),j(C.$$.fragment,t),j(B.$$.fragment,t),j(k.$$.fragment,t),j(W.$$.fragment,t),j(Z.$$.fragment,t),j(E.$$.fragment,t),j(V.$$.fragment,t),j(_.$$.fragment,t),j(H.$$.fragment,t),j(q.$$.fragment,t),j(X.$$.fragment,t),j(Y.$$.fragment,t),j(z.$$.fragment,t),j(F.$$.fragment,t),j(P.$$.fragment,t),j(tt.$$.fragment,t),j(et.$$.fragment,t),j(nt.$$.fragment,t),j(pt.$$.fragment,t),j(Mt.$$.fragment,t),j(dt.$$.fragment,t),j(jt.$$.fragment,t),j(rt.$$.fragment,t),j(ct.$$.fragment,t),j(yt.$$.fragment,t),j(Tt.$$.fragment,t),j(Jt.$$.fragment,t),j(gt.$$.fragment,t),j(ft.$$.fragment,t),j(At.$$.fragment,t),j(Ct.$$.fragment,t),j(kt.$$.fragment,t),j(Gt.$$.fragment,t),ss=!0)},o(t){m(w.$$.fragment,t),m(T.$$.fragment,t),m(J.$$.fragment,t),m(b.$$.fragment,t),m(C.$$.fragment,t),m(B.$$.fragment,t),m(k.$$.fragment,t),m(W.$$.fragment,t),m(Z.$$.fragment,t),m(E.$$.fragment,t),m(V.$$.fragment,t),m(_.$$.fragment,t),m(H.$$.fragment,t),m(q.$$.fragment,t),m(X.$$.fragment,t),m(Y.$$.fragment,t),m(z.$$.fragment,t),m(F.$$.fragment,t),m(P.$$.fragment,t),m(tt.$$.fragment,t),m(et.$$.fragment,t),m(nt.$$.fragment,t),m(pt.$$.fragment,t),m(Mt.$$.fragment,t),m(dt.$$.fragment,t),m(jt.$$.fragment,t),m(rt.$$.fragment,t),m(ct.$$.fragment,t),m(yt.$$.fragment,t),m(Tt.$$.fragment,t),m(Jt.$$.fragment,t),m(gt.$$.fragment,t),m(ft.$$.fragment,t),m(At.$$.fragment,t),m(Ct.$$.fragment,t),m(kt.$$.fragment,t),m(Gt.$$.fragment,t),ss=!1},d(t){t&&(s(Nt),s(Et),s(vt),s(Vt),s(_t),s(U),s(St),s(xt),s(g),s(Ht),s(qt),s(f),s(Xt),s(I),s(Yt),s(A),s(zt),s($),s(Ft),s(Lt),s(Dt),s(Pt),s(Kt),s(Ot),s(G),s(te),s(R),s(ee),s(se),s(Q),s(le),s(N),s(ne),s(v),s(ae),s(pe),s(ie),s(S),s(Me),s(x),s(oe),s(de),s(je),s(me),s(re),s(ue),s(ce),s(L),s(he),s(D),s(ye),s(we),s(K),s(Te),s(O),s(Ue),s(Je),s(ge),s(st),s(be),s(lt),s(fe),s(Ie),s(at),s(Ae),s($e),s(it),s(Ce),s(Be),s(ot),s(ke),s(We),s(Ze),s(mt),s(Ge),s(Re),s(ut),s(Ee),s(Qe),s(ht),s(Ne),s(ve),s(wt),s(Ve),s(_e),s(Ut),s(Se),s(xe),s(He),s(bt),s(qe),s(Xe),s(It),s(Ye),s(ze),s($t),s(Fe),s(Le),s(Bt),s(De),s(Pe),s(Wt),s(Ke),s(Zt),s(Oe),s(ts),s(Rt),s(es),s(Qt)),s(y),r(w,t),r(T,t),r(J,t),r(b,t),r(C,t),r(B,t),r(k,t),r(W,t),r(Z,t),r(E,t),r(V,t),r(_,t),r(H,t),r(q,t),r(X,t),r(Y,t),r(z,t),r(F,t),r(P,t),r(tt,t),r(et,t),r(nt,t),r(pt,t),r(Mt,t),r(dt,t),r(jt,t),r(rt,t),r(ct,t),r(yt,t),r(Tt,t),r(Jt,t),r(gt,t),r(ft,t),r(At,t),r(Ct,t),r(kt,t),r(Gt,t)}}}const Ls='{"title":"How to use Inference Endpoints to Embed Documents","local":"how-to-use-inference-endpoints-to-embed-documents","sections":[{"title":"Goal","local":"goal","sections":[],"depth":2},{"title":"Approach","local":"approach","sections":[],"depth":2},{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Imports","local":"imports","sections":[],"depth":2},{"title":"Config","local":"config","sections":[],"depth":2},{"title":"Get Dataset","local":"get-dataset","sections":[],"depth":2}],"depth":1}';function Ds(ls){return xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class el extends Hs{constructor(y){super(),qs(this,y,Ds,Fs,_s,{})}}export{el as component};
