import{s as hl,n as wl,o as ul}from"../chunks/scheduler.39a43cde.js";import{S as bl,i as gl,g as y,s as a,r as p,A as Ul,h as J,f as e,c as n,j as jl,u as m,x as j,k as cl,y as Zl,a as t,v as i,d as M,t as d,w as o}from"../chunks/index.23ec2204.js";import{D as fl,C as r}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as Ds}from"../chunks/Heading.c42e7061.js";function Tl(Os){let c,ms,ns,is,h,Ms,w,ds,u,sl=`嵌入对于语义压缩信息很有用。它们可用于执行相似性搜索、零样本分类或简单地训练新模型。相似性搜索用例包括在电子商务中搜索类似的产品、在社交媒体中搜索内容等等。<br/>
本 notebook 指导你使用 🤗transformers、🤗datasets 和 FAISS 从特征提取模型创建和索引嵌入，以便稍后使用它们进行相似性搜索。<br/>
让我们安装必要的库。`,os,b,rs,g,ll='对于本教程，我们将会使用 <a href="https://huggingface.co/openai/clip-vit-base-patch16" rel="nofollow">CLIP 模型</a>来提取特征。 CLIP 是一个革命性的模型，其成功的将文本数据和图片数据两个模态联合起来训练。',ys,U,Js,Z,el='载入数据集，为了保持 notebook 的轻量性，我们这里会使用一个小型字幕数据集 <a href="https://huggingface.co/datasets/jmhessel/newyorker_caption_contest" rel="nofollow">jmhessel/newyorker_caption_contest</a>.',js,f,cs,T,tl="让我们来看一个例子",hs,$,ws,C,us,I,al="我们没必要去写任何函数去嵌入例子或创建索引。 🤗 datasets 库的 FAISS 组件抽象这些过程。我们可以仅仅简单使用 dataset 的 <code>map</code> 方法就可以创建一个新的带有每个例子嵌入的列，就像下面所示。让我们针对提示列中的文本特征创建一个嵌入。",bs,k,gs,W,Us,G,nl="我们可以同样处理图像嵌入",Zs,_,fs,V,Ts,X,$s,R,pl="我们现在可以用文本或者图片查询数据集来获取相似的项目",Cs,B,Is,q,ks,Q,ml=`['A man is in the snow. A boy with a huge snow shovel is there too. They are outside a house.']
`,Ws,N,Gs,A,il="图片相似度推理也类似，你只需要调用 <code>get_image_features</code> 函数即可。",_s,v,Vs,z,Ml="搜索相似的图片",Xs,Y,Rs,F,dl="显示与海狸图像最相似的图像。",Bs,S,qs,H,ol=`['Salmon swim upstream but they see a grizzly bear and are in shock. The bear has a smug look on his face when he sees the salmon.']
`,Qs,E,Ns,x,rl="我们可以用 <code>save_faiss_index</code> 函数储存数据集的嵌入。",As,K,vs,L,zs,P,yl=`去储存一个数据集仓库的嵌入是一个很好的练习，所以我们将在那里创建一个，并将我们的嵌入稍后推送到那里。<br/>
我们会登录 Hugging Face Hub， 创建一个数据集仓库，推送我们的所以，然后使用 <code>snapshot_download</code> 加载。`,Ys,D,Fs,O,Ss,ss,Hs,ls,Jl="我们可以使用 <code>load_faiss_index</code> 将嵌入加载到没有嵌入的数据集中。",Es,es,xs,ts,Ks,as,Ls,ps,Ps;return h=new fl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/faiss_with_hf_datasets_and_clip.ipynb"}]}}),w=new Ds({props:{title:"用 🤗 transformers, 🤗 datasets 和 FAISS 嵌入多模态数据进行相似度搜索",local:"用--transformers--datasets-和-faiss-嵌入多模态数据进行相似度搜索",headingTag:"h1"}}),b=new r({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGRhdGFzZXRzJTIwZmFpc3MtZ3B1JTIwdHJhbnNmb3JtZXJzJTIwc2VudGVuY2VwaWVjZQ==",highlighted:"!pip install -q datasets faiss-gpu transformers sentencepiece",wrap:!1}}),U=new r({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ltYWdlUHJvY2Vzc29yJTJDJTIwQXV0b01vZGVsJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMGZhaXNzJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZjbGlwLXZpdC1iYXNlLXBhdGNoMTYlMjIpLnRvKGRldmljZSklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRmNsaXAtdml0LWJhc2UtcGF0Y2gxNiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZjbGlwLXZpdC1iYXNlLXBhdGNoMTYlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel, AutoTokenizer
<span class="hljs-keyword">import</span> faiss
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>).to(device)
processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>)`,wrap:!1}}),f=new r({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyam1oZXNzZWwlMkZuZXd5b3JrZXJfY2FwdGlvbl9jb250ZXN0JTIyJTJDJTIwJTIyZXhwbGFuYXRpb24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;jmhessel/newyorker_caption_contest&quot;</span>, <span class="hljs-string">&quot;explanation&quot;</span>)`,wrap:!1}}),$=new r({props:{code:"ZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQlNUIlMjJpbWFnZSUyMiU1RA==",highlighted:'ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),C=new r({props:{code:"ZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQlNUIlMjJpbWFnZV9kZXNjcmlwdGlvbiUyMiU1RA==",highlighted:'ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image_description&quot;</span>]',wrap:!1}}),k=new r({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRzJTVCJTIydHJhaW4lMjIlNUQlMEFkc193aXRoX2VtYmVkZGluZ3MlMjAlM0QlMjBkYXRhc2V0Lm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjBleGFtcGxlJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW1iZWRkaW5ncyUyMiUzQSUyMG1vZGVsLmdldF90ZXh0X2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqdG9rZW5pemVyKCU1QmV4YW1wbGUlNUIlMjJpbWFnZV9kZXNjcmlwdGlvbiUyMiU1RCU1RCUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC5kZXRhY2goKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC5jcHUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC5udW1weSgpJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`dataset = ds[<span class="hljs-string">&quot;train&quot;</span>]
ds_with_embeddings = dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> example: {
        <span class="hljs-string">&quot;embeddings&quot;</span>: model.get_text_features(
            **tokenizer([example[<span class="hljs-string">&quot;image_description&quot;</span>]], truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
        )[<span class="hljs-number">0</span>]
        .detach()
        .cpu()
        .numpy()
    }
)`,wrap:!1}}),W=new r({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzLmFkZF9mYWlzc19pbmRleChjb2x1bW4lM0QlMjJlbWJlZGRpbmdzJTIyKQ==",highlighted:'ds_with_embeddings.add_faiss_index(column=<span class="hljs-string">&quot;embeddings&quot;</span>)',wrap:!1}}),_=new r({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzJTIwJTNEJTIwZHNfd2l0aF9lbWJlZGRpbmdzLm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjBleGFtcGxlJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW1hZ2VfZW1iZWRkaW5ncyUyMiUzQSUyMG1vZGVsLmdldF9pbWFnZV9mZWF0dXJlcygqKnByb2Nlc3NvciglNUJleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSklNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLmRldGFjaCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLmNwdSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLm51bXB5KCklMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`ds_with_embeddings = ds_with_embeddings.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> example: {
        <span class="hljs-string">&quot;image_embeddings&quot;</span>: model.get_image_features(**processor([example[<span class="hljs-string">&quot;image&quot;</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[
            <span class="hljs-number">0</span>
        ]
        .detach()
        .cpu()
        .numpy()
    }
)`,wrap:!1}}),V=new r({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzLmFkZF9mYWlzc19pbmRleChjb2x1bW4lM0QlMjJpbWFnZV9lbWJlZGRpbmdzJTIyKQ==",highlighted:'ds_with_embeddings.add_faiss_index(column=<span class="hljs-string">&quot;image_embeddings&quot;</span>)',wrap:!1}}),X=new Ds({props:{title:"用文本提示( prompts )查询相关数据",local:"用文本提示-prompts-查询相关数据",headingTag:"h2"}}),B=new r({props:{code:"cHJtdCUyMCUzRCUyMCUyMmElMjBzbm93eSUyMGRheSUyMiUwQXBybXRfZW1iZWRkaW5nJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMG1vZGVsLmdldF90ZXh0X2ZlYXR1cmVzKCoqdG9rZW5pemVyKCU1QnBybXQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpLnRvKCUyMmN1ZGElMjIpKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAuZGV0YWNoKCklMEElMjAlMjAlMjAlMjAuY3B1KCklMEElMjAlMjAlMjAlMjAubnVtcHkoKSUwQSklMEFzY29yZXMlMkMlMjByZXRyaWV2ZWRfZXhhbXBsZXMlMjAlM0QlMjBkc193aXRoX2VtYmVkZGluZ3MuZ2V0X25lYXJlc3RfZXhhbXBsZXMoJTIyZW1iZWRkaW5ncyUyMiUyQyUyMHBybXRfZW1iZWRkaW5nJTJDJTIwayUzRDEp",highlighted:`prmt = <span class="hljs-string">&quot;a snowy day&quot;</span>
prmt_embedding = (
    model.get_text_features(**tokenizer([prmt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, truncation=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[<span class="hljs-number">0</span>]
    .detach()
    .cpu()
    .numpy()
)
scores, retrieved_examples = ds_with_embeddings.get_nearest_examples(<span class="hljs-string">&quot;embeddings&quot;</span>, prmt_embedding, k=<span class="hljs-number">1</span>)`,wrap:!1}}),q=new r({props:{code:"ZGVmJTIwZG93bnNjYWxlX2ltYWdlcyhpbWFnZSklM0ElMEElMjAlMjAlMjAlMjB3aWR0aCUyMCUzRCUyMDIwMCUwQSUyMCUyMCUyMCUyMHJhdGlvJTIwJTNEJTIwd2lkdGglMjAlMkYlMjBmbG9hdChpbWFnZS5zaXplJTVCMCU1RCklMEElMjAlMjAlMjAlMjBoZWlnaHQlMjAlM0QlMjBpbnQoKGZsb2F0KGltYWdlLnNpemUlNUIxJTVEKSUyMColMjBmbG9hdChyYXRpbykpKSUwQSUyMCUyMCUyMCUyMGltZyUyMCUzRCUyMGltYWdlLnJlc2l6ZSgod2lkdGglMkMlMjBoZWlnaHQpJTJDJTIwSW1hZ2UuUmVzYW1wbGluZy5MQU5DWk9TKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGltZyUwQSUwQSUwQWltYWdlcyUyMCUzRCUyMCU1QmRvd25zY2FsZV9pbWFnZXMoaW1hZ2UpJTIwZm9yJTIwaW1hZ2UlMjBpbiUyMHJldHJpZXZlZF9leGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIzJTIwc2VlJTIwdGhlJTIwY2xvc2VzdCUyMHRleHQlMjBhbmQlMjBpbWFnZSUwQXByaW50KHJldHJpZXZlZF9leGFtcGxlcyU1QiUyMmltYWdlX2Rlc2NyaXB0aW9uJTIyJTVEKSUwQWRpc3BsYXkoaW1hZ2VzJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">downscale_images</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    width = <span class="hljs-number">200</span>
<span class="hljs-meta">... </span>    ratio = width / <span class="hljs-built_in">float</span>(image.size[<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>    height = <span class="hljs-built_in">int</span>((<span class="hljs-built_in">float</span>(image.size[<span class="hljs-number">1</span>]) * <span class="hljs-built_in">float</span>(ratio)))
<span class="hljs-meta">... </span>    img = image.resize((width, height), Image.Resampling.LANCZOS)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> img


<span class="hljs-meta">&gt;&gt;&gt; </span>images = [downscale_images(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> retrieved_examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see the closest text and image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_examples[<span class="hljs-string">&quot;image_description&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>display(images[<span class="hljs-number">0</span>])`,wrap:!1}}),N=new Ds({props:{title:"用图片提示( prompts )来查询数据",local:"用图片提示-prompts-来查询数据",headingTag:"h2"}}),v=new r({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBpbWFnZSUyMG9mJTIwYSUyMGJlYXZlciUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnRyYW5zZm9ybWVycyUyRmJlYXZlci5wbmclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFkaXNwbGF5KGRvd25zY2FsZV9pbWFnZXMoaW1hZ2UpKQ==",highlighted:`<span class="hljs-keyword">import</span> requests

<span class="hljs-comment"># image of a beaver</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/beaver.png&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
display(downscale_images(image))`,wrap:!1}}),Y=new r({props:{code:"aW1nX2VtYmVkZGluZyUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjBtb2RlbC5nZXRfaW1hZ2VfZmVhdHVyZXMoKipwcm9jZXNzb3IoJTVCaW1hZ2UlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpLnRvKCUyMmN1ZGElMjIpKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAuZGV0YWNoKCklMEElMjAlMjAlMjAlMjAuY3B1KCklMEElMjAlMjAlMjAlMjAubnVtcHkoKSUwQSklMEFzY29yZXMlMkMlMjByZXRyaWV2ZWRfZXhhbXBsZXMlMjAlM0QlMjBkc193aXRoX2VtYmVkZGluZ3MuZ2V0X25lYXJlc3RfZXhhbXBsZXMoJTIyaW1hZ2VfZW1iZWRkaW5ncyUyMiUyQyUyMGltZ19lbWJlZGRpbmclMkMlMjBrJTNEMSk=",highlighted:`img_embedding = (
    model.get_image_features(**processor([image], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, truncation=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[<span class="hljs-number">0</span>]
    .detach()
    .cpu()
    .numpy()
)
scores, retrieved_examples = ds_with_embeddings.get_nearest_examples(<span class="hljs-string">&quot;image_embeddings&quot;</span>, img_embedding, k=<span class="hljs-number">1</span>)`,wrap:!1}}),S=new r({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCZG93bnNjYWxlX2ltYWdlcyhpbWFnZSklMjBmb3IlMjBpbWFnZSUyMGluJTIwcmV0cmlldmVkX2V4YW1wbGVzJTVCJTIyaW1hZ2UlMjIlNUQlNUQlMEElMjMlMjBzZWUlMjB0aGUlMjBjbG9zZXN0JTIwdGV4dCUyMGFuZCUyMGltYWdlJTBBcHJpbnQocmV0cmlldmVkX2V4YW1wbGVzJTVCJTIyaW1hZ2VfZGVzY3JpcHRpb24lMjIlNUQpJTBBZGlzcGxheShpbWFnZXMlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>images = [downscale_images(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> retrieved_examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see the closest text and image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_examples[<span class="hljs-string">&quot;image_description&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>display(images[<span class="hljs-number">0</span>])`,wrap:!1}}),E=new Ds({props:{title:"保存，推送，加载嵌入( embeddings )",local:"保存推送加载嵌入-embeddings-",headingTag:"h2"}}),K=new r({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzLnNhdmVfZmFpc3NfaW5kZXgoJTIyZW1iZWRkaW5ncyUyMiUyQyUyMCUyMmVtYmVkZGluZ3MlMkZlbWJlZGRpbmdzLmZhaXNzJTIyKQ==",highlighted:'ds_with_embeddings.save_faiss_index(<span class="hljs-string">&quot;embeddings&quot;</span>, <span class="hljs-string">&quot;embeddings/embeddings.faiss&quot;</span>)',wrap:!1}}),L=new r({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzLnNhdmVfZmFpc3NfaW5kZXgoJTIyaW1hZ2VfZW1iZWRkaW5ncyUyMiUyQyUyMCUyMmVtYmVkZGluZ3MlMkZpbWFnZV9lbWJlZGRpbmdzLmZhaXNzJTIyKQ==",highlighted:'ds_with_embeddings.save_faiss_index(<span class="hljs-string">&quot;image_embeddings&quot;</span>, <span class="hljs-string">&quot;embeddings/image_embeddings.faiss&quot;</span>)',wrap:!1}}),D=new r({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwbm90ZWJvb2tfbG9naW4lMkMlMjBzbmFwc2hvdF9kb3dubG9hZCUwQSUwQW5vdGVib29rX2xvZ2luKCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, notebook_login, snapshot_download

notebook_login()`,wrap:!1}}),O=new r({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5jcmVhdGVfcmVwbyglMjJtZXJ2ZSUyRmZhaXNzX2VtYmVkZGluZ3MlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKSUwQWFwaS51cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEJTIyLiUyRmVtYmVkZGluZ3MlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIybWVydmUlMkZmYWlzc19lbWJlZGRpbmdzJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

api = HfApi()
api.create_repo(<span class="hljs-string">&quot;merve/faiss_embeddings&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
api.upload_folder(
    folder_path=<span class="hljs-string">&quot;./embeddings&quot;</span>,
    repo_id=<span class="hljs-string">&quot;merve/faiss_embeddings&quot;</span>,
    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
)`,wrap:!1}}),ss=new r({props:{code:"c25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMm1lcnZlJTJGZmFpc3NfZW1iZWRkaW5ncyUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMjBsb2NhbF9kaXIlM0QlMjJkb3dubG9hZGVkX2VtYmVkZGluZ3MlMjIp",highlighted:'snapshot_download(repo_id=<span class="hljs-string">&quot;merve/faiss_embeddings&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, local_dir=<span class="hljs-string">&quot;downloaded_embeddings&quot;</span>)',wrap:!1}}),es=new r({props:{code:"ZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVEJTBBZHMubG9hZF9mYWlzc19pbmRleCglMjJlbWJlZGRpbmdzJTIyJTJDJTIwJTIyLiUyRmRvd25sb2FkZWRfZW1iZWRkaW5ncyUyRmVtYmVkZGluZ3MuZmFpc3MlMjIpJTBBJTIzJTIwaW5mZXIlMjBhZ2FpbiUwQXBybXQlMjAlM0QlMjAlMjJwZW9wbGUlMjB1bmRlciUyMHRoZSUyMHJhaW4lMjI=",highlighted:`ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
ds.load_faiss_index(<span class="hljs-string">&quot;embeddings&quot;</span>, <span class="hljs-string">&quot;./downloaded_embeddings/embeddings.faiss&quot;</span>)
<span class="hljs-comment"># infer again</span>
prmt = <span class="hljs-string">&quot;people under the rain&quot;</span>`,wrap:!1}}),ts=new r({props:{code:"cHJtdF9lbWJlZGRpbmclMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwbW9kZWwuZ2V0X3RleHRfZmVhdHVyZXMoKip0b2tlbml6ZXIoJTVCcHJtdCU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSkudG8oJTIyY3VkYSUyMikpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMC5kZXRhY2goKSUwQSUyMCUyMCUyMCUyMC5jcHUoKSUwQSUyMCUyMCUyMCUyMC5udW1weSgpJTBBKSUwQSUwQXNjb3JlcyUyQyUyMHJldHJpZXZlZF9leGFtcGxlcyUyMCUzRCUyMGRzLmdldF9uZWFyZXN0X2V4YW1wbGVzKCUyMmVtYmVkZGluZ3MlMjIlMkMlMjBwcm10X2VtYmVkZGluZyUyQyUyMGslM0QxKQ==",highlighted:`prmt_embedding = (
    model.get_text_features(**tokenizer([prmt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, truncation=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[<span class="hljs-number">0</span>]
    .detach()
    .cpu()
    .numpy()
)

scores, retrieved_examples = ds.get_nearest_examples(<span class="hljs-string">&quot;embeddings&quot;</span>, prmt_embedding, k=<span class="hljs-number">1</span>)`,wrap:!1}}),as=new r({props:{code:"ZGlzcGxheShyZXRyaWV2ZWRfZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQp",highlighted:'display(retrieved_examples[<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>])',wrap:!1}}),{c(){c=y("meta"),ms=a(),ns=y("p"),is=a(),p(h.$$.fragment),Ms=a(),p(w.$$.fragment),ds=a(),u=y("p"),u.innerHTML=sl,os=a(),p(b.$$.fragment),rs=a(),g=y("p"),g.innerHTML=ll,ys=a(),p(U.$$.fragment),Js=a(),Z=y("p"),Z.innerHTML=el,js=a(),p(f.$$.fragment),cs=a(),T=y("p"),T.textContent=tl,hs=a(),p($.$$.fragment),ws=a(),p(C.$$.fragment),us=a(),I=y("p"),I.innerHTML=al,bs=a(),p(k.$$.fragment),gs=a(),p(W.$$.fragment),Us=a(),G=y("p"),G.textContent=nl,Zs=a(),p(_.$$.fragment),fs=a(),p(V.$$.fragment),Ts=a(),p(X.$$.fragment),$s=a(),R=y("p"),R.textContent=pl,Cs=a(),p(B.$$.fragment),Is=a(),p(q.$$.fragment),ks=a(),Q=y("pre"),Q.textContent=ml,Ws=a(),p(N.$$.fragment),Gs=a(),A=y("p"),A.innerHTML=il,_s=a(),p(v.$$.fragment),Vs=a(),z=y("p"),z.textContent=Ml,Xs=a(),p(Y.$$.fragment),Rs=a(),F=y("p"),F.textContent=dl,Bs=a(),p(S.$$.fragment),qs=a(),H=y("pre"),H.textContent=ol,Qs=a(),p(E.$$.fragment),Ns=a(),x=y("p"),x.innerHTML=rl,As=a(),p(K.$$.fragment),vs=a(),p(L.$$.fragment),zs=a(),P=y("p"),P.innerHTML=yl,Ys=a(),p(D.$$.fragment),Fs=a(),p(O.$$.fragment),Ss=a(),p(ss.$$.fragment),Hs=a(),ls=y("p"),ls.innerHTML=Jl,Es=a(),p(es.$$.fragment),xs=a(),p(ts.$$.fragment),Ks=a(),p(as.$$.fragment),Ls=a(),ps=y("p"),this.h()},l(s){const l=Ul("svelte-u9bgzb",document.head);c=J(l,"META",{name:!0,content:!0}),l.forEach(e),ms=n(s),ns=J(s,"P",{}),jl(ns).forEach(e),is=n(s),m(h.$$.fragment,s),Ms=n(s),m(w.$$.fragment,s),ds=n(s),u=J(s,"P",{"data-svelte-h":!0}),j(u)!=="svelte-te9t6z"&&(u.innerHTML=sl),os=n(s),m(b.$$.fragment,s),rs=n(s),g=J(s,"P",{"data-svelte-h":!0}),j(g)!=="svelte-1kuw15h"&&(g.innerHTML=ll),ys=n(s),m(U.$$.fragment,s),Js=n(s),Z=J(s,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-1py7qhe"&&(Z.innerHTML=el),js=n(s),m(f.$$.fragment,s),cs=n(s),T=J(s,"P",{"data-svelte-h":!0}),j(T)!=="svelte-yo4343"&&(T.textContent=tl),hs=n(s),m($.$$.fragment,s),ws=n(s),m(C.$$.fragment,s),us=n(s),I=J(s,"P",{"data-svelte-h":!0}),j(I)!=="svelte-4ziknj"&&(I.innerHTML=al),bs=n(s),m(k.$$.fragment,s),gs=n(s),m(W.$$.fragment,s),Us=n(s),G=J(s,"P",{"data-svelte-h":!0}),j(G)!=="svelte-jqfwt6"&&(G.textContent=nl),Zs=n(s),m(_.$$.fragment,s),fs=n(s),m(V.$$.fragment,s),Ts=n(s),m(X.$$.fragment,s),$s=n(s),R=J(s,"P",{"data-svelte-h":!0}),j(R)!=="svelte-1oig01q"&&(R.textContent=pl),Cs=n(s),m(B.$$.fragment,s),Is=n(s),m(q.$$.fragment,s),ks=n(s),Q=J(s,"PRE",{"data-svelte-h":!0}),j(Q)!=="svelte-uwozqd"&&(Q.textContent=ml),Ws=n(s),m(N.$$.fragment,s),Gs=n(s),A=J(s,"P",{"data-svelte-h":!0}),j(A)!=="svelte-oqcn0n"&&(A.innerHTML=il),_s=n(s),m(v.$$.fragment,s),Vs=n(s),z=J(s,"P",{"data-svelte-h":!0}),j(z)!=="svelte-1ryeewd"&&(z.textContent=Ml),Xs=n(s),m(Y.$$.fragment,s),Rs=n(s),F=J(s,"P",{"data-svelte-h":!0}),j(F)!=="svelte-1w7mqo7"&&(F.textContent=dl),Bs=n(s),m(S.$$.fragment,s),qs=n(s),H=J(s,"PRE",{"data-svelte-h":!0}),j(H)!=="svelte-17oljg4"&&(H.textContent=ol),Qs=n(s),m(E.$$.fragment,s),Ns=n(s),x=J(s,"P",{"data-svelte-h":!0}),j(x)!=="svelte-se5d8v"&&(x.innerHTML=rl),As=n(s),m(K.$$.fragment,s),vs=n(s),m(L.$$.fragment,s),zs=n(s),P=J(s,"P",{"data-svelte-h":!0}),j(P)!=="svelte-i60998"&&(P.innerHTML=yl),Ys=n(s),m(D.$$.fragment,s),Fs=n(s),m(O.$$.fragment,s),Ss=n(s),m(ss.$$.fragment,s),Hs=n(s),ls=J(s,"P",{"data-svelte-h":!0}),j(ls)!=="svelte-w8wf6n"&&(ls.innerHTML=Jl),Es=n(s),m(es.$$.fragment,s),xs=n(s),m(ts.$$.fragment,s),Ks=n(s),m(as.$$.fragment,s),Ls=n(s),ps=J(s,"P",{}),jl(ps).forEach(e),this.h()},h(){cl(c,"name","hf:doc:metadata"),cl(c,"content",$l)},m(s,l){Zl(document.head,c),t(s,ms,l),t(s,ns,l),t(s,is,l),i(h,s,l),t(s,Ms,l),i(w,s,l),t(s,ds,l),t(s,u,l),t(s,os,l),i(b,s,l),t(s,rs,l),t(s,g,l),t(s,ys,l),i(U,s,l),t(s,Js,l),t(s,Z,l),t(s,js,l),i(f,s,l),t(s,cs,l),t(s,T,l),t(s,hs,l),i($,s,l),t(s,ws,l),i(C,s,l),t(s,us,l),t(s,I,l),t(s,bs,l),i(k,s,l),t(s,gs,l),i(W,s,l),t(s,Us,l),t(s,G,l),t(s,Zs,l),i(_,s,l),t(s,fs,l),i(V,s,l),t(s,Ts,l),i(X,s,l),t(s,$s,l),t(s,R,l),t(s,Cs,l),i(B,s,l),t(s,Is,l),i(q,s,l),t(s,ks,l),t(s,Q,l),t(s,Ws,l),i(N,s,l),t(s,Gs,l),t(s,A,l),t(s,_s,l),i(v,s,l),t(s,Vs,l),t(s,z,l),t(s,Xs,l),i(Y,s,l),t(s,Rs,l),t(s,F,l),t(s,Bs,l),i(S,s,l),t(s,qs,l),t(s,H,l),t(s,Qs,l),i(E,s,l),t(s,Ns,l),t(s,x,l),t(s,As,l),i(K,s,l),t(s,vs,l),i(L,s,l),t(s,zs,l),t(s,P,l),t(s,Ys,l),i(D,s,l),t(s,Fs,l),i(O,s,l),t(s,Ss,l),i(ss,s,l),t(s,Hs,l),t(s,ls,l),t(s,Es,l),i(es,s,l),t(s,xs,l),i(ts,s,l),t(s,Ks,l),i(as,s,l),t(s,Ls,l),t(s,ps,l),Ps=!0},p:wl,i(s){Ps||(M(h.$$.fragment,s),M(w.$$.fragment,s),M(b.$$.fragment,s),M(U.$$.fragment,s),M(f.$$.fragment,s),M($.$$.fragment,s),M(C.$$.fragment,s),M(k.$$.fragment,s),M(W.$$.fragment,s),M(_.$$.fragment,s),M(V.$$.fragment,s),M(X.$$.fragment,s),M(B.$$.fragment,s),M(q.$$.fragment,s),M(N.$$.fragment,s),M(v.$$.fragment,s),M(Y.$$.fragment,s),M(S.$$.fragment,s),M(E.$$.fragment,s),M(K.$$.fragment,s),M(L.$$.fragment,s),M(D.$$.fragment,s),M(O.$$.fragment,s),M(ss.$$.fragment,s),M(es.$$.fragment,s),M(ts.$$.fragment,s),M(as.$$.fragment,s),Ps=!0)},o(s){d(h.$$.fragment,s),d(w.$$.fragment,s),d(b.$$.fragment,s),d(U.$$.fragment,s),d(f.$$.fragment,s),d($.$$.fragment,s),d(C.$$.fragment,s),d(k.$$.fragment,s),d(W.$$.fragment,s),d(_.$$.fragment,s),d(V.$$.fragment,s),d(X.$$.fragment,s),d(B.$$.fragment,s),d(q.$$.fragment,s),d(N.$$.fragment,s),d(v.$$.fragment,s),d(Y.$$.fragment,s),d(S.$$.fragment,s),d(E.$$.fragment,s),d(K.$$.fragment,s),d(L.$$.fragment,s),d(D.$$.fragment,s),d(O.$$.fragment,s),d(ss.$$.fragment,s),d(es.$$.fragment,s),d(ts.$$.fragment,s),d(as.$$.fragment,s),Ps=!1},d(s){s&&(e(ms),e(ns),e(is),e(Ms),e(ds),e(u),e(os),e(rs),e(g),e(ys),e(Js),e(Z),e(js),e(cs),e(T),e(hs),e(ws),e(us),e(I),e(bs),e(gs),e(Us),e(G),e(Zs),e(fs),e(Ts),e($s),e(R),e(Cs),e(Is),e(ks),e(Q),e(Ws),e(Gs),e(A),e(_s),e(Vs),e(z),e(Xs),e(Rs),e(F),e(Bs),e(qs),e(H),e(Qs),e(Ns),e(x),e(As),e(vs),e(zs),e(P),e(Ys),e(Fs),e(Ss),e(Hs),e(ls),e(Es),e(xs),e(Ks),e(Ls),e(ps)),e(c),o(h,s),o(w,s),o(b,s),o(U,s),o(f,s),o($,s),o(C,s),o(k,s),o(W,s),o(_,s),o(V,s),o(X,s),o(B,s),o(q,s),o(N,s),o(v,s),o(Y,s),o(S,s),o(E,s),o(K,s),o(L,s),o(D,s),o(O,s),o(ss,s),o(es,s),o(ts,s),o(as,s)}}}const $l='{"title":"用 🤗 transformers, 🤗 datasets 和 FAISS 嵌入多模态数据进行相似度搜索","local":"用--transformers--datasets-和-faiss-嵌入多模态数据进行相似度搜索","sections":[{"title":"用文本提示( prompts )查询相关数据","local":"用文本提示-prompts-查询相关数据","sections":[],"depth":2},{"title":"用图片提示( prompts )来查询数据","local":"用图片提示-prompts-来查询数据","sections":[],"depth":2},{"title":"保存，推送，加载嵌入( embeddings )","local":"保存推送加载嵌入-embeddings-","sections":[],"depth":2}],"depth":1}';function Cl(Os){return ul(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _l extends bl{constructor(c){super(),gl(this,c,Cl,Tl,hl,{})}}export{_l as component};
