import{s as Vt,o as zt,n as St}from"../chunks/scheduler.6062bdaf.js";import{S as Xt,i as Bt,g as s,s as r,r as g,A as Wt,h as d,f as o,c as n,j as $,u,x as f,k as M,y as t,a as m,v as h,d as _,t as x,w as b}from"../chunks/index.4bca734e.js";import{T as Gt}from"../chunks/Tip.b9ac1f03.js";import{D as C}from"../chunks/Docstring.81ba5e3c.js";import{C as Zt}from"../chunks/CodeBlock.fa01571c.js";import{E as Yt}from"../chunks/ExampleCodeBlock.30e7542f.js";import{H as Ce,E as Qt}from"../chunks/EditOnGithub.74ab2baa.js";function Kt(me){let p,F="It is possible to know which tasks are supported for a model for a given backend, by doing:",y,k,T;return k=new Zt({props:{code:"ZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzLnRhc2tzJTIwaW1wb3J0JTIwVGFza3NNYW5hZ2VyJTBBJTBBbW9kZWxfdHlwZSUyMCUzRCUyMCUyMmRpc3RpbGJlcnQlMjIlMEElMjMlMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGZvciUyMHRoZSUyME9OTlglMjBleHBvcnQuJTBBYmFja2VuZCUyMCUzRCUyMCUyMm9ubnglMjIlMEFkaXN0aWxiZXJ0X3Rhc2tzJTIwJTNEJTIwbGlzdChUYXNrc01hbmFnZXIuZ2V0X3N1cHBvcnRlZF90YXNrc19mb3JfbW9kZWxfdHlwZShtb2RlbF90eXBlJTJDJTIwYmFja2VuZCkua2V5cygpKSUwQSUwQXByaW50KGRpc3RpbGJlcnRfdGFza3Mp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.tasks <span class="hljs-keyword">import</span> TasksManager

<span class="hljs-meta">&gt;&gt;&gt; </span>model_type = <span class="hljs-string">&quot;distilbert&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, for the ONNX export.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>backend = <span class="hljs-string">&quot;onnx&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>distilbert_tasks = <span class="hljs-built_in">list</span>(TasksManager.get_supported_tasks_for_model_type(model_type, backend).keys())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(distilbert_tasks)
[<span class="hljs-string">&#x27;default&#x27;</span>, <span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;text-classification&#x27;</span>, <span class="hljs-string">&#x27;multiple-choice&#x27;</span>, <span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;question-answering&#x27;</span>]`,wrap:!1}}),{c(){p=s("p"),p.textContent=F,y=r(),g(k.$$.fragment)},l(i){p=d(i,"P",{"data-svelte-h":!0}),f(p)!=="svelte-af61zr"&&(p.textContent=F),y=n(i),u(k.$$.fragment,i)},m(i,v){m(i,p,v),m(i,y,v),h(k,i,v),T=!0},p:St,i(i){T||(_(k.$$.fragment,i),T=!0)},o(i){x(k.$$.fragment,i),T=!1},d(i){i&&(o(p),o(y)),b(k,i)}}}function eo(me){let p,F="Example:",y,k,T;return k=new Zt({props:{code:"cmVnaXN0ZXJfZm9yX25ld19iYWNrZW5kJTIwJTNEJTIwY3JlYXRlX3JlZ2lzdGVyKCUyMm5ldy1iYWNrZW5kJTIyKSUwQSUwQSU0MHJlZ2lzdGVyX2Zvcl9uZXdfYmFja2VuZCglMjJiZXJ0JTIyJTJDJTIwJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMCUyMnRva2VuLWNsYXNzaWZpY2F0aW9uJTIyKSUwQWNsYXNzJTIwQmVydE5ld0JhY2tlbmRDb25maWcoTmV3QmFja2VuZENvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>register_for_new_backend = create_register(<span class="hljs-string">&quot;new-backend&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>@register_for_new_backend(<span class="hljs-string">&quot;bert&quot;</span>, <span class="hljs-string">&quot;text-classification&quot;</span>, <span class="hljs-string">&quot;token-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">BertNewBackendConfig</span>(<span class="hljs-title class_ inherited__">NewBackendConfig</span>):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">pass</span>`,wrap:!1}}),{c(){p=s("p"),p.textContent=F,y=r(),g(k.$$.fragment)},l(i){p=d(i,"P",{"data-svelte-h":!0}),f(p)!=="svelte-11lpom8"&&(p.textContent=F),y=n(i),u(k.$$.fragment,i)},m(i,v){m(i,p,v),m(i,y,v),h(k,i,v),T=!0},p:St,i(i){T||(_(k.$$.fragment,i),T=!0)},o(i){x(k.$$.fragment,i),T=!1},d(i){i&&(o(p),o(y)),b(k,i)}}}function to(me){let p,F,y,k,T,i,v,vt="Exporting a model from one framework to some format (also called backend here) involves specifying inputs and outputs information that the export function needs. The way <code>optimum.exporters</code> is structured for each backend is as follows:",Fe,S,$t="<li>Configuration classes containing the information for each model to perform the export.</li> <li>Exporting functions using the proper configuration for the model to export.</li>",Ne,Z,Mt='The role of the <a href="/docs/optimum/v1.23.1/en/exporters/task_manager#optimum.exporters.TasksManager">TasksManager</a> is to be the main entry-point to load a model given a name and a task, and to get the proper configuration for a given (architecture, backend) couple. That way, there is a centralized place to register the <code>task -&gt; model class</code> and <code>(architecture, backend) -&gt; configuration</code> mappings. This allows the export functions to use this, and to rely on the various checks it provides.',Pe,V,De,z,wt="The tasks supported might depend on the backend, but here are the mappings between a task name and the auto class for both PyTorch and TensorFlow.",He,D,je,X,Ue,B,Ct="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-generation</code>, <code>text-generation-with-past</code></td> <td><code>AutoModelForCausalLM</code></td></tr> <tr><td><code>feature-extraction</code>, <code>feature-extraction-with-past</code></td> <td><code>AutoModel</code></td></tr> <tr><td><code>fill-mask</code></td> <td><code>AutoModelForMaskedLM</code></td></tr> <tr><td><code>question-answering</code></td> <td><code>AutoModelForQuestionAnswering</code></td></tr> <tr><td><code>text2text-generation</code>, <code>text2text-generation-with-past</code></td> <td><code>AutoModelForSeq2SeqLM</code></td></tr> <tr><td><code>text-classification</code></td> <td><code>AutoModelForSequenceClassification</code></td></tr> <tr><td><code>token-classification</code></td> <td><code>AutoModelForTokenClassification</code></td></tr> <tr><td><code>multiple-choice</code></td> <td><code>AutoModelForMultipleChoice</code></td></tr> <tr><td><code>image-classification</code></td> <td><code>AutoModelForImageClassification</code></td></tr> <tr><td><code>object-detection</code></td> <td><code>AutoModelForObjectDetection</code></td></tr> <tr><td><code>image-segmentation</code></td> <td><code>AutoModelForImageSegmentation</code></td></tr> <tr><td><code>masked-im</code></td> <td><code>AutoModelForMaskedImageModeling</code></td></tr> <tr><td><code>semantic-segmentation</code></td> <td><code>AutoModelForSemanticSegmentation</code></td></tr> <tr><td><code>automatic-speech-recognition</code></td> <td><code>AutoModelForSpeechSeq2Seq</code></td></tr></tbody>",Ie,W,Ae,G,Ft="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-generation</code>, <code>text-generation-with-past</code></td> <td><code>TFAutoModelForCausalLM</code></td></tr> <tr><td><code>default</code>, <code>default-with-past</code></td> <td><code>TFAutoModel</code></td></tr> <tr><td><code>fill-mask</code></td> <td><code>TFAutoModelForMaskedLM</code></td></tr> <tr><td><code>question-answering</code></td> <td><code>TFAutoModelForQuestionAnswering</code></td></tr> <tr><td><code>text2text-generation</code>, <code>text2text-generation-with-past</code></td> <td><code>TFAutoModelForSeq2SeqLM</code></td></tr> <tr><td><code>text-classification</code></td> <td><code>TFAutoModelForSequenceClassification</code></td></tr> <tr><td><code>token-classification</code></td> <td><code>TFAutoModelForTokenClassification</code></td></tr> <tr><td><code>multiple-choice</code></td> <td><code>TFAutoModelForMultipleChoice</code></td></tr> <tr><td><code>semantic-segmentation</code></td> <td><code>TFAutoModelForSemanticSegmentation</code></td></tr></tbody>",Oe,Y,qe,c,Q,Ye,pe,Nt="Handles the <code>task name -&gt; model class</code> and <code>architecture -&gt; configuration</code> mappings.",Qe,N,K,Ke,ge,Pt="Creates a register function for the specified backend.",et,H,tt,w,ee,ot,ue,Dt="Determines the framework to use for the export.",rt,fe,Ht="The priority is in the following order:",nt,he,jt="<li>User input via <code>framework</code>.</li> <li>If local checkpoint is provided, use the same framework as the checkpoint.</li> <li>If model repo, try to infer the framework from the cache if available, else from the Hub.</li> <li>If could not infer, use available framework in environment, with priority given to PyTorch.</li>",at,j,te,st,_e,Ut="Retrieves all the possible tasks.",dt,U,oe,it,xe,It="Gets the <code>ExportConfigConstructor</code> for a model (or alternatively for a model type) and task combination.",ct,I,re,lt,be,At="Attempts to retrieve an AutoModel class from a task name.",mt,A,ne,pt,ke,Ot="Retrieves a model from its name and the task to be enabled.",gt,O,ae,ut,Te,qt="Returns the list of supported architectures by the exporter for a given task. Transformers-specific.",ft,q,se,ht,ye,Et="Retrieves the <code>task -&gt; exporter backend config constructors</code> map from the model type.",_t,E,de,xt,ve,Lt="Infers the library from the model repo, model instance, or model class.",bt,L,ie,kt,$e,Rt="Infers the task from the model repo, model instance, or model class.",Tt,R,ce,yt,Me,Jt=`Updates the model for export. This function is suitable to make required changes to the models from different
libraries to follow transformers style.`,Ee,le,Le,we,Re;return T=new Ce({props:{title:"The Tasks Manager",local:"the-tasks-manager",headingTag:"h1"}}),V=new Ce({props:{title:"Task names",local:"task-names",headingTag:"h2"}}),D=new Gt({props:{$$slots:{default:[Kt]},$$scope:{ctx:me}}}),X=new Ce({props:{title:"PyTorch",local:"pytorch",headingTag:"h3"}}),W=new Ce({props:{title:"TensorFlow",local:"tensorflow",headingTag:"h3"}}),Y=new Ce({props:{title:"Reference",local:"optimum.exporters.TasksManager",headingTag:"h2"}}),Q=new C({props:{name:"class optimum.exporters.TasksManager",anchor:"optimum.exporters.TasksManager",parameters:[],source:"https://github.com/huggingface/optimum/blob/v1.23.1/optimum/exporters/tasks.py#L173"}}),K=new C({props:{name:"create_register",anchor:"optimum.exporters.TasksManager.create_register",parameters:[{name:"backend",val:": str"},{name:"overwrite_existing",val:": bool = False"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.create_register.backend",description:`<strong>backend</strong> (<code>str</code>) &#x2014;
The name of the backend that the register function will handle.`,name:"backend"},{anchor:"optimum.exporters.TasksManager.create_register.overwrite_existing",description:`<strong>overwrite_existing</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not the register function is allowed to overwrite an already existing config.`,name:"overwrite_existing"}],source:"https://github.com/huggingface/optimum/blob/v1.23.1/optimum/exporters/tasks.py#L1187",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A decorator taking the model type and a the
supported tasks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Callable[[str, Tuple[str, ...]], Callable[[Type], Type]]</code></p>
`}}),H=new Yt({props:{anchor:"optimum.exporters.TasksManager.create_register.example",$$slots:{default:[eo]},$$scope:{ctx:me}}}),ee=new C({props:{name:"determine_framework",anchor:"optimum.exporters.TasksManager.determine_framework",parameters:[{name:"model_name_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/root/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.determine_framework.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either the model id of a model repo on the Hugging Face Hub, or a path to a local directory
containing a model.`,name:"model_name_or_path"},{anchor:"optimum.exporters.TasksManager.determine_framework.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.determine_framework.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>,  defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.TasksManager.determine_framework.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.TasksManager.determine_framework.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"}],source:"https://github.com/huggingface/optimum/blob/v1.23.1/optimum/exporters/tasks.py#L1489",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The framework to use for the export.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),te=new C({props:{name:"get_all_tasks",anchor:"optimum.exporters.TasksManager.get_all_tasks",parameters:[],source:"https://github.com/huggingface/optimum/blob/v1.23.1/optimum/exporters/tasks.py#L1961",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>all the possible tasks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`}}),oe=new C({props:{name:"get_exporter_config_constructor",anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor",parameters:[{name:"exporter",val:": str"},{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel'), NoneType] = None"},{name:"task",val:": str = 'feature-extraction'"},{name:"model_type",val:": typing.Optional[str] = None"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"exporter_config_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"library_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.exporter",description:`<strong>exporter</strong> (<code>str</code>) &#x2014;
The exporter to use.`,name:"exporter"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.model",description:`<strong>model</strong> (<code>Optional[Union[PreTrainedModel, TFPreTrainedModel]]</code>, defaults to <code>None</code>) &#x2014;
The instance of the model.`,name:"model"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;feature-extraction&quot;</code>) &#x2014;
The task to retrieve the config for.`,name:"task"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.model_type",description:`<strong>model_type</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The model type to retrieve the config for.`,name:"model_type"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.model_name",description:`<strong>model_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The name attribute of the model object, only used for the exception message.`,name:"model_name"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.exporter_config_kwargs",description:`<strong>exporter_config_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Arguments that will be passed to the exporter config class when building the config constructor.`,name:"exporter_config_kwargs"},{anchor:"optimum.exporters.TasksManager.get_exporter_config_constructor.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/v1.23.1/optimum/exporters/tasks.py#L2134",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>ExportConfig</code> constructor for the requested backend.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ExportConfigConstructor</code></p>
`}}),re=new C({props:{name:"get_model_class_for_task",anchor:"optimum.exporters.TasksManager.get_model_class_for_task",parameters:[{name:"task",val:": str"},{name:"framework",val:": str = 'pt'"},{name:"model_type",val:": typing.Optional[str] = None"},{name:"model_class_name",val:": typing.Optional[str] = None"},{name:"library",val:": str = 'transformers'"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task required.`,name:"task"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.framework",description:`<strong>framework</strong> (<code>str</code>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The framework to use for the export.`,name:"framework"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.model_type",description:`<strong>model_type</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The model type to retrieve the model class for. Some architectures need a custom class to be loaded,
and can not be loaded from auto class.`,name:"model_type"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.model_class_name",description:`<strong>model_class_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
A model class name, allowing to override the default class that would be detected for the task. This
parameter is useful for example for &#x201C;automatic-speech-recognition&#x201D;, that may map to
AutoModelForSpeechSeq2Seq or to AutoModelForCTC.`,name:"model_class_name"},{anchor:"optimum.exporters.TasksManager.get_model_class_for_task.library",description:`<strong>library</strong> (<code>str</code>, defaults to <code>transformers</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;.`,name:"library"}],source:"https://github.com/huggingface/optimum/blob/v1.23.1/optimum/exporters/tasks.py#L1345",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The AutoModel class corresponding to the task.</p>
`}}),ne=new C({props:{name:"get_model_from_task",anchor:"optimum.exporters.TasksManager.get_model_from_task",parameters:[{name:"task",val:": str"},{name:"model_name_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/root/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"framework",val:": typing.Optional[str] = None"},{name:"torch_dtype",val:": typing.Optional[ForwardRef('torch.dtype')] = None"},{name:"device",val:": typing.Union[ForwardRef('torch.device'), str, NoneType] = None"},{name:"library_name",val:": typing.Optional[str] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_model_from_task.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task required.`,name:"task"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either the model id of a model repo on the Hugging Face Hub, or a path to a local directory
containing a model.`,name:"model_name_or_path"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.framework",description:`<strong>framework</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
The framework to use for the export. See <code>TasksManager.determine_framework</code> for the priority should
none be provided.`,name:"framework"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.torch_dtype",description:`<strong>torch_dtype</strong> (<code>Optional[torch.dtype]</code>, defaults to <code>None</code>) &#x2014;
Data type to load the model on. PyTorch-only argument.`,name:"torch_dtype"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
Device to initialize the model on. PyTorch-only argument. For PyTorch, defaults to &#x201C;cpu&#x201D;.`,name:"device"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;. See <code>TasksManager.infer_library_from_model</code> for the priority should
none be provided.`,name:"library_name"},{anchor:"optimum.exporters.TasksManager.get_model_from_task.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Keyword arguments to pass to the model <code>.from_pretrained()</code> method.`,name:"model_kwargs"}],source:"https://github.com/huggingface/optimum/blob/v1.23.1/optimum/exporters/tasks.py#L1983",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The instance of the model.</p>
`}}),ae=new C({props:{name:"get_supported_model_type_for_task",anchor:"optimum.exporters.TasksManager.get_supported_model_type_for_task",parameters:[{name:"task",val:": str"},{name:"exporter",val:": str"}],source:"https://github.com/huggingface/optimum/blob/v1.23.1/optimum/exporters/tasks.py#L1304"}}),se=new C({props:{name:"get_supported_tasks_for_model_type",anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type",parameters:[{name:"model_type",val:": str"},{name:"exporter",val:": str"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"library_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.model_type",description:`<strong>model_type</strong> (<code>str</code>) &#x2014;
The model type to retrieve the supported tasks for.`,name:"model_type"},{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.exporter",description:`<strong>exporter</strong> (<code>str</code>) &#x2014;
The name of the exporter.`,name:"exporter"},{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.model_name",description:`<strong>model_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The name attribute of the model object, only used for the exception message.`,name:"model_name"},{anchor:"optimum.exporters.TasksManager.get_supported_tasks_for_model_type.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/v1.23.1/optimum/exporters/tasks.py#L1242",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary mapping each task to a corresponding <code>ExportConfig</code>
constructor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>TaskNameToExportConfigDict</code></p>
`}}),de=new C({props:{name:"infer_library_from_model",anchor:"optimum.exporters.TasksManager.infer_library_from_model",parameters:[{name:"model",val:": typing.Union[str, ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel'), ForwardRef('DiffusionPipeline'), typing.Type]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/root/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.infer_library_from_model.model",description:`<strong>model</strong> (<code>Union[str, PreTrainedModel, TFPreTrainedModel, DiffusionPipeline, Type]</code>) &#x2014;
The model to infer the task from. This can either be the name of a repo on the HuggingFace Hub, an
instance of a model, or a model class.`,name:"model"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.TasksManager.infer_library_from_model.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"}],source:"https://github.com/huggingface/optimum/blob/v1.23.1/optimum/exporters/tasks.py#L1869",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The library name automatically detected from the model repo, model instance, or model class.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),ie=new C({props:{name:"infer_task_from_model",anchor:"optimum.exporters.TasksManager.infer_task_from_model",parameters:[{name:"model",val:": typing.Union[str, ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel'), ForwardRef('DiffusionPipeline'), typing.Type]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/root/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.infer_task_from_model.model",description:`<strong>model</strong> (<code>Union[str, PreTrainedModel, TFPreTrainedModel, DiffusionPipeline, Type]</code>) &#x2014;
The model to infer the task from. This can either be the name of a repo on the HuggingFace Hub, an
instance of a model, or a model class.`,name:"model"},{anchor:"optimum.exporters.TasksManager.infer_task_from_model.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.TasksManager.infer_task_from_model.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>,  defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.TasksManager.infer_task_from_model.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.TasksManager.infer_task_from_model.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"}],source:"https://github.com/huggingface/optimum/blob/v1.23.1/optimum/exporters/tasks.py#L1714",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The task name automatically detected from the HF hub repo, model instance, or model class.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),ce=new C({props:{name:"standardize_model_attributes",anchor:"optimum.exporters.TasksManager.standardize_model_attributes",parameters:[{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('TFPreTrainedModel'), ForwardRef('DiffusionPipeline')]"}],parametersDescription:[{anchor:"optimum.exporters.TasksManager.standardize_model_attributes.model",description:`<strong>model</strong> (<code>Union[PreTrainedModel, TFPreTrainedModel, DiffusionPipeline]</code>) &#x2014;
The instance of the model.`,name:"model"}],source:"https://github.com/huggingface/optimum/blob/v1.23.1/optimum/exporters/tasks.py#L1915"}}),le=new Qt({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/exporters/task_manager.mdx"}}),{c(){p=s("meta"),F=r(),y=s("p"),k=r(),g(T.$$.fragment),i=r(),v=s("p"),v.innerHTML=vt,Fe=r(),S=s("ul"),S.innerHTML=$t,Ne=r(),Z=s("p"),Z.innerHTML=Mt,Pe=r(),g(V.$$.fragment),De=r(),z=s("p"),z.textContent=wt,He=r(),g(D.$$.fragment),je=r(),g(X.$$.fragment),Ue=r(),B=s("table"),B.innerHTML=Ct,Ie=r(),g(W.$$.fragment),Ae=r(),G=s("table"),G.innerHTML=Ft,Oe=r(),g(Y.$$.fragment),qe=r(),c=s("div"),g(Q.$$.fragment),Ye=r(),pe=s("p"),pe.innerHTML=Nt,Qe=r(),N=s("div"),g(K.$$.fragment),Ke=r(),ge=s("p"),ge.textContent=Pt,et=r(),g(H.$$.fragment),tt=r(),w=s("div"),g(ee.$$.fragment),ot=r(),ue=s("p"),ue.textContent=Dt,rt=r(),fe=s("p"),fe.textContent=Ht,nt=r(),he=s("ol"),he.innerHTML=jt,at=r(),j=s("div"),g(te.$$.fragment),st=r(),_e=s("p"),_e.textContent=Ut,dt=r(),U=s("div"),g(oe.$$.fragment),it=r(),xe=s("p"),xe.innerHTML=It,ct=r(),I=s("div"),g(re.$$.fragment),lt=r(),be=s("p"),be.textContent=At,mt=r(),A=s("div"),g(ne.$$.fragment),pt=r(),ke=s("p"),ke.textContent=Ot,gt=r(),O=s("div"),g(ae.$$.fragment),ut=r(),Te=s("p"),Te.textContent=qt,ft=r(),q=s("div"),g(se.$$.fragment),ht=r(),ye=s("p"),ye.innerHTML=Et,_t=r(),E=s("div"),g(de.$$.fragment),xt=r(),ve=s("p"),ve.textContent=Lt,bt=r(),L=s("div"),g(ie.$$.fragment),kt=r(),$e=s("p"),$e.textContent=Rt,Tt=r(),R=s("div"),g(ce.$$.fragment),yt=r(),Me=s("p"),Me.textContent=Jt,Ee=r(),g(le.$$.fragment),Le=r(),we=s("p"),this.h()},l(e){const a=Wt("svelte-u9bgzb",document.head);p=d(a,"META",{name:!0,content:!0}),a.forEach(o),F=n(e),y=d(e,"P",{}),$(y).forEach(o),k=n(e),u(T.$$.fragment,e),i=n(e),v=d(e,"P",{"data-svelte-h":!0}),f(v)!=="svelte-ab4qq0"&&(v.innerHTML=vt),Fe=n(e),S=d(e,"UL",{"data-svelte-h":!0}),f(S)!=="svelte-g9sbqh"&&(S.innerHTML=$t),Ne=n(e),Z=d(e,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-5xrb9y"&&(Z.innerHTML=Mt),Pe=n(e),u(V.$$.fragment,e),De=n(e),z=d(e,"P",{"data-svelte-h":!0}),f(z)!=="svelte-1bgg04"&&(z.textContent=wt),He=n(e),u(D.$$.fragment,e),je=n(e),u(X.$$.fragment,e),Ue=n(e),B=d(e,"TABLE",{"data-svelte-h":!0}),f(B)!=="svelte-52hvyl"&&(B.innerHTML=Ct),Ie=n(e),u(W.$$.fragment,e),Ae=n(e),G=d(e,"TABLE",{"data-svelte-h":!0}),f(G)!=="svelte-1b4ycm7"&&(G.innerHTML=Ft),Oe=n(e),u(Y.$$.fragment,e),qe=n(e),c=d(e,"DIV",{class:!0});var l=$(c);u(Q.$$.fragment,l),Ye=n(l),pe=d(l,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-11ax9pk"&&(pe.innerHTML=Nt),Qe=n(l),N=d(l,"DIV",{class:!0});var P=$(N);u(K.$$.fragment,P),Ke=n(P),ge=d(P,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-1hg58vd"&&(ge.textContent=Pt),et=n(P),u(H.$$.fragment,P),P.forEach(o),tt=n(l),w=d(l,"DIV",{class:!0});var J=$(w);u(ee.$$.fragment,J),ot=n(J),ue=d(J,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-rshgf5"&&(ue.textContent=Dt),rt=n(J),fe=d(J,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-1wbth9c"&&(fe.textContent=Ht),nt=n(J),he=d(J,"OL",{"data-svelte-h":!0}),f(he)!=="svelte-17imzut"&&(he.innerHTML=jt),J.forEach(o),at=n(l),j=d(l,"DIV",{class:!0});var Je=$(j);u(te.$$.fragment,Je),st=n(Je),_e=d(Je,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-1u59gs0"&&(_e.textContent=Ut),Je.forEach(o),dt=n(l),U=d(l,"DIV",{class:!0});var Se=$(U);u(oe.$$.fragment,Se),it=n(Se),xe=d(Se,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-77ppuy"&&(xe.innerHTML=It),Se.forEach(o),ct=n(l),I=d(l,"DIV",{class:!0});var Ze=$(I);u(re.$$.fragment,Ze),lt=n(Ze),be=d(Ze,"P",{"data-svelte-h":!0}),f(be)!=="svelte-dfgadj"&&(be.textContent=At),Ze.forEach(o),mt=n(l),A=d(l,"DIV",{class:!0});var Ve=$(A);u(ne.$$.fragment,Ve),pt=n(Ve),ke=d(Ve,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-xnksbg"&&(ke.textContent=Ot),Ve.forEach(o),gt=n(l),O=d(l,"DIV",{class:!0});var ze=$(O);u(ae.$$.fragment,ze),ut=n(ze),Te=d(ze,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-1tobybd"&&(Te.textContent=qt),ze.forEach(o),ft=n(l),q=d(l,"DIV",{class:!0});var Xe=$(q);u(se.$$.fragment,Xe),ht=n(Xe),ye=d(Xe,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-h2w0ej"&&(ye.innerHTML=Et),Xe.forEach(o),_t=n(l),E=d(l,"DIV",{class:!0});var Be=$(E);u(de.$$.fragment,Be),xt=n(Be),ve=d(Be,"P",{"data-svelte-h":!0}),f(ve)!=="svelte-k1qkuj"&&(ve.textContent=Lt),Be.forEach(o),bt=n(l),L=d(l,"DIV",{class:!0});var We=$(L);u(ie.$$.fragment,We),kt=n(We),$e=d(We,"P",{"data-svelte-h":!0}),f($e)!=="svelte-rnhyr"&&($e.textContent=Rt),We.forEach(o),Tt=n(l),R=d(l,"DIV",{class:!0});var Ge=$(R);u(ce.$$.fragment,Ge),yt=n(Ge),Me=d(Ge,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-3l6tv0"&&(Me.textContent=Jt),Ge.forEach(o),l.forEach(o),Ee=n(e),u(le.$$.fragment,e),Le=n(e),we=d(e,"P",{}),$(we).forEach(o),this.h()},h(){M(p,"name","hf:doc:metadata"),M(p,"content",oo),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){t(document.head,p),m(e,F,a),m(e,y,a),m(e,k,a),h(T,e,a),m(e,i,a),m(e,v,a),m(e,Fe,a),m(e,S,a),m(e,Ne,a),m(e,Z,a),m(e,Pe,a),h(V,e,a),m(e,De,a),m(e,z,a),m(e,He,a),h(D,e,a),m(e,je,a),h(X,e,a),m(e,Ue,a),m(e,B,a),m(e,Ie,a),h(W,e,a),m(e,Ae,a),m(e,G,a),m(e,Oe,a),h(Y,e,a),m(e,qe,a),m(e,c,a),h(Q,c,null),t(c,Ye),t(c,pe),t(c,Qe),t(c,N),h(K,N,null),t(N,Ke),t(N,ge),t(N,et),h(H,N,null),t(c,tt),t(c,w),h(ee,w,null),t(w,ot),t(w,ue),t(w,rt),t(w,fe),t(w,nt),t(w,he),t(c,at),t(c,j),h(te,j,null),t(j,st),t(j,_e),t(c,dt),t(c,U),h(oe,U,null),t(U,it),t(U,xe),t(c,ct),t(c,I),h(re,I,null),t(I,lt),t(I,be),t(c,mt),t(c,A),h(ne,A,null),t(A,pt),t(A,ke),t(c,gt),t(c,O),h(ae,O,null),t(O,ut),t(O,Te),t(c,ft),t(c,q),h(se,q,null),t(q,ht),t(q,ye),t(c,_t),t(c,E),h(de,E,null),t(E,xt),t(E,ve),t(c,bt),t(c,L),h(ie,L,null),t(L,kt),t(L,$e),t(c,Tt),t(c,R),h(ce,R,null),t(R,yt),t(R,Me),m(e,Ee,a),h(le,e,a),m(e,Le,a),m(e,we,a),Re=!0},p(e,[a]){const l={};a&2&&(l.$$scope={dirty:a,ctx:e}),D.$set(l);const P={};a&2&&(P.$$scope={dirty:a,ctx:e}),H.$set(P)},i(e){Re||(_(T.$$.fragment,e),_(V.$$.fragment,e),_(D.$$.fragment,e),_(X.$$.fragment,e),_(W.$$.fragment,e),_(Y.$$.fragment,e),_(Q.$$.fragment,e),_(K.$$.fragment,e),_(H.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(re.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(se.$$.fragment,e),_(de.$$.fragment,e),_(ie.$$.fragment,e),_(ce.$$.fragment,e),_(le.$$.fragment,e),Re=!0)},o(e){x(T.$$.fragment,e),x(V.$$.fragment,e),x(D.$$.fragment,e),x(X.$$.fragment,e),x(W.$$.fragment,e),x(Y.$$.fragment,e),x(Q.$$.fragment,e),x(K.$$.fragment,e),x(H.$$.fragment,e),x(ee.$$.fragment,e),x(te.$$.fragment,e),x(oe.$$.fragment,e),x(re.$$.fragment,e),x(ne.$$.fragment,e),x(ae.$$.fragment,e),x(se.$$.fragment,e),x(de.$$.fragment,e),x(ie.$$.fragment,e),x(ce.$$.fragment,e),x(le.$$.fragment,e),Re=!1},d(e){e&&(o(F),o(y),o(k),o(i),o(v),o(Fe),o(S),o(Ne),o(Z),o(Pe),o(De),o(z),o(He),o(je),o(Ue),o(B),o(Ie),o(Ae),o(G),o(Oe),o(qe),o(c),o(Ee),o(Le),o(we)),o(p),b(T,e),b(V,e),b(D,e),b(X,e),b(W,e),b(Y,e),b(Q),b(K),b(H),b(ee),b(te),b(oe),b(re),b(ne),b(ae),b(se),b(de),b(ie),b(ce),b(le,e)}}}const oo='{"title":"The Tasks Manager","local":"the-tasks-manager","sections":[{"title":"Task names","local":"task-names","sections":[{"title":"PyTorch","local":"pytorch","sections":[],"depth":3},{"title":"TensorFlow","local":"tensorflow","sections":[],"depth":3}],"depth":2},{"title":"Reference","local":"optimum.exporters.TasksManager","sections":[],"depth":2}],"depth":1}';function ro(me){return zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class po extends Xt{constructor(p){super(),Bt(this,p,ro,to,Vt,{})}}export{po as component};
